/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match.generator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javaslang.match.model.ClassModel;

class ImportManager {
    private final String packageNameOfClass;
    private List<String> directImports;
    private Map<FQN, Import> imports = new HashMap<FQN, Import>();

    private ImportManager(String packageNameOfClass, List<String> directImports) {
        this.packageNameOfClass = packageNameOfClass;
        this.directImports = directImports;
    }

    public static ImportManager forClass(ClassModel classModel, String ... directImports) {
        return new ImportManager(classModel.getPackageName(), ImportManager.reverseSort(directImports));
    }

    public String getType(ClassModel classModel) {
        FQN fqn2 = new FQN(classModel.getPackageName(), classModel.getClassName());
        return ImportManager.getType(fqn2, this.imports, this.packageNameOfClass, this.directImports);
    }

    public String getType(String packageName, String className) {
        FQN fqn2 = new FQN(packageName, className);
        return ImportManager.getType(fqn2, this.imports, this.packageNameOfClass, this.directImports);
    }

    public String getImports() {
        return ImportManager.optimizeImports(this.imports.values());
    }

    private static String getType(FQN fqn2, Map<FQN, Import> imports2, String packageNameOfClass, List<String> directImports) {
        if (fqn2.packageName.isEmpty() && !packageNameOfClass.isEmpty()) {
            throw new IllegalStateException("Can't import class '" + fqn2.className + "' located in default package");
        }
        if (fqn2.packageName.equals(packageNameOfClass)) {
            Import _import = ImportManager.createImport(fqn2, directImports);
            if (_import.type.equals(fqn2.className)) {
                return fqn2.className;
            }
            imports2.put(fqn2, _import);
            return _import.type;
        }
        if (imports2.containsKey(fqn2)) {
            return imports2.get((Object)fqn2).type;
        }
        Import _import = ImportManager.createImport(fqn2, directImports);
        imports2.put(fqn2, _import);
        return _import.type;
    }

    private static Import createImport(FQN fqn2, List<String> directImports) {
        String qualifiedName2 = fqn2.qualifiedName();
        Optional<String> directImportOption = directImports.stream().filter(directImport -> qualifiedName2.equals(directImport) || qualifiedName2.startsWith(directImport + ".")).findFirst();
        if (directImportOption.isPresent()) {
            String directImport2 = directImportOption.get();
            if (qualifiedName2.equals(directImport2)) {
                String type2 = directImport2.substring(directImport2.lastIndexOf(46) + 1);
                return new Import(directImport2, type2);
            }
            String type3 = qualifiedName2.substring(directImport2.length() + 1);
            int index = type3.indexOf(".");
            String firstSegment = index < 0 ? type3 : type3.substring(0, index);
            return new Import(directImport2 + "." + firstSegment, type3);
        }
        int index = fqn2.className.indexOf(".");
        String firstSegment = index < 0 ? fqn2.className : fqn2.className.substring(0, index);
        return new Import(fqn2.packageName + "." + firstSegment, fqn2.className);
    }

    private static String optimizeImports(Collection<Import> imports2) {
        return imports2.stream().filter(currentImport -> !currentImport.name.startsWith("java.lang.") || imports2.stream().filter(otherImport -> !otherImport.equals(currentImport)).map(otherImport -> otherImport.type).filter(otherType -> otherType.equals(currentImport.type)).findFirst().isPresent()).map(_import -> _import.name).distinct().sorted().map(s -> "import " + s + ";").collect(Collectors.joining("\n"));
    }

    private static List<String> reverseSort(String[] strings2) {
        String[] copy = new String[strings2.length];
        System.arraycopy(strings2, 0, copy, 0, strings2.length);
        Arrays.sort(copy, (s1, s2) -> s2.compareTo((String)s1));
        return Arrays.asList(copy);
    }

    private static class Import {
        final String name;
        final String type;

        Import(String name2, String type2) {
            this.name = name2;
            this.type = type2;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof Import && this.toString().equals(o.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "Import(" + this.name + ", " + this.type + ")";
        }
    }

    private static class FQN {
        private final String packageName;
        private final String className;

        FQN(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        String qualifiedName() {
            return this.packageName.isEmpty() ? this.className : this.packageName + "." + this.className;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof FQN && this.qualifiedName().equals(((FQN)o).qualifiedName());
        }

        public int hashCode() {
            return this.qualifiedName().hashCode();
        }

        public String toString() {
            return "FQN(" + this.packageName + ", " + this.className + ")";
        }
    }
}

