/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import javaslang.Function1;
import javaslang.Kind1;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Collections;
import javaslang.collection.Iterator;
import javaslang.collection.LinearSeq;
import javaslang.collection.ListModule;
import javaslang.collection.Map;
import javaslang.collection.Stack;
import javaslang.control.Option;
import javaslang.\u03bb;

public interface List<T>
extends Kind1<List<?>, T>,
LinearSeq<T>,
Stack<T> {
    public static final long serialVersionUID = 1L;

    public static <T> Collector<T, ArrayList<T>, List<T>> collector() {
        Supplier<ArrayList> supplier = ArrayList::new;
        BiConsumer<ArrayList, Object> accumulator = ArrayList::add;
        BinaryOperator combiner = (left, right) -> {
            left.addAll(right);
            return left;
        };
        Function<ArrayList, List> finisher = List::ofAll;
        return Collector.of(supplier, accumulator, combiner, finisher, new Collector.Characteristics[0]);
    }

    public static <T> List<T> empty() {
        return Nil.instance();
    }

    @Override
    public boolean isEmpty();

    public static <T> List<T> narrow(List<? extends T> list2) {
        return list2;
    }

    public static <T> List<T> of(T element3) {
        return new Cons(element3, Nil.instance());
    }

    @SafeVarargs
    public static <T> List<T> of(T ... elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinearSeq result2 = Nil.instance();
        for (int i2 = elements2.length - 1; i2 >= 0; --i2) {
            result2 = result2.prepend((Object)elements2[i2]);
        }
        return result2;
    }

    public static <T> List<T> ofAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        if (elements2 instanceof List) {
            return (List)elements2;
        }
        if (elements2 instanceof java.util.List) {
            LinearSeq result2 = Nil.instance();
            java.util.List list2 = (java.util.List)elements2;
            ListIterator iterator2 = list2.listIterator(list2.size());
            while (iterator2.hasPrevious()) {
                result2 = result2.prepend(iterator2.previous());
            }
            return result2;
        }
        if (elements2 instanceof NavigableSet) {
            LinearSeq result3 = Nil.instance();
            java.util.Iterator iterator3 = ((NavigableSet)elements2).descendingIterator();
            while (iterator3.hasNext()) {
                result3 = result3.prepend(iterator3.next());
            }
            return result3;
        }
        LinearSeq result4 = Nil.instance();
        for (T element3 : elements2) {
            result4 = result4.prepend((Object)element3);
        }
        return result4.reverse();
    }

    public static List<Boolean> ofAll(boolean[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Byte> ofAll(byte[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Character> ofAll(char[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Double> ofAll(double[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Float> ofAll(float[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Integer> ofAll(int[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Long> ofAll(long[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static List<Short> ofAll(short[] array2) {
        Objects.requireNonNull(array2, "array is null");
        return List.ofAll(Iterator.ofAll(array2));
    }

    public static <T> List<T> tabulate(int n, Function<? super Integer, ? extends T> f2) {
        Objects.requireNonNull(f2, "f is null");
        return Collections.tabulate(n, f2, List.empty(), List::of);
    }

    public static <T> List<T> fill(int n, Supplier<? extends T> s) {
        Objects.requireNonNull(s, "s is null");
        return Collections.fill(n, s, List.empty(), List::of);
    }

    public static List<Character> range(char from, char toExclusive) {
        return List.ofAll(Iterator.range(from, toExclusive));
    }

    public static List<Character> rangeBy(char from, char toExclusive, int step2) {
        return List.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static List<Double> rangeBy(double from, double toExclusive, double step2) {
        return List.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static List<Integer> range(int from, int toExclusive) {
        return List.ofAll(Iterator.range(from, toExclusive));
    }

    public static List<Integer> rangeBy(int from, int toExclusive, int step2) {
        return List.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static List<Long> range(long from, long toExclusive) {
        return List.ofAll(Iterator.range(from, toExclusive));
    }

    public static List<Long> rangeBy(long from, long toExclusive, long step2) {
        return List.ofAll(Iterator.rangeBy(from, toExclusive, step2));
    }

    public static List<Character> rangeClosed(char from, char toInclusive) {
        return List.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static List<Character> rangeClosedBy(char from, char toInclusive, int step2) {
        return List.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    public static List<Double> rangeClosedBy(double from, double toInclusive, double step2) {
        return List.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    public static List<Integer> rangeClosed(int from, int toInclusive) {
        return List.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static List<Integer> rangeClosedBy(int from, int toInclusive, int step2) {
        return List.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    public static List<Long> rangeClosed(long from, long toInclusive) {
        return List.ofAll(Iterator.rangeClosed(from, toInclusive));
    }

    public static List<Long> rangeClosedBy(long from, long toInclusive, long step2) {
        return List.ofAll(Iterator.rangeClosedBy(from, toInclusive, step2));
    }

    @Override
    default public List<T> append(T element3) {
        return this.foldRight(List.of(element3), (x, xs) -> xs.prepend(x));
    }

    @Override
    default public List<T> appendAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        return this.foldRight(List.ofAll(elements2), (x, xs) -> xs.prepend(x));
    }

    @Override
    default public List<List<T>> combinations() {
        return List.rangeClosed(0, this.length()).map((T n) -> this.combinations((int)n)).flatMap(Function.identity());
    }

    @Override
    default public List<List<T>> combinations(int k) {
        return ListModule.Combinations.apply(this, Math.max(k, 0));
    }

    @Override
    default public Iterator<List<T>> crossProduct(int power) {
        return Collections.crossProduct(List.empty(), this, power);
    }

    @Override
    default public List<T> distinct() {
        return this.distinctBy(Function.identity());
    }

    @Override
    default public List<T> distinctBy(Comparator<? super T> comparator2) {
        Objects.requireNonNull(comparator2, "comparator is null");
        TreeSet<? super T> seen = new TreeSet<T>(comparator2);
        return this.filter(seen::add);
    }

    @Override
    default public <U> List<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        HashSet seen = new HashSet();
        return this.filter((T t) -> seen.add(keyExtractor.apply(t)));
    }

    @Override
    default public List<T> drop(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.size()) {
            return List.empty();
        }
        LinearSeq<T> list2 = this;
        for (long i2 = n; i2 > 0L && !list2.isEmpty(); --i2) {
            list2 = list2.tail();
        }
        return list2;
    }

    @Override
    default public List<T> dropRight(long n) {
        if (n <= 0L) {
            return this;
        }
        if (n >= (long)this.length()) {
            return List.empty();
        }
        return List.ofAll(this.iterator().dropRight(n));
    }

    @Override
    default public List<T> dropUntil(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        return this.dropWhile((Predicate)predicate2.negate());
    }

    @Override
    default public List<T> dropWhile(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        LinearSeq<T> list2 = this;
        while (!list2.isEmpty() && predicate2.test(list2.head())) {
            list2 = list2.tail();
        }
        return list2;
    }

    @Override
    default public List<T> filter(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        List filtered = this.foldLeft(List.empty(), (xs, x) -> predicate2.test(x) ? xs.prepend(x) : xs);
        return this.length() == filtered.length() ? this : filtered.reverse();
    }

    @Override
    default public <U> List<U> flatMap(Function<? super T, ? extends Iterable<? extends U>> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        if (this.isEmpty()) {
            return List.empty();
        }
        LinearSeq<T> list2 = List.empty();
        for (Object t : this) {
            for (U u : mapper2.apply(t)) {
                list2 = list2.prepend(u);
            }
        }
        return list2.reverse();
    }

    @Override
    default public T get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("get(" + index + ") on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("get(" + index + ")");
        }
        LinearSeq<T> list2 = this;
        for (int i2 = index - 1; i2 >= 0; --i2) {
            if (!(list2 = list2.tail()).isEmpty()) continue;
            throw new IndexOutOfBoundsException(String.format("get(%s) on List of length %s", index, index - i2));
        }
        return list2.head();
    }

    @Override
    default public <C> Map<C, List<T>> groupBy(Function<? super T, ? extends C> classifier) {
        return Collections.groupBy(this, classifier, List::ofAll);
    }

    @Override
    default public Iterator<List<T>> grouped(long size) {
        return this.sliding(size, size);
    }

    @Override
    default public boolean hasDefiniteSize() {
        return true;
    }

    @Override
    default public int indexOf(T element3, int from) {
        int index = 0;
        LinearSeq<T> list2 = this;
        while (!list2.isEmpty()) {
            if (index >= from && Objects.equals(list2.head(), element3)) {
                return index;
            }
            list2 = list2.tail();
            ++index;
        }
        return -1;
    }

    @Override
    default public List<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty list");
        }
        return this.dropRight(1L);
    }

    @Override
    default public Option<List<T>> initOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.init());
    }

    @Override
    public int length();

    @Override
    default public List<T> insert(int index, T element3) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("insert(" + index + ", e)");
        }
        LinearSeq preceding = Nil.instance();
        LinearSeq<T> tail = this;
        int i2 = index;
        while (i2 > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("insert(" + index + ", e) on List of length " + this.length());
            }
            preceding = preceding.prepend(tail.head());
            --i2;
            tail = tail.tail();
        }
        LinearSeq result2 = tail.prepend((Object)element3);
        for (Object next2 : preceding) {
            result2 = result2.prepend(next2);
        }
        return result2;
    }

    @Override
    default public List<T> insertAll(int index, Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        if (index < 0) {
            throw new IndexOutOfBoundsException("insertAll(" + index + ", elements)");
        }
        LinearSeq preceding = Nil.instance();
        LinearSeq<T> tail = this;
        int i2 = index;
        while (i2 > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("insertAll(" + index + ", elements) on List of length " + this.length());
            }
            preceding = preceding.prepend(tail.head());
            --i2;
            tail = tail.tail();
        }
        LinearSeq result2 = tail.prependAll((Iterable)elements2);
        for (Object next2 : preceding) {
            result2 = result2.prepend(next2);
        }
        return result2;
    }

    @Override
    default public List<T> intersperse(T element3) {
        return this.isEmpty() ? Nil.instance() : this.foldRight(List.empty(), (x, xs) -> xs.isEmpty() ? xs.prepend(x) : xs.prepend(element3).prepend(x));
    }

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    default public int lastIndexOf(T element3, int end) {
        int result2 = -1;
        LinearSeq<T> list2 = this;
        for (int index = 0; index <= end && !list2.isEmpty(); ++index) {
            if (Objects.equals(list2.head(), element3)) {
                result2 = index;
            }
            list2 = list2.tail();
        }
        return result2;
    }

    @Override
    default public <U> List<U> map(Function<? super T, ? extends U> mapper2) {
        Objects.requireNonNull(mapper2, "mapper is null");
        LinearSeq<T> list2 = List.empty();
        for (Object t : this) {
            list2 = list2.prepend(mapper2.apply(t));
        }
        return list2.reverse();
    }

    @Override
    default public List<T> padTo(int length, T element3) {
        if (length <= this.length()) {
            return this;
        }
        return this.appendAll((Iterable)Iterator.continually(element3).take(length - this.length()));
    }

    @Override
    default public List<T> patch(int from, Iterable<? extends T> that, int replaced2) {
        from = from < 0 ? 0 : from;
        replaced2 = replaced2 < 0 ? 0 : replaced2;
        LinearSeq result2 = this.take(from).appendAll((Iterable)that);
        result2 = result2.appendAll((Iterable)this.drop(from += replaced2));
        return result2;
    }

    @Override
    default public Tuple2<List<T>, List<T>> partition(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        ArrayList left = new ArrayList();
        ArrayList right = new ArrayList();
        for (Object t : this) {
            (predicate2.test(t) ? left : right).add(t);
        }
        return Tuple.of(List.ofAll(left), List.ofAll(right));
    }

    @Override
    default public T peek() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("peek of empty list");
        }
        return this.head();
    }

    @Override
    default public Option<T> peekOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.head());
    }

    @Override
    default public List<T> peek(Consumer<? super T> action2) {
        Objects.requireNonNull(action2, "action is null");
        if (!this.isEmpty()) {
            action2.accept(this.head());
        }
        return this;
    }

    @Override
    default public List<List<T>> permutations() {
        if (this.isEmpty()) {
            return Nil.instance();
        }
        LinearSeq tail = this.tail();
        if (tail.isEmpty()) {
            return List.of(this);
        }
        Nil zero = Nil.instance();
        return this.distinct().foldLeft(zero, (xs, x) -> {
            Function<List, List> prepend = l -> l.prepend(x);
            return xs.appendAll((Iterable)this.remove(x).permutations().map(prepend));
        });
    }

    @Override
    default public List<T> pop() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("pop of empty list");
        }
        return this.tail();
    }

    @Override
    default public Option<List<T>> popOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    default public Tuple2<T, List<T>> pop2() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("pop2 of empty list");
        }
        return Tuple.of(this.head(), this.tail());
    }

    @Override
    default public Option<Tuple2<T, List<T>>> pop2Option() {
        return this.isEmpty() ? Option.none() : Option.some(Tuple.of(this.head(), this.tail()));
    }

    @Override
    default public List<T> prepend(T element3) {
        return new Cons(element3, this);
    }

    /*
     * Exception decompiling
     */
    @Override
    default public List<T> prependAll(Iterable<? extends T> elements) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    default public List<T> push(T element3) {
        return new Cons(element3, this);
    }

    @Override
    default public List<T> push(T ... elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinearSeq<T> result2 = this;
        for (T element3 : elements2) {
            result2 = result2.prepend((Object)element3);
        }
        return result2;
    }

    @Override
    default public List<T> pushAll(Iterable<T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinearSeq<T> result2 = this;
        for (T element3 : elements2) {
            result2 = result2.prepend((Object)element3);
        }
        return result2;
    }

    @Override
    default public List<T> remove(T element3) {
        LinearSeq preceding = Nil.instance();
        LinearSeq<T> tail = this;
        boolean found2 = false;
        while (!found2 && !tail.isEmpty()) {
            Object head = tail.head();
            if (Objects.equals(head, element3)) {
                found2 = true;
            } else {
                preceding = preceding.prepend(head);
            }
            tail = tail.tail();
        }
        if (!found2) {
            return this;
        }
        LinearSeq<T> result2 = tail;
        for (Object next2 : preceding) {
            result2 = result2.prepend(next2);
        }
        return result2;
    }

    /*
     * Exception decompiling
     */
    @Override
    default public List<T> removeFirst(Predicate<T> predicate) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    default public List<T> removeLast(Predicate<T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        LinearSeq removedAndReversed = this.reverse().removeFirst((Predicate)predicate2);
        return removedAndReversed.length() == this.length() ? this : removedAndReversed.reverse();
    }

    @Override
    default public List<T> removeAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ")");
        }
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("removeAt(" + index + ") on Nil");
        }
        LinearSeq init2 = Nil.instance();
        LinearSeq<T> tail = this;
        while (index > 0 && !tail.isEmpty()) {
            init2 = init2.prepend(tail.head());
            tail = tail.tail();
            --index;
        }
        if (index > 0) {
            throw new IndexOutOfBoundsException("removeAt() on Nil");
        }
        return init2.reverse().appendAll((Iterable)tail.tail());
    }

    @Override
    default public List<T> removeAll(T removed) {
        LinearSeq result2 = Nil.instance();
        boolean found2 = false;
        for (Object element3 : this) {
            if (element3.equals(removed)) {
                found2 = true;
                continue;
            }
            result2 = result2.prepend(element3);
        }
        return found2 ? result2.reverse() : this;
    }

    @Override
    default public List<T> removeAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinearSeq removed = List.ofAll(elements2).distinct();
        LinearSeq result2 = Nil.instance();
        boolean found2 = false;
        for (Object element3 : this) {
            if (removed.contains(element3)) {
                found2 = true;
                continue;
            }
            result2 = result2.prepend(element3);
        }
        return found2 ? result2.reverse() : this;
    }

    @Override
    default public List<T> replace(T currentElement, T newElement2) {
        LinearSeq preceding = Nil.instance();
        LinearSeq<T> tail = this;
        while (!tail.isEmpty() && !Objects.equals(tail.head(), currentElement)) {
            preceding = preceding.prepend(tail.head());
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            return this;
        }
        LinearSeq result2 = tail.tail().prepend((Object)newElement2);
        for (Object next2 : preceding) {
            result2 = result2.prepend(next2);
        }
        return result2;
    }

    @Override
    default public List<T> replaceAll(T currentElement, T newElement2) {
        LinearSeq result2 = Nil.instance();
        boolean changed2 = false;
        LinearSeq<T> list2 = this;
        while (!list2.isEmpty()) {
            Object head = list2.head();
            if (Objects.equals(head, currentElement)) {
                result2 = result2.prepend((Object)newElement2);
                changed2 = true;
            } else {
                result2 = result2.prepend(head);
            }
            list2 = list2.tail();
        }
        return changed2 ? result2.reverse() : this;
    }

    @Override
    default public List<T> retainAll(Iterable<? extends T> elements2) {
        Objects.requireNonNull(elements2, "elements is null");
        LinearSeq kept = List.ofAll(elements2).distinct();
        LinearSeq result2 = Nil.instance();
        for (Object element3 : this) {
            if (!kept.contains(element3)) continue;
            result2 = result2.prepend(element3);
        }
        return result2.size() == this.size() ? this : result2.reverse();
    }

    /*
     * Exception decompiling
     */
    @Override
    default public List<T> reverse() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.TernaryExpression.applyExpressionRewriter(TernaryExpression.java:106)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    default public List<T> scan(T zero, BiFunction<? super T, ? super T, ? extends T> operation2) {
        return this.scanLeft(zero, operation2);
    }

    /*
     * Exception decompiling
     */
    @Override
    default public <U> List<U> scanLeft(U zero, BiFunction<? super U, ? super T, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    default public <U> List<U> scanRight(U zero, BiFunction<? super T, ? super U, ? extends U> operation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 1 out of bounds for length 1
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    default public List<T> slice(long beginIndex, long endIndex) {
        if (beginIndex >= endIndex || beginIndex >= (long)this.length() || this.isEmpty()) {
            return List.empty();
        }
        LinearSeq result2 = Nil.instance();
        LinearSeq<T> list2 = this;
        long lowerBound = Math.max(beginIndex, 0L);
        long upperBound = Math.min(endIndex, (long)this.length());
        int i2 = 0;
        while ((long)i2 < upperBound) {
            if ((long)i2 >= lowerBound) {
                result2 = result2.prepend(list2.head());
            }
            list2 = list2.tail();
            ++i2;
        }
        return result2.reverse();
    }

    @Override
    default public Iterator<List<T>> sliding(long size) {
        return this.sliding(size, 1L);
    }

    @Override
    default public Iterator<List<T>> sliding(long size, long step2) {
        return this.iterator().sliding(size, step2).map(List::ofAll);
    }

    @Override
    default public List<T> sorted() {
        return this.isEmpty() ? this : this.toJavaStream().sorted().collect(List.collector());
    }

    @Override
    default public List<T> sorted(Comparator<? super T> comparator2) {
        Objects.requireNonNull(comparator2, "comparator is null");
        return this.isEmpty() ? this : this.toJavaStream().sorted(comparator2).collect(List.collector());
    }

    @Override
    default public <U extends Comparable<? super U>> List<T> sortBy(Function<? super T, ? extends U> mapper2) {
        return this.sortBy(Comparable::compareTo, (Function)mapper2);
    }

    @Override
    default public <U> List<T> sortBy(Comparator<? super U> comparator2, Function<? super T, ? extends U> mapper2) {
        \u03bb domain = Function1.of(mapper2::apply).memoized();
        return this.toJavaStream().sorted((arg_0, arg_1) -> List.lambda$sortBy$8(comparator2, (Function)((Object)domain), arg_0, arg_1)).collect(List.collector());
    }

    @Override
    default public Tuple2<List<T>, List<T>> span(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        Tuple2<Iterator<? super T>, Iterator<? super T>> itt = this.iterator().span(predicate2);
        return Tuple.of(List.ofAll((Iterable)itt._1), List.ofAll((Iterable)itt._2));
    }

    @Override
    default public Tuple2<List<T>, List<T>> splitAt(long n) {
        if (this.isEmpty()) {
            return Tuple.of(List.empty(), List.empty());
        }
        LinearSeq init2 = Nil.instance();
        LinearSeq<T> tail = this;
        while (n > 0L && !tail.isEmpty()) {
            init2 = init2.prepend(tail.head());
            tail = tail.tail();
            --n;
        }
        return Tuple.of(init2.reverse(), tail);
    }

    @Override
    default public Tuple2<List<T>, List<T>> splitAt(Predicate<? super T> predicate2) {
        if (this.isEmpty()) {
            return Tuple.of(List.empty(), List.empty());
        }
        Tuple2<List<? super T>, List<? super T>> t = ListModule.SplitAt.splitByPredicateReversed(this, predicate2);
        if (((List)t._2).isEmpty()) {
            return Tuple.of(this, List.empty());
        }
        return Tuple.of(((List)t._1).reverse(), t._2);
    }

    @Override
    default public Tuple2<List<T>, List<T>> splitAtInclusive(Predicate<? super T> predicate2) {
        if (this.isEmpty()) {
            return Tuple.of(List.empty(), List.empty());
        }
        Tuple2<List<? super T>, List<? super T>> t = ListModule.SplitAt.splitByPredicateReversed(this, predicate2);
        if (((List)t._2).isEmpty() || ((List)t._2).tail().isEmpty()) {
            return Tuple.of(this, List.empty());
        }
        return Tuple.of(((List)t._1).prepend(((List)t._2).head()).reverse(), ((List)t._2).tail());
    }

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    @Override
    default public String stringPrefix() {
        return "List";
    }

    @Override
    default public List<T> subSequence(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("subSequence(" + beginIndex + ")");
        }
        LinearSeq<T> result2 = this;
        int i2 = 0;
        while (i2 < beginIndex) {
            if (result2.isEmpty()) {
                throw new IndexOutOfBoundsException(String.format("subSequence(%s) on List of length %s", beginIndex, i2));
            }
            ++i2;
            result2 = result2.tail();
        }
        return result2;
    }

    @Override
    default public List<T> subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(String.format("subSequence(%s, %s) on List of length %s", beginIndex, endIndex, this.length()));
        }
        LinearSeq result2 = Nil.instance();
        LinearSeq<T> list2 = this;
        int i2 = 0;
        while (i2 < endIndex) {
            if (list2.isEmpty()) {
                throw new IndexOutOfBoundsException(String.format("subSequence(%s, %s) on List of length %s", beginIndex, endIndex, i2));
            }
            if (i2 >= beginIndex) {
                result2 = result2.prepend(list2.head());
            }
            ++i2;
            list2 = list2.tail();
        }
        return result2.reverse();
    }

    @Override
    public List<T> tail();

    @Override
    default public Option<List<T>> tailOption() {
        return this.isEmpty() ? Option.none() : Option.some(this.tail());
    }

    @Override
    default public List<T> take(long n) {
        if (n <= 0L) {
            return List.empty();
        }
        if (n >= (long)this.length()) {
            return this;
        }
        LinearSeq result2 = Nil.instance();
        LinearSeq<T> list2 = this;
        int i2 = 0;
        while ((long)i2 < n) {
            result2 = result2.prepend(list2.head());
            ++i2;
            list2 = list2.tail();
        }
        return result2.reverse();
    }

    @Override
    default public List<T> takeRight(long n) {
        if (n <= 0L) {
            return List.empty();
        }
        if (n >= (long)this.length()) {
            return this;
        }
        return this.reverse().take(n).reverse();
    }

    @Override
    default public List<T> takeUntil(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        return this.takeWhile((Predicate)predicate2.negate());
    }

    @Override
    default public List<T> takeWhile(Predicate<? super T> predicate2) {
        Objects.requireNonNull(predicate2, "predicate is null");
        LinearSeq result2 = Nil.instance();
        LinearSeq<T> list2 = this;
        while (!list2.isEmpty() && predicate2.test(list2.head())) {
            result2 = result2.prepend(list2.head());
            list2 = list2.tail();
        }
        return result2.length() == this.length() ? this : result2.reverse();
    }

    default public <U> U transform(Function<? super List<T>, ? extends U> f2) {
        Objects.requireNonNull(f2, "f is null");
        return f2.apply(this);
    }

    @Override
    default public <U> List<U> unit(Iterable<? extends U> iterable) {
        return List.ofAll(iterable);
    }

    @Override
    default public <T1, T2> Tuple2<List<T1>, List<T2>> unzip(Function<? super T, Tuple2<? extends T1, ? extends T2>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        LinearSeq xs = Nil.instance();
        LinearSeq ys = Nil.instance();
        for (Object element3 : this) {
            Tuple2<? extends T1, ? extends T2> t = unzipper.apply(element3);
            xs = xs.prepend(t._1);
            ys = ys.prepend(t._2);
        }
        return Tuple.of(xs.reverse(), ys.reverse());
    }

    @Override
    default public <T1, T2, T3> Tuple3<List<T1>, List<T2>, List<T3>> unzip3(Function<? super T, Tuple3<? extends T1, ? extends T2, ? extends T3>> unzipper) {
        Objects.requireNonNull(unzipper, "unzipper is null");
        LinearSeq xs = Nil.instance();
        LinearSeq ys = Nil.instance();
        LinearSeq zs = Nil.instance();
        for (Object element3 : this) {
            Tuple3<? extends T1, ? extends T2, ? extends T3> t = unzipper.apply(element3);
            xs = xs.prepend(t._1);
            ys = ys.prepend(t._2);
            zs = zs.prepend(t._3);
        }
        return Tuple.of(xs.reverse(), ys.reverse(), zs.reverse());
    }

    @Override
    default public List<T> update(int index, T element3) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index + ", e) on Nil");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("update(" + index + ", e)");
        }
        LinearSeq preceding = Nil.instance();
        LinearSeq<T> tail = this;
        int i2 = index;
        while (i2 > 0) {
            if (tail.isEmpty()) {
                throw new IndexOutOfBoundsException("update(" + index + ", e) on List of length " + this.length());
            }
            preceding = preceding.prepend(tail.head());
            --i2;
            tail = tail.tail();
        }
        if (tail.isEmpty()) {
            throw new IndexOutOfBoundsException("update(" + index + ", e) on List of length " + this.length());
        }
        LinearSeq result2 = tail.tail().prepend((Object)element3);
        for (Object next2 : preceding) {
            result2 = result2.prepend(next2);
        }
        return result2;
    }

    @Override
    default public <U> List<Tuple2<T, U>> zip(Iterable<? extends U> that) {
        Objects.requireNonNull(that, "that is null");
        return List.ofAll(this.iterator().zip(that));
    }

    @Override
    default public <U> List<Tuple2<T, U>> zipAll(Iterable<? extends U> that, T thisElem, U thatElem) {
        Objects.requireNonNull(that, "that is null");
        return List.ofAll(this.iterator().zipAll(that, thisElem, thatElem));
    }

    @Override
    default public List<Tuple2<T, Long>> zipWithIndex() {
        return List.ofAll(this.iterator().zipWithIndex());
    }

    private static /* synthetic */ int lambda$sortBy$8(Comparator comparator2, Function domain, Object e1, Object e2) {
        return comparator2.compare(domain.apply(e1), domain.apply(e2));
    }

    public static final class Cons<T>
    implements List<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final T head;
        private final List<T> tail;
        private final int length;

        private Cons(T head, List<T> tail) {
            this.head = head;
            this.tail = tail;
            this.length = 1 + tail.length();
        }

        @Override
        public T head() {
            return this.head;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public List<T> tail() {
            return this.tail;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof List) {
                LinearSeq<T> list1 = this;
                LinearSeq list2 = (List)o;
                while (!list1.isEmpty() && !list2.isEmpty()) {
                    boolean isEqual = Objects.equals(list1.head(), list2.head());
                    if (!isEqual) {
                        return false;
                    }
                    list1 = list1.tail();
                    list2 = list2.tail();
                }
                return list1.isEmpty() && list2.isEmpty();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Collections.hash(this);
        }

        @Override
        public String toString() {
            return this.mkString(this.stringPrefix() + "(", ", ", ")");
        }

        private Object writeReplace() {
            return new SerializationProxy(this);
        }

        private void readObject(ObjectInputStream stream) throws InvalidObjectException {
            throw new InvalidObjectException("Proxy required");
        }

        private static final class SerializationProxy<T>
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private transient Cons<T> list;

            SerializationProxy(Cons<T> list2) {
                this.list = list2;
            }

            private void writeObject(ObjectOutputStream s) throws IOException {
                s.defaultWriteObject();
                s.writeInt(this.list.length());
                LinearSeq<T> l = this.list;
                while (!l.isEmpty()) {
                    s.writeObject(l.head());
                    l = l.tail();
                }
            }

            private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
                s.defaultReadObject();
                int size = s.readInt();
                if (size <= 0) {
                    throw new InvalidObjectException("No elements");
                }
                LinearSeq temp = Nil.instance();
                for (int i2 = 0; i2 < size; ++i2) {
                    Object element3 = s.readObject();
                    temp = temp.prepend(element3);
                }
                this.list = (Cons)temp.reverse();
            }

            private Object readResolve() {
                return this.list;
            }
        }
    }

    public static final class Nil<T>
    implements List<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final Nil<?> INSTANCE = new Nil();

        private Nil() {
        }

        public static <T> Nil<T> instance() {
            return INSTANCE;
        }

        @Override
        public T head() {
            throw new NoSuchElementException("head of empty list");
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public List<T> tail() {
            throw new UnsupportedOperationException("tail of empty list");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return this.stringPrefix() + "()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

