/*
 * Decompiled with CFR 0.152.
 */
package javaslang;

import java.util.Objects;
import java.util.function.Predicate;
import javaslang.collection.List;

public final class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> instanceOf(Class<? extends T> type2) {
        Objects.requireNonNull(type2, "type is null");
        return obj -> obj != null && type2.isAssignableFrom(obj.getClass());
    }

    public static <T> Predicate<T> is(T value2) {
        return obj -> Objects.equals(obj, value2);
    }

    @SafeVarargs
    public static <T> Predicate<T> isIn(T ... values2) {
        Objects.requireNonNull(values2, "values is null");
        return obj -> List.of(values2).find(value2 -> Objects.equals(value2, obj)).isDefined();
    }

    @SafeVarargs
    public static <T> Predicate<T> allOf(Predicate<T> ... predicates) {
        Objects.requireNonNull(predicates, "predicates is null");
        return t -> List.of(predicates).foldLeft(true, (bool, pred) -> bool != false && pred.test(t));
    }

    @SafeVarargs
    public static <T> Predicate<T> anyOf(Predicate<T> ... predicates) {
        Objects.requireNonNull(predicates, "predicates is null");
        return t -> List.of(predicates).find(pred -> pred.test(t)).isDefined();
    }

    @SafeVarargs
    public static <T> Predicate<T> noneOf(Predicate<T> ... predicates) {
        Objects.requireNonNull(predicates, "predicates is null");
        return Predicates.anyOf(predicates).negate();
    }
}

