/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.NestedMappingEntry;
import org.jetbrains.debugger.sourcemap.NestedMappings;
import org.jetbrains.debugger.sourcemap.SourceFileResolver;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0012H\u0016J4\u0010$\u001a\u00020%2\u0006\u0010)\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'2\u0010\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010,\u0018\u00010+2\u0006\u0010(\u001a\u00020\u0012H\u0016J\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020%H\u0016J\u0012\u0010/\u001a\u0004\u0018\u00010\u00162\u0006\u00100\u001a\u00020\u0007H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u0010.\u001a\u00020%H\u0016J\u0012\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u00100\u001a\u00020\u0007H\u0016J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u0007032\u0006\u0010.\u001a\u00020%2\u0006\u00104\u001a\u00020%H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000RV\u0010\u0005\u001aJ\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\n\u00a2\u0006\u0002\b\t0\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lorg/jetbrains/debugger/sourcemap/NestedSourceMap;", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "childMap", "parentMap", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;Lorg/jetbrains/debugger/sourcemap/SourceMap;)V", "childMappingToTransformed", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "generatedMappings$delegate", "Lkotlin/Lazy;", "hasNameMappings", "", "getHasNameMappings", "()Z", "outFile", "", "getOutFile", "()Ljava/lang/String;", "sourceIndexToSourceMappings", "", "[Lorg/jetbrains/debugger/sourcemap/Mappings;", "sourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "getSourceResolver", "()Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "sources", "Lcom/intellij/util/Url;", "getSources", "()[Lcom/intellij/util/Url;", "findSourceIndex", "", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "localFileUrlOnly", "sourceUrl", "resolver", "Lkotlin/Lazy;", "Lorg/jetbrains/debugger/sourcemap/SourceFileResolver;", "findSourceMappings", "sourceIndex", "getRawSource", "entry", "getSourceContent", "getSourceMappingsInLine", "", "sourceLine", "intellij.platform.scriptDebugger.backend"})
@SourceDebugExtension(value={"SMAP\nNestedSourceMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedSourceMap.kt\norg/jetbrains/debugger/sourcemap/NestedSourceMap\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,107:1\n1360#2:108\n1446#2,2:109\n1448#2,3:118\n372#3,7:111\n*S KotlinDebug\n*F\n+ 1 NestedSourceMap.kt\norg/jetbrains/debugger/sourcemap/NestedSourceMap\n*L\n47#1:108\n47#1:109,2\n47#1:118,3\n54#1:111,7\n*E\n"})
public final class NestedSourceMap
implements SourceMap {
    @NotNull
    private final SourceMap childMap;
    @NotNull
    private final SourceMap parentMap;
    @NotNull
    private final Mappings[] sourceIndexToSourceMappings;
    @NotNull
    private final Map<MappingEntry, MappingEntry> childMappingToTransformed;
    @NotNull
    private final Lazy generatedMappings$delegate;

    public NestedSourceMap(@NotNull SourceMap childMap, @NotNull SourceMap parentMap) {
        Intrinsics.checkNotNullParameter((Object)childMap, (String)"childMap");
        Intrinsics.checkNotNullParameter((Object)parentMap, (String)"parentMap");
        this.childMap = childMap;
        this.parentMap = parentMap;
        this.sourceIndexToSourceMappings = new Mappings[this.parentMap.getSources().length];
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        this.childMappingToTransformed = map2;
        this.generatedMappings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NestedMappings>(this){
            final /* synthetic */ NestedSourceMap this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NestedMappings invoke() {
                return new NestedMappings(NestedSourceMap.access$getChildMap$p(this.this$0).getGeneratedMappings(), NestedSourceMap.access$getParentMap$p(this.this$0).getGeneratedMappings(), false);
            }
        }));
    }

    @Override
    @NotNull
    public SourceResolver getSourceResolver() {
        return this.parentMap.getSourceResolver();
    }

    @Override
    @NotNull
    public Url[] getSources() {
        return this.parentMap.getSources();
    }

    @Override
    @Nullable
    public String getOutFile() {
        return this.childMap.getOutFile();
    }

    @Override
    public boolean getHasNameMappings() {
        return this.childMap.getHasNameMappings() || this.parentMap.getHasNameMappings();
    }

    @Override
    @NotNull
    public Mappings getGeneratedMappings() {
        Lazy lazy = this.generatedMappings$delegate;
        return (Mappings)lazy.getValue();
    }

    @Override
    @NotNull
    public Mappings findSourceMappings(int sourceIndex) {
        Mappings result2 = this.sourceIndexToSourceMappings[sourceIndex];
        if (result2 == null) {
            this.sourceIndexToSourceMappings[sourceIndex] = result2 = (Mappings)new NestedMappings(this.childMap.findSourceMappings(sourceIndex), this.parentMap.findSourceMappings(sourceIndex), true);
        }
        return result2;
    }

    @Override
    public int findSourceIndex(@NotNull VirtualFile sourceFile, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        return this.parentMap.findSourceIndex(sourceFile, localFileUrlOnly);
    }

    @Override
    public int findSourceIndex(@NotNull Url sourceUrl, @Nullable VirtualFile sourceFile, @Nullable Lazy<? extends SourceFileResolver> resolver, boolean localFileUrlOnly) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        return this.parentMap.findSourceIndex(sourceUrl, sourceFile, resolver, localFileUrlOnly);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<MappingEntry> getSourceMappingsInLine(int sourceIndex, int sourceLine) {
        void $this$flatMapTo$iv$iv;
        Mappings childSourceMappings = this.childMap.findSourceMappings(sourceIndex);
        Mappings mappings = this.parentMap.findSourceMappings(sourceIndex);
        Intrinsics.checkNotNull((Object)mappings, (String)"null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        Iterable<MappingEntry> $this$flatMap$iv = ((MappingList)mappings).getMappingsInLine(sourceLine);
        boolean $i$f$flatMap = false;
        Iterable<MappingEntry> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.iterator();
        if (iterator.hasNext()) {
            MappingEntry mappingEntry;
            Object element$iv$iv = iterator.next();
            MappingEntry entry2 = (MappingEntry)element$iv$iv;
            boolean bl = false;
            int childIndex = childSourceMappings.indexOf(entry2.getGeneratedLine(), entry2.getGeneratedColumn());
            if (childIndex == -1) {
                return CollectionsKt.emptyList();
            }
            MappingEntry childEntry = childSourceMappings.getByIndex(childIndex);
            Map<MappingEntry, MappingEntry> $this$getOrPut$iv = this.childMappingToTransformed;
            boolean $i$f$getOrPut = false;
            MappingEntry value$iv = $this$getOrPut$iv.get(childEntry);
            if (value$iv == null) {
                boolean bl2 = false;
                MappingEntry answer$iv = new NestedMappingEntry(childEntry, entry2);
                $this$getOrPut$iv.put(childEntry, answer$iv);
                mappingEntry = answer$iv;
            } else {
                mappingEntry = value$iv;
            }
            return CollectionsKt.listOf((Object)mappingEntry);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public String getRawSource(@NotNull MappingEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        return this.parentMap.getRawSource(entry2);
    }

    @Override
    @Nullable
    public String getSourceContent(@NotNull MappingEntry entry2) {
        Intrinsics.checkNotNullParameter((Object)entry2, (String)"entry");
        return this.parentMap.getSourceContent(entry2);
    }

    @Override
    @Nullable
    public String getSourceContent(int sourceIndex) {
        return this.parentMap.getSourceContent(sourceIndex);
    }

    public static final /* synthetic */ SourceMap access$getChildMap$p(NestedSourceMap $this) {
        return $this.childMap;
    }

    public static final /* synthetic */ SourceMap access$getParentMap$p(NestedSourceMap $this) {
        return $this.parentMap;
    }
}

