/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnnotationChildVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameClassedPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.NullVisitor;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.rnc.ComplexityCache;
import com.thaiopensource.relaxng.output.rnc.NamespaceManager;
import com.thaiopensource.relaxng.output.rnc.Prettyprinter;
import com.thaiopensource.relaxng.output.rnc.StreamingPrettyprinter;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.util.Utf16;
import com.thaiopensource.xml.out.CharRepertoire;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class Output {
    private final Prettyprinter pp;
    private final CharRepertoire cr;
    private final String indent;
    private final String sourceUri;
    private final OutputDirectory od;
    private final ErrorReporter er;
    private final NamespaceManager.NamespaceBindings nsb;
    private final Map datatypeLibraryMap = new HashMap();
    private final ComplexityCache complexityCache = new ComplexityCache();
    private final NameClassVisitor nameClassOutput = new NameClassOutput(true);
    private final NameClassVisitor noParenNameClassOutput = new NameClassOutput(false);
    private final PatternVisitor noParenPatternOutput = new PatternOutput(false);
    private final PatternVisitor patternOutput = new PatternOutput(true);
    private final ComponentVisitor componentOutput = new ComponentOutput();
    private final AnnotationChildVisitor annotationChildOutput = new AnnotationChildOutput();
    private final AnnotationChildVisitor followingAnnotationChildOutput = new FollowingAnnotationChildOutput();
    private boolean isAttributeNameClass;
    private final StringBuffer encodeBuf = new StringBuffer();
    private static final String[] keywords = new String[]{"attribute", "default", "datatypes", "div", "element", "empty", "external", "grammar", "include", "inherit", "list", "mixed", "namespace", "notAllowed", "parent", "start", "string", "text", "token"};
    private static final Set keywordSet = new HashSet();
    private static final String[] delims;

    static void output(Pattern pattern2, String string2, String string3, OutputDirectory outputDirectory, ErrorReporter errorReporter) throws IOException {
        try {
            new Output(string3, string2, outputDirectory, errorReporter, NamespaceVisitor.createBindings(pattern2)).topLevel(pattern2);
        }
        catch (Prettyprinter.WrappedException wrappedException) {
            throw wrappedException.getIOException();
        }
    }

    private Output(String string2, String string3, OutputDirectory outputDirectory, ErrorReporter errorReporter, NamespaceManager.NamespaceBindings namespaceBindings) throws IOException {
        this.sourceUri = string2;
        this.od = outputDirectory;
        this.er = errorReporter;
        if (!(string3 == null || string3.equalsIgnoreCase("UTF-8") || string3.equalsIgnoreCase("UTF-16") || string3.equalsIgnoreCase("US-ASCII"))) {
            string3 = null;
        }
        OutputDirectory.Stream stream = outputDirectory.open(string2, string3);
        this.cr = stream.getCharRepertoire();
        this.pp = new StreamingPrettyprinter(outputDirectory.getLineLength(), outputDirectory.getLineSeparator(), stream.getWriter());
        this.nsb = namespaceBindings;
        char[] cArray = new char[outputDirectory.getIndent()];
        int n = 0;
        while (n < cArray.length) {
            cArray[n] = 32;
            ++n;
        }
        this.indent = new String(cArray);
    }

    private void topLevel(Pattern pattern2) {
        boolean bl;
        pattern2.accept(new TextAnnotationMerger());
        boolean bl2 = bl = pattern2 instanceof GrammarPattern && pattern2.getAttributeAnnotations().isEmpty();
        if (bl && !pattern2.getLeadingComments().isEmpty()) {
            this.leadingComments(pattern2);
            this.pp.hardNewline();
        }
        this.outputNamespaceDeclarations();
        this.outputDatatypeLibraryDeclarations(pattern2);
        if (bl) {
            Iterator iterator = pattern2.getChildElementAnnotations().iterator();
            while (iterator.hasNext()) {
                ((AnnotationChild)iterator.next()).accept(this.annotationChildOutput);
                this.pp.hardNewline();
            }
            this.innerBody(((GrammarPattern)pattern2).getComponents());
            Iterator iterator2 = pattern2.getFollowingElementAnnotations().iterator();
            while (iterator2.hasNext()) {
                this.pp.hardNewline();
                ((AnnotationChild)iterator2.next()).accept(this.annotationChildOutput);
            }
        } else {
            pattern2.accept(this.patternOutput);
        }
        this.pp.close();
    }

    private void outputNamespaceDeclarations() {
        Vector vector = new Vector();
        vector.addAll(this.nsb.getPrefixes());
        Collections.sort(vector);
        boolean bl = false;
        String string2 = null;
        String string3 = this.nsb.getNamespaceUri("");
        if (string3 != null && !string3.equals(SchemaBuilder.INHERIT_NS)) {
            string2 = this.nsb.getNonEmptyPrefix(string3);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            String string5 = this.nsb.getNamespaceUri(string4);
            if (string4.length() == 0) {
                if (string2 != null || string5.equals(SchemaBuilder.INHERIT_NS)) continue;
                this.pp.startGroup();
                this.pp.text("default namespace =");
                this.pp.startNest(this.indent);
                this.pp.softNewline(" ");
                this.literal(string5);
                this.pp.endNest();
                this.pp.endGroup();
                this.pp.hardNewline();
                bl = true;
                continue;
            }
            if (string4.equals("xml")) continue;
            this.pp.startGroup();
            if (string4.equals(string2)) {
                this.pp.text("default namespace ");
            } else {
                this.pp.text("namespace ");
            }
            this.encodedText(string4);
            this.pp.text(" =");
            this.pp.startNest(this.indent);
            this.pp.softNewline(" ");
            if (string5.equals(SchemaBuilder.INHERIT_NS)) {
                this.pp.text("inherit");
            } else {
                this.literal(string5);
            }
            this.pp.endNest();
            this.pp.endGroup();
            this.pp.hardNewline();
            bl = true;
        }
        if (bl) {
            this.pp.hardNewline();
        }
    }

    private void outputDatatypeLibraryDeclarations(Pattern pattern2) {
        this.datatypeLibraryMap.put("http://www.w3.org/2001/XMLSchema-datatypes", "xsd");
        Vector vector = new Vector();
        vector.addAll(DatatypeLibraryVisitor.findDatatypeLibraries(pattern2));
        if (vector.isEmpty()) {
            return;
        }
        Collections.sort(vector);
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            String string2 = "d";
            if (n2 > 1) {
                string2 = string2 + Integer.toString(n + 1);
            }
            String string3 = (String)vector.get(n);
            this.datatypeLibraryMap.put(string3, string2);
            this.pp.startGroup();
            this.pp.text("datatypes ");
            this.encodedText(string2);
            this.pp.text(" =");
            this.pp.startNest(this.indent);
            this.pp.softNewline(" ");
            this.literal(string3);
            this.pp.endNest();
            this.pp.endGroup();
            this.pp.hardNewline();
            ++n;
        }
        this.pp.hardNewline();
    }

    private static boolean hasAnnotations(Annotated annotated) {
        return !annotated.getChildElementAnnotations().isEmpty() || !annotated.getAttributeAnnotations().isEmpty() || !annotated.getFollowingElementAnnotations().isEmpty();
    }

    private boolean startAnnotations(Annotated annotated) {
        if (!annotated.getLeadingComments().isEmpty()) {
            this.leadingComments(annotated);
            if (!Output.hasAnnotations(annotated)) {
                return false;
            }
        } else if (!Output.hasAnnotations(annotated)) {
            return false;
        }
        List list2 = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
        int n = 0;
        int n2 = list2.size();
        while (n < n2) {
            String string2;
            int n3 = n;
            if (n != 0) {
                while (list2.get(n3) instanceof Comment && ++n3 < n2) {
                }
                if (n3 >= n2) break;
            }
            if ((string2 = Output.documentationString((AnnotationChild)list2.get(n3))) == null) break;
            if (n3 == n) {
                this.pp.hardNewline();
            } else {
                while (true) {
                    ((Comment)list2.get(n)).accept(this.annotationChildOutput);
                    if (++n == n3) break;
                    this.pp.hardNewline();
                }
            }
            this.comment("##", string2);
            ++n;
        }
        if (n > 0) {
            list2 = list2.subList(n, n2);
        }
        this.pp.startGroup();
        if (!annotated.getAttributeAnnotations().isEmpty() || !list2.isEmpty()) {
            if (!annotated.getAttributeAnnotations().isEmpty()) {
                this.checkContext(annotated.getContext(), annotated.getSourceLocation());
            }
            this.annotationBody(annotated.getAttributeAnnotations(), list2);
            this.pp.softNewline(" ");
        }
        return true;
    }

    private static String documentationString(AnnotationChild annotationChild) {
        if (!(annotationChild instanceof ElementAnnotation)) {
            return null;
        }
        ElementAnnotation elementAnnotation = (ElementAnnotation)annotationChild;
        if (!elementAnnotation.getLocalName().equals("documentation")) {
            return null;
        }
        if (!elementAnnotation.getNamespaceUri().equals("http://relaxng.org/ns/compatibility/annotations/1.0")) {
            return null;
        }
        if (!elementAnnotation.getAttributes().isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = elementAnnotation.getChildren().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TextAnnotation)) {
                return null;
            }
            stringBuffer.append(((TextAnnotation)e).getValue());
        }
        return stringBuffer.toString();
    }

    private void endAnnotations(Annotated annotated) {
        if (!annotated.mayContainText()) {
            Iterator iterator = annotated.getFollowingElementAnnotations().iterator();
            while (iterator.hasNext()) {
                if (annotated instanceof Component) {
                    this.pp.hardNewline();
                } else {
                    this.pp.softNewline(" ");
                }
                AnnotationChildVisitor annotationChildVisitor = annotated instanceof Component ? this.annotationChildOutput : this.followingAnnotationChildOutput;
                ((AnnotationChild)iterator.next()).accept(annotationChildVisitor);
            }
        }
        if (Output.hasAnnotations(annotated)) {
            this.pp.endGroup();
        }
    }

    private void leadingComments(Annotated annotated) {
        boolean bl = true;
        Iterator iterator = annotated.getLeadingComments().iterator();
        while (iterator.hasNext()) {
            if (!bl) {
                this.pp.hardNewline();
            } else {
                bl = false;
            }
            ((Comment)iterator.next()).accept(this.annotationChildOutput);
        }
    }

    private void annotationBody(List list2, List list3) {
        Object object;
        this.pp.startGroup();
        this.pp.text("[");
        this.pp.startNest(this.indent);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            object = (AttributeAnnotation)iterator.next();
            this.pp.softNewline(" ");
            this.pp.startGroup();
            this.qualifiedName(((AttributeAnnotation)object).getNamespaceUri(), ((AttributeAnnotation)object).getPrefix(), ((AttributeAnnotation)object).getLocalName(), true);
            this.pp.text(" =");
            this.pp.startNest(this.indent);
            this.pp.softNewline(" ");
            this.literal(((AttributeAnnotation)object).getValue());
            this.pp.endNest();
            this.pp.endGroup();
        }
        object = list3.iterator();
        while (object.hasNext()) {
            this.pp.softNewline(" ");
            ((AnnotationChild)object.next()).accept(this.annotationChildOutput);
        }
        this.pp.endNest();
        this.pp.softNewline(" ");
        this.pp.text("]");
        this.pp.endGroup();
    }

    private void body(Container container) {
        this.body(container.getComponents());
    }

    private void body(List list2) {
        if (list2.size() == 0) {
            this.pp.text(" { }");
        } else {
            this.pp.text(" {");
            this.pp.startNest(this.indent);
            this.pp.hardNewline();
            this.innerBody(list2);
            this.pp.endNest();
            this.pp.hardNewline();
            this.pp.text("}");
        }
    }

    private void innerBody(List list2) {
        boolean bl = true;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                this.pp.hardNewline();
            }
            ((Component)iterator.next()).accept(this.componentOutput);
        }
    }

    private void inherit(String string2) {
        if (string2.equals(this.nsb.getNamespaceUri(""))) {
            return;
        }
        this.pp.softNewline(" ");
        this.pp.text("inherit = ");
        this.encodedText(this.nsb.getNonEmptyPrefix(string2));
    }

    private void identifier(String string2) {
        if (keywordSet.contains(string2)) {
            this.pp.text("\\");
        }
        this.encodedText(string2);
    }

    private void literal(String string2) {
        int n;
        int n2 = 0;
        int n3 = string2.length();
        do {
            String string3 = null;
            n = -1;
            int n4 = string2.indexOf(10, n2);
            n4 = n4 < 0 ? n3 : ++n4;
            int n5 = 0;
            while (n5 < delims.length) {
                int n6 = (string2 + delims[n5]).indexOf(delims[n5], n2);
                if (n6 > n) {
                    string3 = delims[n5];
                    n = n6;
                    if (n6 >= n4) {
                        n = n4;
                        break;
                    }
                }
                ++n5;
            }
            if (n2 != 0) {
                this.pp.text(" ~");
                this.pp.softNewline(" ");
            }
            this.pp.text(string3);
            this.encodedText(string2.substring(n2, n));
            this.pp.text(string3);
        } while ((n2 = n) != n3);
    }

    private void encodedText(String string2) {
        this.pp.text(this.encode(string2));
    }

    private String encode(String string2) {
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        while (n3 < n2) {
            char c = string2.charAt(n3);
            switch (c) {
                case '\\': {
                    if (!Output.startsWithEscapeOpen(string2, n3)) break;
                }
                case '\n': 
                case '\r': {
                    if (n < n3) {
                        this.encodeBuf.append(string2.substring(n, n3));
                    }
                    this.escape(c);
                    n = n3 + 1;
                    break;
                }
                default: {
                    if (Utf16.isSurrogate(c)) {
                        if (!this.cr.contains(c, string2.charAt(n3 + 1))) {
                            if (n < n3) {
                                this.encodeBuf.append(string2.substring(n, n3));
                            }
                            this.escape(Utf16.scalarValue(c, string2.charAt(n3 + 1)));
                            n = n3 + 2;
                        }
                        ++n3;
                        break;
                    }
                    if (this.cr.contains(c)) break;
                    if (n < n3) {
                        this.encodeBuf.append(string2.substring(n, n3));
                    }
                    this.escape(c);
                    n = n3 + 1;
                }
            }
            ++n3;
        }
        if (n == 0) {
            return string2;
        }
        if (n != n2) {
            this.encodeBuf.append(string2.substring(n, n2));
        }
        string2 = this.encodeBuf.toString();
        this.encodeBuf.setLength(0);
        return string2;
    }

    private void escape(int n) {
        this.encodeBuf.append("\\x{");
        this.encodeBuf.append(Integer.toHexString(n));
        this.encodeBuf.append("}");
    }

    private static boolean startsWithEscapeOpen(String string2, int n) {
        if (!string2.startsWith("\\x", n)) {
            return false;
        }
        n += 2;
        while (string2.startsWith("x", n)) {
            ++n;
        }
        return string2.startsWith("{", n);
    }

    private void qualifiedName(String string2, String string3, String string4, boolean bl) {
        if ((string3 = this.choosePrefix(string2, string3, bl)) == null) {
            this.encodedText(string4);
        } else {
            this.encodedText(string3);
            this.pp.text(":");
            this.encodedText(string4);
        }
    }

    private String choosePrefix(String string2, String string3, boolean bl) {
        if (string3 != null && string2.equals(this.nsb.getNamespaceUri(string3))) {
            return string3;
        }
        if (bl ? string2.length() == 0 : string2.equals(this.nsb.getNamespaceUri(""))) {
            return null;
        }
        return this.nsb.getNonEmptyPrefix(string2);
    }

    private void comment(String string2, String string3) {
        int n = 0;
        while (true) {
            int n2;
            this.pp.text(string2);
            if (n < string3.length() && string3.charAt(n) != '\t') {
                this.pp.text(" ");
            }
            String string4 = (n2 = string3.indexOf(10, n)) < 0 ? string3.substring(n) : string3.substring(n, n2);
            this.encodedText(string4);
            this.pp.hardNewline();
            if (n2 < 0) break;
            n = n2 + 1;
        }
    }

    private void checkContext(Context context, SourceLocation sourceLocation) {
        if (context == null) {
            return;
        }
        Enumeration enumeration = context.prefixes();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (string3.equals("") || (string2 = context.resolveNamespacePrefix(string3)) == null || string2.equals(SchemaBuilder.INHERIT_NS) || this.nsb.getNamespaceUri(string3).equals(string2)) continue;
            this.er.warning("annotation_inconsistent_binding", string3, string2, sourceLocation);
        }
    }

    static {
        int n = 0;
        while (n < keywords.length) {
            keywordSet.add(keywords[n]);
            ++n;
        }
        delims = new String[]{"\"", "'", "\"\"\"", "'''"};
    }

    class FollowingAnnotationChildOutput
    extends AnnotationChildOutput {
        FollowingAnnotationChildOutput() {
        }

        public Object visitElement(ElementAnnotation elementAnnotation) {
            Output.this.pp.text(">> ");
            Output.this.pp.startNest(">> ");
            super.visitElement(elementAnnotation);
            Output.this.pp.endNest();
            return null;
        }
    }

    class AnnotationChildOutput
    implements AnnotationChildVisitor {
        AnnotationChildOutput() {
        }

        public Object visitText(TextAnnotation textAnnotation) {
            Output.this.literal(textAnnotation.getValue());
            return null;
        }

        public Object visitComment(Comment comment) {
            Output.this.comment("#", comment.getValue());
            return null;
        }

        public Object visitElement(ElementAnnotation elementAnnotation) {
            Output.this.checkContext(elementAnnotation.getContext(), elementAnnotation.getSourceLocation());
            Output.this.qualifiedName(elementAnnotation.getNamespaceUri(), elementAnnotation.getPrefix(), elementAnnotation.getLocalName(), true);
            Output.this.pp.text(" ");
            Output.this.annotationBody(elementAnnotation.getAttributes(), elementAnnotation.getChildren());
            return null;
        }
    }

    class NameClassOutput
    implements NameClassVisitor {
        private final boolean alwaysUseParens;

        NameClassOutput(boolean bl) {
            this.alwaysUseParens = bl;
        }

        public Object visitAnyName(AnyNameNameClass anyNameNameClass) {
            NameClass nameClass = anyNameNameClass.getExcept();
            if (nameClass == null) {
                Output.this.startAnnotations(anyNameNameClass);
                Output.this.pp.text("*");
            } else {
                boolean bl = Output.this.startAnnotations(anyNameNameClass) || this.alwaysUseParens;
                String string2 = bl ? "(* - " : "* - ";
                Output.this.pp.text(string2);
                Output.this.pp.startNest(string2);
                nameClass.accept(Output.this.nameClassOutput);
                if (bl) {
                    Output.this.pp.text(")");
                }
                Output.this.pp.endNest();
            }
            Output.this.endAnnotations(anyNameNameClass);
            return null;
        }

        public Object visitNsName(NsNameNameClass nsNameNameClass) {
            NameClass nameClass = nsNameNameClass.getExcept();
            String string2 = Output.this.nsb.getNonEmptyPrefix(nsNameNameClass.getNs());
            if (nameClass == null) {
                Output.this.startAnnotations(nsNameNameClass);
                Output.this.encodedText(string2);
                Output.this.pp.text(":*");
            } else {
                boolean bl = Output.this.startAnnotations(nsNameNameClass) || this.alwaysUseParens;
                String string3 = bl ? "(" : "";
                string3 = string3 + Output.this.encode(string2);
                string3 = string3 + ":* - ";
                Output.this.pp.text(string3);
                Output.this.pp.startNest(string3);
                nameClass.accept(Output.this.nameClassOutput);
                Output.this.pp.endNest();
                if (bl) {
                    Output.this.pp.text(")");
                }
            }
            Output.this.endAnnotations(nsNameNameClass);
            return null;
        }

        public Object visitName(NameNameClass nameNameClass) {
            Output.this.startAnnotations(nameNameClass);
            Output.this.qualifiedName(nameNameClass.getNamespaceUri(), nameNameClass.getPrefix(), nameNameClass.getLocalName(), Output.this.isAttributeNameClass);
            Output.this.endAnnotations(nameNameClass);
            return null;
        }

        public Object visitChoice(ChoiceNameClass choiceNameClass) {
            boolean bl = this.alwaysUseParens;
            if (Output.this.startAnnotations(choiceNameClass)) {
                bl = true;
            } else if (choiceNameClass.getChildren().size() == 1) {
                bl = false;
            }
            if (bl) {
                Output.this.pp.text("(");
                Output.this.pp.startNest("(");
            }
            Output.this.pp.startGroup();
            boolean bl2 = true;
            Iterator iterator = choiceNameClass.getChildren().iterator();
            while (iterator.hasNext()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    Output.this.pp.softNewline(" ");
                    Output.this.pp.text("| ");
                }
                ((NameClass)iterator.next()).accept(Output.this.nameClassOutput);
            }
            Output.this.pp.endGroup();
            if (bl) {
                Output.this.pp.endNest();
                Output.this.pp.text(")");
            }
            Output.this.endAnnotations(choiceNameClass);
            return null;
        }
    }

    class PatternOutput
    implements PatternVisitor {
        private final boolean alwaysUseParens;

        PatternOutput(boolean bl) {
            this.alwaysUseParens = bl;
        }

        public Object visitGrammar(GrammarPattern grammarPattern) {
            Output.this.startAnnotations(grammarPattern);
            Output.this.pp.text("grammar");
            Output.this.body(grammarPattern);
            Output.this.endAnnotations(grammarPattern);
            return null;
        }

        public Object visitElement(ElementPattern elementPattern) {
            Output.this.isAttributeNameClass = false;
            this.nameClassed(elementPattern, "element ");
            return null;
        }

        public Object visitAttribute(AttributePattern attributePattern) {
            Output.this.isAttributeNameClass = true;
            this.nameClassed(attributePattern, "attribute ");
            return null;
        }

        private void nameClassed(NameClassedPattern nameClassedPattern, String string2) {
            Output.this.startAnnotations(nameClassedPattern);
            Output.this.pp.text(string2);
            Output.this.pp.startNest(string2);
            nameClassedPattern.getNameClass().accept(Output.this.noParenNameClassOutput);
            Output.this.pp.endNest();
            this.braceChild(nameClassedPattern);
            Output.this.endAnnotations(nameClassedPattern);
        }

        private void braceChild(UnaryPattern unaryPattern) {
            boolean bl;
            Pattern pattern2 = unaryPattern.getChild();
            boolean bl2 = bl = !Output.this.complexityCache.isComplex(pattern2);
            if (bl) {
                Output.this.pp.startGroup();
            }
            Output.this.pp.text(" {");
            Output.this.pp.startNest(Output.this.indent);
            if (bl) {
                Output.this.pp.softNewline(" ");
            } else {
                Output.this.pp.hardNewline();
            }
            pattern2.accept(Output.this.noParenPatternOutput);
            Output.this.pp.endNest();
            if (bl) {
                Output.this.pp.softNewline(" ");
            } else {
                Output.this.pp.hardNewline();
            }
            Output.this.pp.text("}");
            if (bl) {
                Output.this.pp.endGroup();
            }
        }

        public Object visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            this.postfix(oneOrMorePattern, "+");
            return null;
        }

        public Object visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            this.postfix(zeroOrMorePattern, "*");
            return null;
        }

        public Object visitOptional(OptionalPattern optionalPattern) {
            this.postfix(optionalPattern, "?");
            return null;
        }

        private void postfix(UnaryPattern unaryPattern, String string2) {
            if (!Output.this.startAnnotations(unaryPattern)) {
                unaryPattern.getChild().accept(Output.this.patternOutput);
                Output.this.pp.text(string2);
            } else {
                Output.this.pp.text("(");
                Output.this.pp.startNest("(");
                unaryPattern.getChild().accept(Output.this.patternOutput);
                Output.this.pp.endNest();
                Output.this.pp.text(string2);
                Output.this.pp.text(")");
            }
            Output.this.endAnnotations(unaryPattern);
        }

        public Object visitRef(RefPattern refPattern) {
            Output.this.startAnnotations(refPattern);
            Output.this.identifier(refPattern.getName());
            Output.this.endAnnotations(refPattern);
            return null;
        }

        public Object visitParentRef(ParentRefPattern parentRefPattern) {
            Output.this.startAnnotations(parentRefPattern);
            Output.this.pp.text("parent ");
            Output.this.identifier(parentRefPattern.getName());
            Output.this.endAnnotations(parentRefPattern);
            return null;
        }

        public Object visitExternalRef(ExternalRefPattern externalRefPattern) {
            Output.this.startAnnotations(externalRefPattern);
            Output.this.pp.startGroup();
            Output.this.pp.text("external ");
            Output.this.pp.startNest("external ");
            Output.this.literal(Output.this.od.reference(Output.this.sourceUri, externalRefPattern.getHref()));
            Output.this.inherit(externalRefPattern.getNs());
            Output.this.pp.endNest();
            Output.this.pp.endGroup();
            Output.this.endAnnotations(externalRefPattern);
            return null;
        }

        public Object visitText(TextPattern textPattern) {
            Output.this.startAnnotations(textPattern);
            Output.this.pp.text("text");
            Output.this.endAnnotations(textPattern);
            return null;
        }

        public Object visitEmpty(EmptyPattern emptyPattern) {
            Output.this.startAnnotations(emptyPattern);
            Output.this.pp.text("empty");
            Output.this.endAnnotations(emptyPattern);
            return null;
        }

        public Object visitNotAllowed(NotAllowedPattern notAllowedPattern) {
            Output.this.startAnnotations(notAllowedPattern);
            Output.this.pp.text("notAllowed");
            Output.this.endAnnotations(notAllowedPattern);
            return null;
        }

        public Object visitList(ListPattern listPattern) {
            this.prefix(listPattern, "list");
            return null;
        }

        public Object visitMixed(MixedPattern mixedPattern) {
            this.prefix(mixedPattern, "mixed");
            return null;
        }

        private void prefix(UnaryPattern unaryPattern, String string2) {
            Output.this.startAnnotations(unaryPattern);
            Output.this.pp.text(string2);
            this.braceChild(unaryPattern);
            Output.this.endAnnotations(unaryPattern);
        }

        public Object visitChoice(ChoicePattern choicePattern) {
            this.composite(choicePattern, "| ", false);
            return null;
        }

        public Object visitInterleave(InterleavePattern interleavePattern) {
            this.composite(interleavePattern, "& ", false);
            return null;
        }

        public Object visitGroup(GroupPattern groupPattern) {
            this.composite(groupPattern, ",", true);
            return null;
        }

        void composite(CompositePattern compositePattern, String string2, boolean bl) {
            boolean bl2;
            boolean bl3 = this.alwaysUseParens;
            if (Output.this.startAnnotations(compositePattern)) {
                bl3 = true;
            }
            boolean bl4 = bl2 = !Output.this.complexityCache.isComplex(compositePattern);
            if (bl2) {
                Output.this.pp.startGroup();
            }
            if (bl3) {
                Output.this.pp.text("(");
                Output.this.pp.startNest("(");
            }
            boolean bl5 = true;
            Iterator iterator = compositePattern.getChildren().iterator();
            while (iterator.hasNext()) {
                if (!bl5) {
                    if (bl) {
                        Output.this.pp.text(string2);
                    }
                    if (bl2) {
                        Output.this.pp.softNewline(" ");
                    } else {
                        Output.this.pp.hardNewline();
                    }
                    if (!bl) {
                        Output.this.pp.text(string2);
                        Output.this.pp.startNest(string2);
                    }
                }
                ((Pattern)iterator.next()).accept(Output.this.patternOutput);
                if (bl5) {
                    bl5 = false;
                    continue;
                }
                if (bl) continue;
                Output.this.pp.endNest();
            }
            if (bl3) {
                Output.this.pp.endNest();
                Output.this.pp.text(")");
            }
            if (bl2) {
                Output.this.pp.endGroup();
            }
            Output.this.endAnnotations(compositePattern);
        }

        public Object visitData(DataPattern dataPattern) {
            Object object;
            Output.this.startAnnotations(dataPattern);
            String string2 = dataPattern.getDatatypeLibrary();
            String string3 = !string2.equals("") ? (String)Output.this.datatypeLibraryMap.get(string2) + ":" + dataPattern.getType() : dataPattern.getType();
            string3 = Output.this.encode(string3);
            Output.this.pp.text(string3);
            List list2 = dataPattern.getParams();
            if (list2.size() > 0) {
                Output.this.pp.startGroup();
                Output.this.pp.text(" {");
                Output.this.pp.startNest(Output.this.indent);
                object = list2.iterator();
                while (object.hasNext()) {
                    Output.this.pp.softNewline(" ");
                    Param param = (Param)object.next();
                    Output.this.startAnnotations(param);
                    Output.this.pp.startGroup();
                    Output.this.encodedText(param.getName());
                    Output.this.pp.text(" =");
                    Output.this.pp.startNest(Output.this.indent);
                    Output.this.pp.softNewline(" ");
                    Output.this.literal(param.getValue());
                    Output.this.pp.endNest();
                    Output.this.pp.endGroup();
                    Output.this.endAnnotations(param);
                }
                Output.this.pp.endNest();
                Output.this.pp.softNewline(" ");
                Output.this.pp.text("}");
                Output.this.pp.endGroup();
            }
            if ((object = dataPattern.getExcept()) != null) {
                String string4;
                boolean bl;
                boolean bl2 = bl = !((Annotated)object).mayContainText() && !((Annotated)object).getFollowingElementAnnotations().isEmpty();
                if (list2.isEmpty()) {
                    string4 = " - ";
                } else {
                    Output.this.pp.startGroup();
                    Output.this.pp.softNewline(" ");
                    string4 = "- ";
                }
                if (bl) {
                    string4 = string4 + "(";
                }
                Output.this.pp.text(string4);
                Output.this.pp.startNest(list2.isEmpty() ? string3 + string4 : string4);
                ((Pattern)object).accept(bl ? Output.this.noParenPatternOutput : Output.this.patternOutput);
                Output.this.pp.endNest();
                if (bl) {
                    Output.this.pp.text(")");
                }
                if (!list2.isEmpty()) {
                    Output.this.pp.endGroup();
                }
            }
            Output.this.endAnnotations(dataPattern);
            return null;
        }

        public Object visitValue(ValuePattern valuePattern) {
            String string2;
            String string3;
            Object object;
            Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                string3 = (String)object.getKey();
                string2 = (String)object.getValue();
                if (string2.equals(Output.this.nsb.getNamespaceUri(string3))) continue;
                if (string3.equals("")) {
                    Output.this.er.error("value_inconsistent_default_binding", string2, valuePattern.getSourceLocation());
                    continue;
                }
                Output.this.er.error("value_inconsistent_binding", string3, string2, valuePattern.getSourceLocation());
            }
            Output.this.startAnnotations(valuePattern);
            object = valuePattern.getDatatypeLibrary();
            Output.this.pp.startGroup();
            string3 = null;
            if (((String)object).equals("")) {
                if (!valuePattern.getType().equals("token")) {
                    string3 = valuePattern.getType() + " ";
                }
            } else {
                string3 = (String)Output.this.datatypeLibraryMap.get(object) + ":" + valuePattern.getType() + " ";
            }
            if (string3 != null) {
                string2 = Output.this.encode(string3);
                Output.this.pp.text(string2);
                Output.this.pp.startNest(string2);
            }
            Output.this.literal(valuePattern.getValue());
            if (string3 != null) {
                Output.this.pp.endNest();
            }
            Output.this.pp.endGroup();
            Output.this.endAnnotations(valuePattern);
            return null;
        }
    }

    class ComponentOutput
    implements ComponentVisitor {
        ComponentOutput() {
        }

        public Object visitDefine(DefineComponent defineComponent) {
            Output.this.startAnnotations(defineComponent);
            Output.this.pp.startGroup();
            String string2 = defineComponent.getName();
            if (string2 == DefineComponent.START) {
                Output.this.pp.text("start");
            } else {
                Output.this.identifier(string2);
            }
            Combine combine2 = defineComponent.getCombine();
            String string3 = combine2 == null ? " =" : (combine2 == Combine.CHOICE ? " |=" : " &=");
            Output.this.pp.text(string3);
            Output.this.pp.startNest(Output.this.indent);
            Output.this.pp.softNewline(" ");
            defineComponent.getBody().accept(Output.this.noParenPatternOutput);
            Output.this.pp.endNest();
            Output.this.pp.endGroup();
            Output.this.endAnnotations(defineComponent);
            return null;
        }

        public Object visitDiv(DivComponent divComponent) {
            Output.this.startAnnotations(divComponent);
            Output.this.pp.text("div");
            Output.this.body(divComponent);
            Output.this.endAnnotations(divComponent);
            return null;
        }

        public Object visitInclude(IncludeComponent includeComponent) {
            Output.this.startAnnotations(includeComponent);
            Output.this.pp.startGroup();
            Output.this.pp.text("include ");
            Output.this.pp.startNest("include ");
            Output.this.literal(Output.this.od.reference(Output.this.sourceUri, includeComponent.getHref()));
            Output.this.inherit(includeComponent.getNs());
            Output.this.pp.endNest();
            Output.this.pp.endGroup();
            List list2 = includeComponent.getComponents();
            if (!list2.isEmpty()) {
                Output.this.body(list2);
            }
            Output.this.endAnnotations(includeComponent);
            return null;
        }
    }

    static class NamespaceVisitor
    extends NullVisitor {
        private final NamespaceManager nsm = new NamespaceManager();
        private boolean isAttribute;

        NamespaceVisitor() {
        }

        public void nullVisitInclude(IncludeComponent includeComponent) {
            super.nullVisitInclude(includeComponent);
            this.nsm.requireNamespace(includeComponent.getNs(), true);
        }

        public void nullVisitExternalRef(ExternalRefPattern externalRefPattern) {
            super.nullVisitExternalRef(externalRefPattern);
            this.nsm.requireNamespace(externalRefPattern.getNs(), true);
        }

        public void nullVisitElement(ElementPattern elementPattern) {
            this.isAttribute = false;
            super.nullVisitElement(elementPattern);
        }

        public void nullVisitAttribute(AttributePattern attributePattern) {
            this.isAttribute = true;
            super.nullVisitAttribute(attributePattern);
        }

        public void nullVisitName(NameNameClass nameNameClass) {
            super.nullVisitName(nameNameClass);
            if (!this.isAttribute || nameNameClass.getNamespaceUri().length() != 0) {
                this.nsm.requireNamespace(nameNameClass.getNamespaceUri(), !this.isAttribute);
            }
            if (nameNameClass.getPrefix() == null) {
                if (!this.isAttribute) {
                    this.nsm.preferBinding("", nameNameClass.getNamespaceUri());
                }
            } else {
                this.nsm.preferBinding(nameNameClass.getPrefix(), nameNameClass.getNamespaceUri());
            }
        }

        public void nullVisitNsName(NsNameNameClass nsNameNameClass) {
            super.nullVisitNsName(nsNameNameClass);
            this.nsm.requireNamespace(nsNameNameClass.getNs(), false);
        }

        public void nullVisitValue(ValuePattern valuePattern) {
            super.nullVisitValue(valuePattern);
            Iterator iterator = valuePattern.getPrefixMap().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = iterator.next();
                this.nsm.requireBinding((String)entry2.getKey(), (String)entry2.getValue());
            }
        }

        public void nullVisitElement(ElementAnnotation elementAnnotation) {
            super.nullVisitElement(elementAnnotation);
            this.noteAnnotationBinding(elementAnnotation.getPrefix(), elementAnnotation.getNamespaceUri());
            this.noteContext(elementAnnotation.getContext(), true);
        }

        private void noteContext(Context context, boolean bl) {
            if (context == null) {
                return;
            }
            Enumeration enumeration = context.prefixes();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                if (string3.equals("") || (string2 = context.resolveNamespacePrefix(string3)) == null || string2.equals(SchemaBuilder.INHERIT_NS)) continue;
                if (bl) {
                    this.nsm.requireBinding(string3, string2);
                    continue;
                }
                this.nsm.preferBinding(string3, string2);
            }
        }

        public void nullVisitAttribute(AttributeAnnotation attributeAnnotation) {
            super.nullVisitAttribute(attributeAnnotation);
            this.noteAnnotationBinding(attributeAnnotation.getPrefix(), attributeAnnotation.getNamespaceUri());
        }

        private void noteAnnotationBinding(String string2, String string3) {
            if (string3.length() != 0) {
                this.nsm.requireNamespace(string3, false);
            }
            if (string2 != null) {
                this.nsm.preferBinding(string2, string3);
            }
        }

        public void nullVisitAnnotated(Annotated annotated) {
            annotated.leadingCommentsAccept(this);
            this.noteContext(annotated.getContext(), !annotated.getAttributeAnnotations().isEmpty());
            annotated.attributeAnnotationsAccept(this);
            List list2 = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
            int n = 0;
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                AnnotationChild annotationChild = (AnnotationChild)iterator.next();
                if (n < 2 && Output.documentationString(annotationChild) != null) {
                    n = 1;
                } else if (n != 1 || !(annotationChild instanceof Comment)) {
                    n = 2;
                }
                if (n != 2) continue;
                annotationChild.accept(this);
            }
            if (!annotated.mayContainText()) {
                annotated.followingElementAnnotationsAccept(this);
            }
        }

        static NamespaceManager.NamespaceBindings createBindings(Pattern pattern2) {
            NamespaceVisitor namespaceVisitor = new NamespaceVisitor();
            pattern2.accept(namespaceVisitor);
            return namespaceVisitor.nsm.createBindings();
        }
    }

    static class DatatypeLibraryVisitor
    extends NullVisitor {
        private final Set datatypeLibraries = new HashSet();

        DatatypeLibraryVisitor() {
        }

        public void nullVisitValue(ValuePattern valuePattern) {
            this.noteDatatypeLibrary(valuePattern.getDatatypeLibrary());
            super.nullVisitValue(valuePattern);
        }

        public void nullVisitData(DataPattern dataPattern) {
            this.noteDatatypeLibrary(dataPattern.getDatatypeLibrary());
            super.nullVisitData(dataPattern);
        }

        private void noteDatatypeLibrary(String string2) {
            if (!string2.equals("") && !string2.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                this.datatypeLibraries.add(string2);
            }
        }

        static Set findDatatypeLibraries(Pattern pattern2) {
            DatatypeLibraryVisitor datatypeLibraryVisitor = new DatatypeLibraryVisitor();
            pattern2.accept(datatypeLibraryVisitor);
            return datatypeLibraryVisitor.datatypeLibraries;
        }
    }

    static class TextAnnotationMerger
    extends NullVisitor {
        TextAnnotationMerger() {
        }

        public void nullVisitElement(ElementAnnotation elementAnnotation) {
            TextAnnotation textAnnotation = null;
            Iterator iterator = elementAnnotation.getChildren().iterator();
            while (iterator.hasNext()) {
                AnnotationChild annotationChild = (AnnotationChild)iterator.next();
                if (annotationChild instanceof TextAnnotation) {
                    if (textAnnotation == null) {
                        textAnnotation = (TextAnnotation)annotationChild;
                        continue;
                    }
                    textAnnotation.setValue(textAnnotation.getValue() + ((TextAnnotation)annotationChild).getValue());
                    iterator.remove();
                    continue;
                }
                textAnnotation = null;
                annotationChild.accept(this);
            }
        }
    }
}

