/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.light.legacy.JsonSchemaObjectMergerKt;
import com.jetbrains.jsonSchema.impl.tree.Operation;
import com.jetbrains.jsonSchema.impl.tree.ProcessDefinitionsOperation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaVariantsTreeBuilder {
    public static JsonSchemaTreeNode buildTree(@NotNull Project project2, @NotNull JsonSchemaObject schema, @NotNull JsonPointerPosition position, boolean skipLastExpand) {
        if (project2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(1);
        }
        if (position == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(2);
        }
        JsonSchemaTreeNode root = new JsonSchemaTreeNode(null, schema);
        JsonSchemaService service = JsonSchemaService.Impl.get(project2);
        JsonSchemaVariantsTreeBuilder.expandChildSchema(root, schema, service);
        for (JsonSchemaTreeNode treeNode : root.getChildren()) {
            treeNode.setPosition(position);
        }
        ArrayDeque<JsonSchemaTreeNode> queue2 = new ArrayDeque<JsonSchemaTreeNode>(root.getChildren());
        while (!queue2.isEmpty()) {
            JsonSchemaTreeNode node = queue2.removeFirst();
            if (node.isAny() || node.isNothing() || node.getPosition().isEmpty() || node.getSchema() == null) continue;
            JsonPointerPosition step2 = node.getPosition();
            if (!JsonSchemaVariantsTreeBuilder.typeMatches(step2.isObject(0), node.getSchema())) {
                node.nothingChild();
                continue;
            }
            Pair<ThreeState, JsonSchemaObject> pair = JsonSchemaVariantsTreeBuilder.doSingleStep(step2, node.getSchema(), true);
            if (ThreeState.NO.equals(pair.getFirst())) {
                node.nothingChild();
            } else if (ThreeState.YES.equals(pair.getFirst())) {
                node.anyChild();
            } else {
                assert (pair.getSecond() != null);
                if (node.getPosition().size() > 1 || !skipLastExpand) {
                    JsonSchemaVariantsTreeBuilder.expandChildSchema(node, (JsonSchemaObject)pair.getSecond(), service);
                } else {
                    node.setChild((JsonSchemaObject)pair.getSecond());
                }
            }
            queue2.addAll(node.getChildren());
        }
        return root;
    }

    private static boolean typeMatches(boolean isObject, @NotNull JsonSchemaObject schema) {
        JsonSchemaType requiredType;
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(3);
        }
        JsonSchemaType jsonSchemaType = requiredType = isObject ? JsonSchemaType._object : JsonSchemaType._array;
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static void expandChildSchema(@NotNull JsonSchemaTreeNode node, @NotNull JsonSchemaObject childSchema, @NotNull JsonSchemaService service) {
        if (node == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(4);
        }
        if (childSchema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(5);
        }
        if (service == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(6);
        }
        if (JsonSchemaVariantsTreeBuilder.interestingSchema(childSchema)) {
            node.createChildrenFromOperation(JsonSchemaVariantsTreeBuilder.getOperation(service, childSchema));
        } else {
            node.setChild(childSchema);
        }
    }

    @NotNull
    private static Operation getOperation(@NotNull JsonSchemaService service, JsonSchemaObject param) {
        if (service == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(7);
        }
        ProcessDefinitionsOperation expand = new ProcessDefinitionsOperation(param, service);
        expand.doMap(new HashSet<JsonSchemaObject>());
        expand.doReduce();
        ProcessDefinitionsOperation processDefinitionsOperation = expand;
        if (processDefinitionsOperation == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(8);
        }
        return processDefinitionsOperation;
    }

    @NotNull
    public static Pair<ThreeState, JsonSchemaObject> doSingleStep(@NotNull JsonPointerPosition step2, @NotNull JsonSchemaObject parent, boolean processAllBranches) {
        String name;
        if (step2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(10);
        }
        if ((name = step2.getFirstName()) != null) {
            return JsonSchemaVariantsTreeBuilder.propertyStep(name, parent, processAllBranches);
        }
        int index = step2.getFirstIndex();
        assert (index >= 0);
        return JsonSchemaVariantsTreeBuilder.arrayOrNumericPropertyElementStep(index, parent);
    }

    public static List<JsonSchemaObject> andGroups(@NotNull List<? extends JsonSchemaObject> g1, @NotNull List<? extends JsonSchemaObject> g2) {
        if (g1 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(11);
        }
        if (g2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(12);
        }
        ArrayList<JsonSchemaObject> result2 = new ArrayList<JsonSchemaObject>(g1.size() * g2.size());
        for (JsonSchemaObject jsonSchemaObject : g1) {
            result2.addAll(JsonSchemaVariantsTreeBuilder.andGroup(jsonSchemaObject, g2));
        }
        return result2;
    }

    public static List<JsonSchemaObject> andGroup(@NotNull JsonSchemaObject object, @NotNull List<? extends JsonSchemaObject> group2) {
        if (object == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(13);
        }
        if (group2 == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(14);
        }
        ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>(group2.size());
        for (JsonSchemaObject jsonSchemaObject : group2) {
            JsonSchemaObject schemaObject = JsonSchemaObjectMergerKt.getJsonSchemaObjectMerger().mergeObjects(object, jsonSchemaObject, jsonSchemaObject);
            if (!schemaObject.isValidByExclusion()) continue;
            list2.add(schemaObject);
        }
        return list2;
    }

    private static boolean interestingSchema(@NotNull JsonSchemaObject schema) {
        if (schema == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(15);
        }
        boolean hasAggregators = Registry.is((String)"json.schema.object.v2") ? schema.hasChildNode("anyOf") || schema.hasChildNode("oneOf") || schema.hasChildNode("allOf") || schema.hasChildNode("if") : schema.getAnyOf() != null || schema.getOneOf() != null || schema.getAllOf() != null;
        return hasAggregators || schema.getRef() != null || schema.getIfThenElse() != null;
    }

    @NotNull
    private static Pair<ThreeState, JsonSchemaObject> propertyStep(@NotNull String name, @NotNull JsonSchemaObject parent, boolean processAllBranches) {
        List<IfThenElse> ifThenElseList;
        JsonSchemaObject child;
        if (name == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(17);
        }
        if ((child = parent.getPropertyByName(name)) != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)child);
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(18);
            }
            return pair;
        }
        JsonSchemaObject schema = parent.getMatchingPatternPropertySchema(name);
        if (schema != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)schema);
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(19);
            }
            return pair;
        }
        if (parent.getAdditionalPropertiesSchema() != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalPropertiesSchema());
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(20);
            }
            return pair;
        }
        if (processAllBranches && (ifThenElseList = parent.getIfThenElse()) != null) {
            for (IfThenElse ifThenElse : ifThenElseList) {
                JsonSchemaObject childObject;
                JsonSchemaObject then2 = ifThenElse.getThen();
                if (then2 != null && (childObject = then2.getPropertyByName(name)) != null) {
                    Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)childObject);
                    if (pair == null) {
                        JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(21);
                    }
                    return pair;
                }
                JsonSchemaObject elseBranch = ifThenElse.getElse();
                if (elseBranch == null || (childObject = elseBranch.getPropertyByName(name)) == null) continue;
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)childObject);
                if (pair == null) {
                    JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(22);
                }
                return pair;
            }
        }
        if (Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
            Pair pair = Pair.create((Object)ThreeState.NO, null);
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(23);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)ThreeState.YES, null);
        if (pair == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @NotNull
    private static Pair<ThreeState, JsonSchemaObject> arrayOrNumericPropertyElementStep(int idx, @NotNull JsonSchemaObject parent) {
        String keyAsString;
        JsonSchemaObject propWithNameOrNull;
        if (parent == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(25);
        }
        if (parent.getItemsSchema() != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getItemsSchema());
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(26);
            }
            return pair;
        }
        if (parent.getItemsSchemaList() != null) {
            List<? extends JsonSchemaObject> list2 = parent.getItemsSchemaList();
            if (idx >= 0 && idx < list2.size()) {
                Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)list2.get(idx));
                if (pair == null) {
                    JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(27);
                }
                return pair;
            }
        }
        if ((propWithNameOrNull = parent.getPropertyByName(keyAsString = String.valueOf(idx))) != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)propWithNameOrNull);
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(28);
            }
            return pair;
        }
        JsonSchemaObject matchingPatternPropertySchema = parent.getMatchingPatternPropertySchema(keyAsString);
        if (matchingPatternPropertySchema != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)matchingPatternPropertySchema);
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(29);
            }
            return pair;
        }
        if (parent.getAdditionalItemsSchema() != null) {
            Pair pair = Pair.create((Object)ThreeState.UNSURE, (Object)parent.getAdditionalItemsSchema());
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(30);
            }
            return pair;
        }
        if (Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
            Pair pair = Pair.create((Object)ThreeState.NO, null);
            if (pair == null) {
                JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(31);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)ThreeState.YES, null);
        if (pair == null) {
            JsonSchemaVariantsTreeBuilder.$$$reportNull$$$0(32);
        }
        return pair;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSchema";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 10: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperation";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "propertyStep";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayOrNumericPropertyElementStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTree";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "typeMatches";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandChildSchema";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOperation";
                break;
            }
            case 8: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doSingleStep";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "andGroups";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "andGroup";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "interestingSchema";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "propertyStep";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "arrayOrNumericPropertyElementStep";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32 -> new IllegalStateException(string2);
        };
    }

    public static final class SchemaUrlSplitter {
        @Nullable
        private final String mySchemaId;
        @NotNull
        private final String myRelativePath;

        public SchemaUrlSplitter(@NotNull String ref) {
            if (ref == null) {
                SchemaUrlSplitter.$$$reportNull$$$0(0);
            }
            if (JsonPointerUtil.isSelfReference(ref)) {
                this.mySchemaId = null;
                this.myRelativePath = "";
                return;
            }
            if (!ref.startsWith("#/")) {
                int idx = ref.indexOf("#/");
                if (idx == -1) {
                    this.mySchemaId = ref.endsWith("#") ? ref.substring(0, ref.length() - 1) : ref;
                    this.myRelativePath = "";
                } else {
                    this.mySchemaId = ref.substring(0, idx);
                    this.myRelativePath = ref.substring(idx);
                }
            } else {
                this.mySchemaId = null;
                this.myRelativePath = ref;
            }
        }

        public boolean isAbsolute() {
            return this.mySchemaId != null;
        }

        @Nullable
        public String getSchemaId() {
            return this.mySchemaId;
        }

        @NotNull
        public String getRelativePath() {
            String string2 = this.myRelativePath;
            if (string2 == null) {
                SchemaUrlSplitter.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$SchemaUrlSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaVariantsTreeBuilder$SchemaUrlSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

