/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.util.Arrays;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommitSelectionListener<T extends VcsCommitMetadata>
implements ListSelectionListener {
    private static final Logger LOG = Logger.getInstance(CommitSelectionListener.class);
    @NotNull
    protected final VcsLogGraphTable myGraphTable;
    @NotNull
    private final DataGetter<? extends T> myCommitDetailsGetter;
    @Nullable
    private ListSelectionEvent myLastEvent;
    @Nullable
    private ProgressIndicator myLastRequest;

    protected CommitSelectionListener(@NotNull VcsLogGraphTable table, @NotNull DataGetter<? extends T> dataGetter) {
        if (table == null) {
            CommitSelectionListener.$$$reportNull$$$0(0);
        }
        if (dataGetter == null) {
            CommitSelectionListener.$$$reportNull$$$0(1);
        }
        this.myGraphTable = table;
        this.myCommitDetailsGetter = dataGetter;
    }

    @Override
    public void valueChanged(@Nullable ListSelectionEvent event) {
        if (event != null && event.getValueIsAdjusting()) {
            return;
        }
        this.myLastEvent = event;
        if (this.myLastRequest != null) {
            this.myLastRequest.cancel();
        }
        this.myLastRequest = null;
        ApplicationManager.getApplication().invokeLater(this::processEvent, o -> this.myLastEvent != event);
        this.onLoadingScheduled();
    }

    public void processEvent() {
        int rows = this.myGraphTable.getSelectedRowCount();
        if (rows < 1) {
            this.onLoadingStopped();
            this.onEmptySelection();
        } else {
            int[] toLoad = this.onSelection(this.myGraphTable.getSelectedRows());
            this.onLoadingStarted();
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            this.myLastRequest = indicator;
            this.myCommitDetailsGetter.loadCommitsData(this.myGraphTable.getModel().createSelection(toLoad).getIds(), detailsList -> {
                if (this.myLastRequest == indicator && !indicator.isCanceled()) {
                    if (toLoad.length != detailsList.size()) {
                        LOG.error("Loaded incorrect number of details " + detailsList + " for selection " + Arrays.toString(toLoad));
                    }
                    this.myLastRequest = null;
                    this.onDetailsLoaded((List<? extends T>)detailsList);
                    this.onLoadingStopped();
                }
            }, (Consumer<Throwable>)((Consumer)t -> {
                if (this.myLastRequest == indicator && !indicator.isCanceled()) {
                    this.myLastRequest = null;
                    LOG.error("Error loading details for selection " + Arrays.toString(toLoad), t);
                    this.onError((Throwable)t);
                    this.onLoadingStopped();
                }
            }), (ProgressIndicator)indicator);
        }
    }

    @RequiresEdt
    protected void onLoadingScheduled() {
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected abstract void onLoadingStarted();

    @RequiresEdt
    protected abstract void onLoadingStopped();

    @RequiresEdt
    protected abstract void onError(@NotNull Throwable var1);

    @RequiresEdt
    protected abstract void onDetailsLoaded(@NotNull List<? extends T> var1);

    @RequiresEdt
    protected abstract int @NotNull [] onSelection(int @NotNull [] var1);

    @RequiresEdt
    protected abstract void onEmptySelection();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "table";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataGetter";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/ui/table/CommitSelectionListener";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

