/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeHandlerEditorDiffPreview;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.frame.VcsLogDiffPreviewHandler;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\n\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ui/TreeHandlerEditorDiffPreview;", "changesBrowser", "Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;", "(Lcom/intellij/vcs/log/ui/frame/VcsLogChangesBrowser;)V", "oldToolWindowFocus", "Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview$ToolWindowFocus;", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "getCurrentToolWindowFocus", "getEditorTabName", "", "wrapper", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "handleEscapeKey", "", "openPreview", "", "requestFocus", "performDiffAction", "restoreToolWindowFocus", "ToolWindowFocus", "intellij.platform.vcs.log.impl"})
public final class VcsLogEditorDiffPreview
extends TreeHandlerEditorDiffPreview {
    @NotNull
    private final VcsLogChangesBrowser changesBrowser;
    @Nullable
    private ToolWindowFocus oldToolWindowFocus;

    public VcsLogEditorDiffPreview(@NotNull VcsLogChangesBrowser changesBrowser) {
        Intrinsics.checkNotNullParameter((Object)changesBrowser, (String)"changesBrowser");
        super((ChangesTree)changesBrowser.getViewer(), new VcsLogDiffPreviewHandler(changesBrowser));
        this.changesBrowser = changesBrowser;
        Disposer.register((Disposable)this.changesBrowser, (Disposable)((Disposable)this));
    }

    @Override
    public boolean openPreview(boolean requestFocus2) {
        this.oldToolWindowFocus = this.getCurrentToolWindowFocus();
        return super.openPreview(requestFocus2);
    }

    @Override
    protected void handleEscapeKey() {
        this.closePreview();
        this.restoreToolWindowFocus(this.oldToolWindowFocus);
    }

    private final ToolWindowFocus getCurrentToolWindowFocus() {
        Component component2 = IdeFocusManager.getInstance((Project)this.getProject()).getFocusOwner();
        if (component2 == null) {
            return null;
        }
        Component focusOwner = component2;
        Object object = InternalDecoratorImpl.Companion.findTopLevelDecorator(focusOwner);
        if (object == null || (object = object.getToolWindowId()) == null) {
            return null;
        }
        Object toolWindowId = object;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow((String)toolWindowId);
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null || (contentManager = contentManager.getSelectedContent()) == null) {
            return null;
        }
        ContentManager selectedContent = contentManager;
        return new ToolWindowFocus(focusOwner, (String)toolWindowId, (Content)selectedContent);
    }

    private final void restoreToolWindowFocus(ToolWindowFocus oldToolWindowFocus) {
        if (oldToolWindowFocus == null) {
            return;
        }
        Component component2 = (Component)oldToolWindowFocus.getComponent().get();
        if (component2 == null) {
            return;
        }
        Component component3 = component2;
        Content content = (Content)oldToolWindowFocus.getContent().get();
        if (content == null) {
            return;
        }
        Content content2 = content;
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow(oldToolWindowFocus.getToolWindowId());
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManagerIfCreated();
        if (contentManager == null) {
            return;
        }
        ContentManager contentManager2 = contentManager;
        if (contentManager2.getIndexOfContent(content2) < 0) {
            return;
        }
        contentManager2.setSelectedContent(content2);
        toolWindow2.activate(() -> VcsLogEditorDiffPreview.restoreToolWindowFocus$lambda$0(this, component3), false);
    }

    @Override
    @NotNull
    protected DiffEditorViewer createViewer() {
        return this.changesBrowser.createChangeProcessor(true);
    }

    @Override
    @NotNull
    public String getEditorTabName(@Nullable ChangeViewDiffRequestProcessor.Wrapper wrapper) {
        String string2;
        FilePath filePath;
        ChangeViewDiffRequestProcessor.Wrapper wrapper2 = wrapper;
        Object object = filePath = wrapper2 != null ? wrapper2.getFilePath() : null;
        if (filePath == null) {
            String string3 = VcsLogBundle.message("vcs.log.diff.preview.editor.empty.tab.name", new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{filePath.getName()};
            String string4 = VcsLogBundle.message("vcs.log.diff.preview.editor.tab.name", objectArray);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        }
        return string2;
    }

    @Override
    public boolean performDiffAction() {
        if (ExternalDiffTool.isEnabled()) {
            ListSelection listSelection = VcsTreeModelData.getListSelectionOrAll((JTree)((Object)this.changesBrowser.getViewer())).map(arg_0 -> VcsLogEditorDiffPreview.performDiffAction$lambda$1(this, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"map(...)");
            ListSelection diffProducers = listSelection;
            if (EditorTabPreviewBase.Companion.showExternalToolIfNeeded(this.getProject(), (ListSelection<? extends DiffRequestProducer>)diffProducers)) {
                return true;
            }
        }
        return super.performDiffAction();
    }

    private static final void restoreToolWindowFocus$lambda$0(VcsLogEditorDiffPreview this$0, Component $component) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        IdeFocusManager.getInstance((Project)this$0.getProject()).requestFocus($component, true);
    }

    private static final ChangeDiffRequestChain.Producer performDiffAction$lambda$1(VcsLogEditorDiffPreview this$0, Object change) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        VcsLogChangesBrowser vcsLogChangesBrowser = this$0.changesBrowser;
        Intrinsics.checkNotNull((Object)change);
        return vcsLogChangesBrowser.getDiffRequestProducer(change, false);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/ui/frame/VcsLogEditorDiffPreview$ToolWindowFocus;", "", "component", "Ljava/awt/Component;", "toolWindowId", "", "content", "Lcom/intellij/ui/content/Content;", "(Ljava/awt/Component;Ljava/lang/String;Lcom/intellij/ui/content/Content;)V", "Ljava/lang/ref/WeakReference;", "getComponent", "()Ljava/lang/ref/WeakReference;", "getContent", "getToolWindowId", "()Ljava/lang/String;", "intellij.platform.vcs.log.impl"})
    private static final class ToolWindowFocus {
        @NotNull
        private final String toolWindowId;
        @NotNull
        private final WeakReference<Component> component;
        @NotNull
        private final WeakReference<Content> content;

        public ToolWindowFocus(@NotNull Component component2, @NotNull String toolWindowId, @NotNull Content content) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.toolWindowId = toolWindowId;
            this.component = new WeakReference<Component>(component2);
            this.content = new WeakReference<Content>(content);
        }

        @NotNull
        public final String getToolWindowId() {
            return this.toolWindowId;
        }

        @NotNull
        public final WeakReference<Component> getComponent() {
            return this.component;
        }

        @NotNull
        public final WeakReference<Content> getContent() {
            return this.content;
        }
    }
}

