/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHashFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.FilterPair;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001cB!\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\u000f\u001a\u00020\u00022\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0014J\u0016\u0010\u0012\u001a\u00020\u00032\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011H\u0014J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0015\u001a\u00020\u0002H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0014J\u0016\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0019H\u0014J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/ui/filter/TextFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$PairFilterModel;", "Lcom/intellij/vcs/log/VcsLogTextFilter;", "Lcom/intellij/vcs/log/VcsLogHashFilter;", "properties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Lcom/intellij/vcs/log/VcsLogFilterCollection;Lcom/intellij/openapi/Disposable;)V", "text", "", "getText", "()Ljava/lang/String;", "createFilter1", "values", "", "createFilter2", "createTextFilter", "getFilter1Values", "filter1", "getFilter2Values", "filter2", "getFilterFromProperties", "Lcom/intellij/vcs/log/ui/filter/FilterPair;", "setFilterText", "", "Companion", "intellij.platform.vcs.log.impl"})
public final class TextFilterModel
extends FilterModel.PairFilterModel<VcsLogTextFilter, VcsLogHashFilter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public TextFilterModel(@NotNull MainVcsLogUiProperties properties2, @Nullable VcsLogFilterCollection filters, @NotNull Disposable parentDisposable) {
        VcsLogTextFilter textFilter;
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        VcsLogFilterCollection.FilterKey<VcsLogTextFilter> filterKey = VcsLogFilterCollection.TEXT_FILTER;
        Intrinsics.checkNotNullExpressionValue(filterKey, (String)"TEXT_FILTER");
        VcsLogFilterCollection.FilterKey<VcsLogHashFilter> filterKey2 = VcsLogFilterCollection.HASH_FILTER;
        Intrinsics.checkNotNullExpressionValue(filterKey2, (String)"HASH_FILTER");
        super(filterKey, filterKey2, properties2, filters);
        if (filters != null && (textFilter = filters.get(VcsLogFilterCollection.TEXT_FILTER)) != null) {
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"TEXT_FILTER_MATCH_CASE");
            this.uiProperties.set(vcsLogUiProperty, textFilter.matchesCase());
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.TEXT_FILTER_REGEX;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"TEXT_FILTER_REGEX");
            this.uiProperties.set(vcsLogUiProperty2, textFilter.isRegex());
        }
        VcsLogUiProperties.PropertiesChangeListener listener2 = new VcsLogUiProperties.PropertiesChangeListener(this){
            final /* synthetic */ TextFilterModel this$0;
            {
                this.this$0 = $receiver;
            }

            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
                Intrinsics.checkNotNullParameter(property2, (String)"property");
                if ((Intrinsics.areEqual(MainVcsLogUiProperties.TEXT_FILTER_REGEX, property2) || Intrinsics.areEqual(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, property2)) && this.this$0.getFilter1() != null) {
                    this.this$0._filter = this.this$0.getFilterFromProperties();
                    this.this$0.notifyFiltersChanged();
                }
            }
        };
        properties2.addChangeListener(listener2, parentDisposable);
    }

    @Override
    @Nullable
    protected FilterPair<VcsLogTextFilter, VcsLogHashFilter> getFilterFromProperties() {
        Object filterPair = super.getFilterFromProperties();
        if (filterPair == null) {
            return null;
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)((FilterPair)filterPair).getFilter1();
        VcsLogHashFilter hashFilter = (VcsLogHashFilter)((FilterPair)filterPair).getFilter2();
        if (textFilter != null) {
            String string2 = textFilter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string2)) {
                LOG.warn("Saved text filter is empty. Removing.");
                textFilter = null;
            }
        }
        if (textFilter != null) {
            String string3 = textFilter.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            VcsLogHashFilter hashFilterFromText = VcsLogFilterObject.fromHash(string3);
            if (!Intrinsics.areEqual((Object)hashFilter, (Object)hashFilterFromText)) {
                LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with text filter. Replacing with " + hashFilterFromText);
                hashFilter = hashFilterFromText;
            }
        } else if (hashFilter != null && !hashFilter.getHashes().isEmpty()) {
            String string4 = StringUtil.join(hashFilter.getHashes(), (String)" ");
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"join(...)");
            textFilter = this.createTextFilter(string4);
            LOG.warn("Saved hash filter " + hashFilter + " is inconsistent with empty text filter. Using text filter " + textFilter);
        }
        return new FilterPair<VcsLogFilter, VcsLogFilter>(textFilter, hashFilter);
    }

    @NotNull
    public final String getText() {
        VcsLogTextFilter vcsLogTextFilter = (VcsLogTextFilter)this.getFilter1();
        String string2 = vcsLogTextFilter != null ? vcsLogTextFilter.getText() : null;
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    @Override
    @NotNull
    protected List<String> getFilter1Values(@NotNull VcsLogTextFilter filter1) {
        Intrinsics.checkNotNullParameter((Object)filter1, (String)"filter1");
        String string2 = filter1.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        return CollectionsKt.listOf((Object)string2);
    }

    @Override
    @NotNull
    protected List<String> getFilter2Values(@NotNull VcsLogHashFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter2");
        return new ArrayList<String>(filter2.getHashes());
    }

    @Override
    @NotNull
    protected VcsLogTextFilter createFilter1(@NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        return this.createTextFilter((String)CollectionsKt.first(values2));
    }

    @Override
    @NotNull
    protected VcsLogHashFilter createFilter2(@NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        return VcsLogFilterObject.fromHashes((Collection<String>)values2);
    }

    private final VcsLogTextFilter createTextFilter(String text2) {
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.TEXT_FILTER_REGEX;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"TEXT_FILTER_REGEX");
        Boolean bl = this.uiProperties.get(vcsLogUiProperty);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"get(...)");
        boolean bl2 = bl;
        VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty2 = MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE;
        Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty2, (String)"TEXT_FILTER_MATCH_CASE");
        Boolean bl3 = this.uiProperties.get(vcsLogUiProperty2);
        Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"get(...)");
        return VcsLogFilterObject.fromPattern(text2, bl2, bl3);
    }

    public final void setFilterText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (StringsKt.isBlank((CharSequence)text2)) {
            this.setFilter(null);
        } else {
            VcsLogTextFilter textFilter = this.createTextFilter(text2);
            VcsLogHashFilter hashFilter = VcsLogFilterObject.fromHash(text2);
            this.setFilter(new FilterPair<VcsLogFilter, VcsLogFilter>(textFilter, hashFilter));
        }
    }

    static {
        Logger logger = Logger.getInstance(TextFilterModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/ui/filter/TextFilterModel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

