/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.actions.IndexDiagnosticActionBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/log/ui/actions/CheckSelectedCommits;", "Lcom/intellij/vcs/log/ui/actions/IndexDiagnosticActionBase;", "()V", "getCommitsToCheck", "", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "logManager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "getSelectedCommits", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "reportNotIndexed", "", "update", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nIndexDiagnosticActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexDiagnosticActions.kt\ncom/intellij/vcs/log/ui/actions/CheckSelectedCommits\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n766#2:129\n857#2,2:130\n*S KotlinDebug\n*F\n+ 1 IndexDiagnosticActions.kt\ncom/intellij/vcs/log/ui/actions/CheckSelectedCommits\n*L\n92#1:129\n92#1:130,2\n*E\n"})
public final class CheckSelectedCommits
extends IndexDiagnosticActionBase {
    public CheckSelectedCommits() {
        Supplier<String> supplier = VcsLogBundle.messagePointer("vcs.log.index.diagnostic.selected.action.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        super(supplier);
    }

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull VcsLogManager logManager2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        if (selection == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsLogData vcsLogData = logManager2.getDataManager();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getDataManager(...)");
        List<Integer> selectedCommits = this.getSelectedCommits(vcsLogData, selection, false);
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(!((Collection)selectedCommits).isEmpty());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getSelectedCommits(VcsLogData vcsLogData, VcsLogCommitSelection selection, boolean reportNotIndexed) {
        void $this$filterTo$iv$iv;
        List<Integer> selectedCommits = selection.getIds();
        if (selectedCommits.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable $this$filter$iv = selectedCommits;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!vcsLogData.getIndex().isIndexed(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selectedIndexedCommits = (List)destination$iv$iv;
        if (selectedIndexedCommits.isEmpty() && reportNotIndexed) {
            VcsNotifier.getInstance(vcsLogData.getProject()).notifyWarning(null, "", VcsLogBundle.message("vcs.log.index.diagnostic.selected.non.indexed.warning.message", new Object[0]));
        }
        return selectedIndexedCommits;
    }

    @Override
    @NotNull
    public List<Integer> getCommitsToCheck(@NotNull AnActionEvent e, @NotNull VcsLogManager logManager2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)logManager2, (String)"logManager");
        VcsLogData vcsLogData = logManager2.getDataManager();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogData, (String)"getDataManager(...)");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getRequiredData(...)");
        return this.getSelectedCommits(vcsLogData, (VcsLogCommitSelection)object, true);
    }
}

