/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.ide.impl.TrustedProjects;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogTabsManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.column.VcsLogColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnManager;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumn;
import com.intellij.vcs.log.ui.table.column.VcsLogDefaultColumnKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class VcsLogFeaturesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("vcs.log.ui", 3);
    private static final EventId UI_INITIALIZED = GROUP.registerEvent("uiInitialized");
    private static final VarargEventId DETAILS = GROUP.registerVarargEvent("details", new EventField[]{EventFields.Enabled});
    private static final VarargEventId DIFF_PREVIEW = GROUP.registerVarargEvent("diffPreview", new EventField[]{EventFields.Enabled});
    private static final VarargEventId DIFF_PREVIEW_ON_THE_BOTTOM = GROUP.registerVarargEvent("diffPreviewOnTheBottom", new EventField[]{EventFields.Enabled});
    private static final VarargEventId PARENT_CHANGES = GROUP.registerVarargEvent("parentChanges", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ONLY_AFFECTED_CHANGES = GROUP.registerVarargEvent("onlyAffectedChanges", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LONG_EDGES = GROUP.registerVarargEvent("long.edges", new EventField[]{EventFields.Enabled});
    private static final EnumEventField<PermanentGraph.SortType> SORT_TYPE_FIELD = EventFields.Enum((String)"value", PermanentGraph.SortType.class);
    private static final VarargEventId SORT = GROUP.registerVarargEvent("sort", new EventField[]{EventFields.Enabled, SORT_TYPE_FIELD});
    private static final VarargEventId ROOTS = GROUP.registerVarargEvent("roots", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LABELS_COMPACT = GROUP.registerVarargEvent("labels.compact", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LABELS_SHOW_TAG_NAMES = GROUP.registerVarargEvent("labels.showTagNames", new EventField[]{EventFields.Enabled});
    private static final VarargEventId LABELS_ON_THE_LEFT = GROUP.registerVarargEvent("labels.onTheLeft", new EventField[]{EventFields.Enabled});
    private static final VarargEventId TEXT_FILTER_REGEX = GROUP.registerVarargEvent("textFilter.regex", new EventField[]{EventFields.Enabled});
    private static final VarargEventId TEXT_FILTER_MATCH_CASE = GROUP.registerVarargEvent("textFilter.matchCase", new EventField[]{EventFields.Enabled});
    public static final String THIRD_PARTY = "THIRD_PARTY";
    private static final StringEventField LOG_HIGHLIGHTER_ID_FIELD = EventFields.String((String)"id", List.of("MY_COMMITS", "MERGE_COMMITS", "CURRENT_BRANCH", "THIRD_PARTY"));
    private static final VarargEventId HIGHLIGHTER = GROUP.registerVarargEvent("highlighter", new EventField[]{EventFields.Enabled, LOG_HIGHLIGHTER_ID_FIELD});
    private static final StringEventField FILTER_NAME = EventFields.String((String)"name", (List)ContainerUtil.map(VcsLogFilterCollection.STANDARD_KEYS, it -> it.getName()));
    private static final VarargEventId FILTER = GROUP.registerVarargEvent("filter", new EventField[]{EventFields.Enabled, FILTER_NAME});
    private static final StringEventField COLUMN_NAME = EventFields.String((String)"name", (List)ContainerUtil.map(VcsLogDefaultColumnKt.getDefaultDynamicColumns(), it -> it.getStableName()));
    private static final VarargEventId COLUMN = GROUP.registerVarargEvent("column", new EventField[]{EventFields.Enabled, COLUMN_NAME});
    private static final VarargEventId ADDITIONAL_TABS = GROUP.registerVarargEvent("additionalTabs", new EventField[]{EventFields.Count});

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project2) {
        VcsLogUiImpl ui2;
        if (project2 == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(0);
        }
        if (!TrustedProjects.isTrusted((Project)project2)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        VcsProjectLog projectLog = (VcsProjectLog)project2.getServiceIfCreated(VcsProjectLog.class);
        if (projectLog != null && (ui2 = projectLog.getMainLogUi()) != null) {
            MainVcsLogUiProperties properties2 = ui2.getProperties();
            VcsLogUiProperties defaultProperties = VcsLogFeaturesCollector.createDefaultPropertiesInstance();
            HashSet metricEvents = ContainerUtil.newHashSet((Object[])new MetricEvent[]{UI_INITIALIZED.metric()});
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_DETAILS), (VarargEventId)DETAILS);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_DIFF_PREVIEW), (VarargEventId)DIFF_PREVIEW);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT), (VarargEventId)DIFF_PREVIEW_ON_THE_BOTTOM);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS), (VarargEventId)PARENT_CHANGES);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES), (VarargEventId)ONLY_AFFECTED_CHANGES);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_LONG_EDGES), (VarargEventId)LONG_EDGES);
            MetricEventUtilKt.addIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.BEK_SORT_TYPE), (VarargEventId)SORT, SORT_TYPE_FIELD);
            if (ui2.getTable().getColorManager().hasMultiplePaths()) {
                MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_ROOT_NAMES), (VarargEventId)ROOTS);
            }
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.COMPACT_REFERENCES_VIEW), (VarargEventId)LABELS_COMPACT);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_TAG_NAMES), (VarargEventId)LABELS_SHOW_TAG_NAMES);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.LABELS_LEFT_ALIGNED), (VarargEventId)LABELS_ON_THE_LEFT);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.TEXT_FILTER_REGEX), (VarargEventId)TEXT_FILTER_REGEX);
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE), (VarargEventId)TEXT_FILTER_MATCH_CASE);
            for (VcsLogHighlighterFactory vcsLogHighlighterFactory : VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
                if (!vcsLogHighlighterFactory.showMenuItem()) continue;
                MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties2, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.VcsLogHighlighterProperty.get(vcsLogHighlighterFactory.getId())), (VarargEventId)HIGHLIGHTER, new ArrayList<EventPair>(List.of(LOG_HIGHLIGHTER_ID_FIELD.with((Object)VcsLogFeaturesCollector.getFactoryIdSafe(vcsLogHighlighterFactory)))));
            }
            for (VcsLogFilterCollection.FilterKey filterKey : VcsLogFilterCollection.STANDARD_KEYS) {
                if (properties2.getFilterValues(filterKey.getName()) == null) continue;
                metricEvents.add(FILTER.metric(new EventPair[]{EventFields.Enabled.with((Object)true), FILTER_NAME.with((Object)filterKey.getName())}));
            }
            VcsLogColumnManager modelIndices = VcsLogColumnManager.getInstance();
            Set set = ContainerUtil.map2Set(VcsLogColumnUtilKt.getColumnsOrder(properties2), it -> modelIndices.getModelIndex((VcsLogColumn<?>)it));
            Set defaultColumns = ContainerUtil.map2Set(VcsLogColumnUtilKt.getColumnsOrder(defaultProperties), it -> modelIndices.getModelIndex((VcsLogColumn<?>)it));
            for (VcsLogDefaultColumn<?> column : VcsLogDefaultColumnKt.getDefaultDynamicColumns()) {
                String columnName = column.getStableName();
                MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)set, (Object)defaultColumns, p -> p.contains(modelIndices.getModelIndex(column)), (VarargEventId)COLUMN, new ArrayList<EventPair>(List.of(COLUMN_NAME.with((Object)columnName))));
            }
            VcsLogTabsManager tabManager = projectLog.getTabManager();
            if (tabManager != null) {
                Collection<String> tabs = tabManager.getTabs();
                metricEvents.add(ADDITIONAL_TABS.metric(new EventPair[]{EventFields.Count.with((Object)tabs.size())}));
            }
            HashSet hashSet = metricEvents;
            if (hashSet == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(2);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static String getFactoryIdSafe(@NotNull VcsLogHighlighterFactory factory) {
        if (factory == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(4);
        }
        if (PluginInfoDetectorKt.getPluginInfo(factory.getClass()).isDevelopedByJetBrains()) {
            String string2 = UsageDescriptorKeyValidator.ensureProperKey((String)factory.getId());
            if (string2 == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(5);
            }
            return string2;
        }
        return THIRD_PARTY;
    }

    @NotNull
    private static <T> Function1<VcsLogUiProperties, T> getter(@NotNull VcsLogUiProperties.VcsLogUiProperty<? extends T> property2) {
        if (property2 == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(6);
        }
        Function1 function1 = p -> {
            if (!p.exists(property2)) {
                return null;
            }
            return p.get(property2);
        };
        if (function1 == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(7);
        }
        return function1;
    }

    @NotNull
    private static VcsLogUiProperties createDefaultPropertiesInstance() {
        return new VcsLogUiPropertiesImpl<VcsLogUiPropertiesImpl.State>(new VcsLogApplicationSettings()){
            @NotNull
            private final VcsLogUiPropertiesImpl.State myState = new VcsLogUiPropertiesImpl.State();

            @Override
            @NotNull
            protected VcsLogUiPropertiesImpl.State getLogUiState() {
                VcsLogUiPropertiesImpl.State state = this.myState;
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                return state;
            }

            @Override
            public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values2) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (values2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filterName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "values";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLogUiState";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addRecentlyFilteredGroup";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getRecentlyFilteredGroups";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2, 3 -> new IllegalArgumentException(string2);
                };
            }
        };
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryIdSafe";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryIdSafe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getter";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2, 3, 5, 7 -> new IllegalStateException(string2);
        };
    }
}

