/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UnorderedPair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.GraphModificationUtilKt;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.history.AdditionDeletion;
import com.intellij.vcs.log.history.FileHistory;
import com.intellij.vcs.log.history.FileHistoryData;
import com.intellij.vcs.log.history.FileHistoryKt;
import com.intellij.vcs.log.history.FileHistoryRefiner;
import com.intellij.vcs.log.history.MaybeDeletedFilePath;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.history.Rename;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001:\u0001/BK\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016J\u001e\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00022\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J2\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0'2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020*2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J9\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0+2\u0006\u0010#\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u00a2\u0006\u0002\u0010,J\u0016\u0010-\u001a\u00020\"2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\rH\u0002R \u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder;", "Ljava/util/function/BiConsumer;", "Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;", "Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;", "", "startCommit", "startPath", "Lcom/intellij/openapi/vcs/FilePath;", "fileHistoryData", "Lcom/intellij/vcs/log/history/FileHistoryData;", "oldFileHistory", "Lcom/intellij/vcs/log/history/FileHistory;", "commitsToHide", "", "removeTrivialMerges", "", "refine", "(Ljava/lang/Integer;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/vcs/log/history/FileHistoryData;Lcom/intellij/vcs/log/history/FileHistory;Ljava/util/Set;ZZ)V", "commitToRename", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/util/UnorderedPair;", "Lcom/intellij/vcs/log/history/Rename;", "fileHistory", "getFileHistory", "()Lcom/intellij/vcs/log/history/FileHistory;", "pathsMap", "", "Lcom/intellij/vcs/log/history/MaybeDeletedFilePath;", "processedAdditionsDeletions", "", "Lcom/intellij/vcs/log/history/AdditionDeletion;", "Ljava/lang/Integer;", "unmatchedAdditionsDeletions", "accept", "", "controller", "permanentGraphInfo", "collectAdditionsDeletions", "findAncestorRowAffectingFile", "Lkotlin/Pair;", "commitId", "visibleLinearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "", "(Lcom/intellij/vcs/log/graph/impl/facade/LinearGraphController;Ljava/lang/Integer;Lcom/intellij/vcs/log/graph/api/permanent/PermanentGraphInfo;)Ljava/util/Map;", "reportTrivialMerges", "trivialMerges", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nFileHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,501:1\n1477#2:502\n1502#2,3:503\n1505#2,3:513\n372#3,7:506\n1#4:516\n*S KotlinDebug\n*F\n+ 1 FileHistory.kt\ncom/intellij/vcs/log/history/FileHistoryBuilder\n*L\n81#1:502\n81#1:503,3\n81#1:513,3\n81#1:506,7\n*E\n"})
public final class FileHistoryBuilder
implements BiConsumer<LinearGraphController, PermanentGraphInfo<Integer>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer startCommit;
    @NotNull
    private final FilePath startPath;
    @NotNull
    private final FileHistoryData fileHistoryData;
    @NotNull
    private final FileHistory oldFileHistory;
    @NotNull
    private final Set<Integer> commitsToHide;
    private final boolean removeTrivialMerges;
    private final boolean refine;
    @NotNull
    private final Map<Integer, MaybeDeletedFilePath> pathsMap;
    @NotNull
    private final Set<AdditionDeletion> processedAdditionsDeletions;
    @NotNull
    private final Set<AdditionDeletion> unmatchedAdditionsDeletions;
    @NotNull
    private final MultiMap<UnorderedPair<Integer>, Rename> commitToRename;
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final RegistryValue removeTrivialMergesValue;
    @JvmField
    @NotNull
    public static final RegistryValue refineValue;

    public FileHistoryBuilder(@Nullable Integer startCommit, @NotNull FilePath startPath, @NotNull FileHistoryData fileHistoryData, @NotNull FileHistory oldFileHistory, @NotNull Set<Integer> commitsToHide, boolean removeTrivialMerges2, boolean refine) {
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter((Object)fileHistoryData, (String)"fileHistoryData");
        Intrinsics.checkNotNullParameter((Object)oldFileHistory, (String)"oldFileHistory");
        Intrinsics.checkNotNullParameter(commitsToHide, (String)"commitsToHide");
        this.startCommit = startCommit;
        this.startPath = startPath;
        this.fileHistoryData = fileHistoryData;
        this.oldFileHistory = oldFileHistory;
        this.commitsToHide = commitsToHide;
        this.removeTrivialMerges = removeTrivialMerges2;
        this.refine = refine;
        this.pathsMap = new LinkedHashMap();
        this.processedAdditionsDeletions = new LinkedHashSet();
        this.unmatchedAdditionsDeletions = new LinkedHashSet();
        this.commitToRename = new MultiMap();
    }

    public /* synthetic */ FileHistoryBuilder(Integer n, FilePath filePath, FileHistoryData fileHistoryData, FileHistory fileHistory, Set set, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            set = SetsKt.emptySet();
        }
        if ((n2 & 0x20) != 0) {
            bl = true;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = true;
        }
        this(n, filePath, fileHistoryData, fileHistory, set, bl, bl2);
    }

    @NotNull
    public final FileHistory getFileHistory() {
        return new FileHistory(this.pathsMap, this.processedAdditionsDeletions, this.unmatchedAdditionsDeletions, this.commitToRename);
    }

    @Override
    public void accept(@NotNull LinearGraphController controller, @NotNull PermanentGraphInfo<Integer> permanentGraphInfo) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter(permanentGraphInfo, (String)"permanentGraphInfo");
        boolean needToRepeat2 = this.removeTrivialMerges && FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>((Object)this){

            public final void invoke(@NotNull Set<Integer> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p0);
            }
        }));
        this.pathsMap.putAll(this.refine(controller, this.startCommit, permanentGraphInfo));
        if (needToRepeat2) {
            LOG.info("Some merge commits were not excluded from file history for " + this.startPath.getPath());
            FileHistoryKt.removeTrivialMerges(controller, permanentGraphInfo, this.fileHistoryData, (Function1<? super Set<Integer>, Unit>)((Function1)new Function1<Set<? extends Integer>, Unit>((Object)this){

                public final void invoke(@NotNull Set<Integer> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    FileHistoryBuilder.access$reportTrivialMerges((FileHistoryBuilder)this.receiver, p0);
                }
            }));
        }
        this.collectAdditionsDeletions(controller, permanentGraphInfo);
        this.commitToRename.putAllValues(this.fileHistoryData.getCommitToRename$intellij_platform_vcs_log_impl());
        if (!((Collection)this.commitsToHide).isEmpty()) {
            GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, this.commitsToHide);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void collectAdditionsDeletions(LinearGraphController controller, PermanentGraphInfo<Integer> permanentGraphInfo) {
        this.processedAdditionsDeletions.addAll((Collection<AdditionDeletion>)this.oldFileHistory.getProcessedAdditionsDeletions$intellij_platform_vcs_log_impl());
        this.processedAdditionsDeletions.addAll((Collection<AdditionDeletion>)this.oldFileHistory.getUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl());
        Set additionsDeletions = new LinkedHashSet();
        this.fileHistoryData.iterateUnmatchedAdditionsDeletions$intellij_platform_vcs_log_impl((Function1<? super AdditionDeletion, Unit>)((Function1)new Function1<AdditionDeletion, Unit>(this, (Set<AdditionDeletion>)additionsDeletions){
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ Set<AdditionDeletion> $additionsDeletions;
            {
                this.this$0 = $receiver;
                this.$additionsDeletions = $additionsDeletions;
                super(1);
            }

            public final void invoke(@NotNull AdditionDeletion ad) {
                Intrinsics.checkNotNullParameter((Object)ad, (String)"ad");
                if (!FileHistoryBuilder.access$getProcessedAdditionsDeletions$p(this.this$0).contains(ad)) {
                    this.$additionsDeletions.add(ad);
                }
            }
        }));
        if (!((Collection)additionsDeletions).isEmpty()) {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = additionsDeletions;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                AdditionDeletion it = (AdditionDeletion)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = it.getChild();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map grouped = destination$iv$iv;
            int n = controller.getCompiledGraph().nodesCount();
            for (int row2 = 0; row2 < n; ++row2) {
                Integer n2 = permanentGraphInfo.getPermanentCommitsInfo().getCommitId(controller.getCompiledGraph().getNodeId(row2));
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"getCommitId(...)");
                int commitId2 = ((Number)n2).intValue();
                if ((List)grouped.get(commitId2) != null) {
                    List it;
                    boolean bl = false;
                    this.unmatchedAdditionsDeletions.addAll(it);
                }
            }
        }
    }

    private final void reportTrivialMerges(Set<Integer> trivialMerges2) {
        LOG.debug("Excluding " + trivialMerges2.size() + " trivial merges from history for " + this.startPath.getPath());
    }

    private final Map<Integer, MaybeDeletedFilePath> refine(LinearGraphController controller, Integer startCommit, PermanentGraphInfo<Integer> permanentGraphInfo) {
        block6: {
            Pair<Integer, MaybeDeletedFilePath> pair;
            LinearGraph visibleLinearGraph;
            block8: {
                block7: {
                    LinearGraph linearGraph = controller.getCompiledGraph();
                    Intrinsics.checkNotNullExpressionValue((Object)linearGraph, (String)"getCompiledGraph(...)");
                    visibleLinearGraph = linearGraph;
                    if (visibleLinearGraph.nodesCount() <= 0 || !this.fileHistoryData.getHasRenames() || !this.refine) break block6;
                    pair = startCommit;
                    if (pair == null) break block7;
                    int it = ((Number)pair).intValue();
                    boolean bl = false;
                    Pair<Integer, MaybeDeletedFilePath> pair2 = this.findAncestorRowAffectingFile(startCommit.intValue(), visibleLinearGraph, permanentGraphInfo);
                    pair = pair2;
                    if (pair2 != null) break block8;
                }
                pair = new Pair((Object)0, (Object)new MaybeDeletedFilePath(this.startPath));
            }
            Pair<Integer, MaybeDeletedFilePath> pair3 = pair;
            int row2 = ((Number)pair3.component1()).intValue();
            MaybeDeletedFilePath path2 = (MaybeDeletedFilePath)pair3.component2();
            if (row2 >= 0) {
                FileHistoryRefiner refiner = new FileHistoryRefiner(visibleLinearGraph, permanentGraphInfo, this.fileHistoryData);
                Pair<Map<Integer, MaybeDeletedFilePath>, Set<Integer>> pair4 = refiner.refine(row2, path2);
                Map paths = (Map)pair4.component1();
                Set excluded = (Set)pair4.component2();
                if (!((Collection)excluded).isEmpty()) {
                    LOG.info("Excluding " + excluded.size() + " commits from history for " + this.startPath.getPath());
                    boolean hidden = GraphModificationUtilKt.hideCommits(controller, permanentGraphInfo, excluded);
                    if (!hidden) {
                        LOG.error("Could not hide excluded commits from history for " + this.startPath.getPath());
                    }
                }
                return paths;
            }
        }
        return this.fileHistoryData.buildPathsMap();
    }

    private final Pair<Integer, MaybeDeletedFilePath> findAncestorRowAffectingFile(int commitId2, LinearGraph visibleLinearGraph, PermanentGraphInfo<Integer> permanentGraphInfo) {
        MaybeDeletedFilePath existing = new MaybeDeletedFilePath(this.startPath);
        MaybeDeletedFilePath deleted2 = new MaybeDeletedFilePath(this.startPath, true);
        Ref ref = Ref.create((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref isDeleted = ref;
        Integer n = ReachableNodesUtilKt.findVisibleAncestorRow(commitId2, visibleLinearGraph, permanentGraphInfo, (Function1<? super Integer, Boolean>)((Function1)new Function1<Integer, Boolean>(permanentGraphInfo, this, existing, deleted2, (Ref<Boolean>)isDeleted){
            final /* synthetic */ PermanentGraphInfo<Integer> $permanentGraphInfo;
            final /* synthetic */ FileHistoryBuilder this$0;
            final /* synthetic */ MaybeDeletedFilePath $existing;
            final /* synthetic */ MaybeDeletedFilePath $deleted;
            final /* synthetic */ Ref<Boolean> $isDeleted;
            {
                this.$permanentGraphInfo = $permanentGraphInfo;
                this.this$0 = $receiver;
                this.$existing = $existing;
                this.$deleted = $deleted;
                this.$isDeleted = $isDeleted;
                super(1);
            }

            @NotNull
            public final Boolean invoke(int nodeId) {
                boolean bl;
                Integer n = this.$permanentGraphInfo.getPermanentCommitsInfo().getCommitId(nodeId);
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getCommitId(...)");
                int id = ((Number)n).intValue();
                if (FileHistoryData.affects$default(FileHistoryBuilder.access$getFileHistoryData$p(this.this$0), id, this.$existing, false, 4, null)) {
                    bl = true;
                } else if (FileHistoryData.affects$default(FileHistoryBuilder.access$getFileHistoryData$p(this.this$0), id, this.$deleted, false, 4, null)) {
                    this.$isDeleted.set((Object)true);
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }
        }));
        int row2 = n != null ? n : -1;
        Integer n2 = row2;
        Object object = isDeleted.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return new Pair((Object)n2, (Object)((Boolean)object != false ? deleted2 : existing));
    }

    public static final /* synthetic */ void access$reportTrivialMerges(FileHistoryBuilder $this, Set trivialMerges2) {
        $this.reportTrivialMerges(trivialMerges2);
    }

    public static final /* synthetic */ Set access$getProcessedAdditionsDeletions$p(FileHistoryBuilder $this) {
        return $this.processedAdditionsDeletions;
    }

    public static final /* synthetic */ FileHistoryData access$getFileHistoryData$p(FileHistoryBuilder $this) {
        return $this.fileHistoryData;
    }

    static {
        Logger logger = Logger.getInstance(FileHistoryBuilder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        RegistryValue registryValue = Registry.get((String)"vcs.history.remove.trivial.merges");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"get(...)");
        removeTrivialMergesValue = registryValue;
        RegistryValue registryValue2 = Registry.get((String)"vcs.history.refine");
        Intrinsics.checkNotNullExpressionValue((Object)registryValue2, (String)"get(...)");
        refineValue = registryValue2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0015\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000e\u001a\u00070\r\u00a2\u0006\u0002\b\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/vcs/log/history/FileHistoryBuilder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isRefine", "", "isRefine$intellij_platform_vcs_log_impl", "()Z", "isRemoveTrivialMerges", "isRemoveTrivialMerges$intellij_platform_vcs_log_impl", "refineValue", "Lcom/intellij/openapi/util/registry/RegistryValue;", "removeTrivialMergesValue", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isRemoveTrivialMerges$intellij_platform_vcs_log_impl() {
            return removeTrivialMergesValue.asBoolean();
        }

        public final boolean isRefine$intellij_platform_vcs_log_impl() {
            return refineValue.asBoolean();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

