/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class InvocationCache {
    private static final Map<JavaMethodSignature, Invocation> ourCoreInvocations = new HashMap<JavaMethodSignature, Invocation>();
    private final Map<Method, Invocation> myInvocations = ConcurrentFactoryMap.createMap(key2 -> ourCoreInvocations.get(new JavaMethodSignature((Method)key2)));
    private final Map<Method, JavaMethod> myJavaMethods;
    private final Map<JavaMethod, Boolean> myGetters = ConcurrentFactoryMap.createMap(key2 -> DomImplUtil.isTagValueGetter(key2));
    private final Map<JavaMethod, Boolean> mySetters = ConcurrentFactoryMap.createMap(key2 -> DomImplUtil.isTagValueSetter(key2));
    private final Map<JavaMethod, Map<Class<? extends Annotation>, Object>> myMethodAnnotations = ConcurrentFactoryMap.createMap(method -> ConcurrentFactoryMap.createMap(annoClass -> method.getAnnotation(annoClass)));
    private final Map<Class, Object> myClassAnnotations;
    private final Class myType;
    final StaticGenericInfo genericInfo;

    private static void addCoreInvocations(Class<?> aClass) {
        for (Method method : ReflectionUtil.getClassDeclaredMethods(aClass)) {
            if ("equals".equals(method.getName())) {
                ourCoreInvocations.put(new JavaMethodSignature(method), (handler2, args) -> {
                    Object arg;
                    DomElement proxy = handler2.getProxy();
                    if (proxy == (arg = args[0])) {
                        return true;
                    }
                    if (arg == null) {
                        return false;
                    }
                    if (arg instanceof DomElement) {
                        DomInvocationHandler handler1 = DomManagerImpl.getDomInvocationHandler(proxy);
                        return handler1 != null && handler1.equals(DomManagerImpl.getDomInvocationHandler((DomElement)arg));
                    }
                    return false;
                });
                continue;
            }
            if ("hashCode".equals(method.getName())) {
                ourCoreInvocations.put(new JavaMethodSignature(method), (handler2, args) -> handler2.hashCode());
                continue;
            }
            ourCoreInvocations.put(new JavaMethodSignature(method), (handler2, args) -> method.invoke((Object)handler2, args));
        }
    }

    InvocationCache(Class type2) {
        this.myType = type2;
        this.myJavaMethods = ConcurrentFactoryMap.createMap(key2 -> JavaMethod.getMethod(this.myType, key2));
        this.myClassAnnotations = ConcurrentFactoryMap.createMap(annoClass -> this.myType.getAnnotation(annoClass));
        this.genericInfo = new StaticGenericInfo(type2);
    }

    @Nullable
    Invocation getInvocation(Method method) {
        Invocation invocation = this.myInvocations.get(method);
        if (invocation == null && (invocation = this.genericInfo.createInvocation(this.getInternedMethod(method))) != null) {
            this.myInvocations.put(method, invocation);
        }
        return invocation;
    }

    JavaMethod getInternedMethod(Method method) {
        return this.myJavaMethods.get(method);
    }

    boolean isTagValueGetter(JavaMethod method) {
        return this.myGetters.get(method);
    }

    boolean isTagValueSetter(JavaMethod method) {
        return this.mySetters.get(method);
    }

    @Nullable
    <T extends Annotation> T getMethodAnnotation(JavaMethod method, Class<T> annoClass) {
        return (T)((Annotation)this.myMethodAnnotations.get(method).get(annoClass));
    }

    @Nullable
    <T extends Annotation> T getClassAnnotation(Class<T> annoClass) {
        return (T)((Annotation)this.myClassAnnotations.get(annoClass));
    }

    static {
        InvocationCache.addCoreInvocations(DomElement.class);
        InvocationCache.addCoreInvocations(Navigatable.class);
        InvocationCache.addCoreInvocations(AnnotatedElement.class);
        InvocationCache.addCoreInvocations(Object.class);
        ourCoreInvocations.put(new JavaMethodSignature("getUserData", Key.class), (handler2, args) -> handler2.getUserData((Key)args[0]));
        ourCoreInvocations.put(new JavaMethodSignature("putUserData", Key.class, Object.class), (handler2, args) -> {
            handler2.putUserData((Key)args[0], args[1]);
            return null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("getXmlElement", new Class[0]), (handler2, args) -> handler2.getXmlElement());
        ourCoreInvocations.put(new JavaMethodSignature("getXmlTag", new Class[0]), (handler2, args) -> handler2.getXmlTag());
        ourCoreInvocations.put(new JavaMethodSignature("getParent", new Class[0]), (handler2, args) -> handler2.getParent());
        ourCoreInvocations.put(new JavaMethodSignature("accept", DomElementVisitor.class), (handler2, args) -> {
            handler2.accept((DomElementVisitor)args[0]);
            return null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("acceptChildren", DomElementVisitor.class), (handler2, args) -> {
            handler2.acceptChildren((DomElementVisitor)args[0]);
            return null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("getAnnotation", Class.class), (handler2, args) -> handler2.getAnnotation((Class)args[0]));
        ourCoreInvocations.put(new JavaMethodSignature("getRawText", new Class[0]), (handler2, args) -> handler2.getValue());
        ourCoreInvocations.put(new JavaMethodSignature("getXmlAttribute", new Class[0]), (handler2, args) -> handler2.getXmlElement());
        ourCoreInvocations.put(new JavaMethodSignature("getXmlAttributeValue", new Class[0]), (handler2, args) -> {
            XmlAttribute attribute = (XmlAttribute)handler2.getXmlElement();
            return attribute != null ? attribute.getValueElement() : null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("getConverter", new Class[0]), (handler2, args) -> {
            try {
                return handler2.getScalarConverter();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw cause;
                }
                throw new RuntimeException(e);
            }
        });
    }
}

