/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.NonExhaustiveEnum;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumConverter<T extends Enum>
extends ResolvingConverter<T> {
    private final Class<T> myType;

    private EnumConverter(Class<T> aClass) {
        this.myType = aClass;
    }

    public static <T extends Enum> EnumConverter<T> createEnumConverter(Class<T> aClass) {
        return new EnumConverter<T>(aClass);
    }

    private String getStringValue(T anEnum) {
        return NamedEnumUtil.getEnumValueByElement(anEnum);
    }

    @Override
    public T fromString(String s, ConvertContext context) {
        return s == null ? null : (T)NamedEnumUtil.getEnumElementByValue(this.myType, s);
    }

    @Override
    public String toString(T t, ConvertContext context) {
        return t == null ? null : this.getStringValue(t);
    }

    @Override
    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return XmlDomBundle.message("dom.converter.unknown.enum.value", s);
    }

    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        XmlTag simpleContent;
        XmlElement element = context.getXmlElement();
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)element)) != null && XmlUtil.collectEnumerationValues(simpleContent, new HashSet())) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                EnumConverter.$$$reportNull$$$0(0);
            }
            return list2;
        }
        List<Enum> list3 = Arrays.asList((Enum[])this.myType.getEnumConstants());
        if (list3 == null) {
            EnumConverter.$$$reportNull$$$0(1);
        }
        return list3;
    }

    public boolean isExhaustive() {
        return !ReflectionUtil.isAssignable(NonExhaustiveEnum.class, this.myType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/EnumConverter", "getVariants"));
    }
}

