/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.paths.GlobalPathReferenceProvider;
import com.intellij.openapi.paths.UrlReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/psi/impl/source/resolve/reference/UrlReferenceProvider;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "()V", "doGetReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "host", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "configuration", "Lcom/intellij/openapi/vcs/IssueNavigationConfiguration;", "getReferences", "element", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "intellij.platform.vcs.impl"})
public final class UrlReferenceProvider
implements PsiSymbolReferenceProvider {
    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element, @NotNull PsiSymbolReferenceHints hints) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        if (!Registry.is((String)"ide.symbol.url.references")) {
            return CollectionsKt.emptyList();
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)element), () -> UrlReferenceProvider.getReferences$lambda$0(element, this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Collection)object;
    }

    private final Collection<PsiSymbolReference> doGetReferences(PsiExternalReferenceHost host, IssueNavigationConfiguration configuration) {
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)host.getText(), (long)500L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        CharSequence commentText = charSequence;
        List<IssueNavigationConfiguration.LinkMatch> list2 = configuration.findIssueLinks(commentText);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"findIssueLinks(...)");
        List<IssueNavigationConfiguration.LinkMatch> linkMatches = list2;
        if (linkMatches.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ArrayList result2 = new ArrayList(linkMatches.size());
        for (IssueNavigationConfiguration.LinkMatch linkMatch : linkMatches) {
            String url = linkMatch.getTargetUrl();
            if (!GlobalPathReferenceProvider.isWebReferenceUrl((String)url)) continue;
            Collection collection = result2;
            PsiElement psiElement = (PsiElement)host;
            TextRange textRange = linkMatch.getRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getRange(...)");
            Intrinsics.checkNotNull((Object)url);
            collection.add(new UrlReference(psiElement, textRange, url));
        }
        return result2;
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project2, @NotNull Symbol target) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.emptyList();
    }

    private static final CachedValueProvider.Result getReferences$lambda$0(PsiExternalReferenceHost $element, UrlReferenceProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance($element.getProject());
        Intrinsics.checkNotNull((Object)((Object)configuration));
        Collection<PsiSymbolReference> references = this$0.doGetReferences($element, configuration);
        Object[] objectArray = new Object[]{$element, configuration};
        return CachedValueProvider.Result.create(references, (Object[])objectArray);
    }
}

