/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ml.impl.correctness.autoimport;

import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionEngine;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.ml.impl.correctness.autoimport.ImportFixer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bJ$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\bH$J\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H$J(\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/ml/impl/correctness/autoimport/InspectionBasedImportFixer;", "Lcom/intellij/platform/ml/impl/correctness/autoimport/ImportFixer;", "()V", "applyFixes", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "problemDescriptors", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "areFixableByAutoImport", "", "problems", "filterApplicableFixes", "Lcom/intellij/codeInspection/LocalQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "fixes", "getAutoImportInspections", "Lcom/intellij/codeInspection/LocalInspectionTool;", "runAutoImport", "file", "Lcom/intellij/psi/PsiFile;", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "context", "Lcom/intellij/platform/ml/impl/correctness/autoimport/ImportFixer$ImportContext;", "intellij.platform.ml.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nInspectionBasedImportFixer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectionBasedImportFixer.kt\ncom/intellij/platform/ml/impl/correctness/autoimport/InspectionBasedImportFixer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,69:1\n1549#2:70\n1620#2,3:71\n1726#2,2:74\n1728#2:89\n1549#2:90\n1620#2,2:91\n1622#2:106\n1549#2:107\n1620#2,3:108\n288#2,2:111\n18#3:76\n18#3:93\n26#4:77\n26#4:94\n4098#5,11:78\n4098#5,11:95\n*S KotlinDebug\n*F\n+ 1 InspectionBasedImportFixer.kt\ncom/intellij/platform/ml/impl/correctness/autoimport/InspectionBasedImportFixer\n*L\n35#1:70\n35#1:71,3\n48#1:74,2\n48#1:89\n56#1:90\n56#1:91,2\n56#1:106\n57#1:107\n57#1:108,3\n58#1:111,2\n49#1:76\n56#1:93\n49#1:77\n56#1:94\n49#1:78,11\n56#1:95,11\n*E\n"})
public abstract class InspectionBasedImportFixer
implements ImportFixer {
    @NotNull
    protected abstract List<LocalInspectionTool> getAutoImportInspections(@Nullable PsiElement var1);

    @NotNull
    protected abstract List<LocalQuickFix> filterApplicableFixes(@NotNull PsiElement var1, @NotNull List<? extends LocalQuickFix> var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public void runAutoImport(@NotNull PsiFile file, @NotNull Editor editor, @NotNull TextRange suggestionRange, @NotNull ImportFixer.ImportContext context) {
        void $this$mapTo$iv$iv;
        ProgressIndicator progressIndicator;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List list2 = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)file)).onRange(suggestionRange).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"toList(...)");
        List elements = list2;
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (!bl) {
            progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        } else if (bl) {
            progressIndicator = (ProgressIndicator)new DaemonProgressIndicator();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ProgressIndicator indicator = progressIndicator;
        Iterable $this$map$iv = this.getAutoImportInspections((PsiElement)file);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalInspectionTool localInspectionTool = (LocalInspectionTool)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new LocalInspectionToolWrapper((LocalInspectionTool)it));
        }
        List problemDescriptors = CollectionsKt.flatten((Iterable)InspectionEngine.inspectElements((List)((List)destination$iv$iv), (PsiFile)file, (TextRange)file.getTextRange(), (boolean)true, (boolean)true, (ProgressIndicator)indicator, (List)elements, (PairProcessor)PairProcessor.alwaysTrue()).values());
        this.applyFixes(editor, problemDescriptors);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean areFixableByAutoImport(@NotNull List<? extends ProblemDescriptor> problems2) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(problems2, (String)"problems");
            Iterable $this$all$iv = problems2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    ProblemDescriptor it = (ProblemDescriptor)element$iv;
                    boolean bl2 = false;
                    QuickFix[] $this$orEmpty$iv = it.getFixes();
                    boolean $i$f$orEmpty = false;
                    QuickFix[] quickFixArray = $this$orEmpty$iv;
                    if ($this$orEmpty$iv == null) {
                        boolean $i$f$emptyArray = false;
                        quickFixArray = new QuickFix[]{};
                    }
                    $this$orEmpty$iv = quickFixArray;
                    boolean $i$f$filterIsInstance = false;
                    void $i$f$emptyArray = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof LocalQuickFix)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List fixes = (List)destination$iv$iv;
                    PsiElement psiElement = it.getPsiElement();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
                    if (!((Collection)this.filterApplicableFixes(psiElement, fixes)).isEmpty()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFixes(@NotNull Editor editor, @NotNull List<? extends ProblemDescriptor> problemDescriptors) {
        Object v1;
        block8: {
            void $this$firstOrNull$iv;
            Collection collection;
            ProblemDescriptor problemDescriptor;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter(problemDescriptors, (String)"problemDescriptors");
            Iterable iterable = problemDescriptors;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PsiElement psiElement;
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                void it;
                problemDescriptor = (ProblemDescriptor)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getPsiElement(), (String)"getPsiElement(...)");
                QuickFix[] $this$orEmpty$iv = it.getFixes();
                boolean $i$f$orEmpty = false;
                QuickFix[] quickFixArray = $this$orEmpty$iv;
                if ($this$orEmpty$iv == null) {
                    boolean $i$f$emptyArray = false;
                    quickFixArray = new QuickFix[]{};
                }
                $this$orEmpty$iv = quickFixArray;
                InspectionBasedImportFixer inspectionBasedImportFixer = this;
                void var19_23 = it;
                boolean $i$f$filterIsInstance = false;
                void $i$f$emptyArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LocalQuickFix)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List list2 = (List)destination$iv$iv2;
                collection.add(TuplesKt.to((Object)var19_23, inspectionBasedImportFixer.filterApplicableFixes(psiElement, list2)));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                problemDescriptor = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ProblemDescriptor descriptor = (ProblemDescriptor)problemDescriptor.component1();
                List fixes = (List)problemDescriptor.component2();
                collection.add(TuplesKt.to((Object)descriptor, (Object)CollectionsKt.firstOrNull((List)fixes)));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                LocalQuickFix fix = (LocalQuickFix)pair.component2();
                if (!(fix != null)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        Pair pair = v1;
        if (pair == null) {
            return;
        }
        Pair pair2 = pair;
        ProblemDescriptor descriptor = (ProblemDescriptor)pair2.component1();
        LocalQuickFix fixToApply = (LocalQuickFix)pair2.component2();
        if (fixToApply == null) {
            return;
        }
        long lastModified = editor.getDocument().getModificationStamp();
        Project project2 = editor.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ApplicationManager.getApplication().invokeLater(() -> InspectionBasedImportFixer.applyFixes$action(fixToApply, project3, descriptor), ModalityState.defaultModalityState(), arg_0 -> InspectionBasedImportFixer.applyFixes$lambda$6(editor, lastModified, arg_0));
    }

    private static final void applyFixes$action$lambda$5(LocalQuickFix $fixToApply, Project $project, ProblemDescriptor $descriptor) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$descriptor, (String)"$descriptor");
        $fixToApply.applyFix($project, (CommonProblemDescriptor)$descriptor);
    }

    private static final void applyFixes$action(LocalQuickFix fixToApply, Project project2, ProblemDescriptor descriptor) {
        ApplicationManager.getApplication().runWriteAction(() -> InspectionBasedImportFixer.applyFixes$action$lambda$5(fixToApply, project2, descriptor));
    }

    private static final boolean applyFixes$lambda$6(Editor $editor, long $lastModified, Object it) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        return $editor.getDocument().getModificationStamp() != $lastModified;
    }
}

