/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.simple.AlignableChange;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffRangeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vcs.changes.patch.AppliedTextPatch;
import com.intellij.openapi.vcs.changes.patch.tool.PatchChangeBuilderKt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 %2\u00020\u0001:\u0006#$%&'(B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0015\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0016\u0010\u0019\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0010J\u0014\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tj\u0002`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder;", "", "()V", "convertor1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor$Builder;", "convertor2", "separatorLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "textBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "totalLines", "", "addChangedLines", "", "lines", "", "", "lineNumber", "isAddition", "", "addContext", "context", "beforeLineNumber", "afterLineNumber", "appendLines", "appendSeparator", "build", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$PatchState;", "patchHunks", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "buildFromApplied", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedPatchState;", "splitHunks", "Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$AppliedSplitPatchHunk;", "AppliedHunk", "AppliedPatchState", "Companion", "Hunk", "PatchSideChange", "PatchState", "intellij.platform.vcs.impl"})
public final class PatchChangeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder textBuilder = new StringBuilder();
    @NotNull
    private final LineNumberConvertor.Builder convertor1 = new LineNumberConvertor.Builder();
    @NotNull
    private final LineNumberConvertor.Builder convertor2 = new LineNumberConvertor.Builder();
    @NotNull
    private final IntList separatorLines = (IntList)new IntArrayList();
    private int totalLines;

    @NotNull
    public final AppliedPatchState buildFromApplied(@NotNull List<? extends AppliedTextPatch.AppliedSplitPatchHunk> splitHunks) {
        Intrinsics.checkNotNullParameter(splitHunks, (String)"splitHunks");
        List hunks = new ArrayList();
        int lastBeforeLine = -1;
        for (AppliedTextPatch.AppliedSplitPatchHunk appliedSplitPatchHunk : splitHunks) {
            List<String> contextAfter;
            LineRange afterRange;
            List<String> contextBefore;
            LineRange beforeRange;
            Intrinsics.checkNotNullExpressionValue(appliedSplitPatchHunk.getContextBefore(), (String)"getContextBefore(...)");
            Intrinsics.checkNotNullExpressionValue(appliedSplitPatchHunk.getContextAfter(), (String)"getContextAfter(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appliedSplitPatchHunk.getLineRangeBefore(), (String)"getLineRangeBefore(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appliedSplitPatchHunk.getLineRangeAfter(), (String)"getLineRangeAfter(...)");
            int overlappedContext = 0;
            if (lastBeforeLine != -1) {
                if (lastBeforeLine >= beforeRange.start) {
                    overlappedContext = lastBeforeLine - beforeRange.start + 1;
                } else if (lastBeforeLine < beforeRange.start - 1) {
                    this.appendSeparator();
                }
            }
            List<String> trimContext = contextBefore.subList(overlappedContext, contextBefore.size());
            this.addContext(trimContext, beforeRange.start + overlappedContext, afterRange.start + overlappedContext);
            int deletion = this.totalLines;
            List<String> list2 = appliedSplitPatchHunk.getDeletedLines();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getDeletedLines(...)");
            this.addChangedLines(list2, beforeRange.start + contextBefore.size(), false);
            int insertion = this.totalLines;
            List<String> list3 = appliedSplitPatchHunk.getInsertedLines();
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getInsertedLines(...)");
            this.addChangedLines(list3, afterRange.start + contextBefore.size(), true);
            int hunkEnd = this.totalLines;
            this.addContext(contextAfter, beforeRange.end - contextAfter.size(), afterRange.end - contextAfter.size());
            lastBeforeLine = beforeRange.end - 1;
            LineRange deletionRange = new LineRange(deletion, insertion);
            LineRange insertionRange = new LineRange(insertion, hunkEnd);
            LineRange lineRange = appliedSplitPatchHunk.getAppliedTo();
            AppliedTextPatch.HunkStatus hunkStatus = appliedSplitPatchHunk.getStatus();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)hunkStatus), (String)"getStatus(...)");
            hunks.add(new AppliedHunk(deletionRange, insertionRange, lineRange, hunkStatus));
        }
        CharSequence charSequence = this.textBuilder;
        LineNumberConvertor lineNumberConvertor = this.convertor1.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor, (String)"build(...)");
        LineNumberConvertor lineNumberConvertor2 = this.convertor2.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor2, (String)"build(...)");
        return new AppliedPatchState(charSequence, hunks, lineNumberConvertor, lineNumberConvertor2, this.separatorLines);
    }

    @NotNull
    public final PatchState build(@NotNull List<? extends PatchHunk> patchHunks) {
        Intrinsics.checkNotNullParameter(patchHunks, (String)"patchHunks");
        List hunks = new ArrayList();
        for (PatchHunk patchHunk : patchHunks) {
            if (this.totalLines > 0) {
                this.appendSeparator();
            }
            LineRange beforeRange = new LineRange(patchHunk.getStartLineBefore(), patchHunk.getEndLineBefore());
            LineRange afterRange = new LineRange(patchHunk.getStartLineAfter(), patchHunk.getEndLineAfter());
            Ref.IntRef beforeBlockLines = new Ref.IntRef();
            Ref.IntRef afterBlockLines = new Ref.IntRef();
            List<PatchLine> list2 = patchHunk.getLines();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getLines(...)");
            PatchChangeBuilderKt.access$cutIntoBlocks(list2, (Function3)new Function3<List<? extends PatchLine>, List<? extends PatchLine>, List<? extends PatchLine>, Unit>(this, beforeRange, beforeBlockLines, afterRange, afterBlockLines, (List<Hunk>)hunks){
                final /* synthetic */ PatchChangeBuilder this$0;
                final /* synthetic */ LineRange $beforeRange;
                final /* synthetic */ Ref.IntRef $beforeBlockLines;
                final /* synthetic */ LineRange $afterRange;
                final /* synthetic */ Ref.IntRef $afterBlockLines;
                final /* synthetic */ List<Hunk> $hunks;
                {
                    this.this$0 = $receiver;
                    this.$beforeRange = $beforeRange;
                    this.$beforeBlockLines = $beforeBlockLines;
                    this.$afterRange = $afterRange;
                    this.$afterBlockLines = $afterBlockLines;
                    this.$hunks = $hunks;
                    super(3);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull List<? extends PatchLine> preContextLines, @NotNull List<? extends PatchLine> deletedLines, @NotNull List<? extends PatchLine> insertedLines) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    Collection collection;
                    void $this$mapTo$iv$iv3;
                    void $this$map$iv3;
                    Intrinsics.checkNotNullParameter(preContextLines, (String)"preContextLines");
                    Intrinsics.checkNotNullParameter(deletedLines, (String)"deletedLines");
                    Intrinsics.checkNotNullParameter(insertedLines, (String)"insertedLines");
                    Iterable iterable = preContextLines;
                    PatchChangeBuilder patchChangeBuilder = this.this$0;
                    boolean $i$f$map22 = false;
                    void var6_10 = $this$map$iv3;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        void line;
                        PatchLine patchLine = (PatchLine)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        String string2 = line.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                        collection.add(string2);
                    }
                    PatchChangeBuilder.access$addContext(patchChangeBuilder, (List)destination$iv$iv, this.$beforeRange.start + this.$beforeBlockLines.element, this.$afterRange.start + this.$afterBlockLines.element);
                    this.$beforeBlockLines.element += preContextLines.size();
                    this.$afterBlockLines.element += preContextLines.size();
                    int deletion = PatchChangeBuilder.access$getTotalLines$p(this.this$0);
                    Iterable $i$f$map22 = deletedLines;
                    patchChangeBuilder = this.this$0;
                    boolean $i$f$map32 = false;
                    destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv2) {
                        void line;
                        PatchLine bl = (PatchLine)item$iv$iv;
                        collection = destination$iv$iv2;
                        boolean bl2 = false;
                        String string3 = line.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                        collection.add(string3);
                    }
                    PatchChangeBuilder.access$addChangedLines(patchChangeBuilder, (List)destination$iv$iv2, this.$beforeRange.start + this.$beforeBlockLines.element, false);
                    this.$beforeBlockLines.element += deletedLines.size();
                    int insertion = PatchChangeBuilder.access$getTotalLines$p(this.this$0);
                    Iterable $i$f$map32 = insertedLines;
                    patchChangeBuilder = this.this$0;
                    boolean $i$f$map = false;
                    destination$iv$iv2 = $this$map$iv;
                    Collection destination$iv$iv3 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo3 = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        void line;
                        PatchLine bl2 = (PatchLine)item$iv$iv;
                        collection = destination$iv$iv3;
                        boolean bl = false;
                        String string4 = line.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        collection.add(string4);
                    }
                    PatchChangeBuilder.access$addChangedLines(patchChangeBuilder, (List)destination$iv$iv3, this.$afterRange.start + this.$afterBlockLines.element, true);
                    this.$afterBlockLines.element += insertedLines.size();
                    int hunkEnd = PatchChangeBuilder.access$getTotalLines$p(this.this$0);
                    LineRange deletionRange = new LineRange(deletion, insertion);
                    LineRange insertionRange = new LineRange(insertion, hunkEnd);
                    if (!deletionRange.isEmpty() || !insertionRange.isEmpty()) {
                        this.$hunks.add(new Hunk(deletionRange, insertionRange));
                    }
                }
            });
        }
        CharSequence charSequence = this.textBuilder;
        LineNumberConvertor lineNumberConvertor = this.convertor1.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor, (String)"build(...)");
        LineNumberConvertor lineNumberConvertor2 = this.convertor2.build();
        Intrinsics.checkNotNullExpressionValue((Object)lineNumberConvertor2, (String)"build(...)");
        return new PatchState(charSequence, hunks, lineNumberConvertor, lineNumberConvertor2, this.separatorLines);
    }

    private final void addChangedLines(List<String> lines, int lineNumber, boolean isAddition) {
        if (isAddition) {
            this.convertor2.put(this.totalLines, lineNumber, lines.size());
        } else {
            this.convertor1.put(this.totalLines, lineNumber, lines.size());
        }
        this.appendLines(lines);
    }

    private final void addContext(List<String> context, int beforeLineNumber, int afterLineNumber) {
        this.convertor1.put(this.totalLines, beforeLineNumber, context.size());
        this.convertor2.put(this.totalLines, afterLineNumber, context.size());
        this.appendLines(context);
    }

    private final void appendLines(List<String> lines) {
        for (String line : lines) {
            this.textBuilder.append(line).append("\n");
        }
        this.totalLines += lines.size();
    }

    private final void appendSeparator() {
        this.separatorLines.add(this.totalLines);
        this.textBuilder.append("\n");
        int n = this.totalLines;
        this.totalLines = n + 1;
    }

    @JvmStatic
    @Nullable
    public static final List<DiffFragment> computeInnerDifferences(@NotNull Document patchContent, @NotNull Hunk hunk) {
        return Companion.computeInnerDifferences(patchContent, hunk);
    }

    @JvmStatic
    @Nullable
    public static final List<DiffFragment> computeInnerDifferences(@NotNull CharSequence patchContent, @NotNull LineOffsets lineOffsets, @NotNull Hunk hunk) {
        return Companion.computeInnerDifferences(patchContent, lineOffsets, hunk);
    }

    public static final /* synthetic */ void access$addContext(PatchChangeBuilder $this, List context, int beforeLineNumber, int afterLineNumber) {
        $this.addContext(context, beforeLineNumber, afterLineNumber);
    }

    public static final /* synthetic */ int access$getTotalLines$p(PatchChangeBuilder $this) {
        return $this.totalLines;
    }

    public static final /* synthetic */ void access$addChangedLines(PatchChangeBuilder $this, List lines, int lineNumber, boolean isAddition) {
        $this.addChangedLines(lines, lineNumber, isAddition);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedHunk;", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "patchDeletionRange", "Lcom/intellij/diff/util/LineRange;", "patchInsertionRange", "appliedToLines", "status", "Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$HunkStatus;", "(Lcom/intellij/diff/util/LineRange;Lcom/intellij/diff/util/LineRange;Lcom/intellij/diff/util/LineRange;Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$HunkStatus;)V", "getAppliedToLines", "()Lcom/intellij/diff/util/LineRange;", "getStatus", "()Lcom/intellij/openapi/vcs/changes/patch/AppliedTextPatch$HunkStatus;", "intellij.platform.vcs.impl"})
    public static final class AppliedHunk
    extends Hunk {
        @Nullable
        private final LineRange appliedToLines;
        @NotNull
        private final AppliedTextPatch.HunkStatus status;

        public AppliedHunk(@NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange, @Nullable LineRange appliedToLines, @NotNull AppliedTextPatch.HunkStatus status) {
            Intrinsics.checkNotNullParameter((Object)patchDeletionRange, (String)"patchDeletionRange");
            Intrinsics.checkNotNullParameter((Object)patchInsertionRange, (String)"patchInsertionRange");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            super(patchDeletionRange, patchInsertionRange);
            this.appliedToLines = appliedToLines;
            this.status = status;
        }

        @Nullable
        public final LineRange getAppliedToLines() {
            return this.appliedToLines;
        }

        @NotNull
        public final AppliedTextPatch.HunkStatus getStatus() {
            return this.status;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedPatchState;", "", "patchContent", "", "hunks", "", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$AppliedHunk;", "lineConvertor1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "lineConvertor2", "separatorLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "(Ljava/lang/CharSequence;Ljava/util/List;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lit/unimi/dsi/fastutil/ints/IntList;)V", "getHunks", "()Ljava/util/List;", "getLineConvertor1", "()Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "getLineConvertor2", "getPatchContent", "()Ljava/lang/CharSequence;", "getSeparatorLines", "()Lit/unimi/dsi/fastutil/ints/IntList;", "intellij.platform.vcs.impl"})
    public static final class AppliedPatchState {
        @NotNull
        private final CharSequence patchContent;
        @NotNull
        private final List<AppliedHunk> hunks;
        @NotNull
        private final LineNumberConvertor lineConvertor1;
        @NotNull
        private final LineNumberConvertor lineConvertor2;
        @NotNull
        private final IntList separatorLines;

        public AppliedPatchState(@NotNull CharSequence patchContent, @NotNull List<AppliedHunk> hunks, @NotNull LineNumberConvertor lineConvertor1, @NotNull LineNumberConvertor lineConvertor2, @NotNull IntList separatorLines) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter(hunks, (String)"hunks");
            Intrinsics.checkNotNullParameter((Object)lineConvertor1, (String)"lineConvertor1");
            Intrinsics.checkNotNullParameter((Object)lineConvertor2, (String)"lineConvertor2");
            Intrinsics.checkNotNullParameter((Object)separatorLines, (String)"separatorLines");
            this.patchContent = patchContent;
            this.hunks = hunks;
            this.lineConvertor1 = lineConvertor1;
            this.lineConvertor2 = lineConvertor2;
            this.separatorLines = separatorLines;
        }

        @NotNull
        public final CharSequence getPatchContent() {
            return this.patchContent;
        }

        @NotNull
        public final List<AppliedHunk> getHunks() {
            return this.hunks;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor1() {
            return this.lineConvertor1;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor2() {
            return this.lineConvertor2;
        }

        @NotNull
        public final IntList getSeparatorLines() {
            return this.separatorLines;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J(\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Companion;", "", "()V", "computeInnerDifferences", "", "Lcom/intellij/diff/fragments/DiffFragment;", "patchContent", "Lcom/intellij/openapi/editor/Document;", "hunk", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "", "lineOffsets", "Lcom/intellij/diff/tools/util/text/LineOffsets;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final List<DiffFragment> computeInnerDifferences(@NotNull Document patchContent, @NotNull Hunk hunk) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
            CharSequence charSequence = patchContent.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
            LineOffsets lineOffsets = LineOffsetsUtil.create((Document)patchContent);
            Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(...)");
            return this.computeInnerDifferences(charSequence, lineOffsets, hunk);
        }

        @JvmStatic
        @Nullable
        public final List<DiffFragment> computeInnerDifferences(@NotNull CharSequence patchContent, @NotNull LineOffsets lineOffsets, @NotNull Hunk hunk) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter((Object)lineOffsets, (String)"lineOffsets");
            Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
            LineRange deletionRange = hunk.getPatchDeletionRange();
            LineRange insertionRange = hunk.getPatchInsertionRange();
            if (deletionRange.isEmpty() || insertionRange.isEmpty()) {
                return null;
            }
            try {
                CharSequence charSequence = DiffRangeUtil.getLinesContent((CharSequence)patchContent, (LineOffsets)lineOffsets, (int)deletionRange.start, (int)deletionRange.end);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getLinesContent(...)");
                CharSequence deleted2 = charSequence;
                CharSequence charSequence2 = DiffRangeUtil.getLinesContent((CharSequence)patchContent, (LineOffsets)lineOffsets, (int)insertionRange.start, (int)insertionRange.end);
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getLinesContent(...)");
                CharSequence inserted = charSequence2;
                return ByWord.compare((CharSequence)deleted2, (CharSequence)inserted, (ComparisonPolicy)ComparisonPolicy.DEFAULT, (ProgressIndicator)((ProgressIndicator)DumbProgressIndicator.INSTANCE));
            }
            catch (DiffTooBigException e) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "", "patchDeletionRange", "Lcom/intellij/diff/util/LineRange;", "patchInsertionRange", "(Lcom/intellij/diff/util/LineRange;Lcom/intellij/diff/util/LineRange;)V", "getPatchDeletionRange", "()Lcom/intellij/diff/util/LineRange;", "getPatchInsertionRange", "intellij.platform.vcs.impl"})
    public static class Hunk {
        @NotNull
        private final LineRange patchDeletionRange;
        @NotNull
        private final LineRange patchInsertionRange;

        public Hunk(@NotNull LineRange patchDeletionRange, @NotNull LineRange patchInsertionRange) {
            Intrinsics.checkNotNullParameter((Object)patchDeletionRange, (String)"patchDeletionRange");
            Intrinsics.checkNotNullParameter((Object)patchInsertionRange, (String)"patchInsertionRange");
            this.patchDeletionRange = patchDeletionRange;
            this.patchInsertionRange = patchInsertionRange;
        }

        @NotNull
        public final LineRange getPatchDeletionRange() {
            return this.patchDeletionRange;
        }

        @NotNull
        public final LineRange getPatchInsertionRange() {
            return this.patchInsertionRange;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$PatchSideChange;", "Lcom/intellij/diff/tools/simple/AlignableChange;", "range", "Lcom/intellij/diff/util/Range;", "(Lcom/intellij/diff/util/Range;)V", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "getDiffType", "()Lcom/intellij/diff/util/TextDiffType;", "getRange", "()Lcom/intellij/diff/util/Range;", "getEndLine", "", "side", "Lcom/intellij/diff/util/Side;", "getStartLine", "intellij.platform.vcs.impl"})
    public static final class PatchSideChange
    implements AlignableChange {
        @NotNull
        private final Range range;

        public PatchSideChange(@NotNull Range range) {
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.range = range;
        }

        @NotNull
        public final Range getRange() {
            return this.range;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = DiffUtil.getDiffType((Range)this.range);
            Intrinsics.checkNotNullExpressionValue((Object)textDiffType, (String)"getDiffType(...)");
            return textDiffType;
        }

        public int getStartLine(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return side.select(this.range.start1, this.range.start2);
        }

        public int getEndLine(@NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            return side.select(this.range.end1, this.range.end2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$PatchState;", "", "patchContent", "", "hunks", "", "Lcom/intellij/openapi/vcs/changes/patch/tool/PatchChangeBuilder$Hunk;", "lineConvertor1", "Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "lineConvertor2", "separatorLines", "Lit/unimi/dsi/fastutil/ints/IntList;", "(Ljava/lang/CharSequence;Ljava/util/List;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;Lit/unimi/dsi/fastutil/ints/IntList;)V", "getHunks", "()Ljava/util/List;", "getLineConvertor1", "()Lcom/intellij/diff/tools/fragmented/LineNumberConvertor;", "getLineConvertor2", "getPatchContent", "()Ljava/lang/CharSequence;", "getSeparatorLines", "()Lit/unimi/dsi/fastutil/ints/IntList;", "intellij.platform.vcs.impl"})
    public static final class PatchState {
        @NotNull
        private final CharSequence patchContent;
        @NotNull
        private final List<Hunk> hunks;
        @NotNull
        private final LineNumberConvertor lineConvertor1;
        @NotNull
        private final LineNumberConvertor lineConvertor2;
        @NotNull
        private final IntList separatorLines;

        public PatchState(@NotNull CharSequence patchContent, @NotNull List<? extends Hunk> hunks, @NotNull LineNumberConvertor lineConvertor1, @NotNull LineNumberConvertor lineConvertor2, @NotNull IntList separatorLines) {
            Intrinsics.checkNotNullParameter((Object)patchContent, (String)"patchContent");
            Intrinsics.checkNotNullParameter(hunks, (String)"hunks");
            Intrinsics.checkNotNullParameter((Object)lineConvertor1, (String)"lineConvertor1");
            Intrinsics.checkNotNullParameter((Object)lineConvertor2, (String)"lineConvertor2");
            Intrinsics.checkNotNullParameter((Object)separatorLines, (String)"separatorLines");
            this.patchContent = patchContent;
            this.hunks = hunks;
            this.lineConvertor1 = lineConvertor1;
            this.lineConvertor2 = lineConvertor2;
            this.separatorLines = separatorLines;
        }

        @NotNull
        public final CharSequence getPatchContent() {
            return this.patchContent;
        }

        @NotNull
        public final List<Hunk> getHunks() {
            return this.hunks;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor1() {
            return this.lineConvertor1;
        }

        @NotNull
        public final LineNumberConvertor getLineConvertor2() {
            return this.lineConvertor2;
        }

        @NotNull
        public final IntList getSeparatorLines() {
            return this.separatorLines;
        }
    }
}

