/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.PatchFileHeaderInfo;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.patch.AbstractFilePatchInProgress;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchDefaultExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchExecutor;
import com.intellij.openapi.vcs.changes.patch.ApplyPatchMode;
import com.intellij.openapi.vcs.changes.patch.FilePatchStatus;
import com.intellij.openapi.vcs.changes.patch.MatchPatchPaths;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangeListChooserPanel;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeImpl;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.TreeActionsToolbarPanel;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.LightColors;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.log.VcsUser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyPatchDifferentiatedDialog
extends DialogWrapper {
    @ApiStatus.Internal
    public static final String DIMENSION_SERVICE_KEY = "vcs.ApplyPatchDifferentiatedDialog";
    private static final Logger LOG = Logger.getInstance(ApplyPatchDifferentiatedDialog.class);
    private final MergingUpdateQueue myLoadQueue;
    private final TextFieldWithBrowseButton myPatchFile;
    private final List<AbstractFilePatchInProgress<?>> myPatches;
    private final List<? extends ShelvedBinaryFilePatch> myBinaryShelvedPatches;
    @NotNull
    private final EditorNotificationPanel myErrorNotificationPanel;
    @NotNull
    private final MyChangeTreeList myChangesTreeList;
    @NotNull
    private final JBLoadingPanel myChangesTreeLoadingPanel;
    @Nullable
    private final Collection<? extends Change> myPreselectedChanges;
    private final boolean myUseProjectRootAsPredefinedBase;
    private JComponent myCenterPanel;
    protected final Project myProject;
    private final AtomicReference<FilePresentationModel> myRecentPathFileChange;
    private final Runnable myReset;
    @Nullable
    private final ChangeListChooserPanel myChangeListChooser;
    private final ChangesLegendCalculator myInfoCalculator;
    private final CommitLegendPanel myCommitLegendPanel;
    private final ApplyPatchExecutor myCallback;
    private final List<? extends ApplyPatchExecutor> myExecutors;
    private boolean myContainBasedChanges;
    private JLabel myPatchFileLabel;
    private PatchReader myReader;
    private final boolean myCanChangePatchFile;
    private String myHelpId;
    private final boolean myShouldUpdateChangeListName;

    public ApplyPatchDifferentiatedDialog(Project project2, ApplyPatchExecutor<?> callback2, List<? extends ApplyPatchExecutor<?>> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull VirtualFile patchFile) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(0);
        }
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(1);
        }
        this(project2, callback2, executors, applyPatchMode, patchFile, null, null, null, null, null, false);
    }

    public ApplyPatchDifferentiatedDialog(Project project2, ApplyPatchExecutor<?> callback2, List<? extends ApplyPatchExecutor<?>> executors, @NotNull ApplyPatchMode applyPatchMode, @NotNull List<? extends FilePatch> patches, @Nullable ChangeList defaultList) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(2);
        }
        if (patches == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(3);
        }
        this(project2, callback2, executors, applyPatchMode, null, patches, defaultList, null, null, null, false);
    }

    public ApplyPatchDifferentiatedDialog(Project project2, ApplyPatchExecutor<?> callback2, List<? extends ApplyPatchExecutor<?>> executors, @NotNull ApplyPatchMode applyPatchMode, @Nullable VirtualFile patchFile, @Nullable List<? extends FilePatch> patches, @Nullable ChangeList defaultList, @Nullable List<? extends ShelvedBinaryFilePatch> binaryShelvedPatches, @Nullable Collection<? extends Change> preselectedChanges, @Nullable @NlsSafe String externalCommitMessage, boolean useProjectRootAsPredefinedBase) {
        if (applyPatchMode == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(4);
        }
        super(project2, true);
        this.myHelpId = "reference.dialogs.vcs.patch.apply";
        this.myCallback = callback2;
        this.myExecutors = executors;
        this.myUseProjectRootAsPredefinedBase = useProjectRootAsPredefinedBase;
        this.setModal(false);
        this.setHorizontalStretch(2.0f);
        this.setVerticalStretch(2.0f);
        this.setTitle(applyPatchMode.getTitle());
        FileChooserDescriptor descriptor = ApplyPatchDifferentiatedDialog.createSelectPatchDescriptor();
        descriptor.setTitle(VcsBundle.message("patch.apply.select.title", new Object[0]));
        this.myProject = project2;
        this.myPatches = new ArrayList();
        this.myRecentPathFileChange = new AtomicReference();
        this.myBinaryShelvedPatches = binaryShelvedPatches;
        this.myPreselectedChanges = preselectedChanges;
        this.myErrorNotificationPanel = new EditorNotificationPanel(LightColors.RED, EditorNotificationPanel.Status.Error);
        this.cleanNotifications();
        this.myChangesTreeList = new MyChangeTreeList(project2, new Runnable(){

            @Override
            public void run() {
                NamedLegendStatuses includedNameStatuses = new NamedLegendStatuses();
                Collection includedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getIncludedChanges();
                HashSet<Couple> set = new HashSet<Couple>();
                for (AbstractFilePatchInProgress.PatchChange change : includedChanges) {
                    Object patch = change.getPatchInProgress().getPatch();
                    Couple pair = Couple.of((Object)((FilePatch)patch).getBeforeName(), (Object)((FilePatch)patch).getAfterName());
                    if (set.contains(pair)) continue;
                    set.add(pair);
                    ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, change);
                }
                ApplyPatchDifferentiatedDialog.this.myInfoCalculator.setIncluded(includedNameStatuses);
                ApplyPatchDifferentiatedDialog.this.myCommitLegendPanel.update();
                ApplyPatchDifferentiatedDialog.this.updateOkActions();
            }
        }, new MyChangeNodeDecorator());
        this.myChangesTreeList.setDoubleClickAndEnterKeyHandler(() -> {
            List selectedChanges = this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() == 1 && !((AbstractFilePatchInProgress.PatchChange)selectedChanges.get(0)).isValid()) {
                this.myChangesTreeList.handleInvalidChangesAndToggle();
            }
            new MyShowDiff().showDiff();
        });
        this.myChangesTreeLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable(), 300);
        this.myChangesTreeLoadingPanel.add((Component)((Object)this.myChangesTreeList), (Object)"Center");
        this.myShouldUpdateChangeListName = defaultList == null && externalCommitMessage == null;
        this.myPatchFile = new TextFieldWithBrowseButton();
        this.myPatchFile.addBrowseFolderListener(VcsBundle.message("patch.apply.select.title", new Object[0]), "", project2, descriptor);
        this.myPatchFile.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplyPatchDifferentiatedDialog.this.setPathFileChangeDefault();
                ApplyPatchDifferentiatedDialog.this.queueRequest();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$2", "textChanged"));
            }
        });
        this.myLoadQueue = new MergingUpdateQueue("ApplyPatchDifferentiatedDialog", 500, true, (JComponent)this.myChangesTreeLoadingPanel, this.getDisposable(), null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myCanChangePatchFile = applyPatchMode.isCanChangePatchFile();
        this.myReset = this.myCanChangePatchFile ? this::reset : EmptyRunnable.getInstance();
        ChangeListManager changeListManager = ChangeListManager.getInstance(project2);
        if (changeListManager.areChangeListsEnabled()) {
            this.myChangeListChooser = new ChangeListChooserPanel(project2, (Consumer<? super String>)new Consumer<String>(){

                @Override
                public void accept(@Nullable @NlsContexts.DialogMessage String errorMessage) {
                    ApplyPatchDifferentiatedDialog.this.setOKActionEnabled(errorMessage == null && ApplyPatchDifferentiatedDialog.this.isChangeTreeEnabled());
                    ApplyPatchDifferentiatedDialog.this.setErrorText(errorMessage, ApplyPatchDifferentiatedDialog.this.myChangeListChooser);
                }
            });
            if (defaultList != null) {
                this.myChangeListChooser.setDefaultSelection(defaultList);
            } else if (externalCommitMessage != null) {
                this.myChangeListChooser.setSuggestedName(externalCommitMessage);
            }
            this.myChangeListChooser.init();
        } else {
            this.myChangeListChooser = null;
        }
        this.myInfoCalculator = new ChangesLegendCalculator();
        this.myCommitLegendPanel = new CommitLegendPanel(this.myInfoCalculator){

            @Override
            public void update() {
                super.update();
                int inapplicable = ApplyPatchDifferentiatedDialog.this.myInfoCalculator.getInapplicable();
                if (inapplicable > 0) {
                    this.appendSpace();
                    this.append(inapplicable, FileStatus.MERGED_WITH_CONFLICTS, VcsBundle.message("patch.apply.missing.base.file.label", new Object[0]));
                }
            }
        };
        this.init();
        if (patchFile != null && patchFile.isValid()) {
            patchFile.refresh(false, false);
            this.init(patchFile);
        } else if (patches != null) {
            this.init(patches);
        }
        this.myPatchFileLabel.setVisible(this.myCanChangePatchFile);
        this.myPatchFile.setVisible(this.myCanChangePatchFile);
        if (this.myCanChangePatchFile) {
            BulkFileListener listener2 = new BulkFileListener(){

                public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                    if (events == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    for (VFileEvent vFileEvent : events) {
                        if (!(vFileEvent instanceof VFileContentChangeEvent)) continue;
                        ApplyPatchDifferentiatedDialog.this.syncUpdatePatchFileAndScheduleReloadIfNeeded(vFileEvent.getFile());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$5", "after"));
                }
            };
            ApplicationManager.getApplication().getMessageBus().connect(this.getDisposable()).subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener2);
        }
        this.updateOkActions();
    }

    private void updateOkActions() {
        boolean changeTreeEnabled = this.isChangeTreeEnabled();
        this.setOKActionEnabled(changeTreeEnabled);
        if (changeTreeEnabled && this.myChangeListChooser != null) {
            this.myChangeListChooser.updateEnabled();
        }
    }

    private boolean isChangeTreeEnabled() {
        return !this.myChangesTreeList.getIncludedChanges().isEmpty();
    }

    private void queueRequest() {
        this.paintBusy(true);
        this.myLoadQueue.queue(Update.create((Object)"update", () -> this.reloadPatchFromFile()));
    }

    private void init(@NotNull List<? extends FilePatch> patches) {
        if (patches == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(5);
        }
        List<AbstractFilePatchInProgress<?>> matchedPatches = new MatchPatchPaths(this.myProject).execute(patches, this.myUseProjectRootAsPredefinedBase);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.myPatches.clear();
            this.myPatches.addAll(matchedPatches);
            this.updateTree(true);
        });
    }

    public static FileChooserDescriptor createSelectPatchDescriptor() {
        return new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PatchFileType.INSTANCE) || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)FileTypes.PLAIN_TEXT));
            }
        };
    }

    protected Action @NotNull [] createActions() {
        if (this.myExecutors.isEmpty()) {
            Action[] actionArray = super.createActions();
            if (actionArray == null) {
                ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(6);
            }
            return actionArray;
        }
        ArrayList<Action> actions2 = new ArrayList<Action>(4);
        actions2.add(this.getOKAction());
        int i = 0;
        while (i < this.myExecutors.size()) {
            final ApplyPatchExecutor executor = this.myExecutors.get(i);
            final int finalI = i++;
            actions2.add(new AbstractAction(executor.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplyPatchDifferentiatedDialog.this.runExecutor(executor);
                    ApplyPatchDifferentiatedDialog.this.close(2 + finalI);
                }
            });
        }
        actions2.add(this.getCancelAction());
        actions2.add(this.getHelpAction());
        Action[] actionArray = actions2.toArray(new Action[0]);
        if (actionArray == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(7);
        }
        return actionArray;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void runExecutor(ApplyPatchExecutor<AbstractFilePatchInProgress<?>> applyPatchExecutor) {
        void executor;
        ThreadingAssertions.assertEventDispatchThread();
        Collection<AbstractFilePatchInProgress<?>> included = this.getIncluded();
        if (included.isEmpty()) {
            return;
        }
        MultiMap patchGroups = new MultiMap();
        for (AbstractFilePatchInProgress<?> patchInProgress : included) {
            patchGroups.putValue((Object)patchInProgress.getBase(), patchInProgress);
        }
        LocalChangeList targetChangelist = this.getSelectedChangeList();
        FilePresentationModel presentation2 = this.myRecentPathFileChange.get();
        VirtualFile vf = presentation2 != null ? presentation2.getVf() : null;
        executor.apply(this.getOriginalRemaining(), patchGroups, targetChangelist, vf == null ? null : vf.getName(), this.myReader == null ? null : this.myReader.getAdditionalInfo(ApplyPatchDefaultExecutor.pathsFromGroups(patchGroups)));
    }

    @NotNull
    private List<FilePatch> getOriginalRemaining() {
        Collection notIncluded = ContainerUtil.subtract(this.myPatches, this.getIncluded());
        ArrayList<FilePatch> remainingOriginal = new ArrayList<FilePatch>();
        for (AbstractFilePatchInProgress progress : notIncluded) {
            progress.reset();
            remainingOriginal.add((FilePatch)progress.getPatch());
        }
        ArrayList<FilePatch> arrayList = remainingOriginal;
        if (arrayList == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY;
    }

    protected String getHelpId() {
        return this.myHelpId;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myChangeListChooser != null) {
            return this.myChangeListChooser.getPreferredFocusedComponent();
        }
        return this.myChangesTreeList;
    }

    private void setPathFileChangeDefault() {
        this.myRecentPathFileChange.set(new FilePresentationModel(this.myPatchFile.getText()));
    }

    private void init(@NotNull VirtualFile patchFile) {
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(9);
        }
        this.myPatchFile.setText(patchFile.getPresentableUrl());
        this.myRecentPathFileChange.set(new FilePresentationModel(patchFile));
        this.myLoadQueue.sendFlush();
    }

    public void setHelpId(String s) {
        this.myHelpId = s;
    }

    private void reloadPatchFromFile() {
        VcsUser author;
        VirtualFile file;
        this.cleanNotifications();
        FilePresentationModel filePresentationModel = this.myRecentPathFileChange.get();
        VirtualFile virtualFile = file = filePresentationModel != null ? filePresentationModel.getVf() : null;
        if (file == null) {
            ApplicationManager.getApplication().invokeLater(this.myReset, ModalityState.stateForComponent((Component)this.myCenterPanel));
            return;
        }
        this.myReader = this.loadPatches(file);
        PatchFileHeaderInfo patchFileInfo = this.myReader != null ? this.myReader.getPatchFileInfo() : null;
        String messageFromPatch = patchFileInfo != null ? patchFileInfo.getMessage() : null;
        VcsUser vcsUser = author = patchFileInfo != null ? patchFileInfo.getAuthor() : null;
        if (author != null && this.myChangeListChooser != null) {
            this.myChangeListChooser.setData(new ChangeListData(author));
        }
        ArrayList<FilePatch> filePatches = new ArrayList<FilePatch>();
        if (this.myReader != null) {
            filePatches.addAll(this.myReader.getAllPatches());
        }
        if (!ContainerUtil.isEmpty(this.myBinaryShelvedPatches)) {
            filePatches.addAll(this.myBinaryShelvedPatches);
        }
        List<AbstractFilePatchInProgress<?>> matchedPatches = new MatchPatchPaths(this.myProject).execute(filePatches, this.myUseProjectRootAsPredefinedBase);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (StringUtil.isNotEmpty((String)messageFromPatch) && this.myChangeListChooser != null) {
                this.myChangeListChooser.setChangeListDescription(messageFromPatch);
            } else if (this.myShouldUpdateChangeListName && this.myChangeListChooser != null) {
                String subject = (String)ObjectUtils.chooseNotNull((Object)this.getSubjectFromMessage(messageFromPatch), (Object)file.getNameWithoutExtension().replace('_', ' ').trim());
                this.myChangeListChooser.setSuggestedName(subject, messageFromPatch, false);
            }
            this.myPatches.clear();
            this.myPatches.addAll(matchedPatches);
            this.updateTree(true);
            this.paintBusy(false);
            this.updateOkActions();
        }, ModalityState.stateForComponent((Component)this.myCenterPanel));
    }

    @Nullable
    private String getSubjectFromMessage(@Nullable String message2) {
        return StringUtil.isEmptyOrSpaces((String)message2) ? null : ChangeListUtil.createNameForChangeList(this.myProject, message2);
    }

    @Nullable
    private PatchReader loadPatches(@NotNull VirtualFile patchFile) {
        if (patchFile == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(10);
        }
        try {
            String text2 = (String)ReadAction.compute(() -> {
                try (InputStreamReader inputStreamReader = new InputStreamReader(patchFile.getInputStream(), patchFile.getCharset());){
                    String string2 = StreamUtil.readText((Reader)inputStreamReader);
                    return string2;
                }
            });
            PatchReader reader = new PatchReader(text2);
            reader.parseAllPatches();
            return reader;
        }
        catch (Exception e) {
            this.addNotificationAndWarn(VcsBundle.message("patch.apply.cannot.read.patch", patchFile.getPresentableName(), e.getMessage()));
            return null;
        }
    }

    private void addNotificationAndWarn(@NotNull @NlsContexts.Label String errorMessage) {
        if (errorMessage == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(11);
        }
        LOG.warn(errorMessage);
        this.myErrorNotificationPanel.setText(errorMessage);
        this.myErrorNotificationPanel.setVisible(true);
    }

    private void cleanNotifications() {
        this.myErrorNotificationPanel.setText("");
        this.myErrorNotificationPanel.setVisible(false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private void syncUpdatePatchFileAndScheduleReloadIfNeeded(@Nullable VirtualFile virtualFile) {
        void eventFile;
        VirtualFile filePresentationVf;
        ThreadingAssertions.assertEventDispatchThread();
        FilePresentationModel filePresentationModel = this.myRecentPathFileChange.get();
        VirtualFile virtualFile2 = filePresentationVf = filePresentationModel != null ? filePresentationModel.getVf() : null;
        if (filePresentationVf != null && (eventFile == null || filePresentationVf.equals(eventFile))) {
            filePresentationVf.refresh(false, false);
            this.queueRequest();
        }
    }

    private void reset() {
        this.myPatches.clear();
        this.myChangesTreeList.setChangesToDisplay(Collections.emptyList());
        this.myChangesTreeList.repaint();
        this.myContainBasedChanges = false;
        this.paintBusy(false);
    }

    protected JComponent createCenterPanel() {
        if (this.myCenterPanel == null) {
            this.myCenterPanel = new JPanel(new GridBagLayout());
            GridBagConstraints centralGb = ApplyPatchDifferentiatedDialog.createConstraints();
            this.myPatchFileLabel = new JLabel(VcsBundle.message("patch.apply.file.name.field", new Object[0]));
            this.myPatchFileLabel.setLabelFor((Component)this.myPatchFile);
            this.myCenterPanel.add((Component)this.myPatchFileLabel, centralGb);
            centralGb.fill = 2;
            ++centralGb.gridy;
            this.myCenterPanel.add((Component)this.myPatchFile, centralGb);
            JPanel treePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gb = ApplyPatchDifferentiatedDialog.createConstraints();
            DefaultActionGroup group2 = new DefaultActionGroup();
            MyShowDiff diffAction = new MyShowDiff();
            diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), this.getRootPane());
            group2.add((AnAction)diffAction);
            ActionGroup mapDirectoryActionGroup = new ActionGroup(VcsBundle.message("patch.apply.change.directory.paths.group", new Object[0]), null, AllIcons.Vcs.Folders){

                public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
                    AnAction[] anActionArray = new AnAction[]{new MapDirectory(), new StripUp(IdeBundle.messagePointer((String)"action.Anonymous.text.remove.leading.directory", (Object[])new Object[0])), new ZeroStrip(), new StripDown(IdeBundle.messagePointer((String)"action.Anonymous.text.restore.leading.directory", (Object[])new Object[0])), new ResetStrip()};
                    if (anActionArray == null) {
                        8.$$$reportNull$$$0(0);
                    }
                    return anActionArray;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$8", "getChildren"));
                }
            };
            mapDirectoryActionGroup.setPopup(true);
            group2.add((AnAction)mapDirectoryActionGroup);
            if (this.myCanChangePatchFile) {
                group2.add((AnAction)new DumbAwareAction(VcsBundle.messagePointer("action.DumbAware.ApplyPatchDifferentiatedDialog.text.refresh", new Object[0]), VcsBundle.messagePointer("action.DumbAware.ApplyPatchDifferentiatedDialog.description.refresh", new Object[0]), AllIcons.Actions.Refresh){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            9.$$$reportNull$$$0(0);
                        }
                        ApplyPatchDifferentiatedDialog.this.syncUpdatePatchFileAndScheduleReloadIfNeeded(null);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$9", "actionPerformed"));
                    }
                });
            }
            group2.add((AnAction)Separator.getInstance());
            group2.add(ActionManager.getInstance().getAction("ChangesView.GroupBy"));
            ActionToolbar toolbar2 = ActionManager.getInstance().createActionToolbar("APPLY_PATCH", (ActionGroup)group2, true);
            TreeActionsToolbarPanel toolbarPanel = new TreeActionsToolbarPanel(toolbar2, (ChangesTree)this.myChangesTreeList);
            gb.fill = 2;
            treePanel.add((Component)toolbarPanel, gb);
            ++gb.gridy;
            gb.weighty = 1.0;
            gb.fill = 1;
            BorderLayoutPanel changeTreePanel = JBUI.Panels.simplePanel((Component)this.myChangesTreeLoadingPanel).addToTop((Component)this.myErrorNotificationPanel);
            treePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)changeTreePanel), gb);
            ++gb.gridy;
            gb.weighty = 0.0;
            gb.fill = 0;
            gb.insets.bottom = 4;
            treePanel.add((Component)this.myCommitLegendPanel.getComponent(), gb);
            ++gb.gridy;
            ++centralGb.gridy;
            centralGb.weighty = 1.0;
            centralGb.fill = 1;
            if (this.myChangeListChooser != null) {
                Splitter splitter = new Splitter(true, 0.7f);
                splitter.setFirstComponent((JComponent)treePanel);
                splitter.setSecondComponent((JComponent)this.myChangeListChooser);
                this.myCenterPanel.add((Component)splitter, centralGb);
            } else {
                this.myCenterPanel.add((Component)treePanel, centralGb);
            }
        }
        return this.myCenterPanel;
    }

    @NotNull
    private static GridBagConstraints createConstraints() {
        return new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)1), 0, 0);
    }

    private void paintBusy(boolean isBusy) {
        if (isBusy) {
            this.myChangesTreeList.setEmptyText("");
            this.myChangesTreeLoadingPanel.startLoading();
        } else {
            this.myChangesTreeList.setEmptyText(VcsBundle.message("commit.dialog.no.changes.detected.text", new Object[0]));
            this.myChangesTreeLoadingPanel.stopLoading();
        }
    }

    private static boolean sameBase(List<? extends AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        VirtualFile base = null;
        for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
            VirtualFile changeBase = patchChange.getPatchInProgress().getBase();
            if (base == null) {
                base = changeBase;
                continue;
            }
            if (base.equals(changeBase)) continue;
            return false;
        }
        return true;
    }

    private void updateTree(boolean doInitCheck) {
        List<AbstractFilePatchInProgress> patchesToSelect = ApplyPatchDifferentiatedDialog.changes2patches(this.myChangesTreeList.getSelectedChanges());
        List<AbstractFilePatchInProgress.PatchChange> changes2 = this.getAllChanges();
        Collection<AbstractFilePatchInProgress.PatchChange> included = this.getIncluded(doInitCheck, changes2);
        this.myChangesTreeList.setIncludedChanges(included);
        this.myChangesTreeList.setChangesToDisplay(changes2);
        if (doInitCheck) {
            this.myChangesTreeList.expandAll();
        }
        this.myChangesTreeList.repaint();
        if (!doInitCheck) {
            ArrayList<AbstractFilePatchInProgress.PatchChange> toSelect = new ArrayList<AbstractFilePatchInProgress.PatchChange>(patchesToSelect.size());
            for (AbstractFilePatchInProgress.PatchChange change : changes2) {
                if (!patchesToSelect.contains(change.getPatchInProgress())) continue;
                toSelect.add(change);
            }
            this.myChangesTreeList.setSelectedChanges(toSelect);
        }
        this.myContainBasedChanges = false;
        for (AbstractFilePatchInProgress<?> patch : this.myPatches) {
            if (!patch.baseExistsOrAdded()) continue;
            this.myContainBasedChanges = true;
            break;
        }
    }

    private List<AbstractFilePatchInProgress.PatchChange> getAllChanges() {
        return ContainerUtil.map(this.myPatches, AbstractFilePatchInProgress::getChange);
    }

    private static void acceptChange(NamedLegendStatuses nameStatuses, AbstractFilePatchInProgress.PatchChange change) {
        AbstractFilePatchInProgress<?> patchInProgress = change.getPatchInProgress();
        if (FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus())) {
            nameStatuses.plusAdded();
        } else if (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus())) {
            nameStatuses.plusDeleted();
        } else {
            nameStatuses.plusModified();
        }
        if (!patchInProgress.baseExistsOrAdded()) {
            nameStatuses.plusInapplicable();
        }
    }

    private Collection<AbstractFilePatchInProgress.PatchChange> getIncluded(boolean doInitCheck, List<? extends AbstractFilePatchInProgress.PatchChange> changes2) {
        NamedLegendStatuses totalNameStatuses = new NamedLegendStatuses();
        NamedLegendStatuses includedNameStatuses = new NamedLegendStatuses();
        ArrayList<AbstractFilePatchInProgress.PatchChange> included = new ArrayList<AbstractFilePatchInProgress.PatchChange>();
        if (doInitCheck) {
            for (AbstractFilePatchInProgress.PatchChange patchChange : changes2) {
                ApplyPatchDifferentiatedDialog.acceptChange(totalNameStatuses, patchChange);
                AbstractFilePatchInProgress<?> abstractFilePatchInProgress = patchChange.getPatchInProgress();
                if (!abstractFilePatchInProgress.baseExistsOrAdded() || this.myPreselectedChanges != null && !this.myPreselectedChanges.contains(patchChange)) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, patchChange);
                included.add(patchChange);
            }
        } else {
            AbstractFilePatchInProgress<?> patch;
            Collection includedNow = this.myChangesTreeList.getIncludedChanges();
            HashSet hashSet = new HashSet();
            for (AbstractFilePatchInProgress.PatchChange patchChange : includedNow) {
                patch = patchChange.getPatchInProgress();
                hashSet.add(patch);
            }
            for (AbstractFilePatchInProgress.PatchChange patchChange : changes2) {
                patch = patchChange.getPatchInProgress();
                ApplyPatchDifferentiatedDialog.acceptChange(totalNameStatuses, patchChange);
                if (!hashSet.contains(patch) || !patch.baseExistsOrAdded()) continue;
                ApplyPatchDifferentiatedDialog.acceptChange(includedNameStatuses, patchChange);
                included.add(patchChange);
            }
        }
        this.myInfoCalculator.setTotal(totalNameStatuses);
        this.myInfoCalculator.setIncluded(includedNameStatuses);
        this.myCommitLegendPanel.update();
        return included;
    }

    private static List<AbstractFilePatchInProgress> changes2patches(List<? extends AbstractFilePatchInProgress.PatchChange> selectedChanges) {
        return ContainerUtil.map(selectedChanges, AbstractFilePatchInProgress.PatchChange::getPatchInProgress);
    }

    private boolean basePathWasChanged(@NotNull AbstractFilePatchInProgress patchInProgress) {
        if (patchInProgress == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(12);
        }
        return !FileUtil.filesEqual((File)patchInProgress.myIoCurrentBase, (File)new File(this.myProject.getBasePath(), patchInProgress.getOriginalBeforePath()));
    }

    private Collection<AbstractFilePatchInProgress<?>> getIncluded() {
        return ContainerUtil.map(this.myChangesTreeList.getIncludedChanges(), AbstractFilePatchInProgress.PatchChange::getPatchInProgress);
    }

    @Nullable
    private LocalChangeList getSelectedChangeList() {
        return this.myChangeListChooser != null ? this.myChangeListChooser.getSelectedList(this.myProject) : null;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.runExecutor(this.myCallback);
    }

    @NotNull
    private static DiffRequestProducer createBaseNotFoundErrorRequest(final @NotNull AbstractFilePatchInProgress patchInProgress) {
        if (patchInProgress == null) {
            ApplyPatchDifferentiatedDialog.$$$reportNull$$$0(13);
        }
        final String beforePath = ((FilePatch)patchInProgress.getPatch()).getBeforeName();
        final String afterPath = ((FilePatch)patchInProgress.getPatch()).getAfterName();
        return new DiffRequestProducer(){

            @NotNull
            public String getName() {
                File ioCurrentBase = patchInProgress.getIoCurrentBase();
                String string2 = ioCurrentBase == null ? patchInProgress.getCurrentPath() : ioCurrentBase.getPath();
                if (string2 == null) {
                    10.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @NotNull
            public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
                if (context == null) {
                    10.$$$reportNull$$$0(1);
                }
                if (indicator == null) {
                    10.$$$reportNull$$$0(2);
                }
                throw new DiffRequestProducerException(VcsBundle.message("changes.error.cannot.find.base.for.path", beforePath != null ? beforePath : afterPath));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "process";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 1, 2 -> new IllegalArgumentException(string2);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyPatchMode";
                break;
            }
            case 1: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patchInProgress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalRemaining";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadPatches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addNotificationAndWarn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "basePathWasChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createBaseNotFoundErrorRequest";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6, 7, 8 -> new IllegalStateException(string2);
        };
    }

    private final class MyChangeTreeList
    extends ChangesTreeImpl<AbstractFilePatchInProgress.PatchChange> {
        @Nullable
        private final ChangeNodeDecorator myChangeNodeDecorator;

        private MyChangeTreeList(@Nullable Project project2, @Nullable Runnable inclusionListener, ChangeNodeDecorator decorator) {
            super(project2, true, false, AbstractFilePatchInProgress.PatchChange.class);
            this.setInclusionListener(inclusionListener);
            this.myChangeNodeDecorator = decorator;
        }

        @Override
        @NotNull
        protected DefaultTreeModel buildTreeModel(@NotNull List<? extends AbstractFilePatchInProgress.PatchChange> changes2) {
            if (changes2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(0);
            }
            AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-317156, EA-830617");
            DefaultTreeModel defaultTreeModel = TreeModelBuilder.buildFromChanges(this.myProject, this.getGrouping(), changes2, this.myChangeNodeDecorator);
            DefaultTreeModel defaultTreeModel2 = defaultTreeModel;
            if (defaultTreeModel2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(1);
            }
            return defaultTreeModel2;
            finally {
                if (ignore != null) {
                    ignore.close();
                }
            }
        }

        @Override
        protected boolean isInclusionEnabled(@NotNull ChangesBrowserNode<?> node) {
            if (node == null) {
                MyChangeTreeList.$$$reportNull$$$0(2);
            }
            boolean enabled = super.isInclusionEnabled(node);
            Object value2 = node.getUserObject();
            if (value2 instanceof AbstractFilePatchInProgress.PatchChange) {
                enabled &= ((AbstractFilePatchInProgress.PatchChange)value2).isValid();
            }
            return enabled;
        }

        @NotNull
        private static List<AbstractFilePatchInProgress.PatchChange> getOnlyValidChanges(@NotNull Collection<? extends AbstractFilePatchInProgress.PatchChange> changes2) {
            if (changes2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(3);
            }
            List list2 = ContainerUtil.filter(changes2, AbstractFilePatchInProgress.PatchChange::isValid);
            if (list2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(4);
            }
            return list2;
        }

        @Override
        protected boolean toggleChanges(@NotNull Collection<?> changes2) {
            List patchChanges;
            if (changes2 == null) {
                MyChangeTreeList.$$$reportNull$$$0(5);
            }
            if ((patchChanges = ContainerUtil.findAll(changes2, AbstractFilePatchInProgress.PatchChange.class)).size() == 1 && !((AbstractFilePatchInProgress.PatchChange)patchChanges.get(0)).isValid()) {
                return this.handleInvalidChangesAndToggle();
            }
            return super.toggleChanges(MyChangeTreeList.getOnlyValidChanges(patchChanges));
        }

        private boolean handleInvalidChangesAndToggle() {
            new NewBaseSelector(false).run();
            return super.toggleChanges(MyChangeTreeList.getOnlyValidChanges(this.getSelectedChanges()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeTreeList";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeTreeList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "buildTreeModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOnlyValidChanges";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "buildTreeModel";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isInclusionEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getOnlyValidChanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "toggleChanges";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1, 4 -> new IllegalStateException(string2);
            };
        }
    }

    private final class MyChangeNodeDecorator
    implements ChangeNodeDecorator {
        private MyChangeNodeDecorator() {
        }

        @Override
        public void decorate(@NotNull Change change, @NotNull SimpleColoredComponent component2, boolean isShowFlatten) {
            if (change == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(0);
            }
            if (component2 == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(1);
            }
            if (change instanceof AbstractFilePatchInProgress.PatchChange) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)change;
                AbstractFilePatchInProgress<?> patchInProgress = patchChange.getPatchInProgress();
                if (patchInProgress.getCurrentStrip() > 0) {
                    component2.append(VcsBundle.message("patch.apply.stripped.description", patchInProgress.getCurrentStrip()), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
                }
                String text2 = FilePatchStatus.ADDED.equals((Object)patchInProgress.getStatus()) ? VcsBundle.message("patch.apply.added.status", new Object[0]) : (FilePatchStatus.DELETED.equals((Object)patchInProgress.getStatus()) ? VcsBundle.message("patch.apply.deleted.status", new Object[0]) : VcsBundle.message("patch.apply.modified.status", new Object[0]));
                component2.append("   ");
                component2.append(text2, SimpleTextAttributes.GRAY_ATTRIBUTES);
                if (!patchInProgress.baseExistsOrAdded()) {
                    component2.append("  ");
                    component2.append(VcsBundle.message("patch.apply.select.missing.base.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, ApplyPatchDifferentiatedDialog.this.myChangesTreeList::handleInvalidChangesAndToggle);
                } else if (!patchInProgress.getStatus().equals((Object)FilePatchStatus.ADDED) && ApplyPatchDifferentiatedDialog.this.basePathWasChanged(patchInProgress)) {
                    component2.append("  ");
                    component2.append(VcsBundle.message("patch.apply.new.base.detected.node.description", new Object[0]), SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
                    component2.setToolTipText(VcsBundle.message("patch.apply.old.new.base.info", patchInProgress.getOriginalBeforePath(), ApplyPatchDifferentiatedDialog.this.myProject.getBasePath(), ((FilePatch)patchInProgress.getPatch()).getBeforeName(), patchInProgress.getBase().getPath()));
                }
            }
        }

        @Override
        public void preDecorate(@NotNull Change change, @NotNull ChangesBrowserNodeRenderer renderer2, boolean showFlatten) {
            if (change == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(2);
            }
            if (renderer2 == null) {
                MyChangeNodeDecorator.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyChangeNodeDecorator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decorate";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preDecorate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ChangesLegendCalculator
    implements CommitLegendPanel.InfoCalculator {
        private NamedLegendStatuses myTotal = new NamedLegendStatuses();
        private NamedLegendStatuses myIncluded = new NamedLegendStatuses();

        private ChangesLegendCalculator() {
        }

        public void setTotal(NamedLegendStatuses nameStatuses) {
            this.myTotal = nameStatuses;
        }

        public void setIncluded(NamedLegendStatuses nameStatuses) {
            this.myIncluded = nameStatuses;
        }

        @Override
        public int getNew() {
            return this.myTotal.getAdded();
        }

        @Override
        public int getModified() {
            return this.myTotal.getModified();
        }

        @Override
        public int getDeleted() {
            return this.myTotal.getDeleted();
        }

        @Override
        public int getUnversioned() {
            return 0;
        }

        public int getInapplicable() {
            return this.myTotal.getInapplicable();
        }

        @Override
        public int getIncludedNew() {
            return this.myIncluded.getAdded();
        }

        @Override
        public int getIncludedModified() {
            return this.myIncluded.getModified();
        }

        @Override
        public int getIncludedDeleted() {
            return this.myIncluded.getDeleted();
        }

        @Override
        public int getIncludedUnversioned() {
            return 0;
        }
    }

    private static class FilePresentationModel {
        @NotNull
        private final String myPath;
        @Nullable
        private VirtualFile myVf;

        private FilePresentationModel(@NotNull String path2) {
            if (path2 == null) {
                FilePresentationModel.$$$reportNull$$$0(0);
            }
            this.myPath = path2;
            this.myVf = null;
        }

        FilePresentationModel(@NotNull VirtualFile file) {
            if (file == null) {
                FilePresentationModel.$$$reportNull$$$0(1);
            }
            this.myPath = file.getPath();
            this.myVf = file;
        }

        @Nullable
        public VirtualFile getVf() {
            if (this.myVf == null) {
                VirtualFile file = VfsUtil.findFileByIoFile((File)new File(this.myPath), (boolean)true);
                this.myVf = file != null && !file.isDirectory() ? file : null;
            }
            return this.myVf;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$FilePresentationModel";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyShowDiff
    extends DumbAwareAction {
        private final MyChangeComparator myMyChangeComparator;

        private MyShowDiff() {
            super(VcsBundle.message("action.name.show.difference", new Object[0]), null, AllIcons.Actions.Diff);
            this.myMyChangeComparator = new MyChangeComparator();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyShowDiff.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDiff.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(!ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() && ApplyPatchDifferentiatedDialog.this.myContainBasedChanges);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowDiff.$$$reportNull$$$0(2);
            }
            this.showDiff();
        }

        private void showDiff() {
            if (ChangeListManager.getInstance(ApplyPatchDifferentiatedDialog.this.myProject).isFreezedWithNotification(null)) {
                return;
            }
            if (ApplyPatchDifferentiatedDialog.this.myPatches.isEmpty() || !ApplyPatchDifferentiatedDialog.this.myContainBasedChanges) {
                return;
            }
            List changes2 = ContainerUtil.sorted(ApplyPatchDifferentiatedDialog.this.getAllChanges(), (Comparator)this.myMyChangeComparator);
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (changes2.isEmpty()) {
                return;
            }
            AbstractFilePatchInProgress.PatchChange selectedChange = !selectedChanges.isEmpty() ? (AbstractFilePatchInProgress.PatchChange)selectedChanges.get(0) : (AbstractFilePatchInProgress.PatchChange)changes2.get(0);
            int selectedIdx = 0;
            ArrayList<ChangeDiffRequestChain.Producer> diffRequestPresentableList = new ArrayList<ChangeDiffRequestChain.Producer>();
            for (AbstractFilePatchInProgress.PatchChange change : changes2) {
                diffRequestPresentableList.add(this.createDiffRequestProducer(change));
                if (!change.equals(selectedChange)) continue;
                selectedIdx = diffRequestPresentableList.size() - 1;
            }
            ChangeDiffRequestChain chain = new ChangeDiffRequestChain(diffRequestPresentableList, selectedIdx);
            DiffManager.getInstance().showDiff(ApplyPatchDifferentiatedDialog.this.myProject, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
        }

        @NotNull
        private ChangeDiffRequestChain.Producer createDiffRequestProducer(@NotNull AbstractFilePatchInProgress.PatchChange change) {
            AbstractFilePatchInProgress<?> patchInProgress;
            if (change == null) {
                MyShowDiff.$$$reportNull$$$0(3);
            }
            DiffRequestProducer delegate = !(patchInProgress = change.getPatchInProgress()).baseExistsOrAdded() ? ApplyPatchDifferentiatedDialog.createBaseNotFoundErrorRequest(patchInProgress) : patchInProgress.getDiffRequestProducers(ApplyPatchDifferentiatedDialog.this.myProject, ApplyPatchDifferentiatedDialog.this.myReader);
            return new MyProducerWrapper(delegate, change);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyShowDiff";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyShowDiff";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffRequestProducer";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2, 3 -> new IllegalArgumentException(string2);
            };
        }
    }

    private static class NamedLegendStatuses {
        private int myAdded = 0;
        private int myModified = 0;
        private int myDeleted = 0;
        private int myInapplicable = 0;

        NamedLegendStatuses() {
        }

        public void plusAdded() {
            ++this.myAdded;
        }

        public void plusModified() {
            ++this.myModified;
        }

        public void plusDeleted() {
            ++this.myDeleted;
        }

        public void plusInapplicable() {
            ++this.myInapplicable;
        }

        public int getAdded() {
            return this.myAdded;
        }

        public int getModified() {
            return this.myModified;
        }

        public int getDeleted() {
            return this.myDeleted;
        }

        public int getInapplicable() {
            return this.myInapplicable;
        }
    }

    private class MyChangeComparator
    implements Comparator<AbstractFilePatchInProgress.PatchChange> {
        private MyChangeComparator() {
        }

        @Override
        public int compare(AbstractFilePatchInProgress.PatchChange o1, AbstractFilePatchInProgress.PatchChange o2) {
            if (PropertiesComponent.getInstance((Project)ApplyPatchDifferentiatedDialog.this.myProject).isTrueValue("ChangesBrowser.SHOW_FLATTEN")) {
                return o1.getPatchInProgress().getIoCurrentBase().getName().compareTo(o2.getPatchInProgress().getIoCurrentBase().getName());
            }
            return FileUtil.compareFiles((File)o1.getPatchInProgress().getIoCurrentBase(), (File)o2.getPatchInProgress().getIoCurrentBase());
        }
    }

    private static final class MyProducerWrapper
    implements ChangeDiffRequestChain.Producer {
        private final DiffRequestProducer myProducer;
        private final Change myChange;

        private MyProducerWrapper(@NotNull DiffRequestProducer producer, @NotNull Change change) {
            if (producer == null) {
                MyProducerWrapper.$$$reportNull$$$0(0);
            }
            if (change == null) {
                MyProducerWrapper.$$$reportNull$$$0(1);
            }
            this.myChange = change;
            this.myProducer = producer;
        }

        @NotNull
        public String getName() {
            String string2 = this.myProducer.getName();
            if (string2 == null) {
                MyProducerWrapper.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException {
            if (context == null) {
                MyProducerWrapper.$$$reportNull$$$0(3);
            }
            if (indicator == null) {
                MyProducerWrapper.$$$reportNull$$$0(4);
            }
            DiffRequest diffRequest = this.myProducer.process(context, indicator);
            if (diffRequest == null) {
                MyProducerWrapper.$$$reportNull$$$0(5);
            }
            return diffRequest;
        }

        @Override
        @NotNull
        public FilePath getFilePath() {
            FilePath filePath = ChangesUtil.getFilePath(this.myChange);
            if (filePath == null) {
                MyProducerWrapper.$$$reportNull$$$0(6);
            }
            return filePath;
        }

        @Override
        @NotNull
        public FileStatus getFileStatus() {
            FileStatus fileStatus = this.myChange.getFileStatus();
            if (fileStatus == null) {
                MyProducerWrapper.$$$reportNull$$$0(7);
            }
            return fileStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyProducerWrapper wrapper = (MyProducerWrapper)o;
            return Objects.equals(this.myProducer, wrapper.myProducer);
        }

        public int hashCode() {
            return Objects.hash(this.myProducer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "producer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyProducerWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MyProducerWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2, 5, 6, 7 -> new IllegalStateException(string2);
            };
        }
    }

    private class ResetStrip
    extends StripDown {
        ResetStrip() {
            super(VcsBundle.messagePointer("action.Anonymous.text.restore.all.leading.directories", new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetStrip.$$$reportNull$$$0(0);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().reset());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$ResetStrip", "actionPerformed"));
        }
    }

    private class StripUp
    extends DumbAwareAction {
        StripUp(Supplier<String> text2) {
            super(text2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                StripUp.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StripUp.$$$reportNull$$$0(1);
            }
            boolean isEnabled = ContainerUtil.exists(ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges(), change -> change.getPatchInProgress().canUp());
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StripUp.$$$reportNull$$$0(2);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().up());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$StripUp";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$StripUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string2);
                case 1, 2 -> new IllegalArgumentException(string2);
            };
        }
    }

    private class StripDown
    extends DumbAwareAction {
        StripDown(Supplier<String> text2) {
            if (text2 == null) {
                StripDown.$$$reportNull$$$0(0);
            }
            super(text2);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                StripDown.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                StripDown.$$$reportNull$$$0(2);
            }
            boolean isEnabled = ContainerUtil.exists(ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges(), change -> change.getPatchInProgress().canDown());
            e.getPresentation().setEnabled(isEnabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                StripDown.$$$reportNull$$$0(3);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().down());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$StripDown";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$StripDown";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private class ZeroStrip
    extends StripUp {
        ZeroStrip() {
            super(VcsBundle.messagePointer("action.Anonymous.text.remove.all.leading.directories", new Object[0]));
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ZeroStrip.$$$reportNull$$$0(0);
            }
            ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges().forEach(change -> change.getPatchInProgress().setZero());
            ApplyPatchDifferentiatedDialog.this.updateTree(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$ZeroStrip", "actionPerformed"));
        }
    }

    private final class MapPopup
    extends BaseListPopupStep<VirtualFile> {
        private final Runnable myNewBaseSelector;

        private MapPopup(List<? extends VirtualFile> aValues, Runnable newBaseSelector) {
            if (aValues == null) {
                MapPopup.$$$reportNull$$$0(0);
            }
            super(VcsBundle.message("path.apply.select.base.directory.for.a.path.popup", new Object[0]), aValues);
            this.myNewBaseSelector = newBaseSelector;
        }

        public boolean isSpeedSearchEnabled() {
            return true;
        }

        public PopupStep<?> onChosen(VirtualFile selectedValue, boolean finalChoice) {
            if (selectedValue == null) {
                this.myNewBaseSelector.run();
                return null;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress<?> patch = patchChange.getPatchInProgress();
                    patch.setNewBase(selectedValue);
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
            return null;
        }

        @NotNull
        public String getTextFor(VirtualFile value2) {
            String string2 = value2 == null ? VcsBundle.message("patch.apply.select.base.for.a.path.message", new Object[0]) : value2.getPath();
            if (string2 == null) {
                MapPopup.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aValues";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapPopup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }

    private class NewBaseSelector
    implements Runnable {
        final boolean myDirectorySelector;

        NewBaseSelector() {
            this(true);
        }

        NewBaseSelector(boolean directorySelector) {
            this.myDirectorySelector = directorySelector;
        }

        @Override
        public void run() {
            FileChooserDescriptor descriptor = this.myDirectorySelector ? FileChooserDescriptorFactory.createSingleFolderDescriptor() : FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
            descriptor.setTitle(VcsBundle.message("patch.apply.select.base.title", this.myDirectorySelector ? 0 : 1));
            VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)ApplyPatchDifferentiatedDialog.this.myProject, null);
            if (selectedFile == null) {
                return;
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            if (selectedChanges.size() >= 1) {
                for (AbstractFilePatchInProgress.PatchChange patchChange : selectedChanges) {
                    AbstractFilePatchInProgress<?> patch = patchChange.getPatchInProgress();
                    if (this.myDirectorySelector) {
                        patch.setNewBase(selectedFile);
                        continue;
                    }
                    Object filePatch = patch.getPatch();
                    ((FilePatch)filePatch).setAfterName(selectedFile.getName());
                    ((FilePatch)filePatch).setBeforeName(selectedFile.getName());
                    patch.setNewBase(selectedFile.getParent());
                }
                ApplyPatchDifferentiatedDialog.this.updateTree(false);
            }
        }
    }

    private final class MapDirectory
    extends DumbAwareAction {
        private final NewBaseSelector myNewBaseSelector;

        private MapDirectory() {
            super(VcsBundle.message("patch.apply.map.base.directory.action", new Object[0]));
            this.myNewBaseSelector = new NewBaseSelector();
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            List selectedChanges;
            if (e == null) {
                MapDirectory.$$$reportNull$$$0(0);
            }
            if ((selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges()).size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges)) {
                AbstractFilePatchInProgress.PatchChange patchChange = (AbstractFilePatchInProgress.PatchChange)selectedChanges.get(0);
                AbstractFilePatchInProgress<?> patch = patchChange.getPatchInProgress();
                List<VirtualFile> autoBases = patch.getAutoBasesCopy();
                if (autoBases.isEmpty() || autoBases.size() == 1 && autoBases.get(0).equals(patch.getBase())) {
                    this.myNewBaseSelector.run();
                } else {
                    autoBases.add(null);
                    MapPopup step2 = new MapPopup(autoBases, this.myNewBaseSelector);
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2).showCenteredInCurrentWindow(ApplyPatchDifferentiatedDialog.this.myProject);
                }
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MapDirectory.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MapDirectory.$$$reportNull$$$0(2);
            }
            List selectedChanges = ApplyPatchDifferentiatedDialog.this.myChangesTreeList.getSelectedChanges();
            e.getPresentation().setEnabled(selectedChanges.size() >= 1 && ApplyPatchDifferentiatedDialog.sameBase(selectedChanges));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/ApplyPatchDifferentiatedDialog$MapDirectory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 1 -> new IllegalStateException(string2);
            };
        }
    }
}

