/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class EditAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            EditAction.$$$reportNull$$$0(0);
        }
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        List files2 = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        assert (project2 != null);
        assert (files2 != null);
        EditAction.editFilesAndShowErrors(project2, files2);
    }

    public static void editFilesAndShowErrors(@NotNull Project project2, @NotNull List<? extends VirtualFile> files2) {
        if (project2 == null) {
            EditAction.$$$reportNull$$$0(1);
        }
        if (files2 == null) {
            EditAction.$$$reportNull$$$0(2);
        }
        ArrayList exceptions2 = new ArrayList();
        EditAction.editFiles(project2, files2, exceptions2);
        if (!exceptions2.isEmpty()) {
            AbstractVcsHelper.getInstance(project2).showErrors(exceptions2, VcsBundle.message("edit.errors", new Object[0]));
        }
    }

    public static void editFiles(@NotNull Project project2, @NotNull List<? extends VirtualFile> files2, List<? super VcsException> exceptions2) {
        if (project2 == null) {
            EditAction.$$$reportNull$$$0(3);
        }
        if (files2 == null) {
            EditAction.$$$reportNull$$$0(4);
        }
        ChangesUtil.processVirtualFilesByVcs(project2, files2, (vcs, items2) -> {
            EditFileProvider provider2 = vcs.getEditFileProvider();
            if (provider2 == null) {
                return;
            }
            try {
                provider2.editFiles(VfsUtilCore.toVirtualFileArray((Collection)items2));
            }
            catch (VcsException e1) {
                exceptions2.add(e1);
            }
            VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance(project2);
            FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
            for (VirtualFile file : items2) {
                vcsDirtyScopeManager.fileDirty(file);
                fileStatusManager.fileStatusChanged(file);
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        List files2;
        if (e == null) {
            EditAction.$$$reportNull$$$0(5);
        }
        boolean enabled = (files2 = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY)) != null && !files2.isEmpty();
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            EditAction.$$$reportNull$$$0(6);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/EditAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/EditAction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "editFilesAndShowErrors";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "editFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6 -> new IllegalStateException(string2);
        };
    }
}

