/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.AnnotateToggleAction;
import com.intellij.openapi.vcs.actions.VcsAnnotateUtil;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.history.VcsFileRevisionEx;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vcs.vfs.ContentRevisionVirtualFile;
import com.intellij.openapi.vcs.vfs.VcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateVcsVirtualFileAction {
    private static final Logger LOG = Logger.getInstance(AnnotateVcsVirtualFileAction.class);

    private static boolean isEnabled(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)e.getData(CommonDataKeys.PROJECT)) == null || project2.isDisposed()) {
            return false;
        }
        VirtualFile[] selectedFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (selectedFiles == null || selectedFiles.length != 1) {
            return false;
        }
        VirtualFile file = selectedFiles[0];
        if (file.isDirectory() || file.getFileType().isBinary()) {
            return false;
        }
        if (VcsAnnotateUtil.getEditorFor(file, e.getDataContext()) == null) {
            return false;
        }
        AnnotationData data2 = AnnotateVcsVirtualFileAction.extractData(project2, file);
        if (data2 == null) {
            return false;
        }
        AnnotationProviderEx provider2 = (AnnotationProviderEx)ObjectUtils.tryCast((Object)data2.vcs.getAnnotationProvider(), AnnotationProviderEx.class);
        if (provider2 == null) {
            return false;
        }
        return provider2.isAnnotationValid(data2.filePath, data2.revisionNumber);
    }

    private static boolean isSuspended(@NotNull AnActionEvent e) {
        if (e == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(1);
        }
        VirtualFile file = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        return VcsAnnotateUtil.getBackgroundableLock((Project)e.getRequiredData(CommonDataKeys.PROJECT), file).isLocked();
    }

    private static boolean isAnnotated(@NotNull AnActionEvent e) {
        VirtualFile file;
        Editor editor;
        if (e == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(2);
        }
        return (editor = VcsAnnotateUtil.getEditorFor(file = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0], e.getDataContext())) != null && AnnotateToggleAction.hasVcsAnnotations(editor);
    }

    private static void perform(AnActionEvent e, boolean selected) {
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file = ((VirtualFile[])e.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY))[0];
        Editor editor = Objects.requireNonNull(VcsAnnotateUtil.getEditorFor(file, e.getDataContext()));
        if (!selected) {
            AnnotateToggleAction.closeVcsAnnotations(editor);
        } else {
            AnnotateVcsVirtualFileAction.doAnnotate(project2, editor, file);
        }
    }

    private static void doAnnotate(final @NotNull Project project2, final @NotNull Editor editor, @NotNull VirtualFile file) {
        if (project2 == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(4);
        }
        if (file == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(5);
        }
        final AnnotationData data2 = AnnotateVcsVirtualFileAction.extractData(project2, file);
        assert (data2 != null);
        final AnnotationProviderEx provider2 = (AnnotationProviderEx)data2.vcs.getAnnotationProvider();
        assert (provider2 != null);
        final Ref fileAnnotationRef = new Ref();
        final Ref exceptionRef = new Ref();
        final BackgroundableActionLock actionLock = VcsAnnotateUtil.getBackgroundableLock(project2, file);
        actionLock.lock();
        Task.Backgroundable annotateTask = new Task.Backgroundable(project2, VcsBundle.message("retrieving.annotations", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    fileAnnotationRef.set((Object)provider2.annotate(data2.filePath, data2.revisionNumber));
                }
                catch (VcsException e) {
                    exceptionRef.set((Object)e);
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    exceptionRef.set((Object)new VcsException(t));
                }
            }

            public void onCancel() {
                this.onSuccess();
            }

            public void onSuccess() {
                if (!exceptionRef.isNull()) {
                    LOG.warn((Throwable)exceptionRef.get());
                    AbstractVcsHelper.getInstance(project2).showErrors(Collections.singletonList((VcsException)exceptionRef.get()), VcsBundle.message("message.title.annotate", new Object[0]));
                }
                if (!fileAnnotationRef.isNull()) {
                    AnnotateToggleAction.doAnnotate(editor, project2, (FileAnnotation)fileAnnotationRef.get(), data2.vcs);
                }
            }

            public void onFinished() {
                actionLock.unlock();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)annotateTask);
    }

    @Nullable
    private static AnnotationData extractData(@NotNull Project project2, @NotNull VirtualFile file) {
        if (project2 == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            AnnotateVcsVirtualFileAction.$$$reportNull$$$0(7);
        }
        FilePath filePath = null;
        VcsRevisionNumber revisionNumber = null;
        if (file instanceof VcsVirtualFile) {
            revision = ((VcsVirtualFile)file).getFileRevision();
            filePath = revision instanceof VcsFileRevisionEx ? ((VcsFileRevisionEx)revision).getPath() : VcsUtil.getFilePath(file);
            revisionNumber = revision != null ? revision.getRevisionNumber() : null;
        } else if (file instanceof ContentRevisionVirtualFile) {
            revision = ((ContentRevisionVirtualFile)file).getContentRevision();
            filePath = revision.getFile();
            revisionNumber = revision.getRevisionNumber();
        }
        if (filePath == null || revisionNumber == null) {
            return null;
        }
        if (revisionNumber instanceof TextRevisionNumber || revisionNumber == VcsRevisionNumber.NULL) {
            return null;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor(project2, filePath);
        return vcs != null ? new AnnotationData(vcs, filePath, revisionNumber) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuspended";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAnnotated";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doAnnotate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "extractData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class AnnotationData {
        @NotNull
        public final AbstractVcs vcs;
        @NotNull
        public final FilePath filePath;
        @NotNull
        public final VcsRevisionNumber revisionNumber;

        AnnotationData(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, @NotNull VcsRevisionNumber revisionNumber) {
            if (vcs == null) {
                AnnotationData.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                AnnotationData.$$$reportNull$$$0(1);
            }
            if (revisionNumber == null) {
                AnnotationData.$$$reportNull$$$0(2);
            }
            this.vcs = vcs;
            this.filePath = filePath;
            this.revisionNumber = revisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "revisionNumber";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$AnnotationData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class Provider
    implements AnnotateToggleAction.Provider {
        @Override
        public boolean isEnabled(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isEnabled(e);
        }

        @Override
        public boolean isSuspended(@NotNull AnActionEvent e) {
            if (e == null) {
                Provider.$$$reportNull$$$0(0);
            }
            return AnnotateVcsVirtualFileAction.isSuspended(e);
        }

        @Override
        public boolean isAnnotated(AnActionEvent e) {
            return AnnotateVcsVirtualFileAction.isAnnotated(e);
        }

        @Override
        public void perform(@NotNull AnActionEvent e, boolean selected) {
            if (e == null) {
                Provider.$$$reportNull$$$0(1);
            }
            AnnotateVcsVirtualFileAction.perform(e, selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/vcs/actions/AnnotateVcsVirtualFileAction$Provider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSuspended";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

