/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.ApplyFilePatchBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFilePatch;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApplyBinaryShelvedFilePatch
extends ApplyFilePatchBase<ShelvedBinaryFilePatch> {
    public ApplyBinaryShelvedFilePatch(ShelvedBinaryFilePatch patch) {
        super(patch);
    }

    @Override
    protected void applyCreate(@NotNull Project project2, @NotNull VirtualFile newFile, @Nullable CommitContext commitContext) throws IOException {
        if (project2 == null) {
            ApplyBinaryShelvedFilePatch.$$$reportNull$$$0(0);
        }
        if (newFile == null) {
            ApplyBinaryShelvedFilePatch.$$$reportNull$$$0(1);
        }
        this.writeContentTo(newFile);
    }

    @Override
    protected ApplyFilePatch.Result applyChange(@NotNull Project project2, @NotNull VirtualFile fileToPatch, @NotNull FilePath pathBeforeRename, @Nullable Supplier<? extends CharSequence> baseContents) throws IOException {
        if (project2 == null) {
            ApplyBinaryShelvedFilePatch.$$$reportNull$$$0(2);
        }
        if (fileToPatch == null) {
            ApplyBinaryShelvedFilePatch.$$$reportNull$$$0(3);
        }
        if (pathBeforeRename == null) {
            ApplyBinaryShelvedFilePatch.$$$reportNull$$$0(4);
        }
        this.writeContentTo(fileToPatch);
        return SUCCESS;
    }

    private void writeContentTo(@NotNull VirtualFile fileToPatch) throws IOException {
        if (fileToPatch == null) {
            ApplyBinaryShelvedFilePatch.$$$reportNull$$$0(5);
        }
        ShelvedBinaryFile shelvedBinaryFile = ((ShelvedBinaryFilePatch)this.myPatch).getShelvedBinaryFile();
        if (shelvedBinaryFile.SHELVED_PATH == null) {
            fileToPatch.delete((Object)this);
        } else {
            File fromFile = new File(shelvedBinaryFile.SHELVED_PATH);
            File toFile = VfsUtilCore.virtualToIoFile((VirtualFile)fileToPatch);
            FileUtil.copyContent((File)fromFile, (File)toFile);
            VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{fileToPatch});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFile";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToPatch";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathBeforeRename";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/diff/impl/patch/apply/ApplyBinaryShelvedFilePatch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "applyChange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "writeContentTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

