/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.MessageDiffRequest;
import com.intellij.diff.tools.fragmented.UnifiedDiffPanel;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.FileDifferenceModel;
import com.intellij.history.integration.ui.models.FileHistoryDialogModel;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.lvcs.impl.statistics.LocalHistoryCounter;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.ProgressBarLoadingDecorator;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistoryDialog
extends HistoryDialog<FileHistoryDialogModel> {
    private DiffRequestPanel myDiffPanel;
    private SearchTextArea mySearchTextArea;
    private Future<?> myFilterFuture;
    private final Alarm myAlarm;

    public FileHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f) {
        if (p == null) {
            FileHistoryDialog.$$$reportNull$$$0(0);
        }
        this(p, gw, f, true);
    }

    protected FileHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f, boolean doInit2) {
        if (p == null) {
            FileHistoryDialog.$$$reportNull$$$0(1);
        }
        super(p, gw, f, doInit2);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
    }

    @Override
    protected FileHistoryDialogModel createModel(LocalHistoryFacade vcs) {
        return new EntireFileHistoryDialogModel(this.myProject, this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Pair<JComponent, Dimension> createDiffPanel(JPanel root, ExcludingTraversalPolicy traversalPolicy) {
        this.myDiffPanel = DiffManager.getInstance().createRequestPanel(this.myProject, (Disposable)this, ApplicationManager.getApplication().isUnitTestMode() ? null : this.getFrame());
        this.myDiffPanel.setRequest((DiffRequest)new MessageDiffRequest(""));
        return Pair.create((Object)this.myDiffPanel.getComponent(), null);
    }

    @Override
    protected void addExtraToolbar(@NotNull JPanel toolBarPanel) {
        if (toolBarPanel == null) {
            FileHistoryDialog.$$$reportNull$$$0(2);
        }
        this.mySearchTextArea = new SearchTextArea(new JTextArea(), true);
        this.mySearchTextArea.setBorder(IdeBorderFactory.createBorder((int)7));
        new NextOccurenceAction(true).registerCustomShortcutSet((ShortcutSet)Utils.shortcutSetOf((List)ContainerUtil.concat((List)Utils.shortcutsOf((String)"FindNext"), (List)Utils.shortcutsOf((String)"EditorDown"))), (JComponent)this.mySearchTextArea);
        new NextOccurenceAction(false).registerCustomShortcutSet((ShortcutSet)Utils.shortcutSetOf((List)ContainerUtil.concat((List)Utils.shortcutsOf((String)"FindPrevious"), (List)Utils.shortcutsOf((String)"EditorUp"))), (JComponent)this.mySearchTextArea);
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                IdeFocusManager.getInstance((Project)FileHistoryDialog.this.myProject).requestFocus((Component)FileHistoryDialog.this.mySearchTextArea.getTextArea(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/views/FileHistoryDialog$1", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)Utils.shortcutSetOf((List)Utils.shortcutsOf((String)"Find")), this.myRevisionsList.getComponent());
        new DumbAwareAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileHistoryDialog.this.mySearchTextArea.getTextArea().setText("");
                IdeFocusManager.getInstance((Project)FileHistoryDialog.this.myProject).requestFocus((Component)FileHistoryDialog.this.myRevisionsList.getComponent(), true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/views/FileHistoryDialog$2", "actionPerformed"));
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{27}), (JComponent)this.mySearchTextArea.getTextArea());
        ProgressBarLoadingDecorator decorator = new ProgressBarLoadingDecorator((JPanel)this.mySearchTextArea, (Disposable)this, 500){

            protected boolean isOnTop() {
                return false;
            }
        };
        this.mySearchTextArea.getTextArea().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter((LoadingDecorator)decorator){
            final /* synthetic */ LoadingDecorator val$decorator;
            {
                this.val$decorator = loadingDecorator;
            }

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                FileHistoryDialog.this.myAlarm.cancelAllRequests();
                FileHistoryDialog.this.myAlarm.addRequest(() -> FileHistoryDialog.this.applyFilterText(StringUtil.nullize((String)FileHistoryDialog.this.mySearchTextArea.getTextArea().getText()), this.val$decorator), 100);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/views/FileHistoryDialog$4", "textChanged"));
            }
        });
        toolBarPanel.add((Component)decorator.getComponent(), "Center");
    }

    @Override
    protected ContentDiffRequest createDifference(FileDifferenceModel m) {
        if (this.myRevisionsList.isEmpty()) {
            return null;
        }
        ContentDiffRequest request = super.createDifference(m);
        ApplicationManager.getApplication().invokeLater(this::updateEditorSearch, ModalityState.stateForComponent((Component)this.myRevisionsList.getComponent()));
        return request;
    }

    @RequiresEdt
    private void applyFilterText(@Nullable String filter2, @NotNull LoadingDecorator decorator) {
        boolean hasPreviousSearch;
        if (decorator == null) {
            FileHistoryDialog.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.assertEventDispatchThread();
        decorator.stopLoading();
        boolean bl = hasPreviousSearch = this.myFilterFuture != null;
        if (hasPreviousSearch) {
            this.myFilterFuture.cancel(true);
            this.myFilterFuture = null;
        }
        if (StringUtil.isEmpty((String)filter2)) {
            this.applyFilteredRevisions(null);
        } else {
            if (!hasPreviousSearch) {
                LocalHistoryCounter.INSTANCE.logFilterUsed(((FileHistoryDialogModel)this.myModel).getKind());
            }
            decorator.startLoading(false);
            this.updateEditorSearch();
            this.myFilterFuture = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                FileHistoryDialogModel model2 = (FileHistoryDialogModel)this.myModel;
                Set revisions = model2 != null ? (Set)LocalHistoryCounter.INSTANCE.logFilter(this.myProject, ((FileHistoryDialogModel)this.myModel).getKind(), () -> model2.filterContents(filter2)) : Collections.emptySet();
                decorator.stopLoading();
                UIUtil.invokeLaterIfNeeded(() -> this.applyFilteredRevisions(revisions));
            });
        }
    }

    private void applyFilteredRevisions(Set<Long> revisions) {
        boolean wasEmpty = this.myRevisionsList.isEmpty();
        this.myRevisionsList.setFilteredRevisions(revisions);
        if (wasEmpty != this.myRevisionsList.isEmpty()) {
            this.myForceUpdateDiff = true;
        }
        this.updateEditorSearch();
    }

    private void updateEditorSearch() {
        Editor editor = this.findLeftEditor();
        if (editor == null) {
            return;
        }
        String filter2 = this.mySearchTextArea.getTextArea().getText();
        EditorSearchSession session = EditorSearchSession.get((Editor)editor);
        if (StringUtil.isEmpty((String)filter2)) {
            if (session != null) {
                boolean focused = this.mySearchTextArea.getTextArea().isFocusOwner();
                session.close();
                if (focused) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.mySearchTextArea.getTextArea(), false);
                }
            }
            return;
        }
        if (session == null) {
            session = EditorSearchSession.start((Editor)editor, (Project)this.myProject);
            session.searchForward();
        }
        session.setTextInField(filter2);
    }

    @Nullable
    private Editor findLeftEditor() {
        DiffSplitter splitter = (DiffSplitter)UIUtil.findComponentOfType((JComponent)this.myDiffPanel.getComponent(), DiffSplitter.class);
        JComponent editorPanel = splitter != null ? splitter.getFirstComponent() : UIUtil.findComponentOfType((JComponent)this.myDiffPanel.getComponent(), UnifiedDiffPanel.class);
        EditorComponentImpl comp = editorPanel == null ? null : (EditorComponentImpl)UIUtil.findComponentOfType((JComponent)editorPanel, EditorComponentImpl.class);
        return comp == null ? null : comp.getEditor();
    }

    @Override
    protected void setDiffBorder(Border border) {
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.myDiffPanel != null) {
            Disposer.dispose((Disposable)this.myDiffPanel);
        }
    }

    @Override
    protected Runnable doUpdateDiffs(@NotNull FileHistoryDialogModel model2) {
        if (model2 == null) {
            FileHistoryDialog.$$$reportNull$$$0(4);
        }
        FileDifferenceModel diffModel = model2.getDifferenceModel();
        return () -> this.myDiffPanel.setRequest((DiffRequest)this.createDifference(diffModel));
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.showhistory";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolBarPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/history/integration/ui/views/FileHistoryDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtraToolbar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyFilterText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdateDiffs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class NextOccurenceAction
    extends DumbAwareAction {
        private final boolean myForward;

        private NextOccurenceAction(boolean forward) {
            this.myForward = forward;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                NextOccurenceAction.$$$reportNull$$$0(0);
            }
            if ((editor = FileHistoryDialog.this.findLeftEditor()) == null) {
                return;
            }
            EditorSearchSession session = EditorSearchSession.get((Editor)editor);
            if (session != null && session.hasMatches()) {
                if (session.isLast(this.myForward)) {
                    FileHistoryDialog.this.myRevisionsList.moveSelection(this.myForward);
                } else if (this.myForward) {
                    session.searchForward();
                } else {
                    session.searchBackward();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/history/integration/ui/views/FileHistoryDialog$NextOccurenceAction", "actionPerformed"));
        }
    }
}

