/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.LocalHistoryFacadeKt;
import com.intellij.history.core.RevisionsCollector;
import com.intellij.history.core.revisions.CurrentRevision;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.RevisionData;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.history.integration.ui.models.SelectionCalculator;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lvcs.impl.RevisionId;
import com.intellij.util.PairProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a>\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001aL\u0010\u001d\u001a\u00020\u001e*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u001f\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\u0002\u0012\b\b\u0000\u0012\u0004\u0018\u00010\u00110 H\u0000\u001a\f\u0010!\u001a\u00020\"*\u00020\u0002H\u0000\"#\u0010\u0000\u001a\u0010\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"allRevisions", "", "Lcom/intellij/history/core/revisions/Revision;", "kotlin.jvm.PlatformType", "Lcom/intellij/history/integration/ui/models/RevisionData;", "getAllRevisions", "(Lcom/intellij/history/integration/ui/models/RevisionData;)Ljava/util/List;", "collectRevisionData", "project", "Lcom/intellij/openapi/project/Project;", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "facade", "Lcom/intellij/history/core/LocalHistoryFacade;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "filter", "", "before", "", "filterContents", "", "", "selectionCalculator", "Lcom/intellij/history/integration/ui/models/SelectionCalculator;", "mergeLabelsWithRevisions", "Lcom/intellij/history/integration/ui/models/RevisionItem;", "revisions", "", "processContents", "", "processor", "Lcom/intellij/util/PairProcessor;", "toRevisionId", "Lcom/intellij/platform/lvcs/impl/RevisionId;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nRevisionData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RevisionData.kt\ncom/intellij/history/integration/ui/models/RevisionDataKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1549#2:99\n1620#2,3:100\n766#2:103\n857#2,2:104\n1194#2,2:106\n1222#2,4:108\n*S KotlinDebug\n*F\n+ 1 RevisionData.kt\ncom/intellij/history/integration/ui/models/RevisionDataKt\n*L\n18#1:99\n18#1:100,3\n82#1:103\n82#1:104,2\n82#1:106,2\n82#1:108,4\n*E\n"})
public final class RevisionDataKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Revision> getAllRevisions(@NotNull RevisionData $this$allRevisions) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$allRevisions, (String)"<this>");
        Iterable iterable = $this$allRevisions.getRevisions();
        Collection collection = CollectionsKt.listOf((Object)$this$allRevisions.getCurrentRevision());
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RevisionItem revisionItem = (RevisionItem)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.revision);
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public static final RevisionId toRevisionId(@NotNull Revision $this$toRevisionId) {
        RevisionId revisionId;
        Intrinsics.checkNotNullParameter((Object)$this$toRevisionId, (String)"<this>");
        if ($this$toRevisionId.getChangeSetId() == null) {
            revisionId = RevisionId.Current.INSTANCE;
        } else {
            Long l = $this$toRevisionId.getChangeSetId();
            Intrinsics.checkNotNull((Object)l);
            revisionId = new RevisionId.ChangeSet(l);
        }
        return revisionId;
    }

    @NotNull
    public static final RevisionData collectRevisionData(@NotNull Project project2, @NotNull IdeaGateway gateway, @NotNull LocalHistoryFacade facade, @NotNull VirtualFile file, @Nullable String filter2, boolean before2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (RevisionData)ActionsKt.runReadAction((Function0)((Function0)new Function0<RevisionData>(gateway, facade, file, project2, filter2, before2){
            final /* synthetic */ IdeaGateway $gateway;
            final /* synthetic */ LocalHistoryFacade $facade;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $filter;
            final /* synthetic */ boolean $before;
            {
                this.$gateway = $gateway;
                this.$facade = $facade;
                this.$file = $file;
                this.$project = $project;
                this.$filter = $filter;
                this.$before = $before;
                super(0);
            }

            @NotNull
            public final RevisionData invoke() {
                this.$gateway.registerUnsavedDocuments(this.$facade);
                RootEntry rootEntry = this.$gateway.createTransientRootEntry();
                Intrinsics.checkNotNullExpressionValue((Object)rootEntry, (String)"createTransientRootEntry(...)");
                RootEntry root = rootEntry;
                String path2 = this.$gateway.getPathOrUrl(this.$file);
                List<Revision> list2 = RevisionsCollector.collect(this.$facade, root, path2, this.$project.getLocationHash(), this.$filter, this.$before);
                Intrinsics.checkNotNullExpressionValue(list2, (String)"collect(...)");
                List revisionItems = RevisionDataKt.access$mergeLabelsWithRevisions(list2);
                return new RevisionData(new CurrentRevision(root, path2), revisionItems);
            }
        }));
    }

    public static /* synthetic */ RevisionData collectRevisionData$default(Project project2, IdeaGateway ideaGateway, LocalHistoryFacade localHistoryFacade, VirtualFile virtualFile, String string2, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return RevisionDataKt.collectRevisionData(project2, ideaGateway, localHistoryFacade, virtualFile, string2, bl);
    }

    private static final List<RevisionItem> mergeLabelsWithRevisions(List<? extends Revision> revisions) {
        List result2 = new ArrayList();
        for (Revision revision : CollectionsKt.asReversed(revisions)) {
            if (revision.isLabel()) {
                if (result2.isEmpty()) continue;
                ((RevisionItem)CollectionsKt.last((List)result2)).labels.addFirst(revision);
                continue;
            }
            result2.add(new RevisionItem(revision));
        }
        return CollectionsKt.asReversedMutable((List)result2);
    }

    @NotNull
    public static final Set<Long> filterContents(@NotNull LocalHistoryFacade $this$filterContents, @NotNull IdeaGateway gateway, @NotNull VirtualFile file, @NotNull List<? extends Revision> revisions, @NotNull String filter2, boolean before2) {
        Intrinsics.checkNotNullParameter((Object)$this$filterContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Set result2 = new LinkedHashSet();
        RevisionDataKt.processContents($this$filterContents, gateway, file, revisions, before2, (PairProcessor<? super Revision, ? super String>)((PairProcessor)(arg_0, arg_1) -> RevisionDataKt.filterContents$lambda$1((Function2)new Function2<Revision, String, Boolean>(filter2, (Set<Long>)result2){
            final /* synthetic */ String $filter;
            final /* synthetic */ Set<Long> $result;
            {
                this.$filter = $filter;
                this.$result = $result;
                super(2);
            }

            @NotNull
            public final Boolean invoke(Revision revision, @Nullable String content) {
                Long id;
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                String string2 = content;
                boolean bl = string2 != null ? StringsKt.contains((CharSequence)string2, (CharSequence)this.$filter, (boolean)true) : false;
                if (bl && (id = revision.getChangeSetId()) != null) {
                    this.$result.add(id);
                }
                return true;
            }
        }, arg_0, arg_1)));
        return result2;
    }

    @NotNull
    public static final Set<Long> filterContents(@NotNull SelectionCalculator selectionCalculator, @NotNull String filter2) {
        Intrinsics.checkNotNullParameter((Object)selectionCalculator, (String)"selectionCalculator");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Set result2 = new LinkedHashSet();
        selectionCalculator.processContents((Function2<? super Long, ? super String, Boolean>)((Function2)new Function2<Long, String, Boolean>(filter2, (Set<Long>)result2){
            final /* synthetic */ String $filter;
            final /* synthetic */ Set<Long> $result;
            {
                this.$filter = $filter;
                this.$result = $result;
                super(2);
            }

            @NotNull
            public final Boolean invoke(long id, @NotNull String contents) {
                Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                if (StringsKt.contains((CharSequence)contents, (CharSequence)this.$filter, (boolean)true)) {
                    this.$result.add(id);
                }
                return true;
            }
        }));
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void processContents(@NotNull LocalHistoryFacade $this$processContents, @NotNull IdeaGateway gateway, @NotNull VirtualFile file, @NotNull List<? extends Revision> revisions, boolean before2, @NotNull PairProcessor<? super Revision, ? super String> processor2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$processContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(revisions, (String)"revisions");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        Iterable $this$filter$iv = revisions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Revision it = (Revision)element$iv$iv;
            boolean bl = false;
            if (!(!it.isLabel())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Revision bl = (Revision)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            map2.put(it.getChangeSetId(), element$iv$iv);
        }
        Map revisionMap = destination$iv$iv2;
        if (revisionMap.isEmpty()) {
            return;
        }
        RootEntry rootEntry = ((Revision)CollectionsKt.first((Iterable)revisionMap.values())).getRoot().copy();
        Intrinsics.checkNotNullExpressionValue((Object)rootEntry, (String)"copy(...)");
        RootEntry root = rootEntry;
        String path2 = gateway.getPathOrUrl(file);
        Revision currentRevision = (Revision)revisionMap.get(null);
        if (currentRevision != null) {
            Entry entry2 = root.findEntry(path2);
            Object object = entry2;
            processor2.process((Object)currentRevision, object != null && (object = ((Entry)object).getContent()) != null ? ((Content)object).getString(entry2, gateway) : null);
        }
        Intrinsics.checkNotNull((Object)path2);
        LocalHistoryFacadeKt.processContents($this$processContents, gateway, root, path2, (Set)CollectionsKt.filterNotNullTo((Iterable)revisionMap.keySet(), (Collection)new LinkedHashSet()), before2, (Function2<? super Long, ? super String, Boolean>)((Function2)new Function2<Long, String, Boolean>((Map<Long, ? extends Revision>)revisionMap, processor2){
            final /* synthetic */ Map<Long, Revision> $revisionMap;
            final /* synthetic */ PairProcessor<? super Revision, ? super String> $processor;
            {
                this.$revisionMap = $revisionMap;
                this.$processor = $processor;
                super(2);
            }

            @NotNull
            public final Boolean invoke(long changeSetId, @Nullable String content) {
                Revision revision = this.$revisionMap.get(changeSetId);
                return revision == null || this.$processor.process((Object)revision, (Object)content);
            }
        }));
    }

    private static final boolean filterContents$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ List access$mergeLabelsWithRevisions(List revisions) {
        return RevisionDataKt.mergeLabelsWithRevisions(revisions);
    }
}

