/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.MultiRootBranches;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRepositoryManager<T extends Repository>
implements RepositoryManager<T>,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsKey myVcsKey;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;

    protected AbstractRepositoryManager(@NotNull Project project2, @NotNull VcsKey vcsKey, @NotNull @NonNls String repoDirName) {
        if (project2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(0);
        }
        if (vcsKey == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(1);
        }
        if (repoDirName == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(2);
        }
        this.myGlobalRepositoryManager = VcsRepositoryManager.getInstance(project2);
        this.myProject = project2;
        this.myVcsKey = vcsKey;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresBackgroundThread
    @Nullable
    public T getRepositoryForRoot(@Nullable VirtualFile virtualFile) {
        void root;
        ThreadingAssertions.assertBackgroundThread();
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRoot((VirtualFile)root));
    }

    @Override
    @Nullable
    public T getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRootQuick(root));
    }

    @Override
    @Nullable
    public T getRepositoryForRootQuick(@Nullable FilePath rootPath) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRootQuick(rootPath));
    }

    @Override
    public void addExternalRepository(@NotNull VirtualFile root, @NotNull T repository) {
        if (root == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(3);
        }
        if (repository == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(4);
        }
        this.myGlobalRepositoryManager.addExternalRepository(root, (Repository)repository);
    }

    @Override
    public void removeExternalRepository(@NotNull VirtualFile root) {
        if (root == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(5);
        }
        this.myGlobalRepositoryManager.removeExternalRepository(root);
    }

    @Override
    public boolean isExternal(@NotNull T repository) {
        if (repository == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(6);
        }
        return this.myGlobalRepositoryManager.isExternal((Repository)repository);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresBackgroundThread
    @Nullable
    public T getRepositoryForFile(@Nullable VirtualFile virtualFile) {
        void file;
        ThreadingAssertions.assertBackgroundThread();
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile((VirtualFile)file));
    }

    @Nullable
    public T getRepositoryForFileQuick(@Nullable VirtualFile file) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFileQuick(file));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresBackgroundThread
    @Nullable
    public T getRepositoryForFile(@Nullable FilePath filePath) {
        void file;
        ThreadingAssertions.assertBackgroundThread();
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile((FilePath)file, false));
    }

    @Override
    @Nullable
    public T getRepositoryForFileQuick(@Nullable FilePath file) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file, true));
    }

    @NotNull
    protected List<T> getRepositories(Class<T> type2) {
        List list2 = ContainerUtil.findAll(this.myGlobalRepositoryManager.getRepositories(), type2);
        if (list2 == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @NotNull
    public abstract List<T> getRepositories();

    @Override
    public boolean moreThanOneRoot() {
        return this.getRepositories().size() > 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @RequiresBackgroundThread
    public void updateRepository(@Nullable VirtualFile virtualFile) {
        void root;
        ThreadingAssertions.assertBackgroundThread();
        T repo = this.getRepositoryForRoot((VirtualFile)root);
        if (repo != null) {
            repo.update();
        }
    }

    @Override
    public void updateAllRepositories() {
        ContainerUtil.process(this.getRepositories(), repo -> {
            repo.update();
            return true;
        });
    }

    @Nullable
    private T validateAndGetRepository(@Nullable Repository repository) {
        if (repository == null || !this.myVcsKey.equals(repository.getVcs().getKeyInstanceMethod()) || !repository.getRoot().isValid()) {
            return null;
        }
        return (T)repository;
    }

    @Override
    @NotNull
    public AbstractVcs getVcs() {
        AbstractVcs vcs = ProjectLevelVcsManager.getInstance(this.myProject).findVcsByName(this.myVcsKey.getName());
        AbstractVcs abstractVcs = Objects.requireNonNull(vcs);
        if (abstractVcs == null) {
            AbstractRepositoryManager.$$$reportNull$$$0(8);
        }
        return abstractVcs;
    }

    public boolean shouldProposeSyncControl() {
        return !MultiRootBranches.diverged(this.getRepositories());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoDirName";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/repo/AbstractRepositoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/repo/AbstractRepositoryManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositories";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addExternalRepository";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeExternalRepository";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isExternal";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8 -> new IllegalStateException(string2);
        };
    }
}

