/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.auth.services;

import com.intellij.collaboration.auth.services.OAuthService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.concurrent.Future;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0014\u0010\u0016\u001a\u00020\u00132\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0014J\f\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u0006H$J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "service", "Lcom/intellij/collaboration/auth/services/OAuthService;", "getService", "()Lcom/intellij/collaboration/auth/services/OAuthService;", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "handleAcceptCode", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "isAccepted", "", "handleOAuthResult", "oAuthResult", "Lcom/intellij/collaboration/auth/services/OAuthService$OAuthResult;", "oauthService", "sendRedirect", "", "url", "Lcom/intellij/util/Url;", "AcceptCodeHandleResult", "intellij.platform.collaborationTools.auth.base"})
@SourceDebugExtension(value={"SMAP\nOAuthCallbackHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuthCallbackHandler.kt\ncom/intellij/collaboration/auth/services/OAuthCallbackHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,94:1\n11#2:95\n*S KotlinDebug\n*F\n+ 1 OAuthCallbackHandler.kt\ncom/intellij/collaboration/auth/services/OAuthCallbackHandler\n*L\n25#1:95\n*E\n"})
public abstract class OAuthCallbackHandler {
    @JvmField
    @NotNull
    protected final Logger LOG;

    public OAuthCallbackHandler() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OAuthCallbackHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = logger;
    }

    @NotNull
    protected final OAuthService<?> getService() {
        return this.oauthService();
    }

    @NotNull
    public final String getServiceName() {
        return this.getService().getName();
    }

    @NotNull
    protected abstract OAuthService<?> oauthService();

    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Channel channel = context.channel();
        EmptyProgressIndicator indicator = new EmptyProgressIndicator();
        channel.closeFuture().addListener(arg_0 -> OAuthCallbackHandler.execute$lambda$0(indicator, arg_0));
        ExecutorService executorService = AppExecutorUtil.getAppExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"getAppExecutorService(...)");
        ExecutorService executor = executorService;
        CompletableFuture.supplyAsync(() -> OAuthCallbackHandler.execute$lambda$2(indicator, this, urlDecoder), executor).handle((arg_0, arg_1) -> OAuthCallbackHandler.execute$lambda$3((Function2)new Function2<AcceptCodeHandleResult, Throwable, Object>(channel, this, context, request){
            final /* synthetic */ Channel $channel;
            final /* synthetic */ OAuthCallbackHandler this$0;
            final /* synthetic */ ChannelHandlerContext $context;
            final /* synthetic */ FullHttpRequest $request;
            {
                this.$channel = $channel;
                this.this$0 = $receiver;
                this.$context = $context;
                this.$request = $request;
                super(2);
            }

            public final Object invoke(@Nullable AcceptCodeHandleResult res, Throwable err) {
                ChannelFuture channelFuture;
                if (err != null) {
                    if (err instanceof ProcessCanceledException) {
                        channelFuture = this.$channel.close();
                    } else {
                        this.this$0.LOG.warn(err);
                        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
                        Channel channel = this.$channel;
                        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"$channel");
                        Responses.responseStatus((HttpResponseStatus)httpResponseStatus, (boolean)false, (Channel)channel);
                        channelFuture = Unit.INSTANCE;
                    }
                } else if (res != null) {
                    AcceptCodeHandleResult acceptCodeHandleResult = res;
                    if (acceptCodeHandleResult instanceof AcceptCodeHandleResult.Page) {
                        byte[] byArray = ((AcceptCodeHandleResult.Page)res).getHtml().getBytes(Charsets.UTF_8);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        HttpResponse httpResponse = (HttpResponse)Responses.response((String)"text/html", (ByteBuf)Unpooled.wrappedBuffer((byte[])byArray));
                        Channel channel = this.$context.channel();
                        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                        Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)this.$request), null, (int)4, null);
                    } else if (acceptCodeHandleResult instanceof AcceptCodeHandleResult.Redirect) {
                        OAuthCallbackHandler.access$sendRedirect(this.this$0, this.$request, this.$context, ((AcceptCodeHandleResult.Redirect)res).getUrl());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    channelFuture = Unit.INSTANCE;
                } else {
                    HttpResponseStatus httpResponseStatus = HttpResponseStatus.NO_CONTENT;
                    Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NO_CONTENT");
                    Channel channel = this.$channel;
                    Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"$channel");
                    Responses.responseStatus((HttpResponseStatus)httpResponseStatus, (boolean)false, (Channel)channel);
                    channelFuture = Unit.INSTANCE;
                }
                return channelFuture;
            }
        }, arg_0, arg_1));
        return null;
    }

    @NotNull
    protected AcceptCodeHandleResult handleOAuthResult(@NotNull OAuthService.OAuthResult<?> oAuthResult) {
        Intrinsics.checkNotNullParameter(oAuthResult, (String)"oAuthResult");
        return this.handleAcceptCode(oAuthResult.isAccepted());
    }

    @Deprecated(message="Use handleOAuthResult instead", replaceWith=@ReplaceWith(expression="handleOAuthResult", imports={}))
    @NotNull
    public AcceptCodeHandleResult handleAcceptCode(boolean isAccepted) {
        throw new UnsupportedOperationException();
    }

    private final void sendRedirect(FullHttpRequest request, ChannelHandlerContext context, Url url) {
        HttpHeaders headers = new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url.toExternalForm());
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.FOUND;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"FOUND");
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        Responses.send((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)((HttpRequest)request), null, (HttpHeaders)headers);
    }

    private static final void execute$lambda$0(EmptyProgressIndicator $indicator, Future it) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        $indicator.cancel();
    }

    private static final AcceptCodeHandleResult execute$handle$lambda$1(OAuthCallbackHandler this$0, QueryStringDecoder $urlDecoder) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$urlDecoder, (String)"$urlDecoder");
        OAuthService<?> oAuthService = this$0.getService();
        String string2 = $urlDecoder.path();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path(...)");
        Map map2 = $urlDecoder.parameters();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"parameters(...)");
        OAuthService.OAuthResult<?> oAuthResult = oAuthService.handleOAuthServerCallback(string2, map2);
        if (oAuthResult == null) {
            return null;
        }
        OAuthService.OAuthResult<?> oAuthResult2 = oAuthResult;
        return this$0.handleOAuthResult(oAuthResult2);
    }

    private static final AcceptCodeHandleResult execute$handle(OAuthCallbackHandler this$0, QueryStringDecoder $urlDecoder, EmptyProgressIndicator indicator) {
        return (AcceptCodeHandleResult)ProgressManager.getInstance().runProcess(() -> OAuthCallbackHandler.execute$handle$lambda$1(this$0, $urlDecoder), (ProgressIndicator)indicator);
    }

    private static final AcceptCodeHandleResult execute$lambda$2(EmptyProgressIndicator $indicator, OAuthCallbackHandler this$0, QueryStringDecoder $urlDecoder) {
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$urlDecoder, (String)"$urlDecoder");
        return OAuthCallbackHandler.execute$handle(this$0, $urlDecoder, $indicator);
    }

    private static final Object execute$lambda$3(Function2 $tmp0, Object p0, Throwable p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0, (Object)p1);
    }

    public static final /* synthetic */ void access$sendRedirect(OAuthCallbackHandler $this, FullHttpRequest request, ChannelHandlerContext context, Url url) {
        $this.sendRedirect(request, context, url);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "", "()V", "Page", "Redirect", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Redirect;", "intellij.platform.collaborationTools.auth.base"})
    public static abstract class AcceptCodeHandleResult {
        private AcceptCodeHandleResult() {
        }

        public /* synthetic */ AcceptCodeHandleResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Page;", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "html", "", "(Ljava/lang/String;)V", "getHtml", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.collaborationTools.auth.base"})
        public static final class Page
        extends AcceptCodeHandleResult {
            @NotNull
            private final String html;

            public Page(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                super(null);
                this.html = html;
            }

            @NotNull
            public final String getHtml() {
                return this.html;
            }

            @NotNull
            public final String component1() {
                return this.html;
            }

            @NotNull
            public final Page copy(@NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                return new Page(html);
            }

            public static /* synthetic */ Page copy$default(Page page, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = page.html;
                }
                return page.copy(string2);
            }

            @NotNull
            public String toString() {
                return "Page(html=" + this.html + ")";
            }

            public int hashCode() {
                return this.html.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Page)) {
                    return false;
                }
                Page page = (Page)other;
                return Intrinsics.areEqual((Object)this.html, (Object)page.html);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult$Redirect;", "Lcom/intellij/collaboration/auth/services/OAuthCallbackHandler$AcceptCodeHandleResult;", "url", "Lcom/intellij/util/Url;", "(Lcom/intellij/util/Url;)V", "getUrl", "()Lcom/intellij/util/Url;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.platform.collaborationTools.auth.base"})
        public static final class Redirect
        extends AcceptCodeHandleResult {
            @NotNull
            private final Url url;

            public Redirect(@NotNull Url url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                super(null);
                this.url = url;
            }

            @NotNull
            public final Url getUrl() {
                return this.url;
            }

            @NotNull
            public final Url component1() {
                return this.url;
            }

            @NotNull
            public final Redirect copy(@NotNull Url url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return new Redirect(url);
            }

            public static /* synthetic */ Redirect copy$default(Redirect redirect, Url url, int n, Object object) {
                if ((n & 1) != 0) {
                    url = redirect.url;
                }
                return redirect.copy(url);
            }

            @NotNull
            public String toString() {
                return "Redirect(url=" + this.url + ")";
            }

            public int hashCode() {
                return this.url.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Redirect)) {
                    return false;
                }
                Redirect redirect = (Redirect)other;
                return Intrinsics.areEqual((Object)this.url, (Object)redirect.url);
            }
        }
    }
}

