/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.stemmer;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.stemmer.Stemmer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\f\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0006H\u0002J\f\u0010\u0015\u001a\u00020\u0014*\u00020\u0006H\u0002J\f\u0010\u0016\u001a\u00020\u0014*\u00020\u0006H\u0002J\u0014\u0010\u0017\u001a\u00020\u0014*\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J&\u0010\u0019\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u0004H\u0002J\u001e\u0010\u001c\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00042\b\b\u0002\u0010\u001b\u001a\u00020\u0004H\u0002J\u001e\u0010\u001c\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00062\b\b\u0002\u0010\u001b\u001a\u00020\u0004H\u0002\u00a8\u0006 "}, d2={"Lai/grazie/nlp/stemmer/PorterStemmer;", "Lai/grazie/nlp/stemmer/Stemmer;", "()V", "m", "", "word", "", "stem", "step1", "step1a", "step1b", "step1b1", "step1c", "step2", "step3", "step4", "step5", "step5a", "step5b", "containsVowel", "", "endsWithCvc", "endsWithDoubleChars", "endsWithPattern", "pattern", "replaceEnd", "replacement", "requiredM", "withoutPostfix", "postfixLength", "postfix", "Companion", "nlp-stemmer"})
public final class PorterStemmer
implements Stemmer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String VOWEL = "(?:[aeiou]|(?<![aeiou])y)";
    @NotNull
    private static final String CONSONANT = "(?:[bcdfghjklmnpqrstvwxz]|(?<=[aeiou])y|^y)";
    @NotNull
    private static final String CONSONANT_CVC = "[bcdfghjklmnpqrstvz]";
    @NotNull
    private static final String REDUCED_CONSONANT = "(?:[bcdfghjkmnpqrtvwx]|(?<=[aeiou])y|^y)";
    @NotNull
    private static final Regex VOWELS_REGEX = new Regex("(?:[aeiou]|(?<![aeiou])y)+");
    @NotNull
    private static final Regex M_REGEX = new Regex("((?:[aeiou]|(?<![aeiou])y)+(?:[bcdfghjklmnpqrstvwxz]|(?<=[aeiou])y|^y)+)");

    @Override
    @NotNull
    public String stem(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return word.length() < 3 ? word : this.step5(this.step4(this.step3(this.step2(this.step1(word)))));
    }

    private final String step1(String word) {
        return this.step1c(this.step1b(this.step1a(word)));
    }

    private final String step1a(String word) {
        return StringsKt.endsWith$default((String)word, (String)"sses", (boolean)false, (int)2, null) ? PorterStemmer.replaceEnd$default(this, word, "sses", "ss", 0, 4, null) : (StringsKt.endsWith$default((String)word, (String)"ies", (boolean)false, (int)2, null) ? PorterStemmer.withoutPostfix$default(this, word, 2, 0, 2, null) : (StringsKt.endsWith$default((String)word, (String)"ss", (boolean)false, (int)2, null) ? word : (StringsKt.endsWith$default((String)word, (String)"s", (boolean)false, (int)2, null) ? PorterStemmer.withoutPostfix$default(this, word, 1, 0, 2, null) : word)));
    }

    private final String step1b(String word) {
        return StringsKt.endsWith$default((String)word, (String)"eed", (boolean)false, (int)2, null) ? (this.m(PorterStemmer.withoutPostfix$default(this, word, "eed", 0, 2, null)) > 0 ? PorterStemmer.withoutPostfix$default(this, word, 1, 0, 2, null) : word) : (StringsKt.endsWith$default((String)word, (String)"ed", (boolean)false, (int)2, null) && this.containsVowel(PorterStemmer.withoutPostfix$default(this, word, "ed", 0, 2, null)) ? this.step1b1(PorterStemmer.withoutPostfix$default(this, word, "ed", 0, 2, null)) : (StringsKt.endsWith$default((String)word, (String)"ing", (boolean)false, (int)2, null) && this.containsVowel(PorterStemmer.withoutPostfix$default(this, word, "ing", 0, 2, null)) ? this.step1b1(PorterStemmer.withoutPostfix$default(this, word, "ing", 0, 2, null)) : word));
    }

    private final String step1b1(String word) {
        return StringsKt.endsWith$default((String)word, (String)"at", (boolean)false, (int)2, null) ? word + "e" : (StringsKt.endsWith$default((String)word, (String)"bl", (boolean)false, (int)2, null) ? word + "e" : (StringsKt.endsWith$default((String)word, (String)"iz", (boolean)false, (int)2, null) ? word + "e" : (this.endsWithDoubleChars(word) && this.endsWithPattern(word, REDUCED_CONSONANT) ? PorterStemmer.withoutPostfix$default(this, word, 1, 0, 2, null) : (this.endsWithCvc(word) && this.m(word) == 1 ? word + "e" : word))));
    }

    private final String step1c(String word) {
        return StringsKt.endsWith$default((String)word, (String)"y", (boolean)false, (int)2, null) && this.containsVowel(PorterStemmer.withoutPostfix$default(this, word, "y", 0, 2, null)) ? PorterStemmer.replaceEnd$default(this, word, "y", "i", 0, 4, null) : word;
    }

    private final String step2(String word) {
        return StringsKt.endsWith$default((String)word, (String)"ational", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ational", "ate", 0) : (StringsKt.endsWith$default((String)word, (String)"tional", (boolean)false, (int)2, null) ? this.replaceEnd(word, "tional", "tion", 0) : (StringsKt.endsWith$default((String)word, (String)"enci", (boolean)false, (int)2, null) ? this.replaceEnd(word, "enci", "ence", 0) : (StringsKt.endsWith$default((String)word, (String)"anci", (boolean)false, (int)2, null) ? this.replaceEnd(word, "anci", "ance", 0) : (StringsKt.endsWith$default((String)word, (String)"izer", (boolean)false, (int)2, null) ? this.replaceEnd(word, "izer", "ize", 0) : (StringsKt.endsWith$default((String)word, (String)"bli", (boolean)false, (int)2, null) ? this.replaceEnd(word, "bli", "ble", 0) : (StringsKt.endsWith$default((String)word, (String)"alli", (boolean)false, (int)2, null) ? this.replaceEnd(word, "alli", "al", 0) : (StringsKt.endsWith$default((String)word, (String)"entli", (boolean)false, (int)2, null) ? this.replaceEnd(word, "entli", "ent", 0) : (StringsKt.endsWith$default((String)word, (String)"eli", (boolean)false, (int)2, null) ? this.replaceEnd(word, "eli", "e", 0) : (StringsKt.endsWith$default((String)word, (String)"ousli", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ousli", "ous", 0) : (StringsKt.endsWith$default((String)word, (String)"ization", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ization", "ize", 0) : (StringsKt.endsWith$default((String)word, (String)"ation", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ation", "ate", 0) : (StringsKt.endsWith$default((String)word, (String)"ator", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ator", "ate", 0) : (StringsKt.endsWith$default((String)word, (String)"alism", (boolean)false, (int)2, null) ? this.replaceEnd(word, "alism", "al", 0) : (StringsKt.endsWith$default((String)word, (String)"iveness", (boolean)false, (int)2, null) ? this.replaceEnd(word, "iveness", "ive", 0) : (StringsKt.endsWith$default((String)word, (String)"fulness", (boolean)false, (int)2, null) ? this.replaceEnd(word, "fulness", "ful", 0) : (StringsKt.endsWith$default((String)word, (String)"ousness", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ousness", "ous", 0) : (StringsKt.endsWith$default((String)word, (String)"aliti", (boolean)false, (int)2, null) ? this.replaceEnd(word, "aliti", "al", 0) : (StringsKt.endsWith$default((String)word, (String)"iviti", (boolean)false, (int)2, null) ? this.replaceEnd(word, "iviti", "ive", 0) : (StringsKt.endsWith$default((String)word, (String)"biliti", (boolean)false, (int)2, null) ? this.replaceEnd(word, "biliti", "ble", 0) : (StringsKt.endsWith$default((String)word, (String)"logi", (boolean)false, (int)2, null) ? this.replaceEnd(word, "logi", "log", 0) : word))))))))))))))))))));
    }

    private final String step3(String word) {
        return StringsKt.endsWith$default((String)word, (String)"icate", (boolean)false, (int)2, null) ? this.replaceEnd(word, "icate", "ic", 0) : (StringsKt.endsWith$default((String)word, (String)"ative", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ative", 0) : (StringsKt.endsWith$default((String)word, (String)"alize", (boolean)false, (int)2, null) ? this.replaceEnd(word, "alize", "al", 0) : (StringsKt.endsWith$default((String)word, (String)"iciti", (boolean)false, (int)2, null) ? this.replaceEnd(word, "iciti", "ic", 0) : (StringsKt.endsWith$default((String)word, (String)"ical", (boolean)false, (int)2, null) ? this.replaceEnd(word, "ical", "ic", 0) : (StringsKt.endsWith$default((String)word, (String)"ful", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ful", 0) : (StringsKt.endsWith$default((String)word, (String)"ness", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ness", 0) : word))))));
    }

    @NotNull
    public final String step4(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return StringsKt.endsWith$default((String)word, (String)"al", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "al", 1) : (StringsKt.endsWith$default((String)word, (String)"ance", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ance", 1) : (StringsKt.endsWith$default((String)word, (String)"ence", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ence", 1) : (StringsKt.endsWith$default((String)word, (String)"er", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "er", 1) : (StringsKt.endsWith$default((String)word, (String)"ic", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ic", 1) : (StringsKt.endsWith$default((String)word, (String)"able", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "able", 1) : (StringsKt.endsWith$default((String)word, (String)"ible", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ible", 1) : (StringsKt.endsWith$default((String)word, (String)"ant", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ant", 1) : (StringsKt.endsWith$default((String)word, (String)"ement", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ement", 1) : (StringsKt.endsWith$default((String)word, (String)"ment", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ment", 1) : (StringsKt.endsWith$default((String)word, (String)"ent", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ent", 1) : (StringsKt.endsWith$default((String)word, (String)"ion", (boolean)false, (int)2, null) && (StringsKt.endsWith$default((String)word, (String)"tion", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)word, (String)"sion", (boolean)false, (int)2, null)) ? this.withoutPostfix(word, "ion", 1) : (StringsKt.endsWith$default((String)word, (String)"ou", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ou", 1) : (StringsKt.endsWith$default((String)word, (String)"ism", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ism", 1) : (StringsKt.endsWith$default((String)word, (String)"ate", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ate", 1) : (StringsKt.endsWith$default((String)word, (String)"iti", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "iti", 1) : (StringsKt.endsWith$default((String)word, (String)"ous", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ous", 1) : (StringsKt.endsWith$default((String)word, (String)"ive", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ive", 1) : (StringsKt.endsWith$default((String)word, (String)"ize", (boolean)false, (int)2, null) ? this.withoutPostfix(word, "ize", 1) : word))))))))))))))))));
    }

    @NotNull
    public final String step5(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        return this.step5b(this.step5a(word));
    }

    @NotNull
    public final String step5a(@NotNull String word) {
        String wordWithoutE;
        int m;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (StringsKt.endsWith$default((String)word, (String)"e", (boolean)false, (int)2, null) && ((m = this.m(wordWithoutE = PorterStemmer.withoutPostfix$default(this, word, "e", 0, 2, null))) > 1 || m == 1 && !this.endsWithCvc(wordWithoutE))) {
            return wordWithoutE;
        }
        return word;
    }

    private final String step5b(String word) {
        return StringsKt.endsWith$default((String)word, (String)"ll", (boolean)false, (int)2, null) && this.m(word) > 1 ? PorterStemmer.withoutPostfix$default(this, word, "l", 0, 2, null) : word;
    }

    private final int m(String word) {
        CharSequence charSequence = word;
        Regex regex = new Regex("^(?:[bcdfghjklmnpqrstvwxz]|(?<=[aeiou])y|^y)+");
        String string2 = "";
        String wordWithoutTrailingConsonants = regex.replaceFirst(charSequence, string2);
        return SequencesKt.count((Sequence)Regex.findAll$default((Regex)M_REGEX, (CharSequence)wordWithoutTrailingConsonants, (int)0, (int)2, null));
    }

    private final String replaceEnd(String $this$replaceEnd, String pattern2, String replacement, int requiredM) {
        String string2;
        if (requiredM < 0 || this.m(PorterStemmer.withoutPostfix$default(this, $this$replaceEnd, pattern2, 0, 2, null)) > requiredM) {
            CharSequence charSequence = $this$replaceEnd;
            string2 = new Regex(pattern2 + "$").replaceFirst(charSequence, replacement);
        } else {
            string2 = $this$replaceEnd;
        }
        return string2;
    }

    static /* synthetic */ String replaceEnd$default(PorterStemmer porterStemmer, String string2, String string3, String string4, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return porterStemmer.replaceEnd(string2, string3, string4, n);
    }

    private final String withoutPostfix(String $this$withoutPostfix, String postfix, int requiredM) {
        return this.withoutPostfix($this$withoutPostfix, postfix.length(), requiredM);
    }

    static /* synthetic */ String withoutPostfix$default(PorterStemmer porterStemmer, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        return porterStemmer.withoutPostfix(string2, string3, n);
    }

    private final String withoutPostfix(String $this$withoutPostfix, int postfixLength, int requiredM) {
        String string2 = $this$withoutPostfix.substring(0, $this$withoutPostfix.length() - postfixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String modifiedWord = string2;
        return requiredM < 0 || this.m(modifiedWord) > requiredM ? modifiedWord : $this$withoutPostfix;
    }

    static /* synthetic */ String withoutPostfix$default(PorterStemmer porterStemmer, String string2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = -1;
        }
        return porterStemmer.withoutPostfix(string2, n, n2);
    }

    private final boolean endsWithDoubleChars(String $this$endsWithDoubleChars) {
        return $this$endsWithDoubleChars.length() > 1 && $this$endsWithDoubleChars.charAt($this$endsWithDoubleChars.length() - 1) == $this$endsWithDoubleChars.charAt($this$endsWithDoubleChars.length() - 2);
    }

    private final boolean endsWithPattern(String $this$endsWithPattern, String pattern2) {
        return Regex.find$default((Regex)new Regex(pattern2 + "$"), (CharSequence)$this$endsWithPattern, (int)0, (int)2, null) != null;
    }

    private final boolean endsWithCvc(String $this$endsWithCvc) {
        return this.endsWithPattern($this$endsWithCvc, "(?:[bcdfghjklmnpqrstvwxz]|(?<=[aeiou])y|^y)(?:[aeiou]|(?<![aeiou])y)[bcdfghjklmnpqrstvz]");
    }

    private final boolean containsVowel(String $this$containsVowel) {
        return Regex.find$default((Regex)VOWELS_REGEX, (CharSequence)$this$containsVowel, (int)0, (int)2, null) != null;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lai/grazie/nlp/stemmer/PorterStemmer$Companion;", "", "()V", "CONSONANT", "", "CONSONANT_CVC", "M_REGEX", "Lkotlin/text/Regex;", "REDUCED_CONSONANT", "VOWEL", "VOWELS_REGEX", "load", "Lai/grazie/nlp/stemmer/PorterStemmer;", "language", "Lai/grazie/nlp/langs/Language;", "nlp-stemmer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PorterStemmer load(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            if (WhenMappings.$EnumSwitchMapping$0[language.ordinal()] != 1) {
                throw new IllegalStateException("PorterStemmer supports only English language".toString());
            }
            return new PorterStemmer();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 7, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Language.values().length];
                try {
                    nArray[Language.ENGLISH.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

