/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.repackaged.net.bytebuddy.utility.visitor;

import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.AnnotationVisitor;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.Attribute;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.ClassVisitor;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.FieldVisitor;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.MethodVisitor;
import kotlinx.coroutines.repackaged.net.bytebuddy.jar.asm.TypePath;

public abstract class MetadataAwareClassVisitor
extends ClassVisitor {
    private boolean triggerNestHost = true;
    private boolean triggerOuterClass = true;
    private boolean triggerAttributes = true;

    protected MetadataAwareClassVisitor(int api, ClassVisitor classVisitor) {
        super(api, classVisitor);
    }

    protected abstract void onNestHost();

    protected abstract void onOuterType();

    protected abstract void onAfterAttributes();

    private void considerTriggerNestHost() {
        if (this.triggerNestHost) {
            this.triggerNestHost = false;
            this.onNestHost();
        }
    }

    private void considerTriggerOuterClass() {
        if (this.triggerOuterClass) {
            this.triggerOuterClass = false;
            this.onOuterType();
        }
    }

    private void considerTriggerAfterAttributes() {
        if (this.triggerAttributes) {
            this.triggerAttributes = false;
            this.onAfterAttributes();
        }
    }

    public final void visitNestHost(String nestHost) {
        this.triggerNestHost = false;
        this.onVisitNestHost(nestHost);
    }

    protected void onVisitNestHost(String nestHost) {
        super.visitNestHost(nestHost);
    }

    public final void visitOuterClass(String owner, String name, String descriptor2) {
        this.considerTriggerNestHost();
        this.triggerOuterClass = false;
        this.onVisitOuterClass(owner, name, descriptor2);
    }

    protected void onVisitOuterClass(String owner, String name, String descriptor2) {
        super.visitOuterClass(owner, name, descriptor2);
    }

    public final AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        return this.onVisitAnnotation(descriptor2, visible);
    }

    protected AnnotationVisitor onVisitAnnotation(String descriptor2, boolean visible) {
        return super.visitAnnotation(descriptor2, visible);
    }

    public final AnnotationVisitor visitTypeAnnotation(int typeReference, TypePath typePath, String descriptor2, boolean visible) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        return this.onVisitTypeAnnotation(typeReference, typePath, descriptor2, visible);
    }

    protected AnnotationVisitor onVisitTypeAnnotation(int typeReference, TypePath typePath, String descriptor2, boolean visible) {
        return super.visitTypeAnnotation(typeReference, typePath, descriptor2, visible);
    }

    public final void visitAttribute(Attribute attribute) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.onVisitAttribute(attribute);
    }

    protected void onVisitAttribute(Attribute attribute) {
        super.visitAttribute(attribute);
    }

    public final void visitNestMember(String nestMember) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitNestMember(nestMember);
    }

    protected void onVisitNestMember(String nestMember) {
        super.visitNestMember(nestMember);
    }

    public final void visitInnerClass(String name, String outerName, String innerName, int modifiers) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitInnerClass(name, outerName, innerName, modifiers);
    }

    protected void onVisitInnerClass(String name, String outerName, String innerName, int modifiers) {
        super.visitInnerClass(name, outerName, innerName, modifiers);
    }

    public final FieldVisitor visitField(int modifiers, String internalName, String descriptor2, String signature2, Object defaultValue) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitField(modifiers, internalName, descriptor2, signature2, defaultValue);
    }

    protected FieldVisitor onVisitField(int modifiers, String internalName, String descriptor2, String signature2, Object defaultValue) {
        return super.visitField(modifiers, internalName, descriptor2, signature2, defaultValue);
    }

    public final MethodVisitor visitMethod(int modifiers, String internalName, String descriptor2, String signature2, String[] exception) {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        return this.onVisitMethod(modifiers, internalName, descriptor2, signature2, exception);
    }

    protected MethodVisitor onVisitMethod(int modifiers, String internalName, String descriptor2, String signature2, String[] exception) {
        return super.visitMethod(modifiers, internalName, descriptor2, signature2, exception);
    }

    public final void visitEnd() {
        this.considerTriggerNestHost();
        this.considerTriggerOuterClass();
        this.considerTriggerAfterAttributes();
        this.onVisitEnd();
    }

    protected void onVisitEnd() {
        super.visitEnd();
    }
}

