/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.util.Java11Shim;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.io.SimpleStringPersistentEnumerator;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ID<K, V>
extends IndexId<K, V> {
    private static final Logger LOG = Logger.getInstance(ID.class);
    private static final PluginId CORE_PLUGIN_ID = PluginId.getId((String)"com.intellij");
    private static volatile SimpleStringPersistentEnumerator nameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
    private static final Map<String, ID<?, ?>> idObjects = new ConcurrentHashMap();
    private static final Object lock = new Object();
    private static volatile Map<@NotNull ID<?, ?>, @NotNull PluginId> idToPluginId = Java11Shim.INSTANCE.mapOf();
    private static volatile Map<@NotNull ID<?, ?>, @NotNull Throwable> idToRegistrationStackTrace = Java11Shim.INSTANCE.mapOf();
    static final int MAX_NUMBER_OF_INDICES = Short.MAX_VALUE;
    private volatile int uniqueId;

    @ApiStatus.Internal
    @NotNull
    private static Path getEnumFile() {
        Path path = PathManager.getIndexRoot().resolve("indices.enum");
        if (path == null) {
            ID.$$$reportNull$$$0(0);
        }
        return path;
    }

    @ApiStatus.Internal
    public static void reloadEnumFile() {
        ID.reloadEnumFile(ID.getEnumFile());
    }

    private static void reloadEnumFile(@NotNull Path enumFile) {
        if (enumFile == null) {
            ID.$$$reportNull$$$0(1);
        }
        if (Files.exists(enumFile, new LinkOption[0]) && enumFile.equals(nameToIdRegistry.getFile())) {
            return;
        }
        SimpleStringPersistentEnumerator newNameToIdRegistry = new SimpleStringPersistentEnumerator(ID.getEnumFile());
        Map<String, Integer> newInvertedState = newNameToIdRegistry.getInvertedState();
        Map<String, Integer> oldInvertedState = nameToIdRegistry.getInvertedState();
        oldInvertedState.forEach((oldKey, oldId) -> {
            Integer newId = (Integer)newInvertedState.get(oldKey);
            if (newId == null) {
                int createdId = newNameToIdRegistry.enumerate((String)oldKey);
                if (createdId != oldId) {
                    ID.reassign(oldKey, createdId);
                }
            } else if (oldId.intValue() != newId.intValue()) {
                ID.reassign(oldKey, newId);
            }
        });
        nameToIdRegistry = newNameToIdRegistry;
    }

    private static void reassign(String name, int newId) {
        ID<?, ?> id = idObjects.get(name);
        if (id != null) {
            id.uniqueId = newId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    protected ID(@NotNull String name, @Nullable PluginId pluginId) {
        if (name == null) {
            ID.$$$reportNull$$$0(2);
        }
        super(name);
        this.uniqueId = ID.stringToId(name);
        ID old = idObjects.put(name, this);
        assert (old == null) : "ID with name '" + name + "' is already registered";
        Object object = lock;
        synchronized (object) {
            PluginId oldPluginId = idToPluginId.get(this);
            assert (oldPluginId == null) : "ID with name '" + name + "' is already registered in " + oldPluginId + " but current caller is " + pluginId;
            idToPluginId = UtilKt.with(idToPluginId, this, pluginId == null ? CORE_PLUGIN_ID : pluginId);
            idToRegistrationStackTrace = UtilKt.with(idToRegistrationStackTrace, this, new Throwable());
        }
    }

    private static int stringToId(@NotNull String name) {
        int id;
        if (name == null) {
            ID.$$$reportNull$$$0(3);
        }
        if ((id = nameToIdRegistry.enumerate(name)) != (short)id) {
            throw new AssertionError((Object)"Too many indexes registered");
        }
        return id;
    }

    static void reinitializeDiskStorage() {
        nameToIdRegistry.forceDiskSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(4);
        }
        PluginId pluginId = ID.getCallerPluginId();
        Object object = lock;
        // MONITORENTER : object
        ID<K, V> found = ID.findByName(name, true, pluginId);
        ID<K, V> iD = found == null ? new ID<K, V>(name, pluginId) : found;
        // MONITOREXIT : object
        if (iD != null) return iD;
        ID.$$$reportNull$$$0(5);
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(6);
        }
        return ID.findByName(name, false, null);
    }

    @ApiStatus.Internal
    @Nullable
    protected static <K, V> ID<K, V> findByName(@NotNull String name, boolean checkCallerPlugin, @Nullable PluginId requiredPluginId) {
        if (name == null) {
            ID.$$$reportNull$$$0(7);
        }
        ID<?, ?> id = ID.findById(ID.stringToId(name));
        if (checkCallerPlugin && id != null) {
            String requiredPluginIdStr;
            PluginId actualPluginId = idToPluginId.get(id);
            String actualPluginIdStr = actualPluginId == null ? "" : actualPluginId.getIdString();
            String string2 = requiredPluginIdStr = requiredPluginId == null ? "" : requiredPluginId.getIdString();
            if (!Objects.equals(actualPluginIdStr, requiredPluginIdStr)) {
                Throwable registrationStackTrace = idToRegistrationStackTrace.get(id);
                String message = ID.getInvalidIdAccessMessage(name, actualPluginIdStr, requiredPluginIdStr, registrationStackTrace);
                if (registrationStackTrace == null) {
                    throw new AssertionError((Object)message);
                }
                throw new AssertionError(message, registrationStackTrace);
            }
        }
        return id;
    }

    @NotNull
    private static String getInvalidIdAccessMessage(@NotNull String name, @Nullable String actualPluginIdStr, @Nullable String requiredPluginIdStr, @Nullable Throwable registrationStackTrace) {
        if (name == null) {
            ID.$$$reportNull$$$0(8);
        }
        String string2 = "ID with name '" + name + "' requested for plugin " + requiredPluginIdStr + " but registered for " + actualPluginIdStr + " plugin. Please use an instance field to access corresponding ID." + (registrationStackTrace == null ? " Registration stack trace: " : "");
        if (string2 == null) {
            ID.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @ApiStatus.Internal
    public static Collection<ID<?, ?>> getRegisteredIds() {
        return idToPluginId.keySet();
    }

    @ApiStatus.Internal
    @NotNull
    public Throwable getRegistrationTrace() {
        Throwable throwable = idToRegistrationStackTrace.get(this);
        if (throwable == null) {
            ID.$$$reportNull$$$0(10);
        }
        return throwable;
    }

    @ApiStatus.Internal
    public int getUniqueId() {
        return this.uniqueId;
    }

    @ApiStatus.Internal
    @Nullable
    public PluginId getPluginId() {
        return idToPluginId.get(this);
    }

    @ApiStatus.Internal
    public static ID<?, ?> findById(int id) {
        String key = nameToIdRegistry.valueOf(id);
        return key == null ? null : idObjects.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void unloadId(@NotNull ID<?, ?> id) {
        if (id == null) {
            ID.$$$reportNull$$$0(11);
        }
        String name = id.getName();
        Object object = lock;
        synchronized (object) {
            ID<?, ?> oldID = idObjects.remove(name);
            LOG.assertTrue(id.equals(oldID), "Failed to unload: " + name);
            idToPluginId = UtilKt.without(idToPluginId, id);
            idToRegistrationStackTrace = UtilKt.without(idToRegistrationStackTrace, id);
        }
    }

    @ApiStatus.Internal
    @Nullable
    protected static PluginId getCallerPluginId() {
        Class<?> aClass = Java11Shim.INSTANCE.getCallerClass(3);
        if (aClass == null) {
            return null;
        }
        ClassLoader loader = aClass.getClassLoader();
        if (!(loader instanceof PluginAwareClassLoader)) {
            return null;
        }
        return ((PluginAwareClassLoader)loader).getPluginId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/ID";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/ID";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIdAccessMessage";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegistrationTrace";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reloadEnumFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stringToId";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidIdAccessMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unloadId";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

