/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import it.unimi.dsi.fastutil.Hash;

final class FastUtilCharSequenceHashingStrategy
implements Hash.Strategy<CharSequence> {
    private final boolean isCaseSensitive;

    FastUtilCharSequenceHashingStrategy(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    @Override
    public int hashCode(CharSequence o2) {
        if (o2 == null) {
            return 0;
        }
        return this.isCaseSensitive ? Strings.stringHashCode(o2) : Strings.stringHashCodeInsensitive(o2);
    }

    @Override
    public boolean equals(CharSequence s1, CharSequence s2) {
        return StringUtilRt.equal((CharSequence)s1, (CharSequence)s2, (boolean)this.isCaseSensitive);
    }
}

