/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.BuildNumber;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRange {
    private final BuildNumber since;
    private final BuildNumber until;

    public BuildRange(@NotNull BuildNumber since, @NotNull BuildNumber until) {
        if (since == null) {
            BuildRange.$$$reportNull$$$0(0);
        }
        if (until == null) {
            BuildRange.$$$reportNull$$$0(1);
        }
        this.since = since;
        this.until = until;
        if (since.compareTo(until) > 0) {
            throw new IllegalArgumentException("Invalid range: [" + since + "; " + until + "]");
        }
    }

    public boolean inRange(@NotNull BuildNumber build) {
        if (build == null) {
            BuildRange.$$$reportNull$$$0(2);
        }
        return this.since.compareTo(build) <= 0 && build.compareTo(this.until) <= 0;
    }

    @Contract(value="null, _ -> null; _, null -> null")
    public static BuildRange fromStrings(@Nullable String sinceVal, @Nullable String untilVal) {
        BuildNumber since = BuildNumber.fromString(sinceVal);
        BuildNumber until = BuildNumber.fromString(untilVal);
        return since != null && until != null ? new BuildRange(since, until) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "since";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "until";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/BuildRange";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "inRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

