/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.events.EventField;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rH&J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "", "eventId", "", "(Ljava/lang/String;)V", "recorder", "description", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getEventId", "getRecorder", "getFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getLogger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getLogger$intellij_platform_statistics", "intellij.platform.statistics"})
public abstract class BaseEventId {
    @NotNull
    private final String eventId;
    @NotNull
    private final String recorder;
    @Nullable
    private final String description;

    public BaseEventId(@NotNull String eventId, @NotNull String recorder, @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        this.eventId = eventId;
        this.recorder = recorder;
        this.description = description;
    }

    @NotNull
    public final String getEventId() {
        return this.eventId;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Deprecated(message="Recorder ID should be explicitly provided", replaceWith=@ReplaceWith(expression="BaseEventId(eventId, recorder)", imports={}))
    public BaseEventId(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this(eventId, "FUS", null);
    }

    @NotNull
    public final StatisticsEventLogger getLogger$intellij_platform_statistics() {
        return StatisticsEventLogProviderUtil.getEventLogProvider(this.recorder).getLogger();
    }

    @NotNull
    public abstract List<EventField<?>> getFields();
}

