/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser;

import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.parser.HtmlEntities;

class HtmlHandler {
    private StringBuffer buffer = new StringBuffer();

    HtmlHandler() {
    }

    public String stripHtml(String s) {
        String inner2 = HtmlHandler.getSubstringUnderHtmlTag(s);
        return (inner2 == null ? s : this.removeHtmlInfo(inner2)).trim();
    }

    private String removeHtmlInfo(String inner2) {
        boolean inTag = false;
        boolean inQuoteInTag = false;
        char quoteChar = '\"';
        int entityPos = -1;
        this.buffer.delete(0, this.buffer.length());
        for (char c : inner2.toCharArray()) {
            int entityValue;
            int len;
            if (c == '<') {
                inTag = true;
                entityPos = -1;
                continue;
            }
            if (c == '>') {
                inTag = inTag && inQuoteInTag;
                continue;
            }
            if (inTag) {
                if (c != '\"' && c != '\'') continue;
                if (inQuoteInTag) {
                    inQuoteInTag = quoteChar != c;
                    continue;
                }
                inQuoteInTag = true;
                quoteChar = c;
                continue;
            }
            if (c == '&') {
                entityPos = this.buffer.length();
            } else if (c == ';' && entityPos != -1 && (len = this.buffer.length()) > entityPos + 2 && (entityValue = this.getEntityValue(entityPos + 1)) > 0 && entityValue < 65536) {
                this.buffer.delete(entityPos, len);
                c = (char)entityValue;
            }
            this.buffer.append(c);
        }
        return this.buffer.toString();
    }

    private int getEntityValue(int start2) {
        if (this.buffer.charAt(start2) == '#') {
            char hex = this.buffer.charAt(start2);
            try {
                if (hex == 'x' || hex == 'X') {
                    return Integer.valueOf(this.buffer.substring(start2 + 2), 16);
                }
                return Integer.parseInt(this.buffer.substring(start2 + 1));
            }
            catch (NumberFormatException nfe) {
                return -1;
            }
        }
        return HtmlEntities.getEntityValue(this.buffer.substring(start2));
    }

    private static String getSubstringUnderHtmlTag(String s) {
        int l2 = s.length();
        if (!(l2 < 6 || s.charAt(0) != '<' || s.charAt(5) != '>' || s.charAt(1) != 'h' && s.charAt(1) != 'H' || s.charAt(2) != 't' && s.charAt(2) != 'T' || s.charAt(3) != 'm' && s.charAt(3) != 'M' || s.charAt(4) != 'l' && s.charAt(4) != 'L')) {
            if (!(l2 < 13 || s.charAt(l2 - 1) != '>' || s.charAt(l2 - 7) != '<' || s.charAt(l2 - 6) != '/' || s.charAt(l2 - 5) != 'h' && s.charAt(l2 - 5) != 'H' || s.charAt(l2 - 4) != 't' && s.charAt(l2 - 4) != 'T' || s.charAt(l2 - 3) != 'm' && s.charAt(l2 - 3) != 'M' || s.charAt(l2 - 2) != 'l' && s.charAt(l2 - 2) != 'L')) {
                l2 -= 7;
            }
            return s.substring(6, l2);
        }
        return null;
    }
}

