/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.ChoiceRenderer;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.CustomChoice;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.table.filters.gui.IFilterEditor;

class FilterListCellRenderer
extends JComponent
implements ListCellRenderer {
    private static final long serialVersionUID = 6736940091246039334L;
    private static final int X_MARGIN_ARROW = 1;
    private static final int WIDTH_ARROW = 5;
    private static final int HEIGHT_ARROW = 6;
    private static final int[] X = new int[]{0, 5, 0};
    private static final int[] Y = new int[]{0, 3, 6};
    private final CellRendererPane painter = new CellRendererPane();
    private final JList referenceList;
    private Component inner;
    private Color arrowColor;
    private boolean showArrow;
    private boolean focusOnList;
    private int xDeltaBase;
    private int width;
    IFilterEditor editor;
    ChoiceRenderer renderer;
    private final ListCellRenderer defaultRenderer;

    public FilterListCellRenderer(IFilterEditor editor, JList mainList) {
        this.setUserRenderer(null);
        this.setDoubleBuffered(true);
        this.editor = editor;
        this.referenceList = mainList;
        this.defaultRenderer = new DefaultRenderer(mainList);
    }

    public void setFocusOnList(boolean set) {
        this.focusOnList = set;
    }

    public boolean isFocusOnList() {
        return this.focusOnList;
    }

    public void setUserRenderer(ChoiceRenderer cellRenderer) {
        this.renderer = cellRenderer;
    }

    public ChoiceRenderer getUserRenderer() {
        return this.renderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setupRenderer(list, value, index, this.focusOnList && isSelected, cellHasFocus);
        this.width = this.referenceList.isShowing() ? this.referenceList.getWidth() : list.getWidth();
        this.showArrow = isSelected;
        this.arrowColor = list.getSelectionBackground();
        this.xDeltaBase = 7;
        return this;
    }

    public Component getCellRendererComponent(Object value, int finalWidth, boolean focused) {
        this.setupRenderer(this.referenceList, value, -1, focused, false);
        this.width = finalWidth;
        this.showArrow = false;
        this.xDeltaBase = 0;
        return this;
    }

    private void setupRenderer(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
        this.inner = null;
        if (this.renderer != null) {
            try {
                this.inner = this.renderer.getRendererComponent(this.editor, value, selected);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.inner == null) {
            this.inner = this.defaultRenderer.getListCellRendererComponent(list, value, index, selected, cellHasFocus);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height = this.getHeight();
        int xDelta = this.xDeltaBase;
        int yDelta = 0;
        if (this.showArrow) {
            Object old = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            yDelta = height / 2 + 1 - 3;
            --xDelta;
            g.translate(1, yDelta);
            g.setColor(this.arrowColor);
            g.fillPolygon(X, Y, X.length);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
        g.translate(xDelta, -yDelta);
        boolean resetEnabled = this.inner.isEnabled();
        this.inner.setEnabled(this.isEnabled());
        this.painter.paintComponent(g, this.inner, this, 0, 0, this.width - this.xDeltaBase, height);
        this.inner.setEnabled(resetEnabled);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.inner.getPreferredSize();
    }

    @Override
    public boolean isShowing() {
        return true;
    }

    private static class DefaultRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 5837846455371777058L;
        CustomChoice currentCustomChoice;
        boolean isSelected;

        public DefaultRenderer(JList referenceList) {
            this.setOpaque(false);
            this.setComponentOrientation(referenceList.getComponentOrientation());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.isSelected = isSelected;
            this.currentCustomChoice = value instanceof CustomChoice ? (CustomChoice)value : null;
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

