/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.DataFrame;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Column;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleArrayColumn;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleColumn;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntArrayColumn;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntColumn;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.StringArrayColumn;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.StringColumn;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.StringType;
import org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u001e\u0010\u0002\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004`\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u0015\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\u0012\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0014H\u0016R&\u0010\u0002\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameImpl;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrame;", "columns", "Ljava/util/ArrayList;", "Lorg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/columns/Column;", "Lkotlin/collections/ArrayList;", "(Ljava/util/ArrayList;)V", "dim", "Ljava/awt/Dimension;", "getDim", "()Ljava/awt/Dimension;", "get", "columnIndex", "", "columnName", "", "getColumns", "", "groupBy", "has", "", "sortBy", "", "sortDescending", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nDataFrameImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameImpl.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n1#2:173\n1855#3,2:174\n1855#3,2:176\n1855#3,2:178\n215#4,2:180\n215#4,2:182\n215#4,2:184\n*S KotlinDebug\n*F\n+ 1 DataFrameImpl.kt\norg/jetbrains/plugins/notebooks/visualization/r/inlays/dataframe/DataFrameImpl\n*L\n46#1:174,2\n52#1:176,2\n58#1:178,2\n105#1:180,2\n111#1:182,2\n117#1:184,2\n*E\n"})
public final class DataFrameImpl
extends DataFrame {
    @NotNull
    private final ArrayList<Column<?>> columns;

    public DataFrameImpl(@NotNull ArrayList<Column<?>> columns) {
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        this.columns = columns;
    }

    @Override
    @NotNull
    public Dimension getDim() {
        return new Dimension(this.columns.size(), this.columns.get(0).getSize());
    }

    @Override
    @NotNull
    public List<Column<?>> getColumns() {
        return this.columns;
    }

    @Override
    @NotNull
    public Column<?> get(@NotNull String columnName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    @Override
    @NotNull
    public Column<?> get(int columnIndex) {
        Column<?> column = this.columns.get(columnIndex);
        Intrinsics.checkNotNullExpressionValue(column, (String)"get(...)");
        return column;
    }

    @Override
    public boolean has(@NotNull String columnName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    @Override
    public void sortBy(@NotNull String columnName, boolean sortDescending) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Column<?> sortingColumn = this.get(columnName);
        int n = 0;
        int n2 = this.columns.get(0).getSize();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3;
            nArray[n3] = n3 = n++;
        }
        int[] indices = nArray;
        List sortedIndices = ArraysKt.sortedWith((int[])indices, sortingColumn.getComparator(sortDescending));
        int n4 = this.columns.size();
        for (int i = 0; i < n4; ++i) {
            int it;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            ArrayList<Integer> data2;
            Type<?> type = this.columns.get(i).getType();
            if (type instanceof IntType) {
                Column<?> column = this.columns.get(i);
                Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntColumn");
                IntColumn intColumn = (IntColumn)column;
                data2 = new ArrayList<Integer>(intColumn.getSize());
                $this$forEach$iv = sortedIndices;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    data2.add((Integer)intColumn.get(it));
                }
                this.columns.set(i, new IntColumn(this.columns.get(i).getName(), data2));
                continue;
            }
            if (type instanceof DoubleType) {
                Column<?> column = this.columns.get(i);
                Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleColumn");
                DoubleColumn doubleColumn = (DoubleColumn)column;
                data2 = new ArrayList(doubleColumn.getSize());
                $this$forEach$iv = sortedIndices;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    data2.add((Integer)doubleColumn.get(it));
                }
                this.columns.set(i, new DoubleColumn(this.columns.get(i).getName(), (ArrayList<Double>)data2));
                continue;
            }
            if (type instanceof StringType) {
                Column<?> column = this.columns.get(i);
                Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.StringColumn");
                StringColumn stringColumn = (StringColumn)column;
                data2 = new ArrayList(stringColumn.getSize());
                $this$forEach$iv = sortedIndices;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = ((Number)element$iv).intValue();
                    boolean bl = false;
                    data2.add((Integer)stringColumn.get(it));
                }
                this.columns.set(i, new StringColumn(this.columns.get(i).getName(), (ArrayList<String>)data2));
                continue;
            }
            throw new Exception("Unsupported column type " + this.columns.get(i).getType() + " in sorting.");
        }
    }

    @Override
    @NotNull
    public DataFrame groupBy(@NotNull String columnName) {
        Object v0;
        block28: {
            Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
            Iterable iterable = this.columns;
            for (Object t : iterable) {
                Column column = (Column)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) continue;
                v0 = t;
                break block28;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        Column groupingColumn = v0;
        if (groupingColumn.getType().isArray()) {
            throw new Exception("Currently cannot group on array-type columns");
        }
        HashMap alreadyProcessed = new HashMap();
        int[] indexes = new int[groupingColumn.getSize()];
        Iterator iterator2 = groupingColumn.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Object value = iterator2.next();
            Integer pos = (Integer)alreadyProcessed.get(value);
            if (pos == null) {
                pos = alreadyProcessed.size();
                ((Map)alreadyProcessed).put(value, pos);
            }
            indexes[i] = pos;
        }
        int newColumnsSize = alreadyProcessed.size();
        ArrayList newColumns = new ArrayList();
        for (Column<?> column : this.columns) {
            Column column2;
            Column newColumn;
            Object newData;
            Type<?> type;
            if (Intrinsics.areEqual((Object)column.getName(), (Object)columnName)) {
                Column column3;
                type = column.getType();
                if (type instanceof IntType) {
                    newData = new int[newColumnsSize];
                    $this$forEach$iv2 = alreadyProcessed;
                    $i$f$forEach2 = false;
                    Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv;
                        var16_36 = element$iv = iterator3.next();
                        boolean bl = false;
                        key = var16_36.getKey();
                        value = ((Number)var16_36.getValue()).intValue();
                        Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type kotlin.Int");
                        newData[value] = (Integer)key;
                    }
                    column3 = new IntColumn(column.getName(), (ArrayList)ArraysKt.toCollection((int[])newData, (Collection)new ArrayList()));
                } else if (type instanceof DoubleType) {
                    newData = new double[newColumnsSize];
                    $this$forEach$iv2 = alreadyProcessed;
                    $i$f$forEach2 = false;
                    for (Map.Entry element$iv : $this$forEach$iv2.entrySet()) {
                        var16_36 = element$iv;
                        boolean bl = false;
                        key = var16_36.getKey();
                        value = ((Number)var16_36.getValue()).intValue();
                        Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type kotlin.Double");
                        newData[value] = (Double)key;
                    }
                    column3 = new DoubleColumn(column.getName(), (ArrayList)ArraysKt.toCollection((double[])newData, (Collection)new ArrayList()));
                } else if (type instanceof StringType) {
                    int $this$forEach$iv = 0;
                    String[] $i$f$forEach = new String[newColumnsSize];
                    while ($this$forEach$iv < newColumnsSize) {
                        int n2 = $this$forEach$iv++;
                        $i$f$forEach[n2] = "";
                    }
                    newData = $i$f$forEach;
                    $this$forEach$iv2 = alreadyProcessed;
                    $i$f$forEach2 = false;
                    for (Map.Entry element$iv : $this$forEach$iv2.entrySet()) {
                        var16_36 = element$iv;
                        boolean bl = false;
                        key = var16_36.getKey();
                        value = ((Number)var16_36.getValue()).intValue();
                        Intrinsics.checkNotNull(key, (String)"null cannot be cast to non-null type kotlin.String");
                        newData[value] = key;
                    }
                    column3 = new StringColumn(column.getName(), (ArrayList)ArraysKt.toCollection((Object[])newData, (Collection)new ArrayList()));
                } else {
                    throw new Exception("Unsupported column type " + column.getType() + " in grouping.");
                }
                newColumn = column3;
                newColumns.add(newColumn);
                continue;
            }
            type = column.getType();
            if (type instanceof IntType) {
                newData = new ArrayList(newColumnsSize);
                for (int i = 0; i < newColumnsSize; ++i) {
                    ((ArrayList)newData).add(new ArrayList());
                }
                Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.IntColumn");
                i = ((IntColumn)column).iterator();
                var13_23 = 0;
                while (i.hasNext()) {
                    int i = var13_23++;
                    int value = i.next().intValue();
                    ((ArrayList)((ArrayList)newData).get(indexes[i])).add(value);
                }
                column2 = new IntArrayColumn(column.getName(), (ArrayList<ArrayList<Integer>>)newData);
            } else if (type instanceof DoubleType) {
                newData = new ArrayList(newColumnsSize);
                for (int i = 0; i < newColumnsSize; ++i) {
                    ((ArrayList)newData).add(new ArrayList());
                }
                Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.DoubleColumn");
                i = ((DoubleColumn)column).iterator();
                var13_23 = 0;
                while (i.hasNext()) {
                    int i = var13_23++;
                    double value = i.next().doubleValue();
                    ((ArrayList)((ArrayList)newData).get(indexes[i])).add(value);
                }
                column2 = new DoubleArrayColumn(column.getName(), (ArrayList<ArrayList<Double>>)newData);
            } else if (type instanceof StringType) {
                newData = new ArrayList(newColumnsSize);
                for (int i = 0; i < newColumnsSize; ++i) {
                    ((ArrayList)newData).add(new ArrayList());
                }
                Intrinsics.checkNotNull(column, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.visualization.r.inlays.dataframe.columns.StringColumn");
                Iterator<String> iterator4 = ((StringColumn)column).iterator();
                var13_23 = 0;
                while (iterator4.hasNext()) {
                    int i = var13_23++;
                    String value = iterator4.next();
                    ((ArrayList)((ArrayList)newData).get(indexes[i])).add(value);
                }
                column2 = new StringArrayColumn(column.getName(), (ArrayList<ArrayList<String>>)newData);
            } else {
                throw new Exception("Unsupported column type " + column.getType() + " in grouping.");
            }
            newColumn = column2;
            newColumns.add(newColumn);
        }
        return new DataFrameImpl(newColumns);
    }
}

