/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization.r.inlays.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"convertHSLtoRGB", "", "hslFloats", "", "alpha", "", "convertRGBtoHSL", "", "rgb", "result", "hueToRGB", "p", "q", "h", "intellij.notebooks.visualization"})
public final class HSLUtilKt {
    public static final void convertRGBtoHSL(@NotNull float[] rgb, @NotNull float[] result2) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float min2 = Math.min(r, Math.min(g, b));
        float max2 = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max2 == min2) {
            h = 0.0f;
        } else if (max2 == r) {
            h = ((float)60 * (g - b) / (max2 - min2) + (float)360) % (float)360;
        } else if (max2 == g) {
            h = (float)60 * (b - r) / (max2 - min2) + (float)120;
        } else if (max2 == b) {
            h = (float)60 * (r - g) / (max2 - min2) + (float)240;
        }
        float l2 = (max2 + min2) / (float)2;
        float s = 0.0f;
        s = max2 == min2 ? 0.0f : (l2 <= 0.5f ? (max2 - min2) / (max2 + min2) : (max2 - min2) / ((float)2 - max2 - min2));
        result2[0] = h;
        result2[1] = s * (float)100;
        result2[2] = l2 * (float)100;
    }

    public static final int convertHSLtoRGB(@NotNull float[] hslFloats, float alpha2) {
        Intrinsics.checkNotNullParameter((Object)hslFloats, (String)"hslFloats");
        float h = hslFloats[0];
        float s = hslFloats[1];
        float l2 = hslFloats[2];
        if (s < 0.0f || s > 100.0f) {
            String message = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(message);
        }
        if (l2 < 0.0f || l2 > 100.0f) {
            String message = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(message);
        }
        if (alpha2 < 0.0f || alpha2 > 1.0f) {
            String message = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(message);
        }
        h %= 360.0f;
        float q = 0.0f;
        q = (double)l2 < 0.5 ? l2 * (1.0f + s) : (l2 /= 100.0f) + (s /= 100.0f) - s * l2;
        float p = (float)2 * l2 - q;
        float r = Math.max(0.0f, HSLUtilKt.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, HSLUtilKt.hueToRGB(p, q, h));
        float b = Math.max(0.0f, HSLUtilKt.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return ((int)(alpha2 * (float)255) << 24) + ((int)(r * (float)255) << 16) + ((int)(g * (float)255) << 8) + (int)(b * (float)255);
    }

    private static final float hueToRGB(float p, float q, float h) {
        float h2 = h;
        if (h2 < 0.0f) {
            h2 += 1.0f;
        }
        if (h2 > 1.0f) {
            h2 -= 1.0f;
        }
        if ((float)6 * h2 < 1.0f) {
            return p + (q - p) * (float)6 * h2;
        }
        if ((float)2 * h2 < 1.0f) {
            return q;
        }
        return (float)3 * h2 < 2.0f ? p + (q - p) * (float)6 * (0.6666667f - h2) : p;
    }
}

