/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.notebooks.visualization;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBus;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointer;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerConcurrentMap;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointerFactory;
import org.jetbrains.plugins.notebooks.visualization.NotebookIntervalPointersEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u000eH\u0086\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0018\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001aJ\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010 R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR4\u0010\u000b\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000 \u000f*\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerConcurrentMap;", "Value", "Lcom/intellij/openapi/util/CheckedDisposable;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/util/messages/MessageBus;Lcom/intellij/openapi/Disposable;)V", "factoryListener", "org/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerConcurrentMap$factoryListener$1", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointerConcurrentMap$factoryListener$1;", "mapReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;", "kotlin.jvm.PlatformType", "dispose", "", "get", "cellPointer", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;)Ljava/lang/Object;", "isDisposed", "", "remove", "removeAll", "cellPointers", "", "removePointers", "removed", "Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointersEvent$OnRemoved;", "set", "value", "(Lorg/jetbrains/plugins/notebooks/visualization/NotebookIntervalPointer;Ljava/lang/Object;)V", "intellij.notebooks.visualization"})
public final class NotebookIntervalPointerConcurrentMap<Value>
implements CheckedDisposable {
    @NotNull
    private final AtomicReference<ConcurrentHashMap<NotebookIntervalPointer, Value>> mapReference;
    @NotNull
    private final factoryListener.1<Value> factoryListener;

    public NotebookIntervalPointerConcurrentMap(@NotNull MessageBus messageBus, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)messageBus, (String)"messageBus");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.mapReference = new AtomicReference(new ConcurrentHashMap());
        this.factoryListener = new NotebookIntervalPointerFactory.ChangeListener(this){
            final /* synthetic */ NotebookIntervalPointerConcurrentMap<Value> this$0;
            {
                this.this$0 = $receiver;
            }

            public void onUpdated(@NotNull NotebookIntervalPointersEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                for (NotebookIntervalPointersEvent.Change change : event.getChanges()) {
                    NotebookIntervalPointersEvent.Change change2 = change;
                    if (change2 instanceof NotebookIntervalPointersEvent.OnRemoved) {
                        NotebookIntervalPointerConcurrentMap.access$removePointers(this.this$0, (NotebookIntervalPointersEvent.OnRemoved)change);
                        continue;
                    }
                    if (change2 instanceof NotebookIntervalPointersEvent.OnEdited || change2 instanceof NotebookIntervalPointersEvent.OnInserted || !(change2 instanceof NotebookIntervalPointersEvent.OnSwapped)) continue;
                }
            }
        };
        messageBus.connect(parent).subscribe(NotebookIntervalPointerFactory.ChangeListener.Companion.getTOPIC(), this.factoryListener);
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
    }

    private final void removePointers(NotebookIntervalPointersEvent.OnRemoved removed) {
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        if (concurrentHashMap == null) {
            return;
        }
        ConcurrentHashMap<NotebookIntervalPointer, Value> map2 = concurrentHashMap;
        for (NotebookIntervalPointersEvent.PointerSnapshot p : removed.getSubsequentPointers()) {
            map2.remove(p.getPointer());
        }
    }

    @Nullable
    public final Value get(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        return (Value)(concurrentHashMap != null ? concurrentHashMap.get(cellPointer) : null);
    }

    public final void set(@NotNull NotebookIntervalPointer cellPointer, Value value) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
            if (cellPointer.get() == null) {
                return;
            }
            ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
            if (concurrentHashMap != null) {
                ((Map)concurrentHashMap).put(cellPointer, value);
            }
            if (cellPointer.get() != null) break block3;
            ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap2 = this.mapReference.get();
            if (concurrentHashMap2 != null) {
                concurrentHashMap2.remove(cellPointer);
            }
        }
    }

    @Nullable
    public final Value remove(@NotNull NotebookIntervalPointer cellPointer) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        ConcurrentHashMap<NotebookIntervalPointer, Value> concurrentHashMap = this.mapReference.get();
        return (Value)(concurrentHashMap != null ? concurrentHashMap.remove(cellPointer) : null);
    }

    public final boolean removeAll(@NotNull Collection<? extends NotebookIntervalPointer> cellPointers) {
        Intrinsics.checkNotNullParameter(cellPointers, (String)"cellPointers");
        Serializable serializable = this.mapReference.get();
        return serializable != null && (serializable = (ConcurrentHashMap.KeySetView)((ConcurrentHashMap)serializable).keySet()) != null ? ((ConcurrentHashMap.KeySetView)serializable).removeAll((Collection)cellPointers) : false;
    }

    public void dispose() {
        this.mapReference.set(null);
    }

    public boolean isDisposed() {
        return this.mapReference.get() == null;
    }

    public static final /* synthetic */ void access$removePointers(NotebookIntervalPointerConcurrentMap $this, NotebookIntervalPointersEvent.OnRemoved removed) {
        $this.removePointers(removed);
    }
}

