/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.util.concurrent.atomic.AtomicLong;
import org.h2.mvstore.type.DataType;

public final class MemoryEstimator {
    private static final int SKIP_SUM_SHIFT = 8;
    private static final int COUNTER_MASK = 255;
    private static final int SKIP_SUM_MASK = 65535;
    private static final int INIT_BIT_SHIFT = 24;
    private static final int INIT_BIT = 0x1000000;
    private static final int WINDOW_SHIFT = 8;
    private static final int MAGNITUDE_LIMIT = 7;
    private static final int WINDOW_SIZE = 256;
    private static final int WINDOW_HALF_SIZE = 128;
    private static final int SUM_SHIFT = 32;

    private MemoryEstimator() {
    }

    public static <T> int estimateMemory(AtomicLong atomicLong, DataType<T> dataType, T t) {
        long l2;
        long l3 = atomicLong.get();
        int n = MemoryEstimator.getCounter(l3);
        int n2 = MemoryEstimator.getSkipSum(l3);
        long l4 = l3 & 0x1000000L;
        long l5 = l3 >>> 32;
        int n3 = 0;
        int n4 = 0;
        if (l4 == 0L || n-- == 0) {
            n4 = 1;
            n3 = t == null ? 0 : dataType.getMemory(t);
            l2 = ((long)n3 << 8) - l5;
            if (l4 == 0L) {
                if (++n == 256) {
                    l4 = 0x1000000L;
                }
                l5 = (l5 * (long)n + l2 + (long)(n >> 1)) / (long)n;
            } else {
                long l6 = l2 >= 0L ? l2 : -l2;
                int n5 = MemoryEstimator.calculateMagnitude(l5, l6);
                l5 += (l2 >> 7 - n5) + 1L >> 1;
                n = (1 << n5) - 1 & 0xFF;
                l2 = (n << 8) - n2;
                n2 = (int)((long)n2 + (l2 + 128L >> 8));
            }
        }
        l2 = MemoryEstimator.updateStatsData(atomicLong, l3, n, n2, l4, l5, n4, n3);
        return MemoryEstimator.getAverage(l2);
    }

    public static <T> int estimateMemory(AtomicLong atomicLong, DataType<T> dataType, T[] TArray, int n) {
        long l2 = atomicLong.get();
        int n2 = MemoryEstimator.getCounter(l2);
        int n3 = MemoryEstimator.getSkipSum(l2);
        long l3 = l2 & 0x1000000L;
        long l4 = l2 >>> 32;
        int n4 = 0;
        int n5 = 0;
        if (l3 != 0L && n2 >= n) {
            n2 -= n;
        } else {
            int n6 = n;
            while (n6-- > 0) {
                T t;
                int n7 = (t = TArray[n4++]) == null ? 0 : dataType.getMemory(t);
                n5 += n7;
                long l5 = ((long)n7 << 8) - l4;
                if (l3 == 0L) {
                    if (++n2 == 256) {
                        l3 = 0x1000000L;
                    }
                    l4 = (l4 * (long)n2 + l5 + (long)(n2 >> 1)) / (long)n2;
                    continue;
                }
                n6 -= n2;
                long l6 = l5 >= 0L ? l5 : -l5;
                int n8 = MemoryEstimator.calculateMagnitude(l4, l6);
                l4 += (l5 >> 7 - n8) + 1L >> 1;
                l5 = ((long)(n2 += (1 << n8) - 1 & 0xFF) << 8) - (long)n3;
                n3 = (int)((long)n3 + (l5 + 128L >> 8));
            }
        }
        long l7 = MemoryEstimator.updateStatsData(atomicLong, l2, n2, n3, l3, l4, n4, n5);
        return (MemoryEstimator.getAverage(l7) + 8) * n;
    }

    public static int samplingPct(AtomicLong atomicLong) {
        long l2 = atomicLong.get();
        int n = (l2 & 0x1000000L) == 0L ? MemoryEstimator.getCounter(l2) : 256;
        int n2 = MemoryEstimator.getSkipSum(l2) + n;
        return (n * 100 + (n2 >> 1)) / n2;
    }

    private static int calculateMagnitude(long l2, long l3) {
        int n;
        for (n = 0; l3 < l2 && n < 7; ++n, l3 <<= 1) {
        }
        return n;
    }

    private static long updateStatsData(AtomicLong atomicLong, long l2, int n, int n2, long l3, long l4, int n3, int n4) {
        return MemoryEstimator.updateStatsData(atomicLong, l2, MemoryEstimator.constructStatsData(l4, l3, n2, n), n3, n4);
    }

    private static long constructStatsData(long l2, long l3, int n, int n2) {
        return l2 << 32 | l3 | (long)n << 8 | (long)n2;
    }

    private static long updateStatsData(AtomicLong atomicLong, long l2, long l3, int n, int n2) {
        while (!atomicLong.compareAndSet(l2, l3)) {
            l2 = atomicLong.get();
            long l4 = l2 >>> 32;
            if (n > 0) {
                l4 += (long)n2 - (l4 * (long)n + 128L >> 8);
            }
            l3 = l4 << 32 | l2 & 0x100FFFFL;
        }
        return l3;
    }

    private static int getCounter(long l2) {
        return (int)(l2 & 0xFFL);
    }

    private static int getSkipSum(long l2) {
        return (int)(l2 >> 8 & 0xFFFFL);
    }

    private static int getAverage(long l2) {
        return (int)(l2 >>> 40);
    }
}

