/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.cbor.internal;

import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.cbor.internal.ByteArrayOutput;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u001dJ*\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0014H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#J\u0006\u0010$\u001a\u00020\u000fJ\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006'"}, d2={"Lkotlinx/serialization/cbor/internal/CborEncoder;", "", "output", "Lkotlinx/serialization/cbor/internal/ByteArrayOutput;", "(Lkotlinx/serialization/cbor/internal/ByteArrayOutput;)V", "composeNegative", "", "value", "", "composeNumber", "composePositive", "Lkotlin/ULong;", "composePositive-VKZWuLQ", "(J)[B", "encodeBoolean", "", "", "encodeByteArray", "data", "type", "", "encodeByteString", "encodeDouble", "", "encodeFloat", "", "encodeNull", "encodeNumber", "encodeString", "", "encodeToByteArray", "bytes", "", "tag", "encodeToByteArray-E0BElUM", "(JIB)[B", "end", "startArray", "startMap", "kotlinx-serialization-cbor"})
public final class CborEncoder {
    @NotNull
    private final ByteArrayOutput output;

    public CborEncoder(@NotNull ByteArrayOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
    }

    public final void startArray() {
        this.output.write(159);
    }

    public final void startMap() {
        this.output.write(191);
    }

    public final void end() {
        this.output.write(255);
    }

    public final void encodeNull() {
        this.output.write(246);
    }

    public final void encodeBoolean(boolean value) {
        this.output.write(value ? 245 : 244);
    }

    public final void encodeNumber(long value) {
        ByteArrayOutput.write$default(this.output, this.composeNumber(value), 0, 0, 6, null);
    }

    public final void encodeByteString(@NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.encodeByteArray(data2, (byte)64);
    }

    public final void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encodeByteArray(StringsKt.encodeToByteArray((String)value), (byte)96);
    }

    private final void encodeByteArray(byte[] data2, byte type) {
        byte[] header = this.composeNumber(data2.length);
        header[0] = (byte)(header[0] | type);
        ByteArrayOutput.write$default(this.output, header, 0, 0, 6, null);
        ByteArrayOutput.write$default(this.output, data2, 0, 0, 6, null);
    }

    public final void encodeFloat(float value) {
        this.output.write(250);
        int bits = Float.floatToRawIntBits(value);
        for (int i = 0; i < 4; ++i) {
            this.output.write(bits >> 24 - 8 * i & 0xFF);
        }
    }

    public final void encodeDouble(double value) {
        this.output.write(251);
        long bits = Double.doubleToRawLongBits(value);
        for (int i = 0; i < 8; ++i) {
            this.output.write((int)(bits >> 56 - 8 * i & 0xFFL));
        }
    }

    private final byte[] composeNumber(long value) {
        return value >= 0L ? this.composePositive-VKZWuLQ(ULong.constructor-impl((long)value)) : this.composeNegative(value);
    }

    private final byte[] composePositive-VKZWuLQ(long value) {
        byte[] byArray;
        long l2 = value;
        boolean bl = 0 <= UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)23 & 0xFFFFFFFFL))) <= 0 : false;
        if (bl) {
            byte[] byArray2 = new byte[]{(byte)value};
            byArray = byArray2;
        } else {
            boolean bl2 = 0 <= UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)24 & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(0xFFFFFFFF & 0xFF)) & 0xFFFFFFFFL))) <= 0 : false;
            if (bl2) {
                byte[] byArray3 = new byte[]{24, (byte)value};
                byArray = byArray3;
            } else {
                int n = UInt.constructor-impl((int)(UInt.constructor-impl((int)(0xFFFFFFFF & 0xFF)) + 1));
                byArray = (UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(0xFFFFFFFF & 0xFFFF)) & 0xFFFFFFFFL))) <= 0 ? 0 <= UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)n & 0xFFFFFFFFL))) : false) ? this.encodeToByteArray-E0BElUM(value, 2, (byte)25) : ((0 <= UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)UInt.constructor-impl((int)(UInt.constructor-impl((int)(0xFFFFFFFF & 0xFFFF)) + 1)) & 0xFFFFFFFFL))) ? UnsignedKt.ulongCompare((long)l2, (long)ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) <= 0 : false) ? this.encodeToByteArray-E0BElUM(value, 4, (byte)26) : this.encodeToByteArray-E0BElUM(value, 8, (byte)27));
            }
        }
        return byArray;
    }

    private final byte[] encodeToByteArray-E0BElUM(long value, int bytes, byte tag) {
        byte[] result2 = new byte[bytes + 1];
        int limit = bytes * 8 - 8;
        result2[0] = tag;
        for (int i = 0; i < bytes; ++i) {
            result2[i + 1] = (byte)ULong.constructor-impl((long)(ULong.constructor-impl((long)(value >>> limit - 8 * i)) & 0xFFL));
        }
        return result2;
    }

    private final byte[] composeNegative(long value) {
        long aVal = value == Long.MIN_VALUE ? Long.MAX_VALUE : (long)-1 - value;
        byte[] data2 = this.composePositive-VKZWuLQ(ULong.constructor-impl((long)aVal));
        data2[0] = (byte)(data2[0] | 0x20);
        return data2;
    }
}

