/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.profiler;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001J\u001c\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lio/kinference/profiler/ProfileEntry;", "", "name", "", "time", "", "children", "", "(Ljava/lang/String;JLjava/util/List;)V", "getChildren", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "getTime", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "writeToStringBuilder", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "model-profiler"})
public final class ProfileEntry {
    @NotNull
    private final String name;
    private final long time;
    @NotNull
    private final List<ProfileEntry> children;

    public ProfileEntry(@NotNull String name, long time, @NotNull List<ProfileEntry> children) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        this.name = name;
        this.time = time;
        this.children = children;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final long getTime() {
        return this.time;
    }

    @NotNull
    public final List<ProfileEntry> getChildren() {
        return this.children;
    }

    public final void writeToStringBuilder(@NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        builder2.append(StringsKt.repeat((CharSequence)" ", (int)indent) + this.name + " - " + (float)this.time / 1000000.0f + " ms\n");
        for (ProfileEntry entry2 : this.children) {
            entry2.writeToStringBuilder(builder2, indent + 1);
        }
    }

    public static /* synthetic */ void writeToStringBuilder$default(ProfileEntry profileEntry, StringBuilder stringBuilder, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        profileEntry.writeToStringBuilder(stringBuilder, n);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    public final long component2() {
        return this.time;
    }

    @NotNull
    public final List<ProfileEntry> component3() {
        return this.children;
    }

    @NotNull
    public final ProfileEntry copy(@NotNull String name, long time, @NotNull List<ProfileEntry> children) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        return new ProfileEntry(name, time, children);
    }

    public static /* synthetic */ ProfileEntry copy$default(ProfileEntry profileEntry, String string, long l2, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = profileEntry.name;
        }
        if ((n & 2) != 0) {
            l2 = profileEntry.time;
        }
        if ((n & 4) != 0) {
            list = profileEntry.children;
        }
        return profileEntry.copy(string, l2, list);
    }

    @NotNull
    public String toString() {
        return "ProfileEntry(name=" + this.name + ", time=" + this.time + ", children=" + this.children + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.time);
        result2 = result2 * 31 + ((Object)this.children).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfileEntry)) {
            return false;
        }
        ProfileEntry profileEntry = (ProfileEntry)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)profileEntry.name)) {
            return false;
        }
        if (this.time != profileEntry.time) {
            return false;
        }
        return Intrinsics.areEqual(this.children, profileEntry.children);
    }
}

