/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.DoubleMap;
import io.kinference.ndarray.arrays.FloatMap;
import io.kinference.ndarray.arrays.IntNDArray;
import io.kinference.ndarray.arrays.LongNDArray;
import io.kinference.ndarray.arrays.MutableLongNDArray;
import io.kinference.ndarray.arrays.MutableNDArray;
import io.kinference.ndarray.arrays.MutableNDArrayCore;
import io.kinference.ndarray.arrays.MutableNumberNDArray;
import io.kinference.ndarray.arrays.MutableNumberNDArrayCore;
import io.kinference.ndarray.arrays.MutablePrimitiveNDArray;
import io.kinference.ndarray.arrays.NDArray;
import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.arrays.NDArrayUtilsKt;
import io.kinference.ndarray.arrays.NDIndexer;
import io.kinference.ndarray.arrays.NDIndexerKt;
import io.kinference.ndarray.arrays.NumberNDArray;
import io.kinference.ndarray.arrays.NumberNDArrayCore;
import io.kinference.ndarray.arrays.PadMode;
import io.kinference.ndarray.arrays.PrimitiveMap;
import io.kinference.ndarray.arrays.PrimitiveMaxHeap;
import io.kinference.ndarray.arrays.PrimitiveMinHeap;
import io.kinference.ndarray.arrays.PrimitiveNDArray;
import io.kinference.ndarray.arrays.PrimitiveToPrimitiveFunction;
import io.kinference.ndarray.arrays.Strides;
import io.kinference.ndarray.arrays.pointers.LongPointer;
import io.kinference.ndarray.arrays.pointers.PrimitivePointer;
import io.kinference.ndarray.arrays.pointers.PrimitivePointerKt;
import io.kinference.ndarray.arrays.tiled.LongTiledArray;
import io.kinference.ndarray.arrays.tiled.PrimitiveTiledArray;
import io.kinference.ndarray.broadcasting.Broadcasting;
import io.kinference.ndarray.extensions.MatrixKt;
import io.kinference.ndarray.extensions.NDArrayExtensionsKt;
import io.kinference.ndarray.extensions.PrimitiveExtensionsKt;
import io.kinference.ndarray.extensions.abs.AbsKt;
import io.kinference.ndarray.extensions.argMinMax.ArgMinMaxMode;
import io.kinference.ndarray.extensions.argMinMax.PrimitiveArgMinMaxKt;
import io.kinference.ndarray.extensions.broadcasting.BroadcastTwoArgumentsPrimitiveKt;
import io.kinference.ndarray.extensions.constants.PrimitiveConstants;
import io.kinference.ndarray.extensions.dot.PrimitiveDotParallelMKt;
import io.kinference.ndarray.extensions.dot.PrimitiveDotParallelNKt;
import io.kinference.ndarray.extensions.dot.PrimitiveDotResizeParallelKt;
import io.kinference.ndarray.extensions.reduce.primitive.PrimitiveReduceOperationKt;
import io.kinference.ndarray.extensions.softmax.SoftmaxKt;
import io.kinference.ndarray.stubs.PrimitiveTypeStubsKt;
import io.kinference.primitives.types.DataType;
import io.kinference.primitives.types.ExtensionsKt;
import io.kinference.primitives.types.PrimitiveArray;
import io.kinference.primitives.types.PrimitiveType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0017\b\u0010\u0018\u0000 \u0094\u00012\u00020\u0001:\u0002\u0094\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB#\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\rB\u0015\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010 \u001a\u00020!H\u0096@\u00a2\u0006\u0002\u0010\"J&\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010)J&\u0010*\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010)J\b\u0010+\u001a\u00020\u0000H\u0016J$\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u0010%\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020-H\u0016J&\u00103\u001a\u00020-2\u0006\u0010%\u001a\u00020\u00072\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010)J\u0016\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020!H\u0096B\u00a2\u0006\u0002\u00108J\u001e\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010;J\u0016\u0010<\u001a\u00020-2\u0006\u00107\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u00108J\u001e\u0010<\u001a\u00020-2\u0006\u00107\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010;J\u0013\u0010=\u001a\u00020'2\b\u00107\u001a\u0004\u0018\u00010>H\u0096\u0002J\u000e\u0010?\u001a\u00020\u0000H\u0096@\u00a2\u0006\u0002\u0010\"J\u0016\u0010@\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010AJ2\u0010B\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0018\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020'0DH\u0002J\u0086\u0001\u0010E\u001a\u00020-2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u0002002\u0006\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020J2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u00072\u0006\u0010T\u001a\u00020\u00072\u0006\u0010U\u001a\u00020'2\u0006\u0010V\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010WJ\u0011\u0010X\u001a\u00020\b2\u0006\u0010Y\u001a\u00020\u0003H\u0096\u0002J\u0010\u0010Z\u001a\u00020\b2\u0006\u0010Y\u001a\u00020\u0007H\u0016J\b\u0010[\u001a\u00020\u0007H\u0016J\u0016\u0010\\\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010]J\u0016\u0010^\u001a\u00020-2\u0006\u0010_\u001a\u00020`H\u0096@\u00a2\u0006\u0002\u0010aJ\u001e\u0010^\u001a\u00020-2\u0006\u0010_\u001a\u00020`2\u0006\u00109\u001a\u00020PH\u0096@\u00a2\u0006\u0002\u0010bJ\u0016\u0010c\u001a\u00020-2\u0006\u00107\u001a\u00020!H\u0096@\u00a2\u0006\u0002\u00108J\u001e\u0010c\u001a\u00020-2\u0006\u00107\u001a\u00020!2\u0006\u00109\u001a\u00020dH\u0096@\u00a2\u0006\u0002\u0010eJ\u000e\u0010f\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\"J\u001e\u0010f\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010gJ\u000e\u0010h\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\"J\u001e\u0010h\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010gJ\u0016\u0010i\u001a\u00020-2\u0006\u00107\u001a\u00020!H\u0096B\u00a2\u0006\u0002\u00108J\u001e\u0010i\u001a\u00020-2\u0006\u00107\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010;J\u000e\u0010j\u001a\u00020kH\u0096@\u00a2\u0006\u0002\u0010\"J:\u0010l\u001a\u00020\u00002\u0018\u0010m\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070o0n2\u0006\u0010p\u001a\u00020q2\b\u0010r\u001a\u0004\u0018\u000100H\u0096@\u00a2\u0006\u0002\u0010sJ\u0016\u0010t\u001a\u00020-2\u0006\u00107\u001a\u00020!H\u0096B\u00a2\u0006\u0002\u00108J\u001e\u0010t\u001a\u00020-2\u0006\u00107\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010;J\u001e\u0010u\u001a\u00020\u00002\u0006\u0010v\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010wJ\u0016\u0010x\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010yJ\u0016\u0010x\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010AJ\b\u0010z\u001a\u00020\bH\u0016JL\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020~2\u0006\u0010\u007f\u001a\u00020~2\u0007\u0010\u0080\u0001\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0007\u0010\u0081\u0001\u001a\u00020\u00032\u0007\u0010\u0082\u0001\u001a\u00020\u00032\u0007\u0010\u0083\u0001\u001a\u00020\u0003H\u0002J*\u0010{\u001a\u00020-2\u0007\u0010\u0081\u0001\u001a\u00020\u00032\u0007\u0010\u0082\u0001\u001a\u00020\u00032\u0007\u0010\u0083\u0001\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0003\u0010\u0084\u0001J\u0017\u0010\u0085\u0001\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010]J\u000f\u0010\u0086\u0001\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\"J\u0018\u0010\u0087\u0001\u001a\u00020\u00002\u0007\u0010\u0088\u0001\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010AJ\u0017\u0010\u0089\u0001\u001a\u00020-2\u0006\u00107\u001a\u00020!H\u0096B\u00a2\u0006\u0002\u00108J\u001f\u0010\u0089\u0001\u001a\u00020-2\u0006\u00107\u001a\u00020!2\u0006\u00109\u001a\u00020:H\u0096@\u00a2\u0006\u0002\u0010;J\t\u0010\u008a\u0001\u001a\u00020-H\u0016J>\u0010\u008b\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020k0o2\u0006\u0010%\u001a\u00020\u00072\u0006\u0010H\u001a\u00020\u00072\u0007\u0010\u008c\u0001\u001a\u00020'2\u0007\u0010\u008d\u0001\u001a\u00020'H\u0096@\u00a2\u0006\u0003\u0010\u008e\u0001J\u0018\u0010\u008f\u0001\u001a\u00020\u00002\u0007\u0010\u0090\u0001\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010AJ\u000f\u0010\u0091\u0001\u001a\u00020\u0000H\u0096@\u00a2\u0006\u0002\u0010\"J\u0012\u0010\u0092\u0001\u001a\u00020\u00002\u0007\u0010\u0090\u0001\u001a\u00020\u0003H\u0002J\u0015\u0010\u0093\u0001\u001a\u00020\u00002\n\u0010v\u001a\u00020\u0003\"\u00020\u0007H\u0016R$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R$\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\fR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\u0095\u0001"}, d2={"Lio/kinference/ndarray/arrays/PrimitiveNDArray;", "Lio/kinference/ndarray/arrays/NumberNDArrayCore;", "shape", "", "([I)V", "init", "Lkotlin/Function1;", "", "Lio/kinference/primitives/types/PrimitiveType;", "([ILkotlin/jvm/functions/Function1;)V", "strides", "Lio/kinference/ndarray/arrays/Strides;", "(Lio/kinference/ndarray/arrays/Strides;)V", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/jvm/functions/Function1;)V", "array", "Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "(Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;Lio/kinference/ndarray/arrays/Strides;)V", "<set-?>", "getArray", "()Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;", "setArray", "(Lio/kinference/ndarray/arrays/tiled/PrimitiveTiledArray;)V", "blocksInRow", "getBlocksInRow$ndarray_core", "()I", "getStrides", "()Lio/kinference/ndarray/arrays/Strides;", "setStrides", "type", "Lio/kinference/primitives/types/DataType;", "getType", "()Lio/kinference/primitives/types/DataType;", "abs", "Lio/kinference/ndarray/arrays/NumberNDArray;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "argmax", "Lio/kinference/ndarray/arrays/IntNDArray;", "axis", "keepDims", "", "selectLastIndex", "(IZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "argmin", "clone", "concat", "Lio/kinference/ndarray/arrays/MutablePrimitiveNDArray;", "others", "", "Lio/kinference/ndarray/arrays/NDArray;", "(Ljava/util/List;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "copyIfNotMutable", "cumulativeSum", "exclusive", "reverse", "div", "other", "(Lio/kinference/ndarray/arrays/NumberNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "destination", "Lio/kinference/ndarray/arrays/MutableNumberNDArray;", "(Lio/kinference/ndarray/arrays/NumberNDArray;Lio/kinference/ndarray/arrays/MutableNumberNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dot", "equals", "", "erf", "expand", "([ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findComparable", "compare", "Lkotlin/Function2;", "gemm", "m", "n", "k", "alpha", "", "lda", "b", "ldb", "beta", "c", "Lio/kinference/ndarray/arrays/MutableNDArray;", "ldc", "aOffset", "bOffset", "cOffset", "transposeA", "transposeB", "(IIIDILio/kinference/ndarray/arrays/NDArray;IDLio/kinference/ndarray/arrays/MutableNDArray;IIIIZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "index", "getLinear", "hashCode", "logSoftmax", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "map", "function", "Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;", "(Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Lio/kinference/ndarray/arrays/PrimitiveToPrimitiveFunction;Lio/kinference/ndarray/arrays/MutableNDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "matmul", "Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;", "(Lio/kinference/ndarray/arrays/NumberNDArray;Lio/kinference/ndarray/arrays/MutableNumberNDArrayCore;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "max", "(IZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "min", "minus", "nonZero", "Lio/kinference/ndarray/arrays/LongNDArray;", "pad", "pads", "", "Lkotlin/Pair;", "mode", "Lio/kinference/ndarray/arrays/PadMode;", "constantValue", "([Lkotlin/Pair;Lio/kinference/ndarray/arrays/PadMode;Lio/kinference/ndarray/arrays/NDArray;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "plus", "reduceSum", "axes", "([IZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reshape", "(Lio/kinference/ndarray/arrays/Strides;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "singleValue", "slice", "", "dst", "Lio/kinference/ndarray/arrays/pointers/PrimitivePointer;", "src", "offset", "starts", "ends", "steps", "([I[I[ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "softmax", "sum", "tile", "repeats", "times", "toMutable", "topK", "largest", "sorted", "(IIZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transpose", "permutations", "transpose2D", "transposeByBlocks", "view", "Companion", "ndarray-core"})
@SourceDebugExtension(value={"SMAP\nPrimitiveNDArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveNDArray.kt\nio/kinference/ndarray/arrays/PrimitiveNDArray\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PrimitivePointer.kt\nio/kinference/ndarray/arrays/pointers/PrimitivePointerKt\n+ 6 PrimitivePointerStubs.kt\nio/kinference/ndarray/stubs/PrimitivePointerStubsKt\n+ 7 LongPointer.kt\nio/kinference/ndarray/arrays/pointers/LongPointerKt\n+ 8 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,1313:1\n12895#2,4:1314\n12762#2,3:1526\n12762#2,3:1529\n11065#2:1826\n11400#2,3:1827\n13309#2,2:1866\n11065#2:1908\n11400#2,3:1909\n13309#2,2:1948\n12313#2,2:1951\n12313#2,2:1953\n1#3:1318\n1#3:1331\n1#3:1382\n1#3:1413\n1#3:1463\n1#3:1495\n1#3:1571\n1#3:1604\n1#3:1959\n1#3:1991\n1#3:2023\n1#3:2055\n1789#4,3:1319\n1549#4:1322\n1620#4,2:1323\n1789#4,3:1325\n1622#4:1328\n1855#4:1329\n1856#4:1362\n1726#4,3:1955\n259#5:1330\n261#5,30:1332\n123#5,18:1363\n471#5:1381\n473#5,29:1383\n259#5:1412\n261#5,30:1414\n144#5,18:1444\n259#5:1462\n261#5,30:1464\n259#5:1494\n261#5,30:1496\n200#5,19:1532\n200#5,19:1551\n259#5:1570\n261#5,30:1572\n259#5:1603\n261#5,30:1605\n199#5,20:1636\n200#5,19:1656\n123#5,18:1675\n199#5,20:1711\n200#5,19:1731\n123#5,18:1750\n199#5,20:1786\n199#5,20:1806\n123#5,18:1830\n199#5,20:1868\n199#5,20:1888\n123#5,18:1912\n259#5:1958\n261#5,30:1960\n259#5:1990\n261#5,30:1992\n259#5:2022\n261#5,30:2024\n259#5:2054\n261#5,30:2056\n123#5,18:2086\n21#6:1602\n21#6:1635\n175#7,18:1693\n175#7,18:1768\n175#7,18:1848\n175#7,18:1930\n26#8:1950\n*S KotlinDebug\n*F\n+ 1 PrimitiveNDArray.kt\nio/kinference/ndarray/arrays/PrimitiveNDArray\n*L\n54#1:1314,4\n553#1:1526,3\n554#1:1529,3\n776#1:1826\n776#1:1827,3\n786#1:1866,2\n805#1:1908\n805#1:1909,3\n815#1:1948,2\n1017#1:1951,2\n1167#1:1953,2\n134#1:1331\n458#1:1382\n476#1:1413\n523#1:1463\n527#1:1495\n607#1:1571\n658#1:1604\n1042#1:1959\n1049#1:1991\n1077#1:2023\n1093#1:2055\n126#1:1319,3\n127#1:1322\n127#1:1323,2\n129#1:1325,3\n127#1:1328\n133#1:1329\n133#1:1362\n1169#1:1955,3\n134#1:1330\n134#1:1332,30\n419#1:1363,18\n458#1:1381\n458#1:1383,29\n476#1:1412\n476#1:1414,30\n509#1:1444,18\n523#1:1462\n523#1:1464,30\n527#1:1494\n527#1:1496,30\n569#1:1532,19\n587#1:1551,19\n607#1:1570\n607#1:1572,30\n658#1:1603\n658#1:1605,30\n713#1:1636,20\n715#1:1656,19\n725#1:1675,18\n735#1:1711,20\n737#1:1731,19\n747#1:1750,18\n763#1:1786,20\n767#1:1806,20\n780#1:1830,18\n792#1:1868,20\n796#1:1888,20\n809#1:1912,18\n1042#1:1958\n1042#1:1960,30\n1049#1:1990\n1049#1:1992,30\n1077#1:2022\n1077#1:2024,30\n1093#1:2054\n1093#1:2056,30\n1195#1:2086,18\n614#1:1602\n665#1:1635\n728#1:1693,18\n750#1:1768,18\n783#1:1848,18\n812#1:1930,18\n844#1:1950\n*E\n"})
public class PrimitiveNDArray
implements NumberNDArrayCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private PrimitiveTiledArray array;
    @NotNull
    private final DataType type;
    @NotNull
    private Strides strides;

    public PrimitiveNDArray(@NotNull PrimitiveTiledArray array, @NotNull Strides strides2) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
        this.array = array;
        this.type = DataType.Companion.getCurrentPrimitive();
        this.strides = strides2;
    }

    public PrimitiveNDArray(@NotNull int[] shape) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this(PrimitiveTiledArray.Companion.invoke(shape), new Strides(shape));
    }

    public PrimitiveNDArray(@NotNull int[] shape, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(PrimitiveTiledArray.Companion.invoke(shape, init), new Strides(shape));
    }

    public PrimitiveNDArray(@NotNull Strides strides2) {
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
        this(PrimitiveTiledArray.Companion.invoke(strides2), strides2);
    }

    public PrimitiveNDArray(@NotNull Strides strides2, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        this(PrimitiveTiledArray.Companion.invoke(strides2, init), strides2);
    }

    @NotNull
    public final PrimitiveTiledArray getArray() {
        return this.array;
    }

    protected final void setArray(@NotNull PrimitiveTiledArray primitiveTiledArray) {
        Intrinsics.checkNotNullParameter((Object)primitiveTiledArray, (String)"<set-?>");
        this.array = primitiveTiledArray;
    }

    public final int getBlocksInRow$ndarray_core() {
        return this.strides.getLinearSize() == 0 ? 0 : (this.strides.getShape().length == 0 ? 1 : ArraysKt.last((int[])this.strides.getShape()) / this.array.getBlockSize());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PrimitiveNDArray view(int ... axes2) {
        void $this$foldIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)axes2, (String)"axes");
        int n = axes2.length;
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            int axis2 = axes2[i];
            if (this.getShape()[i2] > axis2) continue;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] nArray = axes2;
        int initial$iv22 = 0;
        int $i$f$foldIndexed = 0;
        int index$iv = 0;
        int accumulator$iv = initial$iv22;
        for (void element$iv : $this$foldIndexed$iv) {
            void i;
            void acc;
            int n2 = index$iv++;
            void var11_16 = element$iv;
            int n3 = accumulator$iv;
            int index = n2;
            boolean bl = false;
            accumulator$iv = acc + i * this.strides.getStrides()[index];
        }
        int offset = accumulator$iv;
        int[] initial$iv22 = this.getShape();
        $i$f$foldIndexed = axes2.length;
        index$iv = this.getShape().length;
        int[] newShape = ArraysKt.copyOfRange((int[])initial$iv22, (int)$i$f$foldIndexed, (int)index$iv);
        Strides newStrides = new Strides(newShape);
        if (this.array.getBlockSize() == 0) {
            return new PrimitiveNDArray(this.array, newStrides);
        }
        int offsetBlocks = offset / this.array.getBlockSize();
        int countBlocks = newStrides.getLinearSize() / this.array.getBlockSize();
        Object[] objectArray = this.array.getBlocks();
        int n4 = offsetBlocks + countBlocks;
        PrimitiveArray[] copyBlocks = (PrimitiveArray[])ArraysKt.copyOfRange((Object[])objectArray, (int)offsetBlocks, (int)n4);
        PrimitiveTiledArray newArray = new PrimitiveTiledArray(copyBlocks);
        return new PrimitiveNDArray(newArray, newStrides);
    }

    @Override
    @NotNull
    public DataType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final Strides getStrides() {
        return this.strides;
    }

    protected final void setStrides(@NotNull Strides strides2) {
        Intrinsics.checkNotNullParameter((Object)strides2, (String)"<set-?>");
        this.strides = strides2;
    }

    @Override
    @NotNull
    public PrimitiveType get(@NotNull int[] index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (!(index.length == this.getRank())) {
            boolean bl = false;
            String string = "Index size should contain " + this.getRank() + " elements, but " + index.length + " given";
            throw new IllegalArgumentException(string.toString());
        }
        int linearIndex = this.strides.offset(index);
        return this.array.get(linearIndex);
    }

    @Override
    @NotNull
    public PrimitiveType getLinear(int index) {
        return this.array.get(index);
    }

    @Override
    @NotNull
    public PrimitiveType singleValue() {
        if (!(NDArrayUtilsKt.isScalar(this) || this.array.getSize() == 1)) {
            boolean bl = false;
            String string = "NDArray contains more than 1 value";
            throw new IllegalArgumentException(string.toString());
        }
        return this.array.getBlocks()[0].get(0);
    }

    @Override
    @NotNull
    public PrimitiveNDArray clone() {
        return new PrimitiveNDArray(this.array.copyOf(), new Strides(this.getShape()));
    }

    @Override
    @NotNull
    public MutablePrimitiveNDArray toMutable() {
        return new MutablePrimitiveNDArray(this.array.copyOf(), this.strides);
    }

    @Nullable
    public Object map(@NotNull PrimitiveToPrimitiveFunction function, @NotNull MutableNDArray destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.map$suspendImpl(this, function, destination, $completion);
    }

    static /* synthetic */ Object map$suspendImpl(PrimitiveNDArray $this, PrimitiveToPrimitiveFunction function, MutableNDArray destination, Continuation<? super MutablePrimitiveNDArray> $completion) {
        Intrinsics.checkNotNull((Object)function, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveMap");
        PrimitiveMap cfr_ignored_0 = (PrimitiveMap)function;
        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        MutablePrimitiveNDArray cfr_ignored_1 = (MutablePrimitiveNDArray)destination;
        int n = $this.array.getBlocksNum();
        block0: for (int blockNum = 0; blockNum < n; ++blockNum) {
            int n2;
            PrimitiveArray thisBlock = $this.array.getBlocks()[blockNum];
            PrimitiveArray destBlock = ((MutablePrimitiveNDArray)destination).getArray().getBlocks()[blockNum];
            IntRange intRange = thisBlock.getIndices();
            int idx = intRange.getFirst();
            if (idx > (n2 = intRange.getLast())) continue;
            while (true) {
                destBlock.set(idx, ((PrimitiveMap)function).apply(thisBlock.get(idx)));
                if (idx == n2) continue block0;
                ++idx;
            }
        }
        return destination;
    }

    @Override
    @Nullable
    public Object abs(@NotNull Continuation<? super NumberNDArray> $completion) {
        return PrimitiveNDArray.abs$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object abs$suspendImpl(PrimitiveNDArray $this, Continuation<? super NumberNDArray> $completion) {
        return AbsKt.abs($this);
    }

    @Nullable
    public Object concat(@NotNull List<? extends NDArray> others, int axis2, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.concat$suspendImpl(this, others, axis2, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object concat$suspendImpl(PrimitiveNDArray $this, List<? extends NDArray> others, int axis2, Continuation<? super MutablePrimitiveNDArray> $completion) {
        void $this$mapTo$iv$iv;
        void $this$fold$iv;
        int n;
        Object object3;
        int actualAxis = NDArrayUtilsKt.indexAxis($this, axis2);
        List inputs = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$this), (Iterable)others);
        int[] nArray = $this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] resultShape = nArray2;
        Iterable iterable = inputs;
        int n2 = actualAxis;
        Object object2 = resultShape;
        int n3 = 0;
        for (Object object3 : iterable) {
            void it;
            NDArray nDArray = (NDArray)object3;
            n = n3;
            boolean bl = false;
            int n4 = it.getShape()[actualAxis];
            n3 = n + n4;
        }
        object2[n2] = n = n3;
        MutablePrimitiveNDArray result2 = new MutablePrimitiveNDArray(new Strides(resultShape));
        PrimitivePointer resultPointer = PrimitiveTiledArray.pointer$default(result2.getArray(), 0, 1, null);
        object3 = ArraysKt.take((int[])resultShape, (int)actualAxis);
        int initial$iv = 1;
        boolean $i$f$fold = false;
        int accumulator$iv22 = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            int n5 = ((Number)element$iv).intValue();
            int p0 = accumulator$iv22;
            boolean bl = false;
            accumulator$iv22 = p0 * p1;
        }
        int numIterations = accumulator$iv22;
        Iterable $this$map$iv = inputs;
        boolean $i$f$map = false;
        Iterable accumulator$iv22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$fold$iv2;
            void initial$iv2;
            Object object4;
            void it;
            NDArray bl = (NDArray)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl2 = false;
            if (!(it instanceof PrimitiveNDArray)) {
                object4 = "Failed requirement.";
                throw new IllegalArgumentException(object4.toString());
            }
            Iterable iterable2 = ArraysKt.drop((int[])it.getShape(), (int)actualAxis);
            object4 = Boxing.boxInt((int)1);
            PrimitivePointer primitivePointer = PrimitiveTiledArray.pointer$default(((PrimitiveNDArray)it).array, 0, 1, null);
            boolean $i$f$fold2 = false;
            Integer accumulator$iv = initial$iv2;
            for (Object element$iv : $this$fold$iv2) {
                void p1;
                int n6 = ((Number)element$iv).intValue();
                int p0 = ((Number)accumulator$iv).intValue();
                boolean bl3 = false;
                accumulator$iv = Boxing.boxInt((int)(p0 * p1));
            }
            object2.add(TuplesKt.to((Object)primitivePointer, (Object)accumulator$iv));
        }
        List pointersToSteps = (List)destination$iv$iv;
        for (int i = 0; i < numIterations; ++i) {
            int it = i;
            boolean bl = false;
            Iterable $this$forEach$iv = pointersToSteps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrimitiveType src;
                boolean bl4;
                Object object5;
                int end$iv;
                Pair pair = (Pair)element$iv;
                boolean bl5 = false;
                PrimitivePointer pointer = (PrimitivePointer)pair.component1();
                int numSteps = ((Number)pair.component2()).intValue();
                PrimitivePointer $this$accept$iv = resultPointer;
                boolean $i$f$accept = false;
                if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, pointer, numSteps)) {
                    boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
                    String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                    throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
                }
                if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, pointer)) {
                    int dstOffset$iv;
                    PrimitiveArray dstBlock$iv;
                    for (end$iv = numSteps; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        PrimitiveArray srcBlock$iv = pointer.getCurrentBlock();
                        if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                            $this$accept$iv.blockIncrement();
                            pointer.blockIncrement();
                        } else {
                            $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                            pointer.setIndexInBlock(pointer.getIndexInBlock() + end$iv);
                        }
                        int index$iv = dstOffset$iv;
                        int n7 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                        while (index$iv < n7) {
                            dstBlock$iv.get(index$iv);
                            PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                            int n8 = index$iv++;
                            object5 = dstBlock$iv;
                            bl4 = false;
                            PrimitiveType primitiveType2 = src;
                            ((PrimitiveArray)object5).set(n8, primitiveType2);
                        }
                    }
                    continue;
                }
                while (end$iv > 0) {
                    $this$accept$iv.get();
                    src = pointer.getAndIncrement();
                    object5 = $this$accept$iv;
                    bl4 = false;
                    ((PrimitivePointer)object5).set(src);
                    $this$accept$iv.increment();
                    --end$iv;
                }
            }
        }
        return result2;
    }

    @Nullable
    public Object map(@NotNull PrimitiveToPrimitiveFunction function, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return this.map(function, (MutableNDArray)new MutablePrimitiveNDArray(this.strides), $completion);
    }

    @Nullable
    public Object slice(@NotNull int[] starts, @NotNull int[] ends, @NotNull int[] steps, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.slice$suspendImpl(this, starts, ends, steps, $completion);
    }

    static /* synthetic */ Object slice$suspendImpl(PrimitiveNDArray $this, int[] starts, int[] ends, int[] steps, Continuation<? super MutablePrimitiveNDArray> $completion) {
        int n = $this.getShape().length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int length = Math.abs(ends[n2] - starts[n2]);
            int rest = length % Math.abs(steps[n2]);
            nArray[n2] = length / Math.abs(steps[n2]) + (rest != 0 ? 1 : 0);
        }
        int[] newShape = nArray;
        Strides newStrides = new Strides(newShape);
        PrimitiveTiledArray newArray = PrimitiveTiledArray.Companion.invoke(newStrides);
        if (newArray.getSize() > 0) {
            $this.slice(PrimitiveTiledArray.pointer$default(newArray, 0, 1, null), PrimitiveTiledArray.pointer$default($this.array, 0, 1, null), 0, 0, $this.getShape(), starts, ends, steps);
        }
        return new MutablePrimitiveNDArray(newArray, newStrides);
    }

    private final void slice(PrimitivePointer dst, PrimitivePointer src, int offset, int axis2, int[] shape, int[] starts, int[] ends, int[] steps) {
        IntProgression range2;
        int start2 = starts[axis2];
        int end2 = ends[axis2];
        int step2 = steps[axis2];
        IntProgression intProgression = range2 = step2 > 0 ? RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start2, (int)end2)), (int)step2) : RangesKt.step((IntProgression)RangesKt.downTo((int)start2, (int)(end2 + 1)), (int)(-step2));
        if (axis2 == shape.length - 1) {
            int index = range2.getFirst();
            int n = range2.getLast();
            int n2 = range2.getStep();
            if (n2 > 0 && index <= n || n2 < 0 && n <= index) {
                while (true) {
                    src.setLinearIndex(offset + index);
                    dst.set(src.get());
                    dst.increment();
                    if (index != n) {
                        index += n2;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int dim = 1;
            int n = shape.length;
            for (int ind = axis2 + 1; ind < n; ++ind) {
                dim *= shape[ind];
            }
            int index = range2.getFirst();
            n = range2.getLast();
            int n3 = range2.getStep();
            if (n3 > 0 && index <= n || n3 < 0 && n <= index) {
                while (true) {
                    this.slice(dst, src, offset + index * dim, axis2 + 1, shape, starts, ends, steps);
                    if (index == n) break;
                    index += n3;
                }
            }
        }
    }

    @Nullable
    public Object min(@NotNull Continuation<? super PrimitiveType> $completion) {
        return PrimitiveNDArray.min$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object min$suspendImpl(PrimitiveNDArray $this, Continuation<? super PrimitiveType> $completion) {
        PrimitiveType min2 = PrimitiveTypeStubsKt.getMAX_VALUE_FOR_MIN(PrimitiveType.Companion);
        block0: for (PrimitiveArray block : $this.array.getBlocks()) {
            int n;
            IntRange intRange = block.getIndices();
            int idx = intRange.getFirst();
            if (idx > (n = intRange.getLast())) continue;
            while (true) {
                PrimitiveType tmp;
                if ((tmp = block.get(idx)).compareTo(min2) < 0) {
                    min2 = tmp;
                }
                if (idx == n) continue block0;
                ++idx;
            }
        }
        return min2;
    }

    @Nullable
    public Object min(int axis2, boolean keepDims2, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return this.findComparable(axis2, keepDims2, (Function2<? super PrimitiveType, ? super PrimitiveType, Boolean>)((Function2)min.3.INSTANCE));
    }

    @Nullable
    public Object max(@NotNull Continuation<? super PrimitiveType> $completion) {
        return PrimitiveNDArray.max$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object max$suspendImpl(PrimitiveNDArray $this, Continuation<? super PrimitiveType> $completion) {
        PrimitiveType max2 = PrimitiveTypeStubsKt.getMIN_VALUE_FOR_MAX(PrimitiveType.Companion);
        block0: for (PrimitiveArray block : $this.array.getBlocks()) {
            int n;
            IntRange intRange = block.getIndices();
            int idx = intRange.getFirst();
            if (idx > (n = intRange.getLast())) continue;
            while (true) {
                PrimitiveType tmp;
                if ((tmp = block.get(idx)).compareTo(max2) > 0) {
                    max2 = tmp;
                }
                if (idx == n) continue block0;
                ++idx;
            }
        }
        return max2;
    }

    @Nullable
    public Object sum(@NotNull Continuation<? super PrimitiveType> $completion) {
        return PrimitiveNDArray.sum$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object sum$suspendImpl(PrimitiveNDArray $this, Continuation<? super PrimitiveType> $completion) {
        PrimitiveType sum2 = ExtensionsKt.toPrimitive(Boxing.boxInt((int)0));
        block0: for (PrimitiveArray block : $this.array.getBlocks()) {
            int n;
            IntRange intRange = block.getIndices();
            int idx = intRange.getFirst();
            if (idx > (n = intRange.getLast())) continue;
            while (true) {
                sum2 = sum2.plus(block.get(idx)).toPrimitive();
                if (idx == n) continue block0;
                ++idx;
            }
        }
        return sum2;
    }

    @Nullable
    public Object cumulativeSum(int axis2, boolean exclusive2, boolean reverse2, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.cumulativeSum$suspendImpl(this, axis2, exclusive2, reverse2, $completion);
    }

    static /* synthetic */ Object cumulativeSum$suspendImpl(PrimitiveNDArray $this, int axis2, boolean exclusive2, boolean reverse2, Continuation<? super MutablePrimitiveNDArray> $completion) {
        MutablePrimitiveNDArray output = new MutablePrimitiveNDArray(PrimitiveTiledArray.Companion.invoke($this.strides), $this.strides);
        int actualAxis = NDArrayUtilsKt.indexAxis($this, axis2);
        int blockSize = NDArrayUtilsKt.computeBlockSize$default($this, actualAxis + 1, 0, 2, null);
        int batchSize = NDArrayUtilsKt.computeBlockSize$default($this, actualAxis, 0, 2, null);
        int numBatches = NDArrayUtilsKt.computeBlockSize$default($this, 0, actualAxis, 1, null);
        int numBlocks = batchSize / blockSize;
        for (int i = 0; i < numBatches; ++i) {
            int thisOff;
            int currentOff;
            int j;
            int i2;
            int dstOff;
            int batchIdx = i;
            boolean bl = false;
            int n = dstOff = !reverse2 ? batchIdx * batchSize : (numBatches - batchIdx) * batchSize - 1;
            if (!exclusive2) {
                if (!reverse2) {
                    output.copyFrom(dstOff, $this, dstOff, dstOff + blockSize);
                } else {
                    output.copyFrom(dstOff - blockSize + 1, $this, dstOff - blockSize + 1, dstOff + 1);
                }
            }
            if (!reverse2) {
                for (i2 = 1; i2 < numBlocks; ++i2) {
                    for (j = 0; j < blockSize; ++j) {
                        currentOff = dstOff + i2 * blockSize + j;
                        thisOff = !exclusive2 ? currentOff : currentOff - blockSize;
                        output.getArray().set(currentOff, output.getArray().get(currentOff - blockSize).plus($this.array.get(thisOff)).toPrimitive());
                    }
                }
                continue;
            }
            for (i2 = 1; i2 < numBlocks; ++i2) {
                for (j = blockSize - 1; -1 < j; --j) {
                    currentOff = dstOff - i2 * blockSize - j;
                    thisOff = !exclusive2 ? currentOff : currentOff + blockSize;
                    output.getArray().set(currentOff, output.getArray().get(currentOff + blockSize).plus($this.array.get(thisOff)).toPrimitive());
                }
            }
        }
        return output;
    }

    @Nullable
    public Object erf(@NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return this.map((PrimitiveToPrimitiveFunction)new PrimitiveMap(){

            @NotNull
            public PrimitiveType apply(@NotNull PrimitiveType value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return PrimitiveExtensionsKt.erf(value);
            }
        }, (Continuation<? super MutablePrimitiveNDArray>)$completion);
    }

    @Nullable
    public Object softmax(int axis2, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.softmax$suspendImpl(this, axis2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object softmax$suspendImpl(PrimitiveNDArray var0, int var1_1, Continuation<? super PrimitiveNDArray> var2_2) {
        if (!(var2_2 instanceof softmax.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ PrimitiveNDArray this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PrimitiveNDArray.softmax$suspendImpl(this.this$0, 0, (Continuation<? super PrimitiveNDArray>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = SoftmaxKt.softmax($this, (int)axis, (Continuation<? super MutableNumberNDArrayCore>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
                return (PrimitiveNDArray)v0;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object logSoftmax(int axis2, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.logSoftmax$suspendImpl(this, axis2, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object logSoftmax$suspendImpl(PrimitiveNDArray var0, int var1_1, Continuation<? super PrimitiveNDArray> var2_2) {
        if (!(var2_2 instanceof logSoftmax.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ PrimitiveNDArray this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PrimitiveNDArray.logSoftmax$suspendImpl(this.this$0, 0, (Continuation<? super PrimitiveNDArray>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = SoftmaxKt.softmax($this, (int)axis, (Continuation<? super MutableNumberNDArrayCore>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                output = (MutableNumberNDArrayCore)v0;
                $continuation.label = 2;
                v1 = output.mapMutable(PrimitiveNDArray.logSoftmax$log(output.getType()), (Continuation<? super MutableNDArrayCore>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl29
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
                return (MutablePrimitiveNDArray)v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object plus(@NotNull NumberNDArray other, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.plus$suspendImpl(this, other, $completion);
    }

    static /* synthetic */ Object plus$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, Continuation<? super MutablePrimitiveNDArray> $completion) {
        int[][] nArrayArray = new int[][]{$this.getShape(), other.getShape()};
        int[] destShape = NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)));
        return $this.plus(other, (MutableNumberNDArray)new MutablePrimitiveNDArray(destShape), $completion);
    }

    @Nullable
    public Object plus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.plus$suspendImpl(this, other, destination, $completion);
    }

    static /* synthetic */ Object plus$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, MutableNumberNDArray destination, Continuation<? super MutablePrimitiveNDArray> $completion) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
        PrimitiveNDArray primitiveNDArray = (PrimitiveNDArray)other;
        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        return BroadcastTwoArgumentsPrimitiveKt.broadcastTwoTensorsPrimitive($this, primitiveNDArray, (MutablePrimitiveNDArray)destination, (Function2<? super PrimitiveType, ? super PrimitiveType, ? extends PrimitiveType>)((Function2)plus.3.INSTANCE), $completion);
    }

    @Nullable
    public Object minus(@NotNull NumberNDArray other, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.minus$suspendImpl(this, other, $completion);
    }

    static /* synthetic */ Object minus$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, Continuation<? super MutablePrimitiveNDArray> $completion) {
        int[][] nArrayArray = new int[][]{$this.getShape(), other.getShape()};
        int[] destShape = NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)));
        return $this.minus(other, (MutableNumberNDArray)new MutablePrimitiveNDArray(destShape), $completion);
    }

    @Nullable
    public Object minus(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.minus$suspendImpl(this, other, destination, $completion);
    }

    static /* synthetic */ Object minus$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, MutableNumberNDArray destination, Continuation<? super MutablePrimitiveNDArray> $completion) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
        PrimitiveNDArray primitiveNDArray = (PrimitiveNDArray)other;
        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        return BroadcastTwoArgumentsPrimitiveKt.broadcastTwoTensorsPrimitive($this, primitiveNDArray, (MutablePrimitiveNDArray)destination, (Function2<? super PrimitiveType, ? super PrimitiveType, ? extends PrimitiveType>)((Function2)minus.3.INSTANCE), $completion);
    }

    @Nullable
    public Object times(@NotNull NumberNDArray other, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.times$suspendImpl(this, other, $completion);
    }

    static /* synthetic */ Object times$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, Continuation<? super MutablePrimitiveNDArray> $completion) {
        int[][] nArrayArray = new int[][]{$this.getShape(), other.getShape()};
        int[] destShape = NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)));
        return $this.times(other, (MutableNumberNDArray)new MutablePrimitiveNDArray(destShape), $completion);
    }

    @Nullable
    public Object times(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.times$suspendImpl(this, other, destination, $completion);
    }

    static /* synthetic */ Object times$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, MutableNumberNDArray destination, Continuation<? super MutablePrimitiveNDArray> $completion) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
        PrimitiveNDArray primitiveNDArray = (PrimitiveNDArray)other;
        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        return BroadcastTwoArgumentsPrimitiveKt.broadcastTwoTensorsPrimitive($this, primitiveNDArray, (MutablePrimitiveNDArray)destination, (Function2<? super PrimitiveType, ? super PrimitiveType, ? extends PrimitiveType>)((Function2)times.3.INSTANCE), $completion);
    }

    @Nullable
    public Object div(@NotNull NumberNDArray other, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.div$suspendImpl(this, other, $completion);
    }

    static /* synthetic */ Object div$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, Continuation<? super MutablePrimitiveNDArray> $completion) {
        int[][] nArrayArray = new int[][]{$this.getShape(), other.getShape()};
        int[] destShape = NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])nArrayArray)));
        return $this.div(other, (MutableNumberNDArray)new MutablePrimitiveNDArray(destShape), $completion);
    }

    @Nullable
    public Object div(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.div$suspendImpl(this, other, destination, $completion);
    }

    static /* synthetic */ Object div$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, MutableNumberNDArray destination, Continuation<? super MutablePrimitiveNDArray> $completion) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
        PrimitiveNDArray primitiveNDArray = (PrimitiveNDArray)other;
        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        return BroadcastTwoArgumentsPrimitiveKt.broadcastTwoTensorsPrimitive($this, primitiveNDArray, (MutablePrimitiveNDArray)destination, (Function2<? super PrimitiveType, ? super PrimitiveType, ? extends PrimitiveType>)((Function2)div.3.INSTANCE), $completion);
    }

    @Nullable
    public Object dot(@NotNull NumberNDArray other, @NotNull MutableNumberNDArray destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.dot$suspendImpl(this, other, destination, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object dot$suspendImpl(PrimitiveNDArray var0, NumberNDArray var1_1, MutableNumberNDArray var2_2, Continuation<? super MutablePrimitiveNDArray> var3_3) {
        block26: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                if (!(var3_3 instanceof dot.1)) ** GOTO lbl-1000
                                var14_4 = var3_3;
                                if ((var14_4.label & -2147483648) != 0) {
                                    var14_4.label -= -2147483648;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    $continuation = new ContinuationImpl(var0, var3_3){
                                        Object L$0;
                                        Object L$1;
                                        /* synthetic */ Object result;
                                        final /* synthetic */ PrimitiveNDArray this$0;
                                        int label;
                                        {
                                            this.this$0 = this$0;
                                            super($completion);
                                        }

                                        @Nullable
                                        public final Object invokeSuspend(@NotNull Object $result) {
                                            this.result = $result;
                                            this.label |= Integer.MIN_VALUE;
                                            return PrimitiveNDArray.dot$suspendImpl(this.this$0, null, null, (Continuation<? super MutablePrimitiveNDArray>)((Continuation)this));
                                        }
                                    };
                                }
                                $result = $continuation.result;
                                var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch ($continuation.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
                                        (PrimitiveNDArray)other;
                                        Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
                                        (MutablePrimitiveNDArray)destination;
                                        var4_7 = $this.getShape().length;
                                        v0 = 1 <= var4_7 ? var4_7 < 3 : false;
                                        if (!v0) ** GOTO lbl-1000
                                        var4_7 = other.getShape().length;
                                        v1 = 1 <= var4_7 ? var4_7 < 3 : false;
                                        if (v1) {
                                            v2 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v2 = false;
                                        }
                                        if (!v2) {
                                            var5_9 = "Failed requirement.";
                                            throw new IllegalArgumentException(var5_9.toString());
                                        }
                                        if ($this.getShape().length != 1) break;
                                        var5_10 = new int[]{1, $this.getShape()[0]};
                                        $continuation.L$0 = other;
                                        $continuation.L$1 = destination;
                                        $continuation.label = 1;
                                        v3 = $this.reshape(var5_10, (Continuation<? super PrimitiveNDArray>)$continuation);
                                        if (v3 == var15_6) {
                                            return var15_6;
                                        }
                                        ** GOTO lbl44
                                    }
                                    case 1: {
                                        destination = (MutableNumberNDArray)$continuation.L$1;
                                        other = (NumberNDArray)$continuation.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v3 = $result;
lbl44:
                                        // 2 sources

                                        v4 = (PrimitiveNDArray)v3;
                                        break block21;
                                    }
                                }
                                v4 = actualThis = var0;
                            }
                            if (other.getShape().length != 1) break block22;
                            var6_11 = new int[]{1, other.getShape()[0]};
                            $continuation.L$0 = destination;
                            $continuation.L$1 = actualThis;
                            $continuation.label = 2;
                            v5 = ((PrimitiveNDArray)other).reshape(var6_11, (Continuation<? super PrimitiveNDArray>)$continuation);
                            if (v5 == var15_6) {
                                return var15_6;
                            }
                            ** GOTO lbl62
                            {
                                case 2: {
                                    actualThis = (PrimitiveNDArray)$continuation.L$1;
                                    destination = (MutableNumberNDArray)$continuation.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v5 = $result;
lbl62:
                                    // 2 sources

                                    v6 = (PrimitiveNDArray)v5;
                                    break block23;
                                }
                            }
                        }
                        v6 = actualOther = (PrimitiveNDArray)other;
                    }
                    if (!(actualThis.getShape()[1] == actualOther.getShape()[0])) {
                        var7_13 = "Failed requirement.";
                        throw new IllegalArgumentException(var7_13.toString());
                    }
                    n = actualThis.getShape()[0];
                    if (n * (t = actualThis.getShape()[1]) * (m = actualOther.getShape()[1]) < 0x10000000) break block24;
                    $continuation.L$0 = null;
                    $continuation.L$1 = null;
                    $continuation.label = 3;
                    v7 = PrimitiveDotResizeParallelKt.dotResizeParallel(actualThis, actualOther, (MutablePrimitiveNDArray)destination, (Continuation<? super MutablePrimitiveNDArray>)$continuation);
                    if (v7 == var15_6) {
                        return var15_6;
                    }
                    ** GOTO lbl82
                    {
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl82:
                            // 2 sources

                            return v7;
                        }
                    }
                }
                rdBlocksInRow = actualOther.getBlocksInRow$ndarray_core();
                rdBlockSize = actualOther.array.getBlockSize();
                countCoroutinesForNParallelization = UtilsKt.countCoroutinesByData(t * m, n, 261120);
                countCoroutinesForMParallelization = UtilsKt.countCoroutinesByData(rdBlockSize * n * t, rdBlocksInRow, 261120);
                if (countCoroutinesForNParallelization <= 1) break block25;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 4;
                v8 = PrimitiveDotParallelNKt.dotParallelN(actualThis, actualOther, (MutablePrimitiveNDArray)destination, (Continuation<? super MutablePrimitiveNDArray>)$continuation);
                if (v8 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl100
                {
                    case 4: {
                        ResultKt.throwOnFailure((Object)$result);
                        v8 = $result;
lbl100:
                        // 2 sources

                        return v8;
                    }
                }
            }
            if (countCoroutinesForMParallelization <= 1) break block26;
            $continuation.L$0 = null;
            $continuation.L$1 = null;
            $continuation.label = 5;
            v9 = PrimitiveDotParallelMKt.dotParallelM(actualThis, actualOther, (MutablePrimitiveNDArray)destination, (Continuation<? super MutablePrimitiveNDArray>)$continuation);
            if (v9 == var15_6) {
                return var15_6;
            }
            ** GOTO lbl113
            {
                case 5: {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl113:
                    // 2 sources

                    return v9;
                }
            }
        }
        $continuation.L$0 = null;
        $continuation.L$1 = null;
        $continuation.label = 6;
        v10 = PrimitiveDotParallelNKt.dotParallelN(actualThis, actualOther, (MutablePrimitiveNDArray)destination, (Continuation<? super MutablePrimitiveNDArray>)$continuation);
        if (v10 == var15_6) {
            return var15_6;
        }
        ** GOTO lbl125
        {
            case 6: {
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl125:
                // 2 sources

                return v10;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object dot(@NotNull NumberNDArray other, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.dot$suspendImpl(this, other, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object dot$suspendImpl(PrimitiveNDArray $this, NumberNDArray other, Continuation<? super MutablePrimitiveNDArray> $completion) {
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
        (PrimitiveNDArray)other;
        var3_3 = $this.getShape().length;
        v0 = 1 <= var3_3 ? var3_3 < 3 : false;
        if (!v0) ** GOTO lbl-1000
        var3_3 = other.getShape().length;
        v1 = 1 <= var3_3 ? var3_3 < 3 : false;
        if (v1) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        if (!v2) {
            var4_5 = "Failed requirement.";
            throw new IllegalArgumentException(var4_5.toString());
        }
        var4_6 = new int[]{$this.getShape()[0], other.getShape()[1]};
        destination = new MutablePrimitiveNDArray(var4_6);
        return $this.dot(other, (MutableNumberNDArray)destination, $completion);
    }

    @Nullable
    public Object matmul(@NotNull NumberNDArray other, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.matmul$suspendImpl(this, other, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object matmul$suspendImpl(PrimitiveNDArray var0, NumberNDArray var1_1, Continuation<? super MutablePrimitiveNDArray> var2_2) {
        if (!(var2_2 instanceof matmul.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ PrimitiveNDArray this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PrimitiveNDArray.matmul$suspendImpl(this.this$0, null, (Continuation<? super MutablePrimitiveNDArray>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArrayCore");
                (NumberNDArrayCore)other;
                outputShape = Broadcasting.INSTANCE.broadcastShapeForMatmul($this.getShape(), other.getShape());
                outputArray = new MutablePrimitiveNDArray(outputShape);
                $continuation.label = 1;
                v0 = MatrixKt.matmul($this, (NumberNDArrayCore)other, outputArray, (Function4<? super NumberNDArrayCore, ? super NumberNDArrayCore, ? super MutableNumberNDArrayCore, ? super Continuation<? super MutableNumberNDArrayCore>, ? extends Object>)((Function4)new Function4<NumberNDArrayCore, NumberNDArrayCore, MutableNumberNDArrayCore, Continuation<? super MutableNumberNDArrayCore>, Object>(null){
                    int label;
                    private /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;
                    /* synthetic */ Object L$2;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                NumberNDArrayCore $this$matmul = (NumberNDArrayCore)this.L$0;
                                NumberNDArrayCore otherArray = (NumberNDArrayCore)this.L$1;
                                MutableNumberNDArrayCore dest = (MutableNumberNDArrayCore)this.L$2;
                                this.L$0 = null;
                                this.L$1 = null;
                                this.label = 1;
                                Object object3 = $this$matmul.dot(otherArray, dest, (Continuation<? super MutableNumberNDArrayCore>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull NumberNDArrayCore p1, @NotNull NumberNDArrayCore p2, @NotNull MutableNumberNDArrayCore p3, @Nullable Continuation<? super MutableNumberNDArrayCore> p4) {
                        var var5_5 = new /* invalid duplicate definition of identical inner class */;
                        var5_5.L$0 = p1;
                        var5_5.L$1 = p2;
                        var5_5.L$2 = p3;
                        return var5_5.invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super MutableNumberNDArrayCore>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
                return (MutablePrimitiveNDArray)v0;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object matmul(@NotNull NumberNDArray other, @NotNull MutableNumberNDArrayCore destination, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.matmul$suspendImpl(this, other, destination, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object matmul$suspendImpl(PrimitiveNDArray var0, NumberNDArray var1_1, MutableNumberNDArrayCore var2_2, Continuation<? super MutablePrimitiveNDArray> var3_3) {
        if (!(var3_3 instanceof matmul.3)) ** GOTO lbl-1000
        var5_4 = var3_3;
        if ((var5_4.label & -2147483648) != 0) {
            var5_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ PrimitiveNDArray this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PrimitiveNDArray.matmul$suspendImpl(this.this$0, null, null, (Continuation<? super MutablePrimitiveNDArray>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.NumberNDArrayCore");
                (NumberNDArrayCore)other;
                $continuation.label = 1;
                v0 = MatrixKt.matmul($this, (NumberNDArrayCore)other, (MutableNumberNDArrayCore)destination, (Function4<? super NumberNDArrayCore, ? super NumberNDArrayCore, ? super MutableNumberNDArrayCore, ? super Continuation<? super MutableNumberNDArrayCore>, ? extends Object>)((Function4)new Function4<NumberNDArrayCore, NumberNDArrayCore, MutableNumberNDArrayCore, Continuation<? super MutableNumberNDArrayCore>, Object>(null){
                    int label;
                    private /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;
                    /* synthetic */ Object L$2;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                NumberNDArrayCore $this$matmul = (NumberNDArrayCore)this.L$0;
                                NumberNDArrayCore otherArray = (NumberNDArrayCore)this.L$1;
                                MutableNumberNDArrayCore dest = (MutableNumberNDArrayCore)this.L$2;
                                this.L$0 = null;
                                this.L$1 = null;
                                this.label = 1;
                                Object object3 = $this$matmul.dot(otherArray, dest, (Continuation<? super MutableNumberNDArrayCore>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull NumberNDArrayCore p1, @NotNull NumberNDArrayCore p2, @NotNull MutableNumberNDArrayCore p3, @Nullable Continuation<? super MutableNumberNDArrayCore> p4) {
                        var var5_5 = new /* invalid duplicate definition of identical inner class */;
                        var5_5.L$0 = p1;
                        var5_5.L$1 = p2;
                        var5_5.L$2 = p3;
                        return var5_5.invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super MutableNumberNDArrayCore>)$continuation);
                if (v0 == var6_6) {
                    return var6_6;
                }
                ** GOTO lbl23
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
                return (MutablePrimitiveNDArray)v0;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object gemm(int m, int n, int k2, double alpha2, int lda, @NotNull NDArray b, int ldb, double beta2, @NotNull MutableNDArray c, int ldc, int aOffset, int bOffset, int cOffset, boolean transposeA, boolean transposeB, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.gemm$suspendImpl(this, m, n, k2, alpha2, lda, b, ldb, beta2, c, ldc, aOffset, bOffset, cOffset, transposeA, transposeB, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object gemm$suspendImpl(PrimitiveNDArray $this, int m, int n, int k2, double alpha2, int lda, NDArray b, int ldb, double beta2, MutableNDArray c, int ldc, int aOffset, int bOffset, int cOffset, boolean transposeA, boolean transposeB, Continuation<? super MutablePrimitiveNDArray> $completion) {
        PrimitiveType primitiveType;
        Object object;
        int n2;
        Intrinsics.checkNotNull((Object)b, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
        PrimitiveNDArray cfr_ignored_0 = (PrimitiveNDArray)b;
        Intrinsics.checkNotNull((Object)c, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
        MutablePrimitiveNDArray cfr_ignored_1 = (MutablePrimitiveNDArray)c;
        PrimitiveType betaPrimitive = ExtensionsKt.toPrimitive(Boxing.boxDouble((double)beta2));
        PrimitiveType alphaPrimitive = ExtensionsKt.toPrimitive(Boxing.boxDouble((double)alpha2));
        PrimitivePointer aPointer = PrimitiveTiledArray.pointer$default($this.array, 0, 1, null);
        PrimitivePointer bPointer = PrimitiveTiledArray.pointer$default(((PrimitiveNDArray)b).array, 0, 1, null);
        PrimitivePointer cPointer = PrimitiveTiledArray.pointer$default(((MutablePrimitiveNDArray)c).getArray(), 0, 1, null);
        if (!(beta2 == 1.0)) {
            for (int i = 0; i < m; ++i) {
                int offset$iv;
                PrimitiveArray block$iv;
                cPointer.setLinearIndex(i * ldc + cOffset);
                PrimitivePointer $this$map$iv = cPointer;
                boolean $i$f$map = false;
                for (int end$iv = n; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                    block$iv = $this$map$iv.getCurrentBlock();
                    offset$iv = $this$map$iv.getIndexInBlock();
                    if (block$iv.getSize() <= offset$iv + end$iv) {
                        $this$map$iv.blockIncrement();
                    } else {
                        $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                    }
                    int index$iv = offset$iv;
                    int n3 = Math.min(block$iv.getSize(), offset$iv + end$iv);
                    while (index$iv < n3) {
                        void it;
                        PrimitiveType primitiveType2 = block$iv.get(index$iv);
                        n2 = index$iv++;
                        object = block$iv;
                        boolean bl = false;
                        primitiveType = betaPrimitive.times((PrimitiveType)it).toPrimitive();
                        ((PrimitiveArray)object).set(n2, primitiveType);
                    }
                }
            }
        }
        if (transposeA && transposeB) {
            for (t = 0; t < m; ++t) {
                for (int j = 0; j < n; ++j) {
                    cPointer.setLinearIndex(t * ldc + j + cOffset);
                    for (i = 0; i < k2; ++i) {
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex(j * ldb + i + bOffset);
                        cPointer.set(alphaPrimitive.times(aPointer.get()).times(bPointer.get()).plus(cPointer.get()).toPrimitive());
                    }
                }
            }
        } else if (transposeA) {
            for (t = 0; t < m; ++t) {
                for (int j = 0; j < n; ++j) {
                    cPointer.setLinearIndex(t * ldc + j + cOffset);
                    for (i = 0; i < k2; ++i) {
                        aPointer.setLinearIndex(i * lda + t + aOffset);
                        bPointer.setLinearIndex(i * ldb + j + bOffset);
                        cPointer.set(alphaPrimitive.times(aPointer.get()).times(bPointer.get()).plus(cPointer.get()).toPrimitive());
                    }
                }
            }
        } else if (transposeB) {
            for (t = 0; t < m; ++t) {
                int aIdx = t * lda + aOffset;
                cPointer.setLinearIndex(t * ldc + cOffset);
                for (int j = 0; j < n; ++j) {
                    aPointer.setLinearIndex(aIdx);
                    bPointer.setLinearIndex(j * ldb + bOffset);
                    PrimitivePointer $this$combine$iv = aPointer;
                    boolean $i$f$combine = false;
                    if (!PrimitivePointerKt.isCompatibleBySize($this$combine$iv, bPointer, k2)) {
                        boolean $i$a$-require-PrimitivePointerKt$combine$1$iv22 = false;
                        String $i$a$-require-PrimitivePointerKt$combine$1$iv22 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$combine$1$iv22.toString());
                    }
                    if (PrimitivePointerKt.isCompatibleWith($this$combine$iv, bPointer)) {
                        int fstOffset$iv;
                        PrimitiveArray fstBlock$iv;
                        for (end$iv = k2; end$iv > 0; end$iv -= fstBlock$iv.getSize() - fstOffset$iv) {
                            fstBlock$iv = $this$combine$iv.getCurrentBlock();
                            fstOffset$iv = $this$combine$iv.getIndexInBlock();
                            PrimitiveArray sndBlock$iv = bPointer.getCurrentBlock();
                            if (fstBlock$iv.getSize() <= fstOffset$iv + end$iv) {
                                $this$combine$iv.blockIncrement();
                                bPointer.blockIncrement();
                            } else {
                                $this$combine$iv.setIndexInBlock($this$combine$iv.getIndexInBlock() + end$iv);
                                bPointer.setIndexInBlock(bPointer.getIndexInBlock() + end$iv);
                            }
                            int n4 = Math.min(fstBlock$iv.getSize(), fstOffset$iv + end$iv);
                            for (int index$iv = fstOffset$iv; index$iv < n4; ++index$iv) {
                                PrimitiveType primitiveType3 = sndBlock$iv.get(index$iv);
                                elementInA = fstBlock$iv.get(index$iv);
                                primitiveType4 = false;
                                cPointer.set(alphaPrimitive.times(elementInA).times(elementInB).plus(cPointer.get()).toPrimitive());
                            }
                        }
                    } else {
                        while (end$iv > 0) {
                            elementInB = bPointer.getAndIncrement();
                            elementInA = $this$combine$iv.getAndIncrement();
                            primitiveType4 = false;
                            cPointer.set(alphaPrimitive.times(elementInA).times(elementInB).plus(cPointer.get()).toPrimitive());
                            --end$iv;
                        }
                    }
                    cPointer.increment();
                }
            }
        } else {
            for (t = 0; t < m; ++t) {
                int cIdx = t * ldc + cOffset;
                aPointer.setLinearIndex(t * lda + aOffset);
                for (i = 0; i < k2; ++i) {
                    PrimitiveType elementInC;
                    PrimitiveType elementInB;
                    boolean bl;
                    int end$iv;
                    PrimitiveType temp = alphaPrimitive.times(aPointer.getAndIncrement()).toPrimitive();
                    bPointer.setLinearIndex(i * ldb + bOffset);
                    cPointer.setLinearIndex(cIdx);
                    PrimitivePointer $this$accept$iv = cPointer;
                    boolean $i$f$accept = false;
                    if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, bPointer, n)) {
                        boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
                        String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
                    }
                    if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, bPointer)) {
                        int dstOffset$iv;
                        PrimitiveArray dstBlock$iv;
                        for (end$iv = n; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            PrimitiveArray srcBlock$iv = bPointer.getCurrentBlock();
                            if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                                $this$accept$iv.blockIncrement();
                                bPointer.blockIncrement();
                            } else {
                                $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                                bPointer.setIndexInBlock(bPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv = dstOffset$iv;
                            int n5 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                            while (index$iv < n5) {
                                PrimitiveType elementInA = srcBlock$iv.get(index$iv);
                                PrimitiveType primitiveType4 = dstBlock$iv.get(index$iv);
                                n2 = index$iv++;
                                object = dstBlock$iv;
                                bl = false;
                                primitiveType = temp.times(elementInB).plus(elementInC).toPrimitive();
                                ((PrimitiveArray)object).set(n2, primitiveType);
                            }
                        }
                        continue;
                    }
                    while (end$iv > 0) {
                        elementInB = bPointer.getAndIncrement();
                        elementInC = $this$accept$iv.get();
                        object = $this$accept$iv;
                        bl = false;
                        ((PrimitivePointer)object).set(temp.times(elementInB).plus(elementInC).toPrimitive());
                        $this$accept$iv.increment();
                        --end$iv;
                    }
                }
            }
        }
        return c;
    }

    @Nullable
    public Object argmax(int axis2, boolean keepDims2, boolean selectLastIndex2, @NotNull Continuation<? super IntNDArray> $completion) {
        return PrimitiveNDArray.argmax$suspendImpl(this, axis2, keepDims2, selectLastIndex2, $completion);
    }

    static /* synthetic */ Object argmax$suspendImpl(PrimitiveNDArray $this, int axis2, boolean keepDims2, boolean selectLastIndex2, Continuation<? super IntNDArray> $completion) {
        return PrimitiveArgMinMaxKt.argMinMaxPrimitive($this, axis2, keepDims2, selectLastIndex2, ArgMinMaxMode.MAX);
    }

    @Nullable
    public Object argmin(int axis2, boolean keepDims2, boolean selectLastIndex2, @NotNull Continuation<? super IntNDArray> $completion) {
        return PrimitiveNDArray.argmin$suspendImpl(this, axis2, keepDims2, selectLastIndex2, $completion);
    }

    static /* synthetic */ Object argmin$suspendImpl(PrimitiveNDArray $this, int axis2, boolean keepDims2, boolean selectLastIndex2, Continuation<? super IntNDArray> $completion) {
        return PrimitiveArgMinMaxKt.argMinMaxPrimitive($this, axis2, keepDims2, selectLastIndex2, ArgMinMaxMode.MIN);
    }

    /*
     * WARNING - void declaration
     */
    private final PrimitiveNDArray findComparable(int axis2, boolean keepDims2, Function2<? super PrimitiveType, ? super PrimitiveType, Boolean> compare) {
        int[] nArray;
        int actualAxis = NDArrayUtilsKt.indexAxis(this, axis2);
        int countIterations = NDArrayUtilsKt.computeBlockSize$default(this, 0, actualAxis, 1, null);
        int countElements = NDArrayUtilsKt.computeBlockSize$default(this, actualAxis + 1, 0, 2, null);
        int countDims = this.getShape()[actualAxis];
        if (keepDims2) {
            int[] nArray2;
            int[] nArray3 = this.getShape();
            int[] nArray4 = Arrays.copyOf(nArray3, nArray3.length);
            Intrinsics.checkNotNullExpressionValue((Object)nArray4, (String)"copyOf(...)");
            int[] $this$findComparable_u24lambda_u2413 = nArray2 = nArray4;
            boolean bl = false;
            $this$findComparable_u24lambda_u2413[actualAxis] = 1;
            nArray = nArray2;
        } else {
            nArray = ArraysKt.sliceArray((int[])this.getShape(), (Collection)CollectionsKt.minus((Iterable)((Iterable)ArraysKt.getIndices((int[])this.getShape())), (Object)actualAxis));
        }
        int[] outputShape2 = nArray;
        PrimitiveNDArray outputArray2 = new PrimitiveNDArray(new Strides(outputShape2));
        PrimitivePointer inputPointer = PrimitiveTiledArray.pointer$default(this.array, 0, 1, null);
        if (actualAxis == ArraysKt.getLastIndex((int[])this.getShape()) || countElements == 1) {
            PrimitivePointer outputPointer = PrimitiveTiledArray.pointer$default(outputArray2.array, 0, 1, null);
            for (int i = 0; i < countIterations; ++i) {
                int offset$iv;
                PrimitiveArray block$iv;
                PrimitiveType result2 = null;
                result2 = inputPointer.getAndIncrement();
                PrimitivePointer primitivePointer = inputPointer;
                int count$iv = countDims - 1;
                boolean $i$f$forEach = false;
                for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                    void $this$forEach$iv;
                    block$iv = $this$forEach$iv.getCurrentBlock();
                    offset$iv = $this$forEach$iv.getIndexInBlock();
                    if (block$iv.getSize() <= offset$iv + end$iv) {
                        $this$forEach$iv.blockIncrement();
                    } else {
                        $this$forEach$iv.setIndexInBlock($this$forEach$iv.getIndexInBlock() + end$iv);
                    }
                    int n = Math.min(block$iv.getSize(), offset$iv + end$iv);
                    for (int index$iv = offset$iv; index$iv < n; ++index$iv) {
                        PrimitiveType value = block$iv.get(index$iv);
                        boolean bl = false;
                        if (!((Boolean)compare.invoke((Object)value, (Object)result2)).booleanValue()) continue;
                        result2 = value;
                    }
                }
                outputPointer.set(result2);
                outputPointer.increment();
            }
            return outputArray2;
        }
        for (int i = 0; i < countIterations; ++i) {
            PrimitiveType primitiveType;
            Object object;
            int n;
            int index$iv;
            PrimitivePointer outputPointer;
            PrimitivePointer $this$accept$iv = outputPointer = outputArray2.array.pointer(i * countElements);
            boolean $i$f$accept = false;
            if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer, countElements)) {
                boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
                String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
            }
            if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer)) {
                int dstOffset$iv;
                PrimitiveArray dstBlock$iv;
                for (end$iv = countElements; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                    PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                    if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                        $this$accept$iv.blockIncrement();
                        inputPointer.blockIncrement();
                    } else {
                        $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                        inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                    }
                    int index$iv2 = dstOffset$iv;
                    index$iv = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                    while (index$iv2 < index$iv) {
                        void src;
                        dstBlock$iv.get(index$iv2);
                        PrimitiveType primitiveType2 = srcBlock$iv.get(index$iv2);
                        n = index$iv2++;
                        object = dstBlock$iv;
                        boolean bl = false;
                        primitiveType = src;
                        ((PrimitiveArray)object).set(n, primitiveType);
                    }
                }
            } else {
                while (end$iv > 0) {
                    $this$accept$iv.get();
                    PrimitiveType src = inputPointer.getAndIncrement();
                    object = $this$accept$iv;
                    boolean bl2 = false;
                    ((PrimitivePointer)object).set(src);
                    $this$accept$iv.increment();
                    --end$iv;
                }
            }
            for (int j = 1; j < countDims; ++j) {
                PrimitiveType src;
                boolean bl;
                int end$iv;
                outputPointer.setLinearIndex(i * countElements);
                PrimitivePointer $this$accept$iv2 = outputPointer;
                boolean $i$f$accept2 = false;
                if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv2, inputPointer, countElements)) {
                    boolean $i$a$-require-PrimitivePointerKt$accept$1$iv32 = false;
                    String $i$a$-require-PrimitivePointerKt$accept$1$iv32 = "Pointers not compatible by available elements";
                    throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv32.toString());
                }
                if (PrimitivePointerKt.isCompatibleWith($this$accept$iv2, inputPointer)) {
                    int dstOffset$iv;
                    PrimitiveArray dstBlock$iv;
                    for (end$iv = countElements; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                        dstBlock$iv = $this$accept$iv2.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv2.getIndexInBlock();
                        PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                        if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                            $this$accept$iv2.blockIncrement();
                            inputPointer.blockIncrement();
                        } else {
                            $this$accept$iv2.setIndexInBlock($this$accept$iv2.getIndexInBlock() + end$iv);
                            inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                        }
                        int n2 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                        for (index$iv = dstOffset$iv; index$iv < n2; ++index$iv) {
                            void dst;
                            PrimitiveType value = srcBlock$iv.get(index$iv);
                            PrimitiveType bl2 = dstBlock$iv.get(index$iv);
                            n = index$iv;
                            object = dstBlock$iv;
                            bl = false;
                            primitiveType = ((Boolean)compare.invoke((Object)src, (Object)dst)).booleanValue() ? src : dst;
                            ((PrimitiveArray)object).set(n, primitiveType);
                        }
                    }
                    continue;
                }
                while (end$iv > 0) {
                    src = inputPointer.getAndIncrement();
                    PrimitiveType dst = $this$accept$iv2.get();
                    object = $this$accept$iv2;
                    bl = false;
                    ((PrimitivePointer)object).set(((Boolean)compare.invoke((Object)src, (Object)dst)).booleanValue() ? src : dst);
                    $this$accept$iv2.increment();
                    --end$iv;
                }
            }
        }
        return outputArray2;
    }

    @Nullable
    public Object max(int axis2, boolean keepDims2, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return this.findComparable(axis2, keepDims2, (Function2<? super PrimitiveType, ? super PrimitiveType, Boolean>)((Function2)max.3.INSTANCE));
    }

    @Nullable
    public Object reduceSum(@NotNull int[] axes2, boolean keepDims2, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.reduceSum$suspendImpl(this, axes2, keepDims2, $completion);
    }

    static /* synthetic */ Object reduceSum$suspendImpl(PrimitiveNDArray $this, int[] axes2, boolean keepDims2, Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveReduceOperationKt.reduceOperationPrimitive$default($this, axes2, keepDims2, null, reduceSum.2.INSTANCE, 4, null);
    }

    @Nullable
    public Object topK(int axis2, int k2, boolean largest2, boolean sorted2, @NotNull Continuation<? super Pair<? extends PrimitiveNDArray, ? extends LongNDArray>> $completion) {
        return PrimitiveNDArray.topK$suspendImpl(this, axis2, k2, largest2, sorted2, $completion);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object topK$suspendImpl(PrimitiveNDArray $this, int axis2, int k2, boolean largest2, boolean sorted2, Continuation<? super Pair<? extends PrimitiveNDArray, ? extends LongNDArray>> $completion) {
        void $this$fold$iv;
        int acc;
        int element$iv;
        void $this$fold$iv2;
        int[] nArray;
        int actualAxis = NDArrayUtilsKt.indexAxis($this, axis2);
        int[] nArray2 = $this.getShape();
        int[] nArray3 = Arrays.copyOf(nArray2, nArray2.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray3, (String)"copyOf(...)");
        int[] $this$topK_u24lambda_u2417 = nArray = nArray3;
        boolean bl = false;
        $this$topK_u24lambda_u2417[actualAxis] = k2;
        Unit unit = Unit.INSTANCE;
        int[] nArray4 = nArray;
        Strides outputStrides = new Strides(nArray4);
        PrimitiveNDArray outputArray2 = new PrimitiveNDArray(outputStrides);
        MutableLongNDArray indicesArray = new MutableLongNDArray(outputStrides);
        int[] nArray5 = ArraysKt.sliceArray((int[])$this.getShape(), (IntRange)RangesKt.until((int)0, (int)actualAxis));
        int initial$iv22 = 1;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv22;
        int n = ((void)$this$fold$iv2).length;
        for (int i = 0; i < n; ++i) {
            void i2;
            element$iv = $this$fold$iv2[i];
            void var18_30 = element$iv;
            acc = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = acc * i2;
        }
        int countIterations = accumulator$iv;
        int[] initial$iv22 = ArraysKt.sliceArray((int[])$this.getShape(), (IntRange)RangesKt.until((int)(actualAxis + 1), (int)$this.getRank()));
        int initial$iv = 1;
        boolean $i$f$fold2 = false;
        int accumulator$iv2 = initial$iv;
        element$iv = ((void)$this$fold$iv).length;
        for (n = 0; n < element$iv; ++n) {
            void i;
            void element$iv2 = $this$fold$iv[n];
            acc = element$iv2;
            int acc2 = accumulator$iv2;
            boolean bl3 = false;
            accumulator$iv2 = acc2 * i;
        }
        int countElements = accumulator$iv2;
        int countDims = $this.getShape()[actualAxis];
        PrimitivePointer inputPointer = PrimitiveTiledArray.pointer$default($this.array, 0, 1, null);
        PrimitivePointer outputPointer = PrimitiveTiledArray.pointer$default(outputArray2.array, 0, 1, null);
        LongPointer outputIndicesPointer = LongTiledArray.pointer$default(indicesArray.getArray(), 0, 1, null);
        if (k2 == 1 && actualAxis == ArraysKt.getLastIndex((int[])$this.getShape())) {
            if (largest2) {
                for (n = 0; n < countIterations; ++n) {
                    int offset$iv;
                    PrimitiveArray block$iv;
                    it = n;
                    boolean bl4 = false;
                    PrimitiveType maximum = null;
                    maximum = inputPointer.getAndIncrement();
                    int maximumIndex = 0;
                    PrimitivePointer bl3 = inputPointer;
                    int n2 = countDims - 1;
                    int startIndex$iv = 1;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (void end$iv = count$iv; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                        void $this$forEachIndexed$iv;
                        block$iv = $this$forEachIndexed$iv.getCurrentBlock();
                        offset$iv = $this$forEachIndexed$iv.getIndexInBlock();
                        if (block$iv.getSize() <= offset$iv + end$iv) {
                            $this$forEachIndexed$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed$iv.setIndexInBlock($this$forEachIndexed$iv.getIndexInBlock() + end$iv);
                        }
                        int n3 = Math.min(block$iv.getSize(), offset$iv + end$iv);
                        for (int index$iv = offset$iv; index$iv < n3; ++index$iv) {
                            void value;
                            int n4 = idx$iv++;
                            PrimitiveType primitiveType = block$iv.get(index$iv);
                            int index = n4;
                            boolean bl5 = false;
                            if (value.compareTo(maximum) <= 0) continue;
                            maximum = value;
                            maximumIndex = index;
                        }
                    }
                    outputPointer.set(maximum);
                    outputPointer.increment();
                    outputIndicesPointer.set(maximumIndex);
                    outputIndicesPointer.increment();
                }
            } else {
                for (n = 0; n < countIterations; ++n) {
                    int offset$iv;
                    PrimitiveArray block$iv;
                    it = n;
                    boolean bl6 = false;
                    PrimitiveType minimum = null;
                    minimum = inputPointer.getAndIncrement();
                    int minimumIndex = 0;
                    PrimitivePointer $this$forEachIndexed$iv = inputPointer;
                    int count$iv = countDims - 1;
                    int startIndex$iv = 1;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (int end$iv = count$iv; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                        block$iv = $this$forEachIndexed$iv.getCurrentBlock();
                        offset$iv = $this$forEachIndexed$iv.getIndexInBlock();
                        if (block$iv.getSize() <= offset$iv + end$iv) {
                            $this$forEachIndexed$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed$iv.setIndexInBlock($this$forEachIndexed$iv.getIndexInBlock() + end$iv);
                        }
                        int n5 = Math.min(block$iv.getSize(), offset$iv + end$iv);
                        for (int index$iv2 = offset$iv; index$iv2 < n5; ++index$iv2) {
                            int n6 = idx$iv++;
                            PrimitiveType value = block$iv.get(index$iv2);
                            int index = n6;
                            boolean bl7 = false;
                            if (value.compareTo(minimum) >= 0) continue;
                            minimum = value;
                            minimumIndex = index;
                        }
                    }
                    outputPointer.set(minimum);
                    outputPointer.increment();
                    outputIndicesPointer.set(minimumIndex);
                    outputIndicesPointer.increment();
                }
            }
        } else if (k2 == 1) {
            if (largest2) {
                for (n = 0; n < countIterations; ++n) {
                    iteration = n;
                    boolean bl8 = false;
                    outputPointer.setLinearIndex(iteration * countElements);
                    PrimitivePointer $this$accept$iv = outputPointer;
                    $i$f$accept = false;
                    if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer, countElements)) {
                        boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
                        String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
                    }
                    if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer)) {
                        int dstOffset$iv;
                        PrimitiveArray dstBlock$iv;
                        for (end$iv = countElements; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                            if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                                $this$accept$iv.blockIncrement();
                                inputPointer.blockIncrement();
                            } else {
                                $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                                inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv = dstOffset$iv;
                            int idx$iv = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                            while (index$iv < idx$iv) {
                                dstBlock$iv.get(index$iv);
                                PrimitiveType block$iv = srcBlock$iv.get(index$iv);
                                int offset$iv = index$iv++;
                                index$iv2 = dstBlock$iv;
                                $i$a$-accept-PrimitiveNDArray$topK$4$1 = false;
                                PrimitiveType value = src;
                                ((PrimitiveArray)index$iv2).set(offset$iv, value);
                            }
                        }
                    } else {
                        while (end$iv > 0) {
                            $this$accept$iv.get();
                            src = inputPointer.getAndIncrement();
                            index$iv2 = $this$accept$iv;
                            $i$a$-accept-PrimitiveNDArray$topK$4$1 = false;
                            ((PrimitivePointer)index$iv2).set(src);
                            $this$accept$iv.increment();
                            --end$iv;
                        }
                    }
                    for (dim = 1; dim < countDims; ++dim) {
                        outputPointer.setLinearIndex(iteration * countElements);
                        outputIndicesPointer.setLinearIndex(iteration * countElements);
                        if (PrimitivePointerKt.isCompatibleWith(inputPointer, outputPointer)) {
                            PrimitivePointer $this$isCompatibleWith$iv = inputPointer;
                            boolean $i$f$isCompatibleWith = false;
                            throw new UnsupportedOperationException();
                        }
                        for (end = countElements; end > 0; --end) {
                            PrimitiveType outputValue;
                            PrimitiveType inputValue = inputPointer.getAndIncrement();
                            if (inputValue.compareTo(outputValue = outputPointer.get()) > 0) {
                                outputPointer.set(inputValue);
                                outputIndicesPointer.set(dim);
                            }
                            outputPointer.increment();
                            outputIndicesPointer.increment();
                        }
                    }
                }
            } else {
                for (n = 0; n < countIterations; ++n) {
                    iteration = n;
                    boolean bl9 = false;
                    outputPointer.setLinearIndex(iteration * countElements);
                    PrimitivePointer $this$accept$iv = outputPointer;
                    $i$f$accept = false;
                    if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer, countElements)) {
                        boolean $i$a$-require-PrimitivePointerKt$accept$1$iv32 = false;
                        String $i$a$-require-PrimitivePointerKt$accept$1$iv32 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv32.toString());
                    }
                    if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer)) {
                        int dstOffset$iv;
                        PrimitiveArray dstBlock$iv;
                        for (end$iv = countElements; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                            if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                                $this$accept$iv.blockIncrement();
                                inputPointer.blockIncrement();
                            } else {
                                $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                                inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv = dstOffset$iv;
                            int idx$iv = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                            while (index$iv < idx$iv) {
                                dstBlock$iv.get(index$iv);
                                src = srcBlock$iv.get(index$iv);
                                int offset$iv = index$iv++;
                                index$iv2 = dstBlock$iv;
                                $i$a$-accept-PrimitiveNDArray$topK$5$1 = false;
                                PrimitiveType value = src;
                                ((PrimitiveArray)index$iv2).set(offset$iv, value);
                            }
                        }
                    } else {
                        while (end$iv > 0) {
                            $this$accept$iv.get();
                            src = inputPointer.getAndIncrement();
                            index$iv2 = $this$accept$iv;
                            $i$a$-accept-PrimitiveNDArray$topK$5$1 = false;
                            ((PrimitivePointer)index$iv2).set(src);
                            $this$accept$iv.increment();
                            --end$iv;
                        }
                    }
                    for (dim = 1; dim < countDims; ++dim) {
                        outputPointer.setLinearIndex(iteration * countElements);
                        outputIndicesPointer.setLinearIndex(iteration * countElements);
                        if (PrimitivePointerKt.isCompatibleWith(inputPointer, outputPointer)) {
                            PrimitivePointer $this$isCompatibleWith$iv = inputPointer;
                            boolean $i$f$isCompatibleWith = false;
                            throw new UnsupportedOperationException();
                        }
                        for (end = countElements; end > 0; --end) {
                            PrimitiveType outputValue;
                            PrimitiveType inputValue = inputPointer.getAndIncrement();
                            if (inputValue.compareTo(outputValue = outputPointer.get()) < 0) {
                                outputPointer.set(inputValue);
                                outputIndicesPointer.set(dim);
                            }
                            outputPointer.increment();
                            outputIndicesPointer.increment();
                        }
                    }
                }
            }
        } else if (actualAxis == ArraysKt.getLastIndex((int[])$this.getShape())) {
            if (largest2) {
                PrimitiveMaxHeap maxHeap = new PrimitiveMaxHeap(k2);
                for (var17_29 = 0; var17_29 < countIterations; ++var17_29) {
                    long[] block$iv;
                    Object bl7;
                    int index;
                    int end$iv;
                    PrimitiveArray block$iv2;
                    Pair $this$forEachIndexed$iv;
                    PrimitiveArray block$iv3;
                    int index2;
                    int offset$iv;
                    int end$iv2;
                    int offset$iv2;
                    PrimitiveArray block$iv4;
                    it = var17_29;
                    boolean bl10 = false;
                    PrimitivePointer $this$forEachIndexed_u24default$iv = inputPointer;
                    int startIndex$iv = 0;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (end$iv2 = k2; end$iv2 > 0; end$iv2 -= block$iv4.getSize() - offset$iv2) {
                        block$iv4 = $this$forEachIndexed_u24default$iv.getCurrentBlock();
                        offset$iv2 = $this$forEachIndexed_u24default$iv.getIndexInBlock();
                        if (block$iv4.getSize() <= offset$iv2 + end$iv2) {
                            $this$forEachIndexed_u24default$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed_u24default$iv.setIndexInBlock($this$forEachIndexed_u24default$iv.getIndexInBlock() + end$iv2);
                        }
                        offset$iv = Math.min(block$iv4.getSize(), offset$iv2 + end$iv2);
                        for (int index$iv = offset$iv2; index$iv < offset$iv; ++index$iv) {
                            void value;
                            int n7 = idx$iv++;
                            PrimitiveType index$iv2 = block$iv4.get(index$iv);
                            index2 = n7;
                            boolean bl11 = false;
                            maxHeap.insert((PrimitiveType)value, index2);
                        }
                    }
                    $this$forEachIndexed_u24default$iv = inputPointer;
                    int count$iv = countDims - k2;
                    $i$f$forEachIndexed = false;
                    idx$iv = k2;
                    for (end$iv2 = count$iv; end$iv2 > 0; end$iv2 -= block$iv3.getSize() - offset$iv2) {
                        block$iv3 = $this$forEachIndexed$iv.getCurrentBlock();
                        offset$iv2 = $this$forEachIndexed$iv.getIndexInBlock();
                        if (block$iv3.getSize() <= offset$iv2 + end$iv2) {
                            $this$forEachIndexed$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed$iv.setIndexInBlock($this$forEachIndexed$iv.getIndexInBlock() + end$iv2);
                        }
                        offset$iv = Math.min(block$iv3.getSize(), offset$iv2 + end$iv2);
                        for (int index$iv = offset$iv2; index$iv < offset$iv; ++index$iv) {
                            int n8 = idx$iv++;
                            PrimitiveType value = block$iv3.get(index$iv);
                            index2 = n8;
                            boolean bl12 = false;
                            if (value.compareTo(maxHeap.getMinValue()) <= 0) continue;
                            maxHeap.removeMin();
                            maxHeap.insert(value, index2);
                        }
                    }
                    $this$forEachIndexed$iv = sorted2 ? maxHeap.sorted() : TuplesKt.to((Object)maxHeap.getData(), (Object)maxHeap.getIndices());
                    PrimitiveArray values = (PrimitiveArray)$this$forEachIndexed$iv.component1();
                    int[] indices = (int[])$this$forEachIndexed$iv.component2();
                    int outputIndex = 0;
                    Object $this$map$iv = outputPointer;
                    boolean $i$f$map = false;
                    for (end$iv = k2; end$iv > 0; end$iv -= block$iv2.getSize() - offset$iv) {
                        block$iv2 = ((PrimitivePointer)$this$map$iv).getCurrentBlock();
                        offset$iv = ((PrimitivePointer)$this$map$iv).getIndexInBlock();
                        if (block$iv2.getSize() <= offset$iv + end$iv) {
                            ((PrimitivePointer)$this$map$iv).blockIncrement();
                        } else {
                            ((PrimitivePointer)$this$map$iv).setIndexInBlock(((PrimitivePointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        index2 = Math.min(block$iv2.getSize(), offset$iv + end$iv);
                        while (index$iv < index2) {
                            PrimitiveType bl12 = block$iv2.get(index$iv);
                            index = index$iv++;
                            bl7 = block$iv2;
                            boolean bl13 = false;
                            int n9 = outputIndex;
                            outputIndex = n9 + 1;
                            PrimitiveType primitiveType = values.get(n9);
                            ((PrimitiveArray)bl7).set(index, primitiveType);
                        }
                    }
                    outputIndex = 0;
                    $this$map$iv = outputIndicesPointer;
                    $i$f$map = false;
                    for (end$iv = k2; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = ((LongPointer)$this$map$iv).getCurrentBlock();
                        if (block$iv.length <= (offset$iv = ((LongPointer)$this$map$iv).getIndexInBlock()) + end$iv) {
                            ((LongPointer)$this$map$iv).blockIncrement();
                        } else {
                            ((LongPointer)$this$map$iv).setIndexInBlock(((LongPointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv3 = offset$iv;
                        index2 = Math.min(block$iv.length, offset$iv + end$iv);
                        while (index$iv3 < index2) {
                            long l2 = block$iv[index$iv3];
                            index = index$iv3++;
                            bl7 = block$iv;
                            boolean bl14 = false;
                            int n10 = outputIndex;
                            outputIndex = n10 + 1;
                            long l3 = indices[n10];
                            bl7[index] = l3;
                        }
                    }
                    maxHeap.clear();
                }
            } else {
                PrimitiveMinHeap minHeap = new PrimitiveMinHeap(k2);
                for (var17_29 = 0; var17_29 < countIterations; ++var17_29) {
                    long[] block$iv;
                    Object bl7;
                    int index;
                    int end$iv;
                    PrimitiveArray block$iv5;
                    Pair $this$forEachIndexed$iv;
                    PrimitiveArray block$iv6;
                    int index3;
                    int offset$iv;
                    int end$iv3;
                    int offset$iv3;
                    PrimitiveArray block$iv7;
                    it = var17_29;
                    $i$a$-repeat-PrimitiveNDArray$topK$7 = 0;
                    PrimitivePointer $this$forEachIndexed_u24default$iv = inputPointer;
                    int startIndex$iv = 0;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (end$iv3 = k2; end$iv3 > 0; end$iv3 -= block$iv7.getSize() - offset$iv3) {
                        block$iv7 = $this$forEachIndexed_u24default$iv.getCurrentBlock();
                        offset$iv3 = $this$forEachIndexed_u24default$iv.getIndexInBlock();
                        if (block$iv7.getSize() <= offset$iv3 + end$iv3) {
                            $this$forEachIndexed_u24default$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed_u24default$iv.setIndexInBlock($this$forEachIndexed_u24default$iv.getIndexInBlock() + end$iv3);
                        }
                        offset$iv = Math.min(block$iv7.getSize(), offset$iv3 + end$iv3);
                        for (int index$iv = offset$iv3; index$iv < offset$iv; ++index$iv) {
                            void value;
                            int n11 = idx$iv++;
                            PrimitiveType index$iv3 = block$iv7.get(index$iv);
                            index3 = n11;
                            boolean bl15 = false;
                            minHeap.insert((PrimitiveType)value, index3);
                        }
                    }
                    $this$forEachIndexed_u24default$iv = inputPointer;
                    int count$iv = countDims - k2;
                    $i$f$forEachIndexed = false;
                    idx$iv = k2;
                    for (end$iv3 = count$iv; end$iv3 > 0; end$iv3 -= block$iv6.getSize() - offset$iv3) {
                        block$iv6 = $this$forEachIndexed$iv.getCurrentBlock();
                        offset$iv3 = $this$forEachIndexed$iv.getIndexInBlock();
                        if (block$iv6.getSize() <= offset$iv3 + end$iv3) {
                            $this$forEachIndexed$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed$iv.setIndexInBlock($this$forEachIndexed$iv.getIndexInBlock() + end$iv3);
                        }
                        offset$iv = Math.min(block$iv6.getSize(), offset$iv3 + end$iv3);
                        for (int index$iv = offset$iv3; index$iv < offset$iv; ++index$iv) {
                            int n12 = idx$iv++;
                            PrimitiveType value = block$iv6.get(index$iv);
                            index3 = n12;
                            boolean bl16 = false;
                            if (value.compareTo(minHeap.getMaxValue()) >= 0) continue;
                            minHeap.removeMax();
                            minHeap.insert(value, index3);
                        }
                    }
                    $this$forEachIndexed$iv = sorted2 ? minHeap.sorted() : TuplesKt.to((Object)minHeap.getData(), (Object)minHeap.getIndices());
                    PrimitiveArray values = (PrimitiveArray)$this$forEachIndexed$iv.component1();
                    int[] indices = (int[])$this$forEachIndexed$iv.component2();
                    int outputIndex = 0;
                    Object $this$map$iv = outputPointer;
                    boolean $i$f$map = false;
                    for (end$iv = k2; end$iv > 0; end$iv -= block$iv5.getSize() - offset$iv) {
                        block$iv5 = ((PrimitivePointer)$this$map$iv).getCurrentBlock();
                        offset$iv = ((PrimitivePointer)$this$map$iv).getIndexInBlock();
                        if (block$iv5.getSize() <= offset$iv + end$iv) {
                            ((PrimitivePointer)$this$map$iv).blockIncrement();
                        } else {
                            ((PrimitivePointer)$this$map$iv).setIndexInBlock(((PrimitivePointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        index3 = Math.min(block$iv5.getSize(), offset$iv + end$iv);
                        while (index$iv < index3) {
                            PrimitiveType bl16 = block$iv5.get(index$iv);
                            index = index$iv++;
                            bl7 = block$iv5;
                            boolean bl17 = false;
                            int bl14 = outputIndex;
                            outputIndex = bl14 + 1;
                            PrimitiveType primitiveType = values.get(bl14);
                            ((PrimitiveArray)bl7).set(index, primitiveType);
                        }
                    }
                    outputIndex = 0;
                    $this$map$iv = outputIndicesPointer;
                    $i$f$map = false;
                    for (end$iv = k2; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = ((LongPointer)$this$map$iv).getCurrentBlock();
                        if (block$iv.length <= (offset$iv = ((LongPointer)$this$map$iv).getIndexInBlock()) + end$iv) {
                            ((LongPointer)$this$map$iv).blockIncrement();
                        } else {
                            ((LongPointer)$this$map$iv).setIndexInBlock(((LongPointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        index3 = Math.min(block$iv.length, offset$iv + end$iv);
                        while (index$iv < index3) {
                            long it = block$iv[index$iv];
                            index = index$iv++;
                            bl7 = block$iv;
                            boolean bl18 = false;
                            int n13 = outputIndex;
                            outputIndex = n13 + 1;
                            long l4 = indices[n13];
                            bl7[index] = l4;
                        }
                    }
                    minHeap.clear();
                }
            }
        } else if (largest2) {
            var17_29 = 0;
            PrimitiveMaxHeap[] it = new PrimitiveMaxHeap[countElements];
            while (var17_29 < countElements) {
                $i$a$-repeat-PrimitiveNDArray$topK$7 = var17_29++;
                it[$i$a$-repeat-PrimitiveNDArray$topK$7] = new PrimitiveMaxHeap(k2);
            }
            PrimitiveMaxHeap[] maxHeaps = it;
            for (var17_29 = 0; var17_29 < countIterations; ++var17_29) {
                List list;
                Object object;
                int offset$iv;
                int it2 = var17_29;
                $i$a$-repeat-PrimitiveNDArray$topK$8 = 0;
                for (int $this$forEachIndexed$iv = 0; $this$forEachIndexed$iv < k2; ++$this$forEachIndexed$iv) {
                    int offset$iv4;
                    PrimitiveArray block$iv;
                    int dim = $this$forEachIndexed$iv;
                    boolean bl19 = false;
                    PrimitivePointer $this$forEachIndexed_u24default$iv = inputPointer;
                    int startIndex$iv = 0;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (int end$iv = countElements; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv4) {
                        block$iv = $this$forEachIndexed_u24default$iv.getCurrentBlock();
                        offset$iv4 = $this$forEachIndexed_u24default$iv.getIndexInBlock();
                        if (block$iv.getSize() <= offset$iv4 + end$iv) {
                            $this$forEachIndexed_u24default$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed_u24default$iv.setIndexInBlock($this$forEachIndexed_u24default$iv.getIndexInBlock() + end$iv);
                        }
                        int it3 = Math.min(block$iv.getSize(), offset$iv4 + end$iv);
                        for (int index$iv4 = offset$iv4; index$iv4 < it3; ++index$iv4) {
                            void value;
                            int n14 = idx$iv++;
                            PrimitiveType index = block$iv.get(index$iv4);
                            int index4 = n14;
                            boolean bl20 = false;
                            maxHeaps[index4].insert((PrimitiveType)value, dim);
                        }
                    }
                }
                for (int dim = k2; dim < countDims; ++dim) {
                    PrimitiveArray block$iv;
                    PrimitivePointer $this$forEachIndexed_u24default$iv = inputPointer;
                    int startIndex$iv = 0;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (int end$iv = countElements; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                        block$iv = $this$forEachIndexed_u24default$iv.getCurrentBlock();
                        offset$iv = $this$forEachIndexed_u24default$iv.getIndexInBlock();
                        if (block$iv.getSize() <= offset$iv + end$iv) {
                            $this$forEachIndexed_u24default$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed_u24default$iv.setIndexInBlock($this$forEachIndexed_u24default$iv.getIndexInBlock() + end$iv);
                        }
                        int offset$iv4 = Math.min(block$iv.getSize(), offset$iv + end$iv);
                        for (int index$iv = offset$iv; index$iv < offset$iv4; ++index$iv) {
                            void value;
                            int n15 = idx$iv++;
                            PrimitiveType index$iv4 = block$iv.get(index$iv);
                            int index = n15;
                            boolean bl21 = false;
                            PrimitiveMaxHeap maxHeap = maxHeaps[index];
                            if (value.compareTo(maxHeap.getMinValue()) <= 0) continue;
                            maxHeap.removeMin();
                            maxHeap.insert((PrimitiveType)value, dim);
                        }
                    }
                }
                if (sorted2) {
                    $this$map$iv = maxHeaps;
                    $i$f$map = false;
                    PrimitiveMaxHeap[] $i$f$forEachIndexed = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    offset$iv = $this$mapTo$iv$iv.length;
                    for (block$iv = 0; block$iv < offset$iv; ++block$iv) {
                        void it4;
                        PrimitiveMaxHeap item$iv$iv;
                        PrimitiveMaxHeap offset$iv4 = item$iv$iv = $this$mapTo$iv$iv[block$iv];
                        object = destination$iv$iv;
                        boolean bl22 = false;
                        object.add(it4.sorted());
                    }
                    list = (List)destination$iv$iv;
                } else {
                    $this$map$iv = maxHeaps;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    offset$iv = $this$mapTo$iv$iv.length;
                    for (block$iv = 0; block$iv < offset$iv; ++block$iv) {
                        PrimitiveMaxHeap item$iv$iv;
                        PrimitiveMaxHeap it4 = item$iv$iv = $this$mapTo$iv$iv[block$iv];
                        object = destination$iv$iv;
                        boolean bl23 = false;
                        object.add(TuplesKt.to((Object)it4.getData(), (Object)it4.getIndices()));
                    }
                    list = (List)destination$iv$iv;
                }
                List valuesAndIndicesArray = list;
                for (int dim = 0; dim < k2; ++dim) {
                    long[] block$iv;
                    int n16;
                    int it5;
                    int end$iv;
                    PrimitiveArray block$iv8;
                    int outputIndex = 0;
                    Object $this$map$iv = outputPointer;
                    boolean $i$f$map = false;
                    for (end$iv = countElements; end$iv > 0; end$iv -= block$iv8.getSize() - offset$iv) {
                        block$iv8 = ((PrimitivePointer)$this$map$iv).getCurrentBlock();
                        offset$iv = ((PrimitivePointer)$this$map$iv).getIndexInBlock();
                        if (block$iv8.getSize() <= offset$iv + end$iv) {
                            ((PrimitivePointer)$this$map$iv).blockIncrement();
                        } else {
                            ((PrimitivePointer)$this$map$iv).setIndexInBlock(((PrimitivePointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        it5 = Math.min(block$iv8.getSize(), offset$iv + end$iv);
                        while (index$iv < it5) {
                            PrimitiveType bl23 = block$iv8.get(index$iv);
                            n16 = index$iv++;
                            object = block$iv8;
                            boolean bl24 = false;
                            int bl21 = outputIndex;
                            outputIndex = bl21 + 1;
                            PrimitiveType primitiveType = ((PrimitiveArray)((Pair)valuesAndIndicesArray.get(bl21)).getFirst()).get(dim);
                            ((PrimitiveArray)object).set(n16, primitiveType);
                        }
                    }
                    outputIndex = 0;
                    $this$map$iv = outputIndicesPointer;
                    $i$f$map = false;
                    for (end$iv = countElements; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = ((LongPointer)$this$map$iv).getCurrentBlock();
                        if (block$iv.length <= (offset$iv = ((LongPointer)$this$map$iv).getIndexInBlock()) + end$iv) {
                            ((LongPointer)$this$map$iv).blockIncrement();
                        } else {
                            ((LongPointer)$this$map$iv).setIndexInBlock(((LongPointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        it5 = Math.min(block$iv.length, offset$iv + end$iv);
                        while (index$iv < it5) {
                            long l5 = block$iv[index$iv];
                            n16 = index$iv++;
                            object = block$iv;
                            boolean bl25 = false;
                            int maxHeap = outputIndex;
                            outputIndex = maxHeap + 1;
                            long l6 = ((int[])((Pair)valuesAndIndicesArray.get(maxHeap)).getSecond())[dim];
                            object[n16] = l6;
                        }
                    }
                }
                PrimitiveMaxHeap[] $this$forEach$iv = maxHeaps;
                boolean $i$f$forEach = false;
                int $i$f$map = $this$forEach$iv.length;
                for (int $this$map$iv = 0; $this$map$iv < $i$f$map; ++$this$map$iv) {
                    PrimitiveMaxHeap element$iv3;
                    PrimitiveMaxHeap it6 = element$iv3 = $this$forEach$iv[$this$map$iv];
                    boolean bl26 = false;
                    it6.clear();
                }
            }
        } else {
            var17_29 = 0;
            PrimitiveMinHeap[] it2 = new PrimitiveMinHeap[countElements];
            while (var17_29 < countElements) {
                $i$a$-repeat-PrimitiveNDArray$topK$8 = var17_29++;
                it2[$i$a$-repeat-PrimitiveNDArray$topK$8] = new PrimitiveMinHeap(k2);
            }
            PrimitiveMinHeap[] minHeaps = it2;
            for (var17_29 = 0; var17_29 < countIterations; ++var17_29) {
                List list;
                Object object;
                int offset$iv;
                int it = var17_29;
                boolean bl27 = false;
                for (int valuesAndIndicesArray = 0; valuesAndIndicesArray < k2; ++valuesAndIndicesArray) {
                    int offset$iv5;
                    PrimitiveArray block$iv;
                    int dim = valuesAndIndicesArray;
                    boolean bl28 = false;
                    PrimitivePointer $this$forEachIndexed_u24default$iv = inputPointer;
                    int startIndex$iv = 0;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (int end$iv = countElements; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv5) {
                        block$iv = $this$forEachIndexed_u24default$iv.getCurrentBlock();
                        offset$iv5 = $this$forEachIndexed_u24default$iv.getIndexInBlock();
                        if (block$iv.getSize() <= offset$iv5 + end$iv) {
                            $this$forEachIndexed_u24default$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed_u24default$iv.setIndexInBlock($this$forEachIndexed_u24default$iv.getIndexInBlock() + end$iv);
                        }
                        int bl24 = Math.min(block$iv.getSize(), offset$iv5 + end$iv);
                        for (int index$iv5 = offset$iv5; index$iv5 < bl24; ++index$iv5) {
                            void value;
                            int n17 = idx$iv++;
                            PrimitiveType bl25 = block$iv.get(index$iv5);
                            int index = n17;
                            boolean bl29 = false;
                            minHeaps[index].insert((PrimitiveType)value, dim);
                        }
                    }
                }
                for (int dim = k2; dim < countDims; ++dim) {
                    PrimitiveArray block$iv;
                    PrimitivePointer $this$forEachIndexed_u24default$iv = inputPointer;
                    int startIndex$iv = 0;
                    boolean $i$f$forEachIndexed = false;
                    int idx$iv = startIndex$iv;
                    for (int end$iv = countElements; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                        block$iv = $this$forEachIndexed_u24default$iv.getCurrentBlock();
                        offset$iv = $this$forEachIndexed_u24default$iv.getIndexInBlock();
                        if (block$iv.getSize() <= offset$iv + end$iv) {
                            $this$forEachIndexed_u24default$iv.blockIncrement();
                        } else {
                            $this$forEachIndexed_u24default$iv.setIndexInBlock($this$forEachIndexed_u24default$iv.getIndexInBlock() + end$iv);
                        }
                        int offset$iv5 = Math.min(block$iv.getSize(), offset$iv + end$iv);
                        for (int index$iv = offset$iv; index$iv < offset$iv5; ++index$iv) {
                            void value;
                            int n18 = idx$iv++;
                            PrimitiveType index$iv5 = block$iv.get(index$iv);
                            int index = n18;
                            boolean bl30 = false;
                            PrimitiveMinHeap minHeap = minHeaps[index];
                            if (value.compareTo(minHeap.getMaxValue()) >= 0) continue;
                            minHeap.removeMax();
                            minHeap.insert((PrimitiveType)value, dim);
                        }
                    }
                }
                if (sorted2) {
                    $this$map$iv = minHeaps;
                    $i$f$map = false;
                    PrimitiveMinHeap[] $i$f$forEachIndexed = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    offset$iv = $this$mapTo$iv$iv.length;
                    for (block$iv = 0; block$iv < offset$iv; ++block$iv) {
                        void it7;
                        PrimitiveMinHeap item$iv$iv;
                        PrimitiveMinHeap offset$iv5 = item$iv$iv = $this$mapTo$iv$iv[block$iv];
                        object = destination$iv$iv;
                        boolean bl31 = false;
                        object.add(it7.sorted());
                    }
                    list = (List)destination$iv$iv;
                } else {
                    $this$map$iv = minHeaps;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList($this$map$iv.length);
                    $i$f$mapTo = false;
                    offset$iv = $this$mapTo$iv$iv.length;
                    for (block$iv = 0; block$iv < offset$iv; ++block$iv) {
                        PrimitiveMinHeap item$iv$iv;
                        PrimitiveMinHeap it7 = item$iv$iv = $this$mapTo$iv$iv[block$iv];
                        object = destination$iv$iv;
                        boolean bl32 = false;
                        object.add(TuplesKt.to((Object)it7.getData(), (Object)it7.getIndices()));
                    }
                    list = (List)destination$iv$iv;
                }
                List valuesAndIndicesArray = list;
                for (int dim = 0; dim < k2; ++dim) {
                    long[] block$iv;
                    int n19;
                    int n20;
                    int end$iv;
                    PrimitiveArray block$iv9;
                    int outputIndex = 0;
                    Object $this$map$iv = outputPointer;
                    boolean $i$f$map = false;
                    for (end$iv = countElements; end$iv > 0; end$iv -= block$iv9.getSize() - offset$iv) {
                        block$iv9 = ((PrimitivePointer)$this$map$iv).getCurrentBlock();
                        offset$iv = ((PrimitivePointer)$this$map$iv).getIndexInBlock();
                        if (block$iv9.getSize() <= offset$iv + end$iv) {
                            ((PrimitivePointer)$this$map$iv).blockIncrement();
                        } else {
                            ((PrimitivePointer)$this$map$iv).setIndexInBlock(((PrimitivePointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        n20 = Math.min(block$iv9.getSize(), offset$iv + end$iv);
                        while (index$iv < n20) {
                            PrimitiveType bl32 = block$iv9.get(index$iv);
                            n19 = index$iv++;
                            object = block$iv9;
                            boolean bl33 = false;
                            int bl30 = outputIndex;
                            outputIndex = bl30 + 1;
                            PrimitiveType primitiveType = ((PrimitiveArray)((Pair)valuesAndIndicesArray.get(bl30)).getFirst()).get(dim);
                            ((PrimitiveArray)object).set(n19, primitiveType);
                        }
                    }
                    outputIndex = 0;
                    $this$map$iv = outputIndicesPointer;
                    $i$f$map = false;
                    for (end$iv = countElements; end$iv > 0; end$iv -= block$iv.length - offset$iv) {
                        block$iv = ((LongPointer)$this$map$iv).getCurrentBlock();
                        if (block$iv.length <= (offset$iv = ((LongPointer)$this$map$iv).getIndexInBlock()) + end$iv) {
                            ((LongPointer)$this$map$iv).blockIncrement();
                        } else {
                            ((LongPointer)$this$map$iv).setIndexInBlock(((LongPointer)$this$map$iv).getIndexInBlock() + end$iv);
                        }
                        int index$iv = offset$iv;
                        n20 = Math.min(block$iv.length, offset$iv + end$iv);
                        while (index$iv < n20) {
                            long it8 = block$iv[index$iv];
                            n19 = index$iv++;
                            object = block$iv;
                            boolean bl34 = false;
                            int n21 = outputIndex;
                            outputIndex = n21 + 1;
                            long l7 = ((int[])((Pair)valuesAndIndicesArray.get(n21)).getSecond())[dim];
                            object[n19] = l7;
                        }
                    }
                }
                PrimitiveMinHeap[] $this$forEach$iv = minHeaps;
                boolean $i$f$forEach = false;
                int n22 = $this$forEach$iv.length;
                for (int i = 0; i < n22; ++i) {
                    PrimitiveMinHeap element$iv4;
                    PrimitiveMinHeap it9 = element$iv4 = $this$forEach$iv[i];
                    boolean bl35 = false;
                    it9.clear();
                }
            }
        }
        return TuplesKt.to((Object)outputArray2, (Object)indicesArray);
    }

    @Override
    @NotNull
    public MutablePrimitiveNDArray copyIfNotMutable() {
        return new MutablePrimitiveNDArray(this.array.copyOf(), this.strides);
    }

    @Nullable
    public Object expand(@NotNull int[] shape, @NotNull Continuation<? super MutablePrimitiveNDArray> $completion) {
        return PrimitiveNDArray.expand$suspendImpl(this, shape, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object expand$suspendImpl(PrimitiveNDArray var0, int[] var1_1, Continuation<? super MutablePrimitiveNDArray> var2_2) {
        if (!(var2_2 instanceof expand.1)) ** GOTO lbl-1000
        var6_3 = var2_2;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PrimitiveNDArray this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PrimitiveNDArray.expand$suspendImpl(this.this$0, null, (Continuation<? super MutablePrimitiveNDArray>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = new int[][]{$this.getShape(), shape};
                outputShape = NDArrayUtilsKt.broadcastShape(CollectionsKt.listOf((Object[])((Object[])var4_6)));
                output = new MutablePrimitiveNDArray(new Strides(outputShape));
                $continuation.L$0 = output;
                $continuation.label = 1;
                v0 = Broadcasting.INSTANCE.applyWithBroadcast((List<? extends NDArrayCore>)CollectionsKt.listOf((Object)$this), output, (Function3<? super List<? extends NDArrayCore>, ? super MutableNDArrayCore, ? super Continuation<? super Unit>, ? extends Object>)((Function3)new Function3<List<? extends NDArray>, MutableNDArray, Continuation<? super Unit>, Object>(null){
                    int label;
                    /* synthetic */ Object L$0;
                    /* synthetic */ Object L$1;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                List inputs = (List)this.L$0;
                                MutableNDArray destination = (MutableNDArray)this.L$1;
                                Intrinsics.checkNotNull((Object)destination, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.MutablePrimitiveNDArray");
                                MutablePrimitiveNDArray cfr_ignored_0 = (MutablePrimitiveNDArray)destination;
                                E e = inputs.get(0);
                                Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type io.kinference.ndarray.arrays.PrimitiveNDArray");
                                PrimitiveNDArray input = (PrimitiveNDArray)e;
                                MutableNDArray.DefaultImpls.copyFrom$default(destination, 0, input, 0, 0, 12, null);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @Nullable
                    public final Object invoke(@NotNull List<? extends NDArray> p1, @NotNull MutableNDArray p2, @Nullable Continuation<? super Unit> p3) {
                        var var4_4 = new /* invalid duplicate definition of identical inner class */;
                        var4_4.L$0 = p1;
                        var4_4.L$1 = p2;
                        return var4_4.invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super MutableNDArrayCore>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                output = (MutablePrimitiveNDArray)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                return output;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object nonZero(@NotNull Continuation<? super LongNDArray> $completion) {
        return PrimitiveNDArray.nonZero$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object nonZero$suspendImpl(PrimitiveNDArray $this, Continuation<? super LongNDArray> $completion) {
        if (NDArrayUtilsKt.isScalar($this)) {
            LongNDArray longNDArray;
            PrimitiveType value = $this.singleValue();
            if (Intrinsics.areEqual((Object)value, (Object)ExtensionsKt.toPrimitive(Boxing.boxInt((int)0)))) {
                boolean $i$f$emptyArray22 = false;
                int[] $i$f$emptyArray22 = new int[]{0, 1};
                LongNDArray longNDArray2 = new LongNDArray(new LongTiledArray(new long[0][]), new Strides($i$f$emptyArray22));
                longNDArray = longNDArray2;
            } else {
                int[] $i$f$emptyArray22 = new int[]{0, 1};
                LongNDArray longNDArray3 = new LongNDArray(new Strides($i$f$emptyArray22), (Function1<? super Integer, Long>)((Function1)nonZero.2.INSTANCE));
                longNDArray = longNDArray3;
            }
            return longNDArray;
        }
        int ndIndexSize = $this.getRank();
        Ref.IntRef totalElements = new Ref.IntRef();
        PrimitivePointer inputPointer = PrimitiveTiledArray.pointer$default($this.array, 0, 1, null);
        int[] indicesArray = new int[$this.getLinearSize() * ndIndexSize];
        NDIndexerKt.ndIndices$default($this, null, null, (Function1)new Function1<int[], Unit>(inputPointer, indicesArray, totalElements, ndIndexSize){
            final /* synthetic */ PrimitivePointer $inputPointer;
            final /* synthetic */ int[] $indicesArray;
            final /* synthetic */ Ref.IntRef $totalElements;
            final /* synthetic */ int $ndIndexSize;
            {
                this.$inputPointer = $inputPointer;
                this.$indicesArray = $indicesArray;
                this.$totalElements = $totalElements;
                this.$ndIndexSize = $ndIndexSize;
                super(1);
            }

            public final void invoke(@NotNull int[] ndIndex) {
                Intrinsics.checkNotNullParameter((Object)ndIndex, (String)"ndIndex");
                if (!Intrinsics.areEqual((Object)this.$inputPointer.getAndIncrement(), (Object)ExtensionsKt.toPrimitive(0))) {
                    ArraysKt.copyInto$default((int[])ndIndex, (int[])this.$indicesArray, (int)(this.$totalElements.element * this.$ndIndexSize), (int)0, (int)0, (int)12, null);
                    int n = this.$totalElements.element;
                    this.$totalElements.element = n + 1;
                }
            }
        }, 3, null);
        int[] nArray = new int[]{ndIndexSize, totalElements.element};
        return LongNDArray.Companion.invoke(nArray, (Function1<? super int[], Long>)((Function1)new Function1<int[], Long>(indicesArray, ndIndexSize){
            final /* synthetic */ int[] $indicesArray;
            final /* synthetic */ int $ndIndexSize;
            {
                this.$indicesArray = $indicesArray;
                this.$ndIndexSize = $ndIndexSize;
                super(1);
            }

            @NotNull
            public final Long invoke(@NotNull int[] nArray) {
                Intrinsics.checkNotNullParameter((Object)nArray, (String)"<name for destructuring parameter 0>");
                int i = nArray[0];
                int j = nArray[1];
                return this.$indicesArray[j * this.$ndIndexSize + i];
            }
        }));
    }

    @Nullable
    public Object pad(@NotNull Pair<Integer, Integer>[] pads2, @NotNull PadMode mode2, @Nullable NDArray constantValue, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.pad$suspendImpl(this, pads2, mode2, constantValue, $completion);
    }

    static /* synthetic */ Object pad$suspendImpl(PrimitiveNDArray $this, Pair<Integer, Integer>[] pads2, PadMode mode2, NDArray constantValue, Continuation<? super PrimitiveNDArray> $completion) {
        if (!(pads2.length == $this.getRank())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] nArray = $this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] outputShape2 = nArray2;
        int n = pads2.length;
        for (int i = 0; i < n; ++i) {
            int axis2 = i;
            Pair<Integer, Integer> pad = pads2[i];
            outputShape2[axis2] = outputShape2[axis2] + (((Number)pad.getFirst()).intValue() + ((Number)pad.getSecond()).intValue());
        }
        MutablePrimitiveNDArray outputArray2 = new MutablePrimitiveNDArray(new Strides(outputShape2));
        Object object = constantValue;
        if (object == null || (object = object.singleValue()) == null) {
            object = ExtensionsKt.toPrimitive(Boxing.boxInt((int)0));
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.kinference.primitives.types.PrimitiveType");
        PrimitiveType constant = (PrimitiveType)object;
        PrimitiveNDArray.pad$recurrentCopyInput(pads2, $this, 0, $this, outputArray2);
        switch (WhenMappings.$EnumSwitchMapping$1[mode2.ordinal()]) {
            case 1: {
                if (Intrinsics.areEqual((Object)constant, (Object)ExtensionsKt.toPrimitive(Boxing.boxInt((int)0)))) break;
                PrimitiveNDArray.pad$recurrentFillConstant(pads2, $this, constant, 0, outputArray2);
                break;
            }
            case 2: {
                PrimitiveNDArray.pad$recurrentFillEdge(pads2, $this, 0, outputArray2);
                break;
            }
            case 3: {
                PrimitiveNDArray.pad$recurrentFillReflect(pads2, $this, 0, outputArray2);
            }
        }
        return outputArray2;
    }

    @Nullable
    public Object tile(@NotNull int[] repeats, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.tile$suspendImpl(this, repeats, $completion);
    }

    static /* synthetic */ Object tile$suspendImpl(PrimitiveNDArray $this, int[] repeats, Continuation<? super PrimitiveNDArray> $completion) {
        int[] $i$f$all2;
        boolean bl;
        block6: {
            if (!(repeats.length == $this.getRank())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int[] $this$all$iv = repeats;
            boolean $i$f$all2 = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                int element$iv;
                int it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (it == 1) continue;
                bl = false;
                break block6;
            }
            bl = true;
        }
        if (bl) {
            return $this.toMutable();
        }
        int[] nArray = $this.getShape();
        int[] nArray2 = Arrays.copyOf(nArray, nArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"copyOf(...)");
        int[] $this$tile_u24lambda_u2461 = $i$f$all2 = nArray2;
        boolean bl3 = false;
        int n = $this$tile_u24lambda_u2461.length;
        for (int idx = 0; idx < n; ++idx) {
            int n2 = idx;
            $this$tile_u24lambda_u2461[n2] = $this$tile_u24lambda_u2461[n2] * repeats[idx];
        }
        int[] outputShape2 = $i$f$all2;
        PrimitiveNDArray outputArray2 = new PrimitiveNDArray(new Strides(outputShape2));
        Ref.IntRef axisToStop = new Ref.IntRef();
        axisToStop.element = -1;
        int n3 = repeats.length;
        for (int idx = 0; idx < n3; ++idx) {
            if (axisToStop.element == -1 && repeats[idx] == 1) {
                axisToStop.element = idx;
                continue;
            }
            if (repeats[idx] == 1) continue;
            axisToStop.element = -1;
        }
        int blockToCopy = axisToStop.element != -1 ? NDArrayUtilsKt.computeBlockSize$default($this, axisToStop.element, 0, 2, null) : 0;
        PrimitiveNDArray.tile$tileCopy(axisToStop, $this, outputArray2, blockToCopy, 0, 0, 0);
        PrimitiveNDArray.tile$tileRepeat(repeats, axisToStop, $this, outputArray2, 0, 0);
        return outputArray2;
    }

    @Nullable
    public Object reshape(@NotNull Strides strides2, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.reshape$suspendImpl(this, strides2, $completion);
    }

    static /* synthetic */ Object reshape$suspendImpl(PrimitiveNDArray $this, Strides strides2, Continuation<? super PrimitiveNDArray> $completion) {
        if (!(strides2.getLinearSize() == $this.strides.getLinearSize())) {
            boolean bl = false;
            String string = "Linear size must be equal";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(strides2.getShape().length == 0) && !($this.getShape().length == 0) && ArraysKt.last((int[])strides2.getShape()) != ArraysKt.last((int[])$this.getShape())) {
            PrimitiveTiledArray newArray = PrimitiveTiledArray.Companion.invoke(strides2);
            PrimitiveTiledArray.copyInto$default($this.array, newArray, 0, 0, 0, 14, null);
            return new PrimitiveNDArray(newArray, strides2);
        }
        return new MutablePrimitiveNDArray($this.array, strides2);
    }

    @Nullable
    public Object reshape(@NotNull int[] shape, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return this.reshape(new Strides(shape), $completion);
    }

    private final PrimitiveNDArray transposeByBlocks(int[] permutations) {
        PrimitiveArray[] primitiveArrayArray = this.array.getBlocks();
        PrimitiveArray[] primitiveArrayArray2 = Arrays.copyOf(primitiveArrayArray, primitiveArrayArray.length);
        Intrinsics.checkNotNullExpressionValue((Object)primitiveArrayArray2, (String)"copyOf(...)");
        PrimitiveArray[] outputBlocks = primitiveArrayArray2;
        Strides outputStrides = this.strides.transpose(permutations);
        Ref.IntRef axisToStop = new Ref.IntRef();
        axisToStop.element = permutations.length;
        for (int idx : UtilsKt.reversed(ArraysKt.getIndices((int[])permutations))) {
            if (permutations[idx] == idx) continue;
            axisToStop.element = idx + 1;
            break;
        }
        int countBlocksToCopy = NDArrayUtilsKt.computeBlockSize$default(this, axisToStop.element, 0, 2, null) / this.array.getBlockSize();
        PrimitiveNDArray.transposeByBlocks$transposeByBlocksRec(this, axisToStop, countBlocksToCopy, outputStrides, outputBlocks, permutations, 0, 0, 0);
        return new PrimitiveNDArray(new PrimitiveTiledArray(outputBlocks), outputStrides);
    }

    @Nullable
    public Object transpose(@NotNull int[] permutations, @NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.transpose$suspendImpl(this, permutations, $completion);
    }

    static /* synthetic */ Object transpose$suspendImpl(PrimitiveNDArray $this, int[] permutations, Continuation<? super PrimitiveNDArray> $completion) {
        boolean bl;
        block11: {
            boolean bl2;
            boolean $i$f$all2;
            Object $this$all$iv;
            block10: {
                if (!(permutations.length == $this.getRank())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                $this$all$iv = permutations;
                $i$f$all2 = false;
                int n = ((int[])$this$all$iv).length;
                for (int i = 0; i < n; ++i) {
                    int element$iv;
                    int it = element$iv = $this$all$iv[i];
                    boolean bl3 = false;
                    if (0 <= it ? it < permutations.length : false) continue;
                    bl2 = false;
                    break block10;
                }
                bl2 = true;
            }
            if (!bl2) {
                String $i$f$all2 = "Failed requirement.";
                throw new IllegalArgumentException($i$f$all2.toString());
            }
            $this$all$iv = ArraysKt.withIndex((int[])permutations);
            $i$f$all2 = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    IndexedValue it = (IndexedValue)element$iv;
                    boolean bl4 = false;
                    if (((Number)it.getValue()).intValue() == it.getIndex()) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return $this;
        }
        Strides outputStrides = $this.strides.transpose(permutations);
        if (NDArrayExtensionsKt.isTransposeReshape($this, permutations)) {
            return $this.reshape(outputStrides, $completion);
        }
        if ($this.getRank() == 2) {
            return $this.transpose2D($completion);
        }
        if (ArraysKt.getLastIndex((int[])permutations) == ArraysKt.last((int[])permutations)) {
            return $this.transposeByBlocks(permutations);
        }
        MutablePrimitiveNDArray outputArray2 = new MutablePrimitiveNDArray(outputStrides);
        PrimitiveNDArray.transpose$transposeRec($this, outputStrides, permutations, outputArray2, 0, 0, 0);
        return outputArray2;
    }

    @Nullable
    public Object transpose2D(@NotNull Continuation<? super PrimitiveNDArray> $completion) {
        return PrimitiveNDArray.transpose2D$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object transpose2D$suspendImpl(PrimitiveNDArray $this, Continuation<? super PrimitiveNDArray> $completion) {
        if (!($this.getRank() == 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] outputShape2 = ArraysKt.reversedArray((int[])$this.getShape());
        Strides outputStrides = new Strides(outputShape2);
        PrimitiveTiledArray outputArray2 = PrimitiveTiledArray.Companion.invoke(outputStrides);
        int newBlocksInRow = outputShape2[1] / outputArray2.getBlockSize();
        int blockNum = 0;
        int n = outputShape2[0];
        for (int row = 0; row < n; ++row) {
            Pair<Integer, Integer> pair = $this.array.indexFor(row);
            int blockOffset = ((Number)pair.component1()).intValue();
            int offset = ((Number)pair.component2()).intValue();
            int col = 0;
            for (int i = 0; i < newBlocksInRow; ++i) {
                PrimitiveArray block = outputArray2.getBlocks()[blockNum++];
                int n2 = outputArray2.getBlockSize();
                for (int idx = 0; idx < n2; ++idx) {
                    block.set(idx, $this.array.getBlocks()[blockOffset + col * $this.getBlocksInRow$ndarray_core()].get(offset));
                    ++col;
                }
            }
        }
        return new MutablePrimitiveNDArray(outputArray2, outputStrides);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PrimitiveNDArray)) {
            return false;
        }
        if (this.getType() != ((PrimitiveNDArray)other).getType()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.strides, (Object)((PrimitiveNDArray)other).strides)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.array, (Object)((PrimitiveNDArray)other).array);
    }

    public int hashCode() {
        int result2 = this.array.hashCode();
        result2 = 31 * result2 + this.strides.hashCode();
        result2 = 31 * result2 + this.getType().hashCode();
        return result2;
    }

    @Override
    public void close() {
        NumberNDArrayCore.DefaultImpls.close(this);
    }

    @Override
    @Nullable
    public Object squeeze(@NotNull int[] axes2, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NumberNDArrayCore.DefaultImpls.squeeze(this, axes2, $completion);
    }

    @Override
    @Nullable
    public Object unsqueeze(@NotNull int[] axes2, @NotNull Continuation<? super NDArray> $completion) {
        return NumberNDArrayCore.DefaultImpls.unsqueeze(this, axes2, $completion);
    }

    @Override
    @Nullable
    public Object stack(@NotNull List<? extends NDArray> others, int axis2, @NotNull Continuation<? super MutableNDArrayCore> $completion) {
        return NumberNDArrayCore.DefaultImpls.stack(this, others, axis2, $completion);
    }

    @Override
    @Nullable
    public Object split(int parts, int axis2, @NotNull Continuation<? super List<? extends NDArrayCore>> $completion) {
        return NumberNDArrayCore.DefaultImpls.split((NumberNDArrayCore)this, parts, axis2, $completion);
    }

    @Override
    @Nullable
    public Object split(@NotNull int[] split, int axis2, @NotNull Continuation<? super List<? extends NDArray>> $completion) {
        return NumberNDArrayCore.DefaultImpls.split((NumberNDArrayCore)this, split, axis2, $completion);
    }

    @Override
    @Nullable
    public Object gather(@NotNull NDArray indices, int axis2, int batchDims2, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NumberNDArrayCore.DefaultImpls.gather((NumberNDArrayCore)this, indices, axis2, batchDims2, $completion);
    }

    @Override
    @Nullable
    public Object gather(@NotNull NDArray indices, int axis2, @NotNull MutableNDArrayCore dst, @NotNull Continuation<? super NDArrayCore> $completion) {
        return NumberNDArrayCore.DefaultImpls.gather((NumberNDArrayCore)this, indices, axis2, dst, $completion);
    }

    @Override
    public int getLinearSize() {
        return NumberNDArrayCore.DefaultImpls.getLinearSize(this);
    }

    @Override
    public int getRank() {
        return NumberNDArrayCore.DefaultImpls.getRank(this);
    }

    @Override
    @NotNull
    public int[] getShape() {
        return NumberNDArrayCore.DefaultImpls.getShape(this);
    }

    private static final PrimitiveToPrimitiveFunction logSoftmax$log(DataType type) {
        return switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> new FloatMap(){

                public float apply(float value) {
                    return (float)Math.log(value);
                }
            };
            case 2 -> new DoubleMap(){

                public double apply(double value) {
                    return Math.log(value);
                }
            };
            default -> throw new IllegalStateException("LogSoftmax supported only for DOUBLE and FLOAT types".toString());
        };
    }

    private static final void pad$recurrentCopyInput(Pair<Integer, Integer>[] $pads, PrimitiveNDArray this$0, int axis2, PrimitiveNDArray input, MutablePrimitiveNDArray output) {
        int leftPad = ((Number)$pads[axis2].getFirst()).intValue();
        int inputDims = input.getShape()[0];
        if (axis2 == this$0.getRank() - 1) {
            MutableNDArray.DefaultImpls.copyFrom$default(output, leftPad, input, 0, 0, 12, null);
            return;
        }
        for (int dim = 0; dim < inputDims; ++dim) {
            int[] nArray = new int[]{dim};
            PrimitiveNDArray primitiveNDArray = input.view(nArray);
            nArray = new int[]{dim + leftPad};
            PrimitiveNDArray.pad$recurrentCopyInput($pads, this$0, axis2 + 1, primitiveNDArray, output.viewMutable(nArray));
        }
    }

    private static final void pad$recurrentFillConstant(Pair<Integer, Integer>[] $pads, PrimitiveNDArray this$0, PrimitiveType constant, int axis2, MutablePrimitiveNDArray output) {
        Pair<Integer, Integer> pair = $pads[axis2];
        int leftPad = ((Number)pair.component1()).intValue();
        int rightPad = ((Number)pair.component2()).intValue();
        int outputDims = output.getShape()[0];
        if (axis2 == this$0.getRank() - 1) {
            output.fill(constant, 0, leftPad);
            output.fill(constant, outputDims - rightPad, outputDims);
            return;
        }
        int dim = 0;
        while (dim < leftPad) {
            int[] nArray = new int[]{dim++};
            MutableNDArray.DefaultImpls.fill$default(output.viewMutable(nArray), constant, 0, 0, 6, null);
        }
        dim = leftPad;
        int n = outputDims - rightPad;
        while (dim < n) {
            int[] nArray = new int[]{dim++};
            PrimitiveNDArray.pad$recurrentFillConstant($pads, this$0, constant, axis2 + 1, output.viewMutable(nArray));
        }
        dim = outputDims - rightPad;
        while (dim < outputDims) {
            int[] nArray = new int[]{dim++};
            MutableNDArray.DefaultImpls.fill$default(output.viewMutable(nArray), constant, 0, 0, 6, null);
        }
    }

    private static final void pad$recurrentFillEdge(Pair<Integer, Integer>[] $pads, PrimitiveNDArray this$0, int axis2, MutablePrimitiveNDArray output) {
        int[] nArray;
        Pair<Integer, Integer> pair = $pads[axis2];
        int leftPad = ((Number)pair.component1()).intValue();
        int rightPad = ((Number)pair.component2()).intValue();
        int outputDims = output.getShape()[0];
        if (axis2 == this$0.getRank() - 1) {
            PrimitiveType leftPadValue = output.getArray().get(leftPad);
            PrimitiveType rightPadValue22 = output.getArray().get(outputDims - rightPad - 1);
            output.fill(leftPadValue, 0, leftPad);
            output.fill(rightPadValue22, outputDims - rightPad, outputDims);
            return;
        }
        int dim = leftPad;
        int rightPadValue22 = outputDims - rightPad;
        while (dim < rightPadValue22) {
            nArray = new int[]{dim++};
            PrimitiveNDArray.pad$recurrentFillEdge($pads, this$0, axis2 + 1, output.viewMutable(nArray));
        }
        int[] rightPadValue22 = new int[]{leftPad};
        PrimitiveNDArray leftPadArray = output.view(rightPadValue22);
        int dim2 = 0;
        while (dim2 < leftPad) {
            nArray = new int[]{dim2++};
            MutableNDArray.DefaultImpls.copyFrom$default(output.viewMutable(nArray), 0, leftPadArray, 0, 0, 12, null);
        }
        nArray = new int[]{outputDims - rightPad - 1};
        PrimitiveNDArray rightPadArray = output.view(nArray);
        int dim3 = outputDims - rightPad;
        while (dim3 < outputDims) {
            int[] nArray2 = new int[]{dim3++};
            MutableNDArray.DefaultImpls.copyFrom$default(output.viewMutable(nArray2), 0, rightPadArray, 0, 0, 12, null);
        }
    }

    private static final void pad$recurrentFillReflect(Pair<Integer, Integer>[] $pads, PrimitiveNDArray this$0, int axis2, MutablePrimitiveNDArray output) {
        Pair<Integer, Integer> pair = $pads[axis2];
        int leftPad = ((Number)pair.component1()).intValue();
        int rightPad = ((Number)pair.component2()).intValue();
        int outputDims = output.getShape()[0];
        if (axis2 == this$0.getRank() - 1) {
            int n;
            PrimitivePointer leftPadInputPointer = output.getArray().pointer(leftPad + 1);
            PrimitivePointer leftPadOutputPointer = output.getArray().pointer(leftPad - 1);
            for (int i = 0; i < leftPad; ++i) {
                int it = i;
                n = 0;
                if (leftPadInputPointer.getLinearIndex() == outputDims - rightPad) {
                    leftPadInputPointer.setLinearIndex(leftPad);
                }
                leftPadOutputPointer.set(leftPadInputPointer.getAndIncrement());
                leftPadOutputPointer.decrement();
            }
            PrimitivePointer rightPadInputPointer = output.getArray().pointer(outputDims - rightPad - 2);
            PrimitivePointer rightPadOutputPointer = output.getArray().pointer(outputDims - rightPad);
            for (n = 0; n < rightPad; ++n) {
                int it2 = n;
                boolean bl = false;
                if (rightPadInputPointer.getLinearIndex() == leftPad - 1) {
                    rightPadInputPointer.setLinearIndex(outputDims - rightPad - 1);
                }
                rightPadOutputPointer.set(rightPadInputPointer.get());
                rightPadInputPointer.decrement();
                rightPadOutputPointer.increment();
            }
            return;
        }
        int dim = leftPad;
        int leftPadOutputPointer = outputDims - rightPad;
        while (dim < leftPadOutputPointer) {
            int[] rightPadInputPointer = new int[]{dim++};
            PrimitiveNDArray.pad$recurrentFillReflect($pads, this$0, axis2 + 1, output.viewMutable(rightPadInputPointer));
        }
        int leftPadInputAxis = 0;
        leftPadInputAxis = leftPad + 1;
        int leftPadOutputAxis = 0;
        leftPadOutputAxis = leftPad - 1;
        for (int rightPadInputPointer = 0; rightPadInputPointer < leftPad; ++rightPadInputPointer) {
            int it = rightPadInputPointer;
            boolean bl = false;
            if (leftPadInputAxis == outputDims - rightPad) {
                leftPadInputAxis = leftPad;
            }
            int[] it2 = new int[]{leftPadOutputAxis};
            MutableNDArray mutableNDArray = output.viewMutable(it2);
            it2 = new int[]{leftPadInputAxis++};
            MutableNDArray.DefaultImpls.copyFrom$default(mutableNDArray, 0, output.view(it2), 0, 0, 12, null);
            leftPadOutputAxis += -1;
        }
        int rightPadInputAxis = 0;
        rightPadInputAxis = outputDims - rightPad - 2;
        int rightPadOutputAxis = 0;
        rightPadOutputAxis = outputDims - rightPad;
        for (int i = 0; i < rightPad; ++i) {
            int it = i;
            boolean bl = false;
            if (rightPadInputAxis == leftPad - 1) {
                rightPadInputAxis = outputDims - rightPad - 1;
            }
            int[] nArray = new int[]{rightPadOutputAxis++};
            MutableNDArray mutableNDArray = output.viewMutable(nArray);
            nArray = new int[]{rightPadInputAxis};
            MutableNDArray.DefaultImpls.copyFrom$default(mutableNDArray, 0, output.view(nArray), 0, 0, 12, null);
            rightPadInputAxis += -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void tile$tileCopy(Ref.IntRef axisToStop, PrimitiveNDArray this$0, PrimitiveNDArray outputArray2, int blockToCopy, int axis2, int inputOffset, int outputOffset) {
        int n = axis2;
        if (n == axisToStop.element) {
            PrimitivePointer outputPointer;
            PrimitivePointer inputPointer = this$0.array.pointer(inputOffset);
            PrimitivePointer $this$accept$iv = outputPointer = outputArray2.array.pointer(outputOffset);
            boolean $i$f$accept = false;
            if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer, blockToCopy)) {
                boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
                String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
            }
            if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer)) {
                int dstOffset$iv;
                PrimitiveArray dstBlock$iv;
                for (end$iv = blockToCopy; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                    PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                    if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                        $this$accept$iv.blockIncrement();
                        inputPointer.blockIncrement();
                    } else {
                        $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                        inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                    }
                    int index$iv = dstOffset$iv;
                    int n2 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                    while (index$iv < n2) {
                        void src;
                        dstBlock$iv.get(index$iv);
                        PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                        int n3 = index$iv++;
                        PrimitiveArray primitiveArray = dstBlock$iv;
                        boolean bl = false;
                        void var24_49 = src;
                        primitiveArray.set(n3, (PrimitiveType)var24_49);
                    }
                }
            } else {
                while (end$iv > 0) {
                    $this$accept$iv.get();
                    PrimitiveType src = inputPointer.getAndIncrement();
                    PrimitivePointer primitivePointer = $this$accept$iv;
                    boolean bl = false;
                    primitivePointer.set(src);
                    $this$accept$iv.increment();
                    --end$iv;
                }
            }
        } else if (n == ArraysKt.getLastIndex((int[])this$0.getShape())) {
            PrimitivePointer outputPointer;
            PrimitivePointer inputPointer = this$0.array.pointer(inputOffset);
            PrimitivePointer $this$accept$iv = outputPointer = outputArray2.array.pointer(outputOffset);
            int count$iv = ArraysKt.last((int[])this$0.getShape());
            boolean $i$f$accept = false;
            if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer, count$iv)) {
                boolean $i$a$-require-PrimitivePointerKt$accept$1$iv32 = false;
                String $i$a$-require-PrimitivePointerKt$accept$1$iv32 = "Pointers not compatible by available elements";
                throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv32.toString());
            }
            if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer)) {
                int dstOffset$iv;
                PrimitiveArray dstBlock$iv;
                for (end$iv = count$iv; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                    dstBlock$iv = $this$accept$iv.getCurrentBlock();
                    dstOffset$iv = $this$accept$iv.getIndexInBlock();
                    PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                    if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                        $this$accept$iv.blockIncrement();
                        inputPointer.blockIncrement();
                    } else {
                        $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                        inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                    }
                    int index$iv = dstOffset$iv;
                    int n4 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                    while (index$iv < n4) {
                        void src;
                        dstBlock$iv.get(index$iv);
                        PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                        int n5 = index$iv++;
                        PrimitiveArray primitiveArray = dstBlock$iv;
                        boolean bl = false;
                        void var24_50 = src;
                        primitiveArray.set(n5, (PrimitiveType)var24_50);
                    }
                }
            } else {
                while (end$iv > 0) {
                    $this$accept$iv.get();
                    PrimitiveType src = inputPointer.getAndIncrement();
                    PrimitivePointer primitivePointer = $this$accept$iv;
                    boolean bl = false;
                    primitivePointer.set(src);
                    $this$accept$iv.increment();
                    --end$iv;
                }
            }
        } else {
            int dims = this$0.getShape()[axis2];
            int n6 = 0;
            while (n6 < dims) {
                int dim = n6++;
                boolean bl = false;
                int additionalInputOffset = dim * this$0.strides.getStrides()[axis2];
                int additionalOutputOffset = dim * outputArray2.strides.getStrides()[axis2];
                PrimitiveNDArray.tile$tileCopy(axisToStop, this$0, outputArray2, blockToCopy, axis2 + 1, inputOffset + additionalInputOffset, outputOffset + additionalOutputOffset);
            }
        }
    }

    private static final void tile$tileRepeat(int[] $repeats, Ref.IntRef axisToStop, PrimitiveNDArray this$0, PrimitiveNDArray outputArray2, int axis2, int offset) {
        block19: {
            int countRepeat;
            block18: {
                countRepeat = $repeats[axis2];
                int n = axis2;
                if (n == axisToStop.element) {
                    return;
                }
                if (n != ArraysKt.getLastIndex((int[])this$0.getShape())) break block18;
                int blockSize = this$0.getShape()[axis2];
                PrimitivePointer inputPointer = PrimitiveTiledArray.pointer$default(outputArray2.array, 0, 1, null);
                PrimitivePointer outputPointer = outputArray2.array.pointer(offset + blockSize);
                int n2 = countRepeat - 1;
                for (int i = 0; i < n2; ++i) {
                    PrimitiveType src;
                    boolean bl;
                    Object object;
                    int end$iv;
                    int it = i;
                    boolean bl2 = false;
                    inputPointer.setLinearIndex(offset);
                    PrimitivePointer $this$accept$iv = outputPointer;
                    boolean $i$f$accept = false;
                    if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer, blockSize)) {
                        boolean $i$a$-require-PrimitivePointerKt$accept$1$iv22 = false;
                        String $i$a$-require-PrimitivePointerKt$accept$1$iv22 = "Pointers not compatible by available elements";
                        throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv22.toString());
                    }
                    if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer)) {
                        int dstOffset$iv;
                        PrimitiveArray dstBlock$iv;
                        for (end$iv = blockSize; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                            dstBlock$iv = $this$accept$iv.getCurrentBlock();
                            dstOffset$iv = $this$accept$iv.getIndexInBlock();
                            PrimitiveArray srcBlock$iv = inputPointer.getCurrentBlock();
                            if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                                $this$accept$iv.blockIncrement();
                                inputPointer.blockIncrement();
                            } else {
                                $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                                inputPointer.setIndexInBlock(inputPointer.getIndexInBlock() + end$iv);
                            }
                            int index$iv = dstOffset$iv;
                            int n3 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                            while (index$iv < n3) {
                                dstBlock$iv.get(index$iv);
                                PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                                int n4 = index$iv++;
                                object = dstBlock$iv;
                                bl = false;
                                PrimitiveType primitiveType2 = src;
                                ((PrimitiveArray)object).set(n4, primitiveType2);
                            }
                        }
                        continue;
                    }
                    while (end$iv > 0) {
                        $this$accept$iv.get();
                        src = inputPointer.getAndIncrement();
                        object = $this$accept$iv;
                        bl = false;
                        ((PrimitivePointer)object).set(src);
                        $this$accept$iv.increment();
                        --end$iv;
                    }
                }
                break block19;
            }
            int dims = this$0.getShape()[axis2];
            int inputPointer = 0;
            while (inputPointer < dims) {
                int dim = inputPointer++;
                boolean bl = false;
                int additionalOffset = dim * outputArray2.strides.getStrides()[axis2];
                PrimitiveNDArray.tile$tileRepeat($repeats, axisToStop, this$0, outputArray2, axis2 + 1, offset + additionalOffset);
            }
            if (countRepeat <= 1) break block19;
            int blockSize = outputArray2.strides.getStrides()[axis2] * this$0.getShape()[axis2];
            PrimitivePointer inputPointer2 = PrimitiveTiledArray.pointer$default(outputArray2.array, 0, 1, null);
            PrimitivePointer outputPointer = outputArray2.array.pointer(offset + blockSize);
            int n = countRepeat - 1;
            for (int i = 0; i < n; ++i) {
                PrimitiveType src;
                boolean bl;
                Object object;
                int end$iv;
                int it = i;
                boolean bl3 = false;
                inputPointer2.setLinearIndex(offset);
                PrimitivePointer $this$accept$iv = outputPointer;
                boolean $i$f$accept = false;
                if (!PrimitivePointerKt.isCompatibleBySize($this$accept$iv, inputPointer2, blockSize)) {
                    boolean $i$a$-require-PrimitivePointerKt$accept$1$iv32 = false;
                    String $i$a$-require-PrimitivePointerKt$accept$1$iv32 = "Pointers not compatible by available elements";
                    throw new IllegalArgumentException($i$a$-require-PrimitivePointerKt$accept$1$iv32.toString());
                }
                if (PrimitivePointerKt.isCompatibleWith($this$accept$iv, inputPointer2)) {
                    int dstOffset$iv;
                    PrimitiveArray dstBlock$iv;
                    for (end$iv = blockSize; end$iv > 0; end$iv -= dstBlock$iv.getSize() - dstOffset$iv) {
                        dstBlock$iv = $this$accept$iv.getCurrentBlock();
                        dstOffset$iv = $this$accept$iv.getIndexInBlock();
                        PrimitiveArray srcBlock$iv = inputPointer2.getCurrentBlock();
                        if (dstBlock$iv.getSize() <= dstOffset$iv + end$iv) {
                            $this$accept$iv.blockIncrement();
                            inputPointer2.blockIncrement();
                        } else {
                            $this$accept$iv.setIndexInBlock($this$accept$iv.getIndexInBlock() + end$iv);
                            inputPointer2.setIndexInBlock(inputPointer2.getIndexInBlock() + end$iv);
                        }
                        int index$iv = dstOffset$iv;
                        int n5 = Math.min(dstBlock$iv.getSize(), dstOffset$iv + end$iv);
                        while (index$iv < n5) {
                            dstBlock$iv.get(index$iv);
                            PrimitiveType primitiveType = srcBlock$iv.get(index$iv);
                            int n6 = index$iv++;
                            object = dstBlock$iv;
                            bl = false;
                            PrimitiveType primitiveType3 = src;
                            ((PrimitiveArray)object).set(n6, primitiveType3);
                        }
                    }
                    continue;
                }
                while (end$iv > 0) {
                    $this$accept$iv.get();
                    src = inputPointer2.getAndIncrement();
                    object = $this$accept$iv;
                    bl = false;
                    ((PrimitivePointer)object).set(src);
                    $this$accept$iv.increment();
                    --end$iv;
                }
            }
        }
    }

    private static final void transposeByBlocks$transposeByBlocksRec(PrimitiveNDArray this$0, Ref.IntRef axisToStop, int countBlocksToCopy, Strides outputStrides, PrimitiveArray[] outputBlocks, int[] $permutations, int axis2, int inputOffset, int outputOffset) {
        int n = axis2;
        if (n == ArraysKt.getLastIndex((int[])this$0.getShape()) ? true : n == axisToStop.element) {
            int inputStartBlockNum = inputOffset / this$0.array.getBlockSize();
            int outputStartBlockNum = outputOffset / this$0.array.getBlockSize();
            int n2 = 0;
            while (n2 < countBlocksToCopy) {
                int it = n2++;
                boolean bl = false;
                outputBlocks[outputStartBlockNum + it] = this$0.array.getBlocks()[inputStartBlockNum + it];
            }
        } else {
            int dims = outputStrides.getShape()[axis2];
            int n3 = 0;
            while (n3 < dims) {
                int dim = n3++;
                boolean bl = false;
                int additionalInputOffset = this$0.strides.getStrides()[$permutations[axis2]] * dim;
                int additionalOutputOffset = outputStrides.getStrides()[axis2] * dim;
                PrimitiveNDArray.transposeByBlocks$transposeByBlocksRec(this$0, axisToStop, countBlocksToCopy, outputStrides, outputBlocks, $permutations, axis2 + 1, inputOffset + additionalInputOffset, outputOffset + additionalOutputOffset);
            }
        }
    }

    private static final void transpose$transposeRec(PrimitiveNDArray this$0, Strides outputStrides, int[] $permutations, MutablePrimitiveNDArray outputArray2, int axis2, int inputOffset, int outputOffset) {
        if (axis2 == ArraysKt.getLastIndex((int[])this$0.getShape())) {
            int offset$iv;
            PrimitiveArray block$iv;
            int dims = outputStrides.getShape()[axis2];
            int inputStride = this$0.strides.getStrides()[$permutations[axis2]];
            int index = 0;
            PrimitivePointer $this$map$iv = outputArray2.getArray().pointer(outputOffset);
            boolean $i$f$map = false;
            for (int end$iv = dims; end$iv > 0; end$iv -= block$iv.getSize() - offset$iv) {
                block$iv = $this$map$iv.getCurrentBlock();
                offset$iv = $this$map$iv.getIndexInBlock();
                if (block$iv.getSize() <= offset$iv + end$iv) {
                    $this$map$iv.blockIncrement();
                } else {
                    $this$map$iv.setIndexInBlock($this$map$iv.getIndexInBlock() + end$iv);
                }
                int index$iv = offset$iv;
                int n = Math.min(block$iv.getSize(), offset$iv + end$iv);
                while (index$iv < n) {
                    block$iv.get(index$iv);
                    int n2 = index$iv++;
                    PrimitiveArray primitiveArray = block$iv;
                    boolean bl = false;
                    int n3 = index;
                    index = n3 + 1;
                    PrimitiveType primitiveType = this$0.array.get(inputOffset + inputStride * n3);
                    primitiveArray.set(n2, primitiveType);
                }
            }
        } else {
            int dims = outputStrides.getShape()[axis2];
            int n = 0;
            while (n < dims) {
                int dim = n++;
                boolean bl = false;
                int inputAdditionalOffset = this$0.strides.getStrides()[$permutations[axis2]] * dim;
                int outputAdditionalOffset = outputStrides.getStrides()[axis2] * dim;
                PrimitiveNDArray.transpose$transposeRec(this$0, outputStrides, $permutations, outputArray2, axis2 + 1, inputOffset + inputAdditionalOffset, outputOffset + outputAdditionalOffset);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ%\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0086\u0002J\u0015\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\bH\u0086\u0002J.\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rH\u0087\u0002\u00a2\u0006\u0002\b\u000fJ.\u0010\t\u001a\u00020\u00042\n\u0010\u0005\u001a\u00020\u0006\"\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0087\u0002\u00a2\u0006\u0002\b\u0010J%\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\rH\u0086\u0002J\"\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u000eJ\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0017"}, d2={"Lio/kinference/ndarray/arrays/PrimitiveNDArray$Companion;", "", "()V", "eyeLike", "Lio/kinference/ndarray/arrays/PrimitiveNDArray;", "shape", "", "k", "", "invoke", "strides", "Lio/kinference/ndarray/arrays/Strides;", "init", "Lkotlin/Function1;", "Lio/kinference/primitives/types/PrimitiveType;", "invokeVarArg", "invokeNDVarArg", "matrixLike", "ones", "Lio/kinference/ndarray/arrays/MutablePrimitiveNDArray;", "scalar", "value", "zeros", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nPrimitiveNDArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveNDArray.kt\nio/kinference/ndarray/arrays/PrimitiveNDArray$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1313:1\n1#2:1314\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutablePrimitiveNDArray zeros(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return new MutablePrimitiveNDArray(shape);
        }

        @NotNull
        public final MutablePrimitiveNDArray ones(@NotNull int[] shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return new MutablePrimitiveNDArray(shape, (Function1<? super Integer, ? extends PrimitiveType>)((Function1)ones.1.INSTANCE));
        }

        @NotNull
        public final PrimitiveNDArray scalar(@NotNull PrimitiveType value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new PrimitiveNDArray(new PrimitiveTiledArray(1, 1, (Function1<? super Integer, ? extends PrimitiveType>)((Function1)new Function1<Integer, PrimitiveType>(value){
                final /* synthetic */ PrimitiveType $value;
                {
                    this.$value = $value;
                    super(1);
                }

                @NotNull
                public final PrimitiveType invoke(int it) {
                    return this.$value;
                }
            })), Strides.Companion.getEMPTY());
        }

        @NotNull
        public final PrimitiveNDArray matrixLike(@NotNull int[] shape, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            PrimitiveTiledArray blocks = PrimitiveTiledArray.Companion.matrixLike(shape, init);
            return new PrimitiveNDArray(blocks, new Strides(shape));
        }

        @NotNull
        public final PrimitiveNDArray eyeLike(@NotNull int[] shape, int k2) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            if (!(shape.length == 2)) {
                boolean bl = false;
                String string = "EyeLike is only supported for tensors of rank=2, current shape rank: " + shape.length;
                throw new IllegalArgumentException(string.toString());
            }
            return Companion.invoke(shape, (Function1<? super int[], ? extends PrimitiveType>)((Function1)new Function1<int[], PrimitiveType>(k2){
                final /* synthetic */ int $k;
                {
                    this.$k = $k;
                    super(1);
                }

                @NotNull
                public final PrimitiveType invoke(@NotNull int[] it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int row = it[0];
                    int column = it[1];
                    return column - this.$k == row ? PrimitiveConstants.INSTANCE.getONE() : PrimitiveConstants.INSTANCE.getZERO();
                }
            }));
        }

        public static /* synthetic */ PrimitiveNDArray eyeLike$default(Companion companion, int[] nArray, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 0;
            }
            return companion.eyeLike(nArray, n);
        }

        @NotNull
        public final PrimitiveNDArray invoke(@NotNull Strides strides2, @NotNull Function1<? super int[], ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)strides2, (String)"strides");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            NDIndexer iterator2 = new NDIndexer(strides2, null, null, 6, null);
            return new PrimitiveNDArray(strides2, (Function1<? super Integer, ? extends PrimitiveType>)((Function1)new Function1<Integer, PrimitiveType>(init, iterator2){
                final /* synthetic */ Function1<int[], PrimitiveType> $init;
                final /* synthetic */ NDIndexer $iterator;
                {
                    this.$init = $init;
                    this.$iterator = $iterator;
                    super(1);
                }

                @NotNull
                public final PrimitiveType invoke(int it) {
                    return (PrimitiveType)this.$init.invoke((Object)this.$iterator.next());
                }
            }));
        }

        @NotNull
        public final PrimitiveNDArray invoke(@NotNull int[] shape, @NotNull Function1<? super int[], ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @NotNull
        public final PrimitiveNDArray invoke(int ... shape) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            return new PrimitiveNDArray(PrimitiveTiledArray.Companion.invoke(shape), new Strides(shape));
        }

        @JvmName(name="invokeNDVarArg")
        @NotNull
        public final PrimitiveNDArray invokeNDVarArg(@NotNull int[] shape, @NotNull Function1<? super int[], ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return this.invoke(new Strides(shape), init);
        }

        @JvmName(name="invokeVarArg")
        @NotNull
        public final PrimitiveNDArray invokeVarArg(@NotNull int[] shape, @NotNull Function1<? super Integer, ? extends PrimitiveType> init) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter(init, (String)"init");
            return new PrimitiveNDArray(PrimitiveTiledArray.Companion.invoke(shape, init), new Strides(shape));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DataType.values().length];
            try {
                nArray[DataType.FLOAT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataType.DOUBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PadMode.values().length];
            try {
                nArray[PadMode.CONSTANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PadMode.EDGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PadMode.REFLECT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

