/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend;

import com.intellij.ide.startup.importSettings.fus.TransferSettingsCollector;
import com.intellij.ide.startup.importSettings.models.BaseIdeVersion;
import com.intellij.ide.startup.importSettings.providers.TransferSettingsProvider;
import com.intellij.ide.startup.importSettings.transfer.backend.TransferSettingsDataProviderKt;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J,\u0010\u000e\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\t0\t \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\t0\t\u0018\u00010\u00030\u000fH\u0002R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/TransferSettingsDataProviderSession;", "", "providers", "", "Lcom/intellij/ide/startup/importSettings/providers/TransferSettingsProvider;", "skipIds", "", "(Ljava/util/List;Ljava/util/List;)V", "baseIdeVersions", "Lcom/intellij/ide/startup/importSettings/models/BaseIdeVersion;", "getBaseIdeVersions", "()Ljava/util/List;", "baseIdeVersions$delegate", "Lkotlin/Lazy;", "createBaseIdeVersions", "", "kotlin.jvm.PlatformType", "intellij.ide.startup.importSettings"})
final class TransferSettingsDataProviderSession {
    @NotNull
    private final List<TransferSettingsProvider> providers;
    @Nullable
    private final List<String> skipIds;
    @NotNull
    private final Lazy baseIdeVersions$delegate;

    public TransferSettingsDataProviderSession(@NotNull List<? extends TransferSettingsProvider> providers, @Nullable List<String> skipIds) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providers = providers;
        this.skipIds = skipIds;
        this.baseIdeVersions$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<BaseIdeVersion>>(this){
            final /* synthetic */ TransferSettingsDataProviderSession this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final List<BaseIdeVersion> invoke() {
                return TransferSettingsDataProviderSession.access$createBaseIdeVersions(this.this$0);
            }
        }));
    }

    @NotNull
    public final List<BaseIdeVersion> getBaseIdeVersions() {
        Lazy lazy = this.baseIdeVersions$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (List)object;
    }

    private final List<BaseIdeVersion> createBaseIdeVersions() {
        return this.providers.parallelStream().flatMap(arg_0 -> TransferSettingsDataProviderSession.createBaseIdeVersions$lambda$0((Function1)new Function1<TransferSettingsProvider, Stream<? extends BaseIdeVersion>>(this){
            final /* synthetic */ TransferSettingsDataProviderSession this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Stream<? extends BaseIdeVersion> invoke(TransferSettingsProvider provider2) {
                Stream<E> stream;
                if (!provider2.isAvailable()) {
                    TransferSettingsDataProviderKt.access$getLogger$p().info("Provider " + provider2.getName() + " is not available");
                    return null;
                }
                try {
                    long startTime = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
                    List list = TransferSettingsDataProviderSession.access$getSkipIds$p(this.this$0);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    Stream<E> stream2 = provider2.getIdeVersions(list).stream();
                    Intrinsics.checkNotNullExpressionValue(stream2, (String)"stream(...)");
                    Stream<E> result2 = stream2;
                    long endTime = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
                    TransferSettingsCollector.INSTANCE.logPerformanceMeasured-Wn2Vu4Y(TransferSettingsCollector.PerformanceMetricType.Total, provider2.getTransferableIdeId(), null, Duration.minus-LRDsOJo((long)endTime, (long)startTime));
                    stream = result2;
                }
                catch (Throwable t) {
                    TransferSettingsDataProviderKt.access$getLogger$p().warn("Failed to get base ide versions", t);
                    return null;
                }
                return stream;
            }
        }, arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static final Stream createBaseIdeVersions$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stream)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ List access$getSkipIds$p(TransferSettingsDataProviderSession $this) {
        return $this.skipIds;
    }

    public static final /* synthetic */ List access$createBaseIdeVersions(TransferSettingsDataProviderSession $this) {
        return $this.createBaseIdeVersions();
    }
}

