/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.ui.toolwindow.ReviewTabViewModel;
import com.intellij.collaboration.util.ComputedResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.details.model.impl.GHPRDetailsViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model.GHPRInfoViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model.GHPRToolWindowProjectViewModel;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabViewModel;", "NewPullRequest", "PullRequest", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel$NewPullRequest;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel$PullRequest;", "intellij.vcs.github"})
@ApiStatus.Experimental
public interface GHPRToolWindowTabViewModel
extends ReviewTabViewModel {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0015\u001a\u00020\tR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel$NewPullRequest;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;)V", "_focusRequests", "Lkotlinx/coroutines/channels/Channel;", "", "allRepos", "", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "focusRequests", "Lkotlinx/coroutines/flow/Flow;", "getFocusRequests$intellij_vcs_github", "()Lkotlinx/coroutines/flow/Flow;", "requestFocus", "intellij.vcs.github"})
    @ApiStatus.Experimental
    @SourceDebugExtension(value={"SMAP\nGHPRToolWindowTabViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRToolWindowTabViewModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel$NewPullRequest\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n31#2,2:71\n1549#3:73\n1620#3,3:74\n*S KotlinDebug\n*F\n+ 1 GHPRToolWindowTabViewModel.kt\norg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel$NewPullRequest\n*L\n56#1:71,2\n56#1:73\n56#1:74,3\n*E\n"})
    public static final class NewPullRequest
    implements GHPRToolWindowTabViewModel {
        @NotNull
        private final List<GHRepositoryCoordinates> allRepos;
        @NotNull
        private final String displayName;
        @NotNull
        private final Channel<Unit> _focusRequests;
        @NotNull
        private final Flow<Unit> focusRequests;

        /*
         * WARNING - void declaration
         */
        public NewPullRequest(@NotNull Project project, @NotNull GHPRDataContext dataContext) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            Object $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GHHostedRepositoriesManager> serviceClass$iv = GHHostedRepositoriesManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            $this$service$iv = HostedGitRepositoriesManagerKt.getKnownRepositories((HostedGitRepositoriesManager)((HostedGitRepositoriesManager)object));
            NewPullRequest newPullRequest = this;
            boolean $i$f$map = false;
            serviceClass$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GHGitRepositoryMapping gHGitRepositoryMapping = (GHGitRepositoryMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getRepository());
            }
            newPullRequest.allRepos = (List)destination$iv$iv;
            Object[] objectArray = new Object[]{GHUIUtil.getRepositoryDisplayName$default(GHUIUtil.INSTANCE, this.allRepos, dataContext.getRepositoryDataService().getRepositoryCoordinates(), false, 4, null)};
            String string = GithubBundle.message("tab.title.pull.requests.new", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            this.displayName = string;
            this._focusRequests = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
            this.focusRequests = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._focusRequests));
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final Flow<Unit> getFocusRequests$intellij_vcs_github() {
            return this.focusRequests;
        }

        public final void requestFocus() {
            this._focusRequests.trySend-JP2dKIU((Object)Unit.INSTANCE);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001a\u001a\u00020\fH\u0016J\u0006\u0010\u001b\u001a\u00020\fJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u000fR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel$PullRequest;", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowTabViewModel;", "Lcom/intellij/openapi/Disposable;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "projectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowProjectViewModel;", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRToolWindowProjectViewModel;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "_focusRequests", "Lkotlinx/coroutines/channels/Channel;", "", "cs", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "focusRequests", "Lkotlinx/coroutines/flow/Flow;", "getFocusRequests$intellij_vcs_github", "()Lkotlinx/coroutines/flow/Flow;", "infoVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRInfoViewModel;", "getInfoVm", "()Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/model/GHPRInfoViewModel;", "dispose", "requestFocus", "selectCommit", "oid", "intellij.vcs.github"})
    @ApiStatus.Experimental
    public static final class PullRequest
    implements GHPRToolWindowTabViewModel,
    Disposable {
        @NotNull
        private final CoroutineScope cs;
        @NotNull
        private final String displayName;
        @NotNull
        private final GHPRInfoViewModel infoVm;
        @NotNull
        private final Channel<Unit> _focusRequests;
        @NotNull
        private final Flow<Unit> focusRequests;

        public PullRequest(@NotNull CoroutineScope parentCs, @NotNull GHPRToolWindowProjectViewModel projectVm2, @NotNull GHPRIdentifier id) {
            Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
            Intrinsics.checkNotNullParameter((Object)projectVm2, (String)"projectVm");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.cs = CoroutineUtilKt.cancelledWith((CoroutineScope)CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, null, (boolean)false, (int)3, null), (Disposable)this);
            this.displayName = "#" + id.getNumber();
            this.infoVm = projectVm2.acquireInfoViewModel(id, this);
            this._focusRequests = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
            this.focusRequests = FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._focusRequests));
        }

        @NotNull
        public String getDisplayName() {
            return this.displayName;
        }

        @NotNull
        public final GHPRInfoViewModel getInfoVm() {
            return this.infoVm;
        }

        @NotNull
        public final Flow<Unit> getFocusRequests$intellij_vcs_github() {
            return this.focusRequests;
        }

        public final void requestFocus() {
            this._focusRequests.trySend-JP2dKIU((Object)Unit.INSTANCE);
        }

        public final void selectCommit(@NotNull String oid) {
            block0: {
                Object object;
                Intrinsics.checkNotNullParameter((Object)oid, (String)"oid");
                Object object2 = ((ComputedResult)this.infoVm.getDetailsVm().getValue()).unbox-impl();
                if (object2 == null || (object2 = (GHPRDetailsViewModel)(Result.isFailure-impl((Object)(object = object2.unbox-impl())) ? null : object)) == null || (object2 = object2.getChangesVm()) == null) break block0;
                object2.selectCommit(oid);
            }
        }

        public void dispose() {
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
        }
    }
}

