/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.text.StringKt;
import git4idea.GitRemoteBranch;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorKt;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRestIdOnly;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRestIdOnlyKt;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCreationService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCreationServiceImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJF\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001e\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0013H\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;)V", "baseRepo", "Lorg/jetbrains/plugins/github/util/GHGitRepositoryMapping;", "repositoryId", "", "createPullRequest", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "baseBranch", "Lgit4idea/GitRemoteBranch;", "headRepo", "headBranch", "title", "description", "draft", "", "findOpenPullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "(Lgit4idea/GitRemoteBranch;Lorg/jetbrains/plugins/github/api/GHRepositoryPath;Lgit4idea/GitRemoteBranch;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findPullRequest", "getHeadRepoPrefix", "intellij.vcs.github"})
public final class GHPRCreationServiceImpl
implements GHPRCreationService {
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GHGitRepositoryMapping baseRepo;
    @NotNull
    private final String repositoryId;

    public GHPRCreationServiceImpl(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GHPRRepositoryDataService repositoryDataService) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        this.progressManager = progressManager;
        this.requestExecutor = requestExecutor;
        this.baseRepo = repositoryDataService.getRepositoryMapping();
        this.repositoryId = repositoryDataService.getRepositoryId();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestShort> createPullRequest(@NotNull ProgressIndicator progressIndicator, @NotNull GitRemoteBranch baseBranch, @NotNull GHGitRepositoryMapping headRepo, @NotNull GitRemoteBranch headBranch, @NotNull String title2, @NotNull String description, boolean draft) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
        Intrinsics.checkNotNullParameter((Object)headRepo, (String)"headRepo");
        Intrinsics.checkNotNullParameter((Object)headBranch, (String)"headBranch");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        return CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPullRequestShort>(this, headRepo, title2, headBranch, description, baseBranch, draft){
            final /* synthetic */ GHPRCreationServiceImpl this$0;
            final /* synthetic */ GHGitRepositoryMapping $headRepo;
            final /* synthetic */ String $title;
            final /* synthetic */ GitRemoteBranch $headBranch;
            final /* synthetic */ String $description;
            final /* synthetic */ GitRemoteBranch $baseBranch;
            final /* synthetic */ boolean $draft;
            {
                this.this$0 = $receiver;
                this.$headRepo = $headRepo;
                this.$title = $title;
                this.$headBranch = $headBranch;
                this.$description = $description;
                this.$baseBranch = $baseBranch;
                this.$draft = $draft;
                super(1);
            }

            @NotNull
            public final GHPullRequestShort invoke(@NotNull ProgressIndicator it) {
                String string;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.setText(GithubBundle.message("pull.request.create.process.title", new Object[0]));
                String headRepositoryPrefix = GHPRCreationServiceImpl.access$getHeadRepoPrefix(this.this$0, this.$headRepo);
                String p0 = string = this.$title;
                boolean bl = false;
                String string2 = !StringsKt.isBlank((CharSequence)p0) ? string : null;
                if (string2 == null) {
                    String string3 = this.$headBranch.getNameForRemoteOperations();
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameForRemoteOperations(...)");
                }
                String actualTitle = string2;
                String body2 = StringKt.nullize((String)this.$description, (boolean)true);
                GithubApiRequestExecutor githubApiRequestExecutor = GHPRCreationServiceImpl.access$getRequestExecutor$p(this.this$0);
                GHRepositoryCoordinates gHRepositoryCoordinates = GHPRCreationServiceImpl.access$getBaseRepo$p(this.this$0).getRepository();
                String string4 = GHPRCreationServiceImpl.access$getRepositoryId$p(this.this$0);
                String string5 = this.$baseBranch.getNameForRemoteOperations();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getNameForRemoteOperations(...)");
                return (GHPullRequestShort)githubApiRequestExecutor.execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.create(gHRepositoryCoordinates, string4, string5, headRepositoryPrefix + this.$headBranch.getNameForRemoteOperations(), actualTitle, body2, this.$draft));
            }
        });
    }

    @Override
    @Nullable
    public GHPRIdentifier findPullRequest(@NotNull ProgressIndicator progressIndicator, @NotNull GitRemoteBranch baseBranch, @NotNull GHGitRepositoryMapping headRepo, @NotNull GitRemoteBranch headBranch) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
        Intrinsics.checkNotNullParameter((Object)headRepo, (String)"headRepo");
        Intrinsics.checkNotNullParameter((Object)headBranch, (String)"headBranch");
        progressIndicator.setText(GithubBundle.message("pull.request.existing.process.title", new Object[0]));
        GHPullRequestRestIdOnly gHPullRequestRestIdOnly = (GHPullRequestRestIdOnly)CollectionsKt.firstOrNull(this.requestExecutor.execute(progressIndicator, GithubApiRequests.Repos.PullRequests.find(this.baseRepo.getRepository(), GithubIssueState.open, baseBranch.getNameForRemoteOperations(), headRepo.getRepository().getRepositoryPath().getOwner() + ":" + headBranch.getNameForRemoteOperations())).getItems());
        return gHPullRequestRestIdOnly != null ? GHPullRequestRestIdOnlyKt.toPRIdentifier(gHPullRequestRestIdOnly) : null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object findOpenPullRequest(@Nullable GitRemoteBranch var1_1, @NotNull GHRepositoryPath var2_2, @NotNull GitRemoteBranch var3_3, @NotNull Continuation<? super GHPRIdentifier> var4_4) {
        if (!(var4_4 instanceof findOpenPullRequest.1)) ** GOTO lbl-1000
        var6_5 = var4_4;
        if ((var6_5.label & -2147483648) != 0) {
            var6_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                final /* synthetic */ GHPRCreationServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.findOpenPullRequest(null, null, null, (Continuation<? super GHPRIdentifier>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = baseBranch;
                $continuation.label = 1;
                v1 = GithubApiRequestExecutorKt.executeSuspend(this.requestExecutor, GithubApiRequests.Repos.PullRequests.find(this.baseRepo.getRepository(), GithubIssueState.open, v0 != null ? v0.getNameForRemoteOperations() : null, headRepo.getOwner() + ":" + headBranch.getNameForRemoteOperations()), $continuation);
                if (v1 == var7_7) {
                    return var7_7;
                }
                ** GOTO lbl21
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl21:
                // 2 sources

                v2 = (GHPullRequestRestIdOnly)CollectionsKt.firstOrNull(((GithubResponsePage)v1).getItems());
                return v2 != null ? GHPullRequestRestIdOnlyKt.toPRIdentifier(v2) : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String getHeadRepoPrefix(GHGitRepositoryMapping headRepo) {
        return Intrinsics.areEqual((Object)this.baseRepo.getRepository(), (Object)headRepo.getRepository()) ? "" : headRepo.getRepository().getRepositoryPath().getOwner() + ":";
    }

    public static final /* synthetic */ String access$getHeadRepoPrefix(GHPRCreationServiceImpl $this, GHGitRepositoryMapping headRepo) {
        return $this.getHeadRepoPrefix(headRepo);
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRCreationServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHGitRepositoryMapping access$getBaseRepo$p(GHPRCreationServiceImpl $this) {
        return $this.baseRepo;
    }

    public static final /* synthetic */ String access$getRepositoryId$p(GHPRCreationServiceImpl $this) {
        return $this.repositoryId;
    }
}

