/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.installer;

import com.google.common.hash.Hashing;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.sdk.Binary;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.installer.BinaryInstaller;
import com.jetbrains.python.sdk.installer.BinaryInstallerException;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.CancelledPrepareException;
import com.jetbrains.python.sdk.installer.PrepareException;
import com.jetbrains.python.sdk.installer.ProcessException;
import com.jetbrains.python.sdk.installer.ResourcePreview;
import com.jetbrains.python.sdk.installer.WrongChecksumPrepareException;
import com.jetbrains.python.sdk.installer.WrongSizePrepareException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u000e\u001a\u00020\u000fH&J&\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u0014H\u0016J$\u0010\u0015\u001a\u00020\u00042\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/python/sdk/installer/DownloadableBinaryInstaller;", "Lcom/jetbrains/python/sdk/installer/BinaryInstaller;", "()V", "checkConsistency", "", "resource", "Lcom/jetbrains/python/sdk/Resource;", "target", "Ljava/nio/file/Path;", "download", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getPreview", "Lcom/jetbrains/python/sdk/installer/ResourcePreview;", "binary", "Lcom/jetbrains/python/sdk/Binary;", "getResourcesToDownload", "", "install", "onPrepareComplete", "Lkotlin/Function0;", "process", "resourcePaths", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nDownloadableBinaryInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadableBinaryInstaller.kt\ncom/jetbrains/python/sdk/installer/DownloadableBinaryInstaller\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1271#2,2:106\n1285#2,4:108\n1855#2:114\n1856#2:116\n1855#2,2:117\n215#3,2:112\n1#4:115\n*S KotlinDebug\n*F\n+ 1 DownloadableBinaryInstaller.kt\ncom/jetbrains/python/sdk/installer/DownloadableBinaryInstaller\n*L\n44#1:106,2\n44#1:108,4\n58#1:114\n58#1:116\n58#1:117,2\n49#1:112,2\n*E\n"})
public abstract class DownloadableBinaryInstaller
implements BinaryInstaller {
    @NotNull
    public abstract List<Resource> getResourcesToDownload(@NotNull Binary var1);

    public abstract void process(@NotNull Map<Resource, ? extends Path> var1, @NotNull ProgressIndicator var2) throws ProcessException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void install(@NotNull Binary binary, @NotNull ProgressIndicator indicator, @NotNull Function0<Unit> onPrepareComplete) throws BinaryInstallerException {
        Object resource;
        Map.Entry element$iv;
        boolean $i$f$forEach;
        Object $this$forEach$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(onPrepareComplete, (String)"onPrepareComplete");
        String string = PathManager.getTempPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempPath(...)");
        String tempPath = string;
        Iterable $this$associateWith$iv = this.getResourcesToDownload(binary);
        boolean $i$f$associateWith = false;
        Iterator result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            object = (Resource)element$iv$iv;
            Object t = element$iv$iv;
            Map map = (Map)((Object)result$iv);
            boolean bl = false;
            String[] stringArray = new String[]{System.nanoTime() + "-" + it.getFileName()};
            Path path2 = Paths.get(tempPath, stringArray);
            map.put(t, path2);
        }
        Map files = (Map)((Object)result$iv);
        try {
            indicator.setText(PySdkBundle.message("python.sdk.preparation.progress.text", new Object[0]));
            $this$forEach$iv = files;
            $i$f$forEach = false;
            result$iv = $this$forEach$iv.entrySet().iterator();
            while (result$iv.hasNext()) {
                Map.Entry $i$f$associateWithTo2 = element$iv = (Map.Entry)result$iv.next();
                boolean bl = false;
                resource = (Resource)$i$f$associateWithTo2.getKey();
                Path path3 = (Path)$i$f$associateWithTo2.getValue();
                Intrinsics.checkNotNull((Object)path3);
                this.download((Resource)resource, path3, indicator);
            }
            onPrepareComplete.invoke();
            this.process(files, indicator);
        }
        catch (Throwable throwable) {
            Iterable $this$forEach$iv2 = files.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object object2;
                Path it = (Path)element$iv2;
                boolean bl = false;
                object = this;
                try {
                    Object $this$install_u24lambda_u243_u24lambda_u242 = object;
                    boolean bl2 = false;
                    FileUtil.delete((Path)it);
                    object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable2) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
            }
            throw throwable;
        }
        $this$forEach$iv = files.values();
        $i$f$forEach = false;
        result$iv = $this$forEach$iv.iterator();
        while (result$iv.hasNext()) {
            element$iv = result$iv.next();
            Path it = (Path)((Object)element$iv);
            boolean bl = false;
            resource = this;
            try {
                DownloadableBinaryInstaller $this$install_u24lambda_u243_u24lambda_u242 = (DownloadableBinaryInstaller)resource;
                boolean bl3 = false;
                FileUtil.delete((Path)it);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
        }
    }

    private final void checkConsistency(Resource resource, Path target) throws PrepareException {
        BinaryInstallerKt.getLOGGER().debug("Checking installer size");
        long sizeDiff = Files.size(target) - resource.getSize();
        if (sizeDiff != 0L) {
            throw new WrongSizePrepareException(target, sizeDiff);
        }
        BinaryInstallerKt.getLOGGER().debug("Checking installer checksum");
        String string = com.google.common.io.Files.asByteSource((File)target.toFile()).hash(Hashing.sha256()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actualHashCode = string;
        if (!StringsKt.equals((String)resource.getSha256(), (String)actualHashCode, (boolean)true)) {
            throw new WrongChecksumPrepareException(target, resource.getSha256(), actualHashCode);
        }
    }

    private final void download(Resource resource, Path target, ProgressIndicator indicator) throws PrepareException {
        BinaryInstallerKt.getLOGGER().info("Downloading " + resource.getUrl() + " to " + target);
        String string = StringUtil.formatFileSize((long)resource.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String fileSizeHumanReadable = string;
        Object[] objectArray = new Object[]{fileSizeHumanReadable, resource.getFileName()};
        indicator.setText2(PySdkBundle.message("python.sdk.downloading.progress.details", objectArray));
        try {
            indicator.checkCanceled();
            HttpRequests.request((Url)resource.getUrl()).productNameAsUserAgent().saveToFile(target.toFile(), indicator);
            indicator.checkCanceled();
            this.checkConsistency(resource, target);
        }
        catch (ProcessCanceledException e) {
            throw new CancelledPrepareException(e);
        }
        catch (PrepareException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PrepareException(e);
        }
    }

    @Override
    @NotNull
    public ResourcePreview getPreview(@NotNull Binary binary) {
        Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
        return ResourcePreview.Companion.of((Resource)CollectionsKt.firstOrNull(this.getResourcesToDownload(binary)));
    }
}

