/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.CondaExecutablesLocator;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyCondaPackageService;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.flavors.CondaEnvironmentsList;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\u001e\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\bH\u0002\u001a \u0010\u000e\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0007\u001a\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0007\u001a\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0007\u001a\"\u0010\u0011\u001a\u00020\u0012*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0002\u00a8\u0006\u0013"}, d2={"findCondaExecutable", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "listCondaEnvironments", "", "condaExecutable", "readCondaEnv", "", "run", "Lcom/intellij/execution/process/ProcessOutput;", "executable", "arguments", "env", "runConda", "runCondaPython", "condaPythonExecutable", "checkExitCode", "", "intellij.python.sdk"})
@SourceDebugExtension(value={"SMAP\nPyCondaRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyCondaRun.kt\ncom/jetbrains/python/sdk/flavors/PyCondaRunKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public final class PyCondaRunKt {
    @Deprecated(message="Use Sdk.configureBuilderToRunPythonOnTarget")
    @NotNull
    public static final ProcessOutput runConda(@NotNull String condaExecutable, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)condaExecutable, (String)"condaExecutable");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return PyCondaRunKt.run(condaExecutable, arguments, PyCondaRunKt.readCondaEnv(condaExecutable));
    }

    @Deprecated(message="Use Sdk.configureBuilderToRunPythonOnTarget")
    @NotNull
    public static final ProcessOutput runConda(@Nullable Sdk sdk2, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String condaExecutable = PyCondaRunKt.findCondaExecutable(sdk2);
        Map<String, String> environment = sdk2 != null ? PySdkUtil.activateVirtualEnv(sdk2) : PyCondaRunKt.readCondaEnv(condaExecutable);
        return PyCondaRunKt.run(condaExecutable, arguments, environment);
    }

    @Deprecated(message="Use Sdk.configureBuilderToRunPythonOnTarget")
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final ProcessOutput runCondaPython(@NotNull String condaPythonExecutable, @NotNull List<String> arguments) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)condaPythonExecutable, (String)"condaPythonExecutable");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return PyCondaRunKt.run(condaPythonExecutable, arguments, PySdkUtil.activateVirtualEnv(condaPythonExecutable));
    }

    private static final ProcessOutput run(String executable, List<String> arguments, Map<String, String> env) {
        CapturingProcessHandler capturingProcessHandler;
        String[] stringArray = new String[]{executable};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray).withParameters(arguments).withEnvironment(env);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withEnvironment(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator == null) {
            progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
        }
        ProgressIndicator indicator = progressIndicator;
        CapturingProcessHandler $this$run_u24lambda_u240 = capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        $this$run_u24lambda_u240.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
        CapturingProcessHandler handler2 = capturingProcessHandler;
        ProcessOutput processOutput = handler2.runProcessWithProgressIndicator(indicator);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcessWithProgressIndicator(...)");
        CapturingProcessHandler $this$run_u24lambda_u241 = capturingProcessHandler = processOutput;
        boolean bl2 = false;
        if ($this$run_u24lambda_u241.isCancelled()) {
            throw new RunCanceledByUserException();
        }
        PyCondaRunKt.checkExitCode((ProcessOutput)$this$run_u24lambda_u241, executable, arguments);
        return capturingProcessHandler;
    }

    private static final Map<String, String> readCondaEnv(String condaExecutable) {
        Map<String, String> map;
        String string = CondaExecutablesLocator.getCondaBasePython(condaExecutable);
        if (string != null) {
            String it = string;
            boolean bl = false;
            map = PySdkUtil.activateVirtualEnv(it);
        } else {
            map = null;
        }
        return map;
    }

    private static final String findCondaExecutable(Sdk sdk2) throws ExecutionException {
        Sdk sdk3 = sdk2;
        String string = PyCondaPackageService.Companion.getCondaExecutable(sdk3 != null ? sdk3.getHomePath() : null);
        if (string == null) {
            throw new ExecutionException(PySdkBundle.message("python.sdk.flavor.cannot.find.conda", new Object[0]));
        }
        return string;
    }

    private static final void checkExitCode(ProcessOutput $this$checkExitCode, String executable, List<String> arguments) throws PyExecutionException {
        if ($this$checkExitCode.getExitCode() != 0) {
            String string = StringUtil.isEmptyOrSpaces((String)$this$checkExitCode.getStdout()) && StringUtil.isEmptyOrSpaces((String)$this$checkExitCode.getStderr()) ? PySdkBundle.message("python.conda.permission.denied", new Object[0]) : PySdkBundle.message("python.conda.non.zero.exit.code", new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String message = string;
            throw new PyExecutionException(message, executable, arguments, $this$checkExitCode);
        }
    }

    @Deprecated(message="Use PyCondaEnv")
    @NotNull
    public static final List<String> listCondaEnvironments(@NotNull String condaExecutable) throws ExecutionException, JsonSyntaxException {
        Intrinsics.checkNotNullParameter((Object)condaExecutable, (String)"condaExecutable");
        Object[] objectArray = new String[]{"env", "list", "--json"};
        ProcessOutput output2 = PyCondaRunKt.runConda(condaExecutable, (List<String>)CollectionsKt.listOf((Object[])objectArray));
        String string = output2.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        String text = string;
        CondaEnvironmentsList envList = (CondaEnvironmentsList)new Gson().fromJson(text, CondaEnvironmentsList.class);
        return envList.getEnvs();
    }
}

