/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.conda;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.Product;
import com.jetbrains.python.sdk.Release;
import com.jetbrains.python.sdk.Resource;
import com.jetbrains.python.sdk.ResourceType;
import com.jetbrains.python.sdk.SdksKeeper;
import com.jetbrains.python.sdk.conda.CondaInstallManager;
import com.jetbrains.python.sdk.installer.BinaryInstallation;
import com.jetbrains.python.sdk.installer.BinaryInstallerKt;
import com.jetbrains.python.sdk.installer.MakeShellScriptExecutableException;
import com.jetbrains.python.sdk.installer.ResourceTypeBinaryInstaller;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0002\u0004\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u0007J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\bH\u0007R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/python/sdk/conda/CondaInstallManager;", "", "()V", "applePkgInstaller", "com/jetbrains/python/sdk/conda/CondaInstallManager$applePkgInstaller$1", "Lcom/jetbrains/python/sdk/conda/CondaInstallManager$applePkgInstaller$1;", "productInstallers", "", "Lcom/jetbrains/python/sdk/Product;", "", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "shellScriptInstaller", "com/jetbrains/python/sdk/conda/CondaInstallManager$shellScriptInstaller$1", "Lcom/jetbrains/python/sdk/conda/CondaInstallManager$shellScriptInstaller$1;", "getAvailableCondaInstallations", "Lcom/jetbrains/python/psi/LanguageLevel;", "Lcom/jetbrains/python/sdk/installer/BinaryInstallation;", "installLatest", "", "project", "Lcom/intellij/openapi/project/Project;", "product", "WindowsInstaller", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nCondaInstallManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CondaInstallManager.kt\ncom/jetbrains/python/sdk/conda/CondaInstallManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,109:1\n1360#2:110\n1446#2,2:111\n1448#2,3:114\n1271#2,2:117\n1285#2,2:119\n766#2:121\n857#2,2:122\n1288#2:124\n1963#2,5:132\n533#2,6:137\n1969#2,2:143\n533#2,6:145\n1971#2,6:151\n1#3:113\n494#4,7:125\n*S KotlinDebug\n*F\n+ 1 CondaInstallManager.kt\ncom/jetbrains/python/sdk/conda/CondaInstallManager\n*L\n79#1:110\n79#1:111,2\n79#1:114,3\n83#1:117,2\n83#1:119,2\n84#1:121\n84#1:122,2\n83#1:124\n96#1:132,5\n97#1:137,6\n96#1:143,2\n97#1:145,6\n96#1:151,6\n85#1:125,7\n*E\n"})
public final class CondaInstallManager {
    @NotNull
    public static final CondaInstallManager INSTANCE = new CondaInstallManager();
    @NotNull
    private static final shellScriptInstaller.1 shellScriptInstaller;
    @NotNull
    private static final applePkgInstaller.1 applePkgInstaller;
    @NotNull
    private static final Map<Product, List<ResourceTypeBinaryInstaller>> productInstallers;

    private CondaInstallManager() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<LanguageLevel, List<BinaryInstallation>> getAvailableCondaInstallations() {
        Object list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = SdksKeeper.condaReleases$default(SdksKeeper.INSTANCE, null, 1, null);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Release release = (Release)element$iv$iv;
            boolean bl = false;
            Release release2 = release;
            Map<Product, List<ResourceTypeBinaryInstaller>> map = productInstallers;
            List list = map.get((Object)release.getProduct());
            if (list == null) {
                Release release3 = release2;
                boolean bl2 = false;
                list = CollectionsKt.emptyList();
                release2 = release3;
            }
            list$iv$iv = BinaryInstallerKt.selectInstallations(release2, list);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List installations = (List)destination$iv$iv;
        List<LanguageLevel> list = LanguageLevel.SUPPORTED_LEVELS;
        Intrinsics.checkNotNullExpressionValue(list, (String)"SUPPORTED_LEVELS");
        Iterable $this$associateWith$iv = list;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            list$iv$iv = (LanguageLevel)((Object)element$iv$iv);
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Iterable $this$filter$iv = installations;
            boolean $i$f$filter = false;
            Iterable bl2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void languageLevel;
                BinaryInstallation it = (BinaryInstallation)element$iv$iv2;
                boolean bl3 = false;
                List<String> list2 = it.getBinary().getTags();
                if (!(list2 != null ? list2.contains(languageLevel.name()) : false)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list3 = (List)destination$iv$iv2;
            map.put(t, list3);
        }
        Map $this$filterValues$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl = false;
            boolean bl4 = !((Collection)it).isEmpty();
            if (!bl4) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @RequiresEdt
    public final void installLatest(@Nullable Project project2, @NotNull Product product) {
        Object v3;
        Intrinsics.checkNotNullParameter((Object)((Object)product), (String)"product");
        Object object = new Product[]{product};
        Release release = (Release)CollectionsKt.firstOrNull(SdksKeeper.INSTANCE.condaReleases((Product[])object));
        if (release == null) {
            throw new IllegalStateException(("There is no available conda releases of the product " + product).toString());
        }
        object = productInstallers;
        Release latestRelease = release;
        Object object2 = object.get((Object)latestRelease.getProduct());
        if (object2 == null) {
            boolean bl = false;
            object2 = CollectionsKt.emptyList();
        }
        List installers = (List)object2;
        List<BinaryInstallation> installations = BinaryInstallerKt.selectInstallations(latestRelease, installers);
        List<LanguageLevel> list = LanguageLevel.SUPPORTED_LEVELS;
        Intrinsics.checkNotNullExpressionValue(list, (String)"SUPPORTED_LEVELS");
        LanguageLevel unknownLevel = (LanguageLevel)((Object)CollectionsKt.first(list));
        Iterable $this$maxByOrNull$iv = installations;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v3 = maxElem$iv;
            } else {
                LanguageLevel languageLevel;
                LanguageLevel languageLevel2;
                block16: {
                    BinaryInstallation bi = (BinaryInstallation)maxElem$iv;
                    boolean bl = false;
                    List<LanguageLevel> list2 = LanguageLevel.SUPPORTED_LEVELS;
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"SUPPORTED_LEVELS");
                    List<LanguageLevel> $this$lastOrNull$iv = list2;
                    boolean $i$f$lastOrNull = false;
                    ListIterator<LanguageLevel> iterator$iv2 = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                    while (iterator$iv2.hasPrevious()) {
                        boolean bl2;
                        LanguageLevel element$iv;
                        LanguageLevel level = element$iv = iterator$iv2.previous();
                        boolean bl3 = false;
                        if (bi.getBinary().getTags() != null) {
                            List<String> tags;
                            boolean bl4 = false;
                            bl2 = tags.contains(level.name());
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        languageLevel2 = element$iv;
                        break block16;
                    }
                    languageLevel2 = null;
                }
                if ((languageLevel = (LanguageLevel)languageLevel2) == null) {
                    languageLevel = unknownLevel;
                }
                Comparable maxValue$iv = (Comparable)((Object)languageLevel);
                do {
                    Comparable v$iv;
                    LanguageLevel languageLevel3;
                    LanguageLevel languageLevel4;
                    Object e$iv;
                    block17: {
                        List<LanguageLevel> $this$lastOrNull$iv;
                        e$iv = iterator$iv.next();
                        BinaryInstallation bi = (BinaryInstallation)e$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue(LanguageLevel.SUPPORTED_LEVELS, (String)"SUPPORTED_LEVELS");
                        boolean $i$f$lastOrNull = false;
                        ListIterator<LanguageLevel> iterator$iv3 = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                        while (iterator$iv3.hasPrevious()) {
                            boolean bl5;
                            LanguageLevel element$iv;
                            LanguageLevel level = element$iv = iterator$iv3.previous();
                            boolean bl6 = false;
                            if (bi.getBinary().getTags() != null) {
                                List<String> tags;
                                boolean bl7 = false;
                                bl5 = tags.contains(level.name());
                            } else {
                                bl5 = false;
                            }
                            if (!bl5) continue;
                            languageLevel4 = element$iv;
                            break block17;
                        }
                        languageLevel4 = null;
                    }
                    if ((languageLevel3 = (LanguageLevel)languageLevel4) == null) {
                        languageLevel3 = unknownLevel;
                    }
                    if (maxValue$iv.compareTo(v$iv = (Comparable)((Object)languageLevel3)) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v3 = maxElem$iv;
            }
        }
        BinaryInstallation installationWithHighestPython = v3;
        if (installationWithHighestPython == null) {
            throw new IllegalStateException(("There is no supported conda installation for the release " + latestRelease).toString());
        }
        BinaryInstallerKt.installBinary$default(installationWithHighestPython, project2, null, 4, null);
    }

    public static /* synthetic */ void installLatest$default(CondaInstallManager condaInstallManager, Project project2, Product product, int n, Object object) {
        if ((n & 2) != 0) {
            product = Product.Miniconda;
        }
        condaInstallManager.installLatest(project2, product);
    }

    static {
        Pair[] pairArray = ResourceType.SHELL_SCRIPT;
        shellScriptInstaller = new ResourceTypeBinaryInstaller((ResourceType)pairArray){

            @NotNull
            public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                if (!path2.toFile().setExecutable(true, true)) {
                    throw new MakeShellScriptExecutableException(path2);
                }
                String[] stringArray = new String[]{((Object)path2.toAbsolutePath()).toString(), "-b", "-u"};
                return new GeneralCommandLine(stringArray);
            }
        };
        pairArray = ResourceType.APPLE_SOFTWARE_PACKAGE;
        applePkgInstaller = new ResourceTypeBinaryInstaller((ResourceType)pairArray){

            @NotNull
            public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
                Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
                String[] stringArray = new String[]{"installer", "-pkg", ((Object)path2.toAbsolutePath()).toString(), "-target", "CurrentUserHomeDirectory"};
                return new GeneralCommandLine(stringArray);
            }
        };
        pairArray = new Pair[2];
        Object[] objectArray = new ResourceTypeBinaryInstaller[]{new WindowsInstaller("%UserProfile%\\miniconda3"), shellScriptInstaller, applePkgInstaller};
        pairArray[0] = TuplesKt.to((Object)((Object)Product.Miniconda), (Object)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new ResourceTypeBinaryInstaller[]{new WindowsInstaller("%UserProfile%\\anaconda3"), shellScriptInstaller, applePkgInstaller};
        pairArray[1] = TuplesKt.to((Object)((Object)Product.Anaconda), (Object)CollectionsKt.listOf((Object[])objectArray));
        productInstallers = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/python/sdk/conda/CondaInstallManager$WindowsInstaller;", "Lcom/jetbrains/python/sdk/installer/ResourceTypeBinaryInstaller;", "installPath", "", "(Ljava/lang/String;)V", "buildCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "resource", "Lcom/jetbrains/python/sdk/Resource;", "path", "Ljava/nio/file/Path;", "intellij.python.community.impl"})
    public static final class WindowsInstaller
    extends ResourceTypeBinaryInstaller {
        @NotNull
        private final String installPath;

        public WindowsInstaller(@NotNull String installPath) {
            Intrinsics.checkNotNullParameter((Object)installPath, (String)"installPath");
            super(ResourceType.MICROSOFT_WINDOWS_EXECUTABLE);
            this.installPath = installPath;
        }

        @Override
        @NotNull
        public GeneralCommandLine buildCommandLine(@NotNull Resource resource, @NotNull Path path2) {
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            String[] stringArray = new String[]{((Object)path2.toAbsolutePath()).toString(), "/InstallationType=JustMe", "/AddToPath=0", "/RegisterPython=0", "/S", "/D=" + this.installPath};
            return new GeneralCommandLine(stringArray);
        }
    }
}

