/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add.target;

import com.intellij.CommonBundle;
import com.intellij.execution.target.IncompleteTargetEnvironmentConfiguration;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBCardLayout;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.add.CreateSdkInterrupted;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkView;
import com.jetbrains.python.sdk.add.PyAddSystemWideInterpreterPanel;
import com.jetbrains.python.sdk.add.WizardUIUtilKt;
import com.jetbrains.python.sdk.add.target.PyAddVirtualEnvPanel;
import com.jetbrains.python.sdk.add.target.PyInterpreterTargetsKt;
import com.jetbrains.python.sdk.add.target.conda.PyAddCondaPanelModel;
import com.jetbrains.python.sdk.add.target.conda.PyAddCondaPanelView;
import com.jetbrains.python.sdk.conda.PyCondaSdkCustomizer;
import com.jetbrains.python.sdk.pipenv.PyAddPipEnvPanel;
import com.jetbrains.python.sdk.poetry.PoetryKt;
import com.jetbrains.python.target.PythonLanguageRuntimeConfiguration;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011BI\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\u001e\u0010\u001f\u001a\u00020 2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00072\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0006\u0010\"\u001a\u00020#J(\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0007\u0012\u0004\u0012\u00020\u00190%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0012\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\b\u0010+\u001a\u00020,H\u0016J\u0006\u0010-\u001a\u00020,J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0007J\b\u00100\u001a\u0004\u0018\u00010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/jetbrains/python/sdk/add/target/PyAddTargetBasedSdkPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "targetSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "config", "Lcom/jetbrains/python/target/PythonLanguageRuntimeConfiguration;", "introspectable", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/util/function/Supplier;Lcom/jetbrains/python/target/PythonLanguageRuntimeConfiguration;Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;)V", "context", "Lcom/intellij/openapi/util/UserDataHolderBase;", "isUnderLocalTarget", "", "()Z", "mainPanel", "Ljavax/swing/JPanel;", "panels", "Lcom/jetbrains/python/sdk/add/PyAddSdkView;", "selectedPanel", "targetEnvironmentConfiguration", "getTargetEnvironmentConfiguration", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "createAnacondaPanel", "createCardSplitter", "Lcom/intellij/openapi/ui/Splitter;", "initiallySelectedPanel", "createCenterPanel", "Ljavax/swing/JComponent;", "createPanels", "Lkotlin/Pair;", "sdks", "createPipEnvPanel", "Lcom/jetbrains/python/sdk/pipenv/PyAddPipEnvPanel;", "newProjectPath", "", "dispose", "", "doOKAction", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getOrCreateSdk", "Companion", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyAddTargetBasedSdkPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyAddTargetBasedSdkPanel.kt\ncom/jetbrains/python/sdk/add/target/PyAddTargetBasedSdkPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n766#2:216\n857#2,2:217\n800#2,11:219\n1855#2,2:230\n*S KotlinDebug\n*F\n+ 1 PyAddTargetBasedSdkPanel.kt\ncom/jetbrains/python/sdk/add/target/PyAddTargetBasedSdkPanel\n*L\n71#1:216\n71#1:217,2\n74#1:219,11\n74#1:230,2\n*E\n"})
public final class PyAddTargetBasedSdkPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @Nullable
    private final Module module;
    @NotNull
    private final List<Sdk> existingSdks;
    @Nullable
    private final Supplier<TargetEnvironmentConfiguration> targetSupplier;
    @NotNull
    private final PythonLanguageRuntimeConfiguration config;
    @Nullable
    private final LanguageRuntimeType.Introspectable introspectable;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private PyAddSdkView selectedPanel;
    @NotNull
    private final UserDataHolderBase context;
    @NotNull
    private List<? extends PyAddSdkView> panels;
    @NotNull
    private static final String SPLITTER_COMPONENT_CARD_PANE = "Splitter";

    public PyAddTargetBasedSdkPanel(@Nullable Project project2, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable Supplier<TargetEnvironmentConfiguration> targetSupplier, @NotNull PythonLanguageRuntimeConfiguration config, @Nullable LanguageRuntimeType.Introspectable introspectable) {
        Intrinsics.checkNotNullParameter(existingSdks, (String)"existingSdks");
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        this.project = project2;
        this.module = module;
        this.existingSdks = existingSdks;
        this.targetSupplier = targetSupplier;
        this.config = config;
        this.introspectable = introspectable;
        this.mainPanel = new JPanel((LayoutManager)new JBCardLayout());
        this.context = new UserDataHolderBase();
        this.panels = CollectionsKt.emptyList();
    }

    private final TargetEnvironmentConfiguration getTargetEnvironmentConfiguration() {
        Supplier<TargetEnvironmentConfiguration> supplier = this.targetSupplier;
        return supplier != null ? supplier.get() : null;
    }

    private final boolean isUnderLocalTarget() {
        return this.getTargetEnvironmentConfiguration() == null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent createCenterPanel() {
        void $this$forEach$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.existingSdks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Sdk it = (Sdk)element$iv$iv;
            boolean bl = false;
            if (!(it.getSdkType() instanceof PythonSdkType && PySdkExtKt.getSdkSeemsValid(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List sdks2 = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new PreferredSdkComparator());
        Pair<List<PyAddSdkView>, PyAddSdkView> pair = this.createPanels(sdks2);
        List panels = (List)pair.component1();
        PyAddSdkView initiallySelectedPanel = (PyAddSdkView)pair.component2();
        Iterable $this$filterIsInstance$iv = CollectionsKt.plus((Collection)panels, (Object)initiallySelectedPanel);
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Disposable)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable it = (Disposable)element$iv;
            boolean bl = false;
            Disposer.register((Disposable)this, (Disposable)it);
        }
        this.mainPanel.add(SPLITTER_COMPONENT_CARD_PANE, (Component)this.createCardSplitter(panels, initiallySelectedPanel));
        return this.mainPanel;
    }

    private final Pair<List<PyAddSdkView>, PyAddSdkView> createPanels(List<? extends Sdk> sdks2) {
        Pair pair;
        PyAddVirtualEnvPanel venvPanel = new PyAddVirtualEnvPanel(this.project, this.module, sdks2, PyAddTargetBasedSdkPanel.Companion.allowCreatingNewEnvironments(this.project), (UserDataHolder)this.context, this.targetSupplier, this.config);
        PyAddSystemWideInterpreterPanel systemWidePanel = new PyAddSystemWideInterpreterPanel(this.project, this.module, this.existingSdks, this.context, this.targetSupplier, this.config);
        PyAddSdkView condaPanel = this.createAnacondaPanel();
        if (this.isUnderLocalTarget()) {
            String newProjectPath = null;
            PyAddPipEnvPanel pipEnvPanel = this.createPipEnvPanel(newProjectPath);
            PyAddSdkPanel poetryPanel = PoetryKt.createPoetryPanel(this.project, this.module, this.existingSdks, newProjectPath, (UserDataHolder)this.context);
            if (PyCondaSdkCustomizer.Companion.getInstance().getPreferCondaEnvironments()) {
                Object[] objectArray = new PyAddSdkView[]{condaPanel, venvPanel, systemWidePanel, pipEnvPanel, poetryPanel};
                pair = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray), (Object)condaPanel);
            } else {
                Object[] objectArray = new PyAddSdkView[]{venvPanel, condaPanel, systemWidePanel, pipEnvPanel, poetryPanel};
                pair = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray), (Object)venvPanel);
            }
        } else if (PyInterpreterTargetsKt.isMutableTarget(this.getTargetEnvironmentConfiguration())) {
            List list;
            List $this$createPanels_u24lambda_u242 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            $this$createPanels_u24lambda_u242.add(venvPanel);
            $this$createPanels_u24lambda_u242.add(systemWidePanel);
            if (Registry.is((String)"enable.conda.on.targets") || !(this.getTargetEnvironmentConfiguration() instanceof IncompleteTargetEnvironmentConfiguration)) {
                $this$createPanels_u24lambda_u242.add(condaPanel);
            }
            pair = TuplesKt.to((Object)CollectionsKt.build((List)list), (Object)venvPanel);
        } else {
            Object[] objectArray = new PyAddSdkView[]{venvPanel, systemWidePanel, condaPanel};
            pair = TuplesKt.to((Object)CollectionsKt.listOf((Object[])objectArray), (Object)systemWidePanel);
        }
        return pair;
    }

    @NotNull
    public final List<ValidationInfo> doValidateAll() {
        Object object = this.selectedPanel;
        if (object == null || (object = object.validateAll()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Nullable
    public final Sdk getOrCreateSdk() {
        PyAddSdkView pyAddSdkView = this.selectedPanel;
        return pyAddSdkView != null ? pyAddSdkView.getOrCreateSdk() : null;
    }

    private final Splitter createCardSplitter(List<? extends PyAddSdkView> panels, PyAddSdkView initiallySelectedPanel) {
        JBList jBList;
        JPanel jPanel;
        Splitter splitter;
        this.panels = panels;
        Splitter $this$createCardSplitter_u24lambda_u246 = splitter = new Splitter(false, 0.25f);
        boolean bl = false;
        CardLayout cardLayout = new CardLayout();
        JPanel $this$createCardSplitter_u24lambda_u246_u24lambda_u243 = jPanel = new JPanel(cardLayout);
        boolean bl2 = false;
        $this$createCardSplitter_u24lambda_u246_u24lambda_u243.setPreferredSize((Dimension)JBUI.size((int)640, (int)480));
        for (PyAddSdkView pyAddSdkView : panels) {
            $this$createCardSplitter_u24lambda_u246_u24lambda_u243.add(PyAddTargetBasedSdkPanel.Companion.applyDefaultInsets(pyAddSdkView.getComponent()), pyAddSdkView.getPanelName());
        }
        JPanel cardPanel2 = jPanel;
        JBList $this$createCardSplitter_u24lambda_u246_u24lambda_u245 = jBList = new JBList((Collection)panels);
        boolean bl3 = false;
        ListItemDescriptorAdapter<PyAddSdkView> listItemDescriptorAdapter = new ListItemDescriptorAdapter<PyAddSdkView>(){

            @NotNull
            public String getTextFor(@NotNull PyAddSdkView value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = StringUtil.toTitleCase((String)value.getPanelName());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toTitleCase(...)");
                return string;
            }

            @NotNull
            public Icon getIconFor(@NotNull PyAddSdkView value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getIcon();
            }
        };
        $this$createCardSplitter_u24lambda_u246_u24lambda_u245.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer<PyAddSdkView>(listItemDescriptorAdapter){

            protected JComponent createItemComponent() {
                JComponent jComponent;
                JComponent $this$createItemComponent_u24lambda_u240 = jComponent = super.createItemComponent();
                boolean bl = false;
                $this$createItemComponent_u24lambda_u240.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)10));
                return jComponent;
            }
        });
        $this$createCardSplitter_u24lambda_u246_u24lambda_u245.addListSelectionListener(arg_0 -> PyAddTargetBasedSdkPanel.createCardSplitter$lambda$6$lambda$5$lambda$4(this, $this$createCardSplitter_u24lambda_u246_u24lambda_u245, cardLayout, cardPanel2, arg_0));
        this.selectedPanel = initiallySelectedPanel;
        $this$createCardSplitter_u24lambda_u246_u24lambda_u245.setSelectedIndex(panels.indexOf(initiallySelectedPanel));
        JBList cardsList2 = jBList;
        $this$createCardSplitter_u24lambda_u246.setFirstComponent((JComponent)cardsList2);
        $this$createCardSplitter_u24lambda_u246.setSecondComponent((JComponent)cardPanel2);
        return splitter;
    }

    private final PyAddSdkView createAnacondaPanel() {
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.getTargetEnvironmentConfiguration();
        Project project2 = this.project;
        Intrinsics.checkNotNull((Object)project2);
        return new PyAddCondaPanelView(new PyAddCondaPanelModel(targetEnvironmentConfiguration, this.existingSdks, project2, this.introspectable));
    }

    private final PyAddPipEnvPanel createPipEnvPanel(String newProjectPath) {
        return new PyAddPipEnvPanel(this.project, this.module, this.existingSdks, newProjectPath, (UserDataHolder)this.context);
    }

    public final void doOKAction() {
        try {
            PyAddSdkView pyAddSdkView = this.selectedPanel;
            if (pyAddSdkView != null) {
                pyAddSdkView.complete();
            }
        }
        catch (CreateSdkInterrupted e) {
            return;
        }
        catch (Exception e) {
            PyExecutionException cause = (PyExecutionException)((Object)ExceptionUtil.findCause((Throwable)e, PyExecutionException.class));
            if (cause == null) {
                Messages.showErrorDialog((String)e.getLocalizedMessage(), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
            } else {
                WizardUIUtilKt.showProcessExecutionErrorDialog(this.project, cause);
            }
            return;
        }
    }

    public void dispose() {
    }

    private static final void createCardSplitter$lambda$6$lambda$5$lambda$4(PyAddTargetBasedSdkPanel this$0, JBList $this_apply, CardLayout $cardLayout, JPanel $cardPanel, ListSelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$cardLayout, (String)"$cardLayout");
        Intrinsics.checkNotNullParameter((Object)$cardPanel, (String)"$cardPanel");
        if (it.getValueIsAdjusting()) {
            return;
        }
        this$0.selectedPanel = (PyAddSdkView)$this_apply.getSelectedValue();
        $cardLayout.show($cardPanel, ((PyAddSdkView)$this_apply.getSelectedValue()).getPanelName());
        ((PyAddSdkView)$this_apply.getSelectedValue()).onSelected();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001b\u0010\t\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b*\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/sdk/add/target/PyAddTargetBasedSdkPanel$Companion;", "", "()V", "SPLITTER_COMPONENT_CARD_PANE", "", "allowCreatingNewEnvironments", "", "project", "Lcom/intellij/openapi/project/Project;", "applyDefaultInsets", "T", "Ljava/awt/Component;", "(Ljava/awt/Component;)Ljava/awt/Component;", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean allowCreatingNewEnvironments(Project project2) {
            return project2 != null || !PlatformUtils.isPyCharm() || PlatformUtils.isPyCharmEducational();
        }

        private final <T extends Component> T applyDefaultInsets(T $this$applyDefaultInsets) {
            T t;
            T $this$applyDefaultInsets_u24lambda_u240 = t = $this$applyDefaultInsets;
            boolean bl = false;
            if ($this$applyDefaultInsets_u24lambda_u240 instanceof JComponent) {
                DialogPanel dialogPanel;
                DialogPanel dialogPanel2 = dialogPanel = (DialogPanel)UIUtil.findComponentOfType((JComponent)((JComponent)$this$applyDefaultInsets_u24lambda_u240), DialogPanel.class);
                (dialogPanel2 != null ? (JComponent)dialogPanel2 : (JComponent)$this$applyDefaultInsets_u24lambda_u240).setBorder((Border)JBUI.Borders.empty((int)4, (int)9, (int)4, (int)15));
            }
            return t;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

