/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.setupPy;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.actions.GotoActionBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.ListChooseByNameModel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.setupPy.SetupTask;
import com.jetbrains.python.packaging.setupPy.SetupTaskDialog;
import com.jetbrains.python.packaging.setupPy.SetupTaskIntrospector;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SetupTaskChooserAction
extends AnAction {
    public SetupTaskChooserAction() {
        super(PyBundle.messagePointer("python.packaging.run.setup.py.task", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Module module;
        if (e == null) {
            SetupTaskChooserAction.$$$reportNull$$$0(0);
        }
        if ((module = (Module)e.getData(PlatformCoreDataKeys.MODULE)) == null) {
            return;
        }
        Project project2 = module.getProject();
        ListChooseByNameModel model2 = new ListChooseByNameModel(project2, PyBundle.message("python.packaging.enter.setup.py.task", new Object[0]), PyBundle.message("python.packaging.no.tasks.found", new Object[0]), SetupTaskIntrospector.getTaskList(module));
        ChooseByNamePopup popup = ChooseByNamePopup.createPopup((Project)project2, (ChooseByNameModel)model2, (PsiElement)GotoActionBase.getPsiContext((AnActionEvent)e));
        popup.setShowListForEmptyPattern(true);
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element) {
                if (element != null) {
                    SetupTask task2 = (SetupTask)element;
                    ApplicationManager.getApplication().invokeLater(() -> SetupTaskChooserAction.runSetupTask(task2.getName(), module), ModalityState.nonModal());
                }
            }
        }, ModalityState.current(), false);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            SetupTaskChooserAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SetupTaskChooserAction.$$$reportNull$$$0(2);
        }
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        e.getPresentation().setEnabled(module != null && PyPackageUtil.hasSetupPy(module) && PythonSdkUtil.findPythonSdk(module) != null);
    }

    private static void runSetupTask(@NlsSafe String taskName, @NotNull Module module) {
        if (module == null) {
            SetupTaskChooserAction.$$$reportNull$$$0(3);
        }
        List<SetupTask.Option> options = SetupTaskIntrospector.getSetupTaskOptions(module, taskName);
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(taskName);
        if (options != null) {
            SetupTaskDialog dialog2 = new SetupTaskDialog(module.getProject(), taskName, options);
            if (!dialog2.showAndGet()) {
                return;
            }
            parameters.addAll(dialog2.getCommandLine());
        }
        SetupTaskChooserAction.runSetupTask(taskName, module, parameters);
    }

    public static void runSetupTask(@NlsSafe String taskName, @NotNull Module module, List<String> parameters) {
        if (module == null) {
            SetupTaskChooserAction.$$$reportNull$$$0(4);
        }
        try {
            PyFile setupPy = PyPackageUtil.findSetupPy(module);
            if (setupPy == null) {
                return;
            }
            PythonTask task2 = new PythonTask(module, taskName);
            VirtualFile virtualFile = setupPy.getVirtualFile();
            task2.setRunnerScript(virtualFile.getPath());
            task2.setWorkingDirectory(virtualFile.getParent().getPath());
            task2.setParameters(parameters);
            task2.setAfterCompletion(() -> LocalFileSystem.getInstance().refresh(true));
            task2.run(null, null);
        }
        catch (ExecutionException ee) {
            Messages.showErrorDialog((Project)module.getProject(), (String)PyBundle.message("python.packaging.failed.to.run.task", ee.getMessage()), (String)taskName);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/setupPy/SetupTaskChooserAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/setupPy/SetupTaskChooserAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "runSetupTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

