/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.newProject.steps;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.ui.JBUI;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.configuration.PyActiveSdkConfigurable;
import com.jetbrains.python.configuration.PyConfigurableInterpreterList;
import com.jetbrains.python.newProject.steps.PySdkChooserKt;
import com.jetbrains.python.sdk.PySdkListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0010\u0010\t\u001a\u00020\n*\u0006\u0012\u0002\b\u00030\u0004H\u0002\u001a:\u0010\u000b\u001a\u00020\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002\u001a&\u0010\u0015\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createPythonSdkComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdks", "", "initialSelection", "updateTooltip", "", "withActionLink", "Ljavax/swing/JPanel;", "E", "Ljavax/swing/JComboBox;", "dropDownLinkItem", "", "popupBuilder", "Lkotlin/Function1;", "Lcom/intellij/ui/components/DropDownLink;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "withAddInterpreterLink", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.python.community.impl"})
public final class PySdkChooserKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final ComboBox<Sdk> createPythonSdkComboBox(@NotNull List<? extends Sdk> sdks2, @Nullable Sdk initialSelection) {
        Intrinsics.checkNotNullParameter(sdks2, (String)"sdks");
        ComboBox comboBox = new ComboBox();
        comboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(sdks2, (Object)initialSelection));
        comboBox.setRenderer((ListCellRenderer)((Object)new PySdkListCellRenderer(null, null, 3, null)));
        comboBox.addActionListener(arg_0 -> PySdkChooserKt.createPythonSdkComboBox$lambda$0(comboBox, arg_0));
        ComboboxSpeedSearch.installOn((JComboBox)((JComboBox)comboBox));
        PySdkChooserKt.updateTooltip(comboBox);
        return comboBox;
    }

    private static final void updateTooltip(ComboBox<?> $this$updateTooltip) {
        String sdkHomePath;
        Object item = $this$updateTooltip.getSelectedItem();
        String string = sdkHomePath = item instanceof Sdk ? ((Sdk)item).getHomePath() : null;
        $this$updateTooltip.setToolTipText(string != null ? FileUtil.toSystemDependentName((String)string) : null);
    }

    @NotNull
    public static final JPanel withAddInterpreterLink(@NotNull ComboBox<Sdk> $this$withAddInterpreterLink, @Nullable Project project2, @Nullable Module module) {
        Intrinsics.checkNotNullParameter($this$withAddInterpreterLink, (String)"<this>");
        JComboBox jComboBox = (JComboBox)$this$withAddInterpreterLink;
        String string = PyBundle.message("active.sdk.dialog.link.add.interpreter.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return PySdkChooserKt.withActionLink(jComboBox, string, (Function1<? super DropDownLink<String>, ? extends JBPopup>)((Function1)new Function1<DropDownLink<String>, JBPopup>(project2, $this$withAddInterpreterLink, module){
            final /* synthetic */ Project $project;
            final /* synthetic */ ComboBox<Sdk> $this_withAddInterpreterLink;
            final /* synthetic */ Module $module;
            {
                this.$project = $project;
                this.$this_withAddInterpreterLink = $receiver;
                this.$module = $module;
                super(1);
            }

            @NotNull
            public final JBPopup invoke(@NotNull DropDownLink<String> dropDownLink) {
                Intrinsics.checkNotNullParameter(dropDownLink, (String)"dropDownLink");
                PyConfigurableInterpreterList interpreterList = PyConfigurableInterpreterList.getInstance(this.$project);
                Sdk oldSelectedSdk = (Sdk)this.$this_withAddInterpreterLink.getSelectedItem();
                Project project2 = this.$project;
                if (project2 == null) {
                    Project project3 = ProjectManager.getInstance().getDefaultProject();
                    project2 = project3;
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getDefaultProject(...)");
                }
                ListPopup listPopup = PyActiveSdkConfigurable.createAddInterpreterPopup(project2, this.$module, (Component)dropDownLink, arg_0 -> withAddInterpreterLink.1.invoke$lambda$0(interpreterList, this.$this_withAddInterpreterLink, oldSelectedSdk, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createAddInterpreterPopup(...)");
                return (JBPopup)listPopup;
            }

            private static final void invoke$lambda$0(PyConfigurableInterpreterList $interpreterList, ComboBox $this_withAddInterpreterLink, Sdk $oldSelectedSdk, Sdk sdk2) {
                Intrinsics.checkNotNullParameter((Object)$this_withAddInterpreterLink, (String)"$this_withAddInterpreterLink");
                if (sdk2 == null) {
                    return;
                }
                ProjectSdksModel projectSdksModel = $interpreterList.getModel();
                if (projectSdksModel.findSdk(sdk2) == null) {
                    projectSdksModel.addSdk(sdk2);
                    try {
                        projectSdksModel.apply();
                    }
                    catch (ConfigurationException e) {
                        PySdkChooserKt.access$getLOG$p().error("Error adding new python interpreter " + e.getMessage());
                    }
                }
                List<Sdk> committedSdks = $interpreterList.getAllPythonSdks();
                Sdk copiedSdk = $interpreterList.getModel().findSdk(sdk2.getName());
                $this_withAddInterpreterLink.setModel((ComboBoxModel)new CollectionComboBoxModel(committedSdks, (Object)$oldSelectedSdk));
                $this_withAddInterpreterLink.setSelectedItem((Object)copiedSdk);
            }
        }));
    }

    private static final <E> JPanel withActionLink(JComboBox<E> $this$withActionLink, String dropDownLinkItem, Function1<? super DropDownLink<String>, ? extends JBPopup> popupBuilder) {
        JPanel result2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = (Insets)JBUI.insets((int)2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.1;
        result2.add((Component)$this$withActionLink, c);
        c.insets = (Insets)JBUI.insets((int)2, (int)14, (int)2, (int)2);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        result2.add((Component)new DropDownLink((Object)dropDownLinkItem, popupBuilder), c);
        return result2;
    }

    private static final void createPythonSdkComboBox$lambda$0(ComboBox $comboBox, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)$comboBox, (String)"$comboBox");
        PySdkChooserKt.updateTooltip($comboBox);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)"#com.jetbrains.python.newProject.steps");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

