/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.namespacePackages;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Transient;
import com.jetbrains.python.FoldersComponentTools;
import com.jetbrains.python.namespacePackages.PyNamespacePackagesStatisticsCollector;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="PyNamespacePackagesService")
public final class PyNamespacePackagesService
implements PersistentStateComponent<PyNamespacePackagesService> {
    private final List<VirtualFile> myNamespacePackageFolders = new ArrayList<VirtualFile>();
    private final FoldersComponentTools myTools = new FoldersComponentTools(this.myNamespacePackageFolders);
    private final Module myModule;

    public PyNamespacePackagesService() {
        this.myModule = null;
    }

    public PyNamespacePackagesService(@Nullable Module module) {
        this.myModule = module;
    }

    @NotNull
    public static PyNamespacePackagesService getInstance(@NotNull Module module) {
        if (module == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(0);
        }
        PyNamespacePackagesService pyNamespacePackagesService = (PyNamespacePackagesService)module.getService(PyNamespacePackagesService.class);
        if (pyNamespacePackagesService == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(1);
        }
        return pyNamespacePackagesService;
    }

    @NotNull
    public List<String> getNamespacePackageFolders() {
        this.removeInvalidNamespacePackageFolders();
        List<String> list = Collections.unmodifiableList(this.myTools.getFoldersAsStrings());
        if (list == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Transient
    @NotNull
    public List<VirtualFile> getNamespacePackageFoldersVirtualFiles() {
        this.removeInvalidNamespacePackageFolders();
        List<VirtualFile> list = Collections.unmodifiableList(this.myNamespacePackageFolders);
        if (list == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setNamespacePackageFolders(@NotNull List<String> folders) {
        if (folders == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(4);
        }
        this.myTools.setFoldersAsStrings(folders);
    }

    @Transient
    public void setNamespacePackageFoldersVirtualFiles(@NotNull List<VirtualFile> folders) {
        if (folders == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(5);
        }
        this.myTools.setFoldersAsVirtualFiles(folders);
    }

    public void toggleMarkingAsNamespacePackage(@NotNull VirtualFile directory2) {
        if (directory2 == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(6);
        }
        SideEffectGuard.checkSideEffectAllowed((SideEffectGuard.EffectType)SideEffectGuard.EffectType.SETTINGS);
        if (!directory2.isDirectory()) {
            return;
        }
        if (this.canBeMarked(directory2)) {
            this.myNamespacePackageFolders.add(directory2);
            PyNamespacePackagesStatisticsCollector.logToggleMarkingAsNamespacePackage(true);
        } else if (this.isMarked(directory2)) {
            this.myNamespacePackageFolders.remove(directory2);
            PyNamespacePackagesStatisticsCollector.logToggleMarkingAsNamespacePackage(false);
        } else {
            throw new IllegalStateException("Can't toggle namespace package state for: " + directory2.getName());
        }
        this.refreshView();
    }

    public boolean canBeMarked(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(7);
        }
        if (this.myModule == null) {
            return false;
        }
        Project project2 = this.myModule.getProject();
        if (PythonLanguageLevelPusher.getLanguageLevelForVirtualFile(project2, virtualFile).isOlderThan(LanguageLevel.PYTHON34)) {
            return false;
        }
        if (PyUtil.isRoot(virtualFile, project2)) {
            return false;
        }
        if (!PyNamespacePackagesService.isInProject(virtualFile, project2)) {
            return false;
        }
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)project2).findDirectory(virtualFile);
        if (psiDirectory != null && PyUtil.isOrdinaryPackage(psiDirectory)) {
            return false;
        }
        for (VirtualFile curDir = virtualFile; curDir != null; curDir = curDir.getParent()) {
            if (!curDir.isDirectory()) {
                return false;
            }
            if (this.myNamespacePackageFolders.contains(curDir)) {
                return false;
            }
            if (PyUtil.isRoot(curDir, project2) || (psiDirectory = PsiManager.getInstance((Project)this.myModule.getProject()).findDirectory(curDir)) != null && PyUtil.isOrdinaryPackage(psiDirectory)) break;
        }
        return true;
    }

    @Nullable
    public PyNamespacePackagesService getState() {
        return this;
    }

    public void loadState(@NotNull PyNamespacePackagesService state2) {
        if (state2 == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(8);
        }
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public boolean isMarked(@NotNull VirtualFile dir) {
        if (dir == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(9);
        }
        return this.myNamespacePackageFolders.contains(dir);
    }

    public boolean isNamespacePackage(VirtualFile directory2) {
        PsiDirectory psiDirectory;
        if (this.myModule != null && (psiDirectory = PsiManager.getInstance((Project)this.myModule.getProject()).findDirectory(directory2)) != null && PyUtil.isOrdinaryPackage(psiDirectory)) {
            return false;
        }
        for (VirtualFile curDir = directory2; curDir != null; curDir = curDir.getParent()) {
            PsiDirectory psiDirectory2;
            if (this.isMarked(curDir)) {
                return true;
            }
            if (this.myModule != null && (PyUtil.isRoot(directory2, this.myModule.getProject()) || (psiDirectory2 = PsiManager.getInstance((Project)this.myModule.getProject()).findDirectory(curDir)) != null && PyUtil.isOrdinaryPackage(psiDirectory2))) break;
        }
        return false;
    }

    public static boolean isEnabled() {
        return Registry.is((String)"python.explicit.namespace.packages");
    }

    private void removeInvalidNamespacePackageFolders() {
        this.myNamespacePackageFolders.removeIf(it -> it == null || !it.isValid());
    }

    private static boolean isInProject(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        PsiManager psiManager;
        PsiDirectory psiDirectory;
        if (virtualFile == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            PyNamespacePackagesService.$$$reportNull$$$0(11);
        }
        if ((psiDirectory = (psiManager = PsiManager.getInstance((Project)project2)).findDirectory(virtualFile)) == null) {
            return false;
        }
        return psiManager.isInProject((PsiElement)psiDirectory);
    }

    private void refreshView() {
        if (!ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
            return;
        }
        if (this.myModule == null) {
            return;
        }
        Project project2 = this.myModule.getProject();
        ProjectView.getInstance((Project)project2).refresh();
        PsiManager.getInstance((Project)project2).dropPsiCaches();
        DaemonCodeAnalyzer.getInstance((Project)project2).restart();
    }

    @TestOnly
    public void resetAllNamespacePackages() {
        this.myNamespacePackageFolders.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/namespacePackages/PyNamespacePackagesService";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folders";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/namespacePackages/PyNamespacePackagesService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePackageFolders";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePackageFoldersVirtualFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setNamespacePackageFolders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNamespacePackageFoldersVirtualFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toggleMarkingAsNamespacePackage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canBeMarked";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMarked";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

